/*
 * Decompiled with CFR 0.152.
 */
package vehicle_tracking;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.UUID;

public class HttpPostMultipart {
    private final String boundary;
    private static final String LINE = "\r\n";
    private HttpURLConnection httpConn;
    private String charset;
    private OutputStream outputStream;
    private PrintWriter writer;

    public HttpPostMultipart(String requestURL, String charset, Map<String, String> headers) throws IOException {
        this.charset = charset;
        this.boundary = UUID.randomUUID().toString();
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                this.httpConn.setRequestProperty(key, value);
            }
        }
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE);
        this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE);
        this.writer.append(LINE);
        this.writer.append(value).append(LINE);
        this.writer.flush();
    }

    public void addFilePart(String fieldName, File uploadFile) throws IOException {
        String fileName = uploadFile.getName();
        System.out.println("fileName:" + fileName);
        this.writer.append("--" + this.boundary).append(LINE);
        this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE);
        this.writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(LINE);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE);
        this.writer.append(LINE);
        this.writer.flush();
        FileInputStream inputStream = new FileInputStream(uploadFile);
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
        }
        this.outputStream.flush();
        inputStream.close();
        this.writer.append(LINE);
        this.writer.flush();
    }

    public String finish() throws IOException {
        ByteArrayOutputStream result;
        String response = "";
        this.writer.flush();
        this.writer.append("--" + this.boundary + "--").append(LINE);
        this.writer.close();
        int status = this.httpConn.getResponseCode();
        if (status == 200) {
            int length;
            result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = this.httpConn.getInputStream().read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        } else {
            throw new IOException("Server returned non-OK status: " + status);
        }
        response = result.toString(this.charset);
        this.httpConn.disconnect();
        return response;
    }
}

