/*
 * Decompiled with CFR 0.152.
 */
package tginventorylib;

import fileFormatUtil.fileFormatUtil;
import inventorydblibdesktop.InventoryDBLibDesktop;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tginventorylib.Inventory_ReportsLib;
import tginventorylib.TGInventoryGlobal;
import tginventorylib.TGInventoryTLV;
import trueguidelibrary.TrueGuideLibrary;
import trueguidelogindesktop.TrueGuideLogin;

public class TGInventoryLib {
    public TGInventoryGlobal glbObj = null;
    public TGInventoryTLV tlvObj = null;
    public TrueGuideLibrary log = null;
    public InventoryDBLibDesktop dblib = null;
    public Inventory_ReportsLib ReportsObj = null;
    public TrueGuideLogin loginobj = null;
    public fileFormatUtil excel = null;
    private String version;

    public TGInventoryLib(TGInventoryLib obj) {
        this.glbObj = new TGInventoryGlobal();
        this.tlvObj = new TGInventoryTLV(this.glbObj);
        this.excel = new fileFormatUtil();
        this.dblib = obj.dblib;
        this.log = obj.log;
        this.loginobj = obj.loginobj;
        this.ReportsObj = new Inventory_ReportsLib();
        this.ReportsObj.glbObj = this.glbObj;
        this.ReportsObj.tlvObj = this.tlvObj;
        this.ReportsObj.log = obj.log;
        this.ReportsObj.dblib = obj.dblib;
        this.ReportsObj.loginobj = obj.loginobj;
    }

    public TGInventoryLib() {
        this.excel = new fileFormatUtil();
        this.glbObj = new TGInventoryGlobal();
        this.tlvObj = new TGInventoryTLV(this.glbObj);
        this.log = new TrueGuideLibrary();
        this.loginobj = new TrueGuideLogin(this.log);
        this.dblib = new InventoryDBLibDesktop(this.log);
        this.ReportsObj = new Inventory_ReportsLib();
        this.ReportsObj.glbObj = this.glbObj;
        this.ReportsObj.tlvObj = this.tlvObj;
        this.ReportsObj.log = this.log;
        this.ReportsObj.dblib = this.dblib;
        this.ReportsObj.loginobj = this.loginobj;
        this.dblib.initParser(this.log);
        this.dblib.CreateAcademicSchema();
        TrueGuideLibrary.isjava = true;
    }

    public boolean do_all_network() throws IOException {
        this.log.error_code = 0;
        this.log.performFulloperation(this.tlvObj.glbObj.req_type, this.tlvObj.glbObj.tlvStr.length(), this.tlvObj.glbObj.tlvStr);
        return true;
    }

    public void Set_Inventory_ModuleIDAndRoleID() throws IOException {
        this.log.Module_ID = "academic";
        this.log.Role_id = "vendor";
        this.log.version = this.version = "1.0.0.0";
        this.loginobj.SetttingModuleAndRole(this.log.Module_ID, this.log.Role_id, this.version);
    }

    public boolean handleLogin_select_user_id() throws IOException {
        boolean check = false;
        this.loginobj.handleLogin_select_user_id();
        this.glbObj.userid = this.loginobj.tutil.GetUserID();
        this.glbObj.status = this.loginobj.tutil.GetStatus();
        return check;
    }

    public void GetPassword() throws IOException {
        this.loginobj.get_password();
        this.glbObj.password = this.loginobj.rcv_passwd;
        this.log.error_code = 0;
        System.out.println("Get password func--->" + this.glbObj.password);
    }

    public boolean handle_Login_select_inventory_usrid_orgid() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(11);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.invt_usrid_lst = this.log.GetValuesFromTbl("tinventoryusertbl.1_invusrid");
            this.glbObj.from_inv_userid = this.glbObj.invt_usrid_lst.get(0).toString();
            this.glbObj.invt_orgid_lst = this.log.GetValuesFromTbl("tinventoryusertbl.2_orgid");
            this.glbObj.inventory_orgid_cur = this.glbObj.invt_orgid_lst.get(0).toString();
            this.glbObj.invt_vertical_lst = this.log.GetValuesFromTbl("tinventoryusertbl.3_verticle");
            this.glbObj.invt_prev_lst = this.log.GetValuesFromTbl("tinventoryusertbl.4_prev");
            System.out.println("this.glbObj.inventory_orgid_cur===========" + this.glbObj.inventory_orgid_cur);
            System.out.println("this.glbObj.from_inv_userid===========" + this.glbObj.from_inv_userid);
            ret = true;
        }
        return ret;
    }

    public boolean get_institution_name_and_type_from_instid() throws IOException {
        this.glbObj.org_name_lst.clear();
        this.glbObj.org_expiry_lst.clear();
        this.glbObj.org_status_lst.clear();
        boolean check = false;
        System.out.println("this.glbObj.invt_orgid_lst===============" + this.glbObj.invt_orgid_lst);
        for (int i = 0; i < this.glbObj.invt_orgid_lst.size(); ++i) {
            this.glbObj.orgid_cur = this.glbObj.invt_orgid_lst.get(i).toString();
            this.glbObj.invt_verticle = this.glbObj.invt_vertical_lst.get(i).toString();
            this.tlvObj.setTlv(28);
            this.do_all_network();
            System.out.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            if (this.glbObj.invt_verticle.equals("academic")) {
                this.glbObj.org_name_lst.add(this.log.GetValuesFromTbl("pinsttbl.1_instname").get(0).toString());
                this.glbObj.org_expiry_lst.add(this.log.GetValuesFromTbl("pinsttbl.2_expiry").get(0).toString());
                this.glbObj.org_status_lst.add(this.log.GetValuesFromTbl("pinsttbl.3_status").get(0).toString());
            }
            if (this.glbObj.invt_verticle.equals("non_academic")) {
                this.glbObj.org_name_lst.add(this.log.GetValuesFromTbl("tfirmtbl.1_firmname").get(0).toString());
                this.glbObj.org_expiry_lst.add(this.log.GetValuesFromTbl("tfirmtbl.2_expiry").get(0).toString());
                this.glbObj.org_status_lst.add(this.log.GetValuesFromTbl("tfirmtbl.3_status").get(0).toString());
                System.out.println("this.glbObj.org_name_lst============" + this.glbObj.org_name_lst);
            }
            check = true;
        }
        return check;
    }

    public boolean insert_firm_details() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(12);
        this.log.delim = "\\^";
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("tfirmtbl^1_firmid");
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean insert_vendor() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(13);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.log.delim = "\\.";
        this.dblib.pme.delim = "\\.";
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("tusertbl.1_usrid");
            this.glbObj.userid_autoinc = this.dblib.autoIncr;
            check = true;
        }
        return check;
    }

    public boolean get_userid_tusertbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(14);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.vendor_userid_cur = this.log.GetValuesFromTbl("tusertbl.1_usrid").get(0).toString();
            this.glbObj.vendor_username_cur = this.log.GetValuesFromTbl("tusertbl.2_usrname").get(0).toString();
            check = true;
        }
        return check;
    }

    public boolean insert_vendor_details() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(15);
        boolean ch = false;
        this.do_all_network();
        check = this.log.error_code == 0;
        return check;
    }

    public boolean get_vendor_name_from_tusertable() throws IOException {
        this.glbObj.vendorname_lst.clear();
        boolean check = false;
        for (int i = 0; i < this.glbObj.vendor_userid_lst.size(); ++i) {
            this.glbObj.vendor_userid_cur = this.glbObj.vendor_userid_lst.get(i).toString();
            this.tlvObj.setTlv(16);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.glbObj.vendorname_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
            check = true;
        }
        return check;
    }

    public boolean insert_chapter_details() throws IOException {
        boolean check = false;
        for (int i = 0; i < this.glbObj.chapter_name_lst.size(); ++i) {
            this.glbObj.chapter_name = this.glbObj.chapter_name_lst.get(i).toString().trim();
            this.dblib.pme.delim = "\\.";
            this.tlvObj.setTlv(17);
            this.do_all_network();
            check = this.log.error_code == 0;
        }
        return check;
    }

    public boolean insert_heading_details() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(18);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("pheadingtbl.1_headingid");
            check = true;
        }
        return check;
    }

    public void get_chapter_code_from_pchaptertbl() throws IOException {
        this.glbObj.chapter_id_lst.clear();
        this.glbObj.chapter_name_lst.clear();
        String q = "select chapterid,chaptername from trueguide.pchaptertbl where invusrid='" + this.glbObj.invt_usrid + "' and orgid='" + this.glbObj.orgid + "'";
        this.glbObj.req_type = 709;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return;
        }
        if (this.log.error_code == 2) {
            return;
        }
        this.glbObj.chapter_id_lst = this.log.GetValuesFromTbl("X^1_1");
        this.glbObj.chapter_name_lst = this.log.GetValuesFromTbl("X^2_2");
    }

    public boolean get_chapterid_from_chapname() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(20);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.ch_id = this.log.GetValuesFromTbl("pchaptertbl.1_chapterid").get(0).toString();
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public boolean get_heading_name_from_chapid() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(21);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.heading_id_lst = this.log.GetValuesFromTbl("pheadingtbl.1_headingid");
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.head_name_lst.clear();
            this.glbObj.head_code_lst.clear();
            for (int i = 0; i < this.glbObj.heading_id_lst.size(); ++i) {
                this.glbObj.heading_id_curr = this.glbObj.heading_id_lst.get(i).toString();
                this.tlvObj.setTlv(21);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.head_name_lst.add(this.log.GetValuesFromTbl("pheadingtbl.1_headingname").get(0).toString());
                this.glbObj.head_code_lst.add(this.log.GetValuesFromTbl("pheadingtbl.2_headingcode").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean insert_subheading_details() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(22);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("psubheadingtbl.1_subheadingid");
            check = true;
        }
        return check;
    }

    public boolean get_headingid_from_headingname() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(23);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.heading_id = this.log.GetValuesFromTbl("pheadingtbl.1_headingid").get(0).toString();
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public boolean get_subheading_name_from_headingid() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(24);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.subheading_id_lst = this.log.GetValuesFromTbl("psubheadingtbl.1_subheadingid");
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.subhead_name_lst.clear();
            this.glbObj.subheading_code_lst.clear();
            for (int i = 0; i < this.glbObj.subheading_id_lst.size(); ++i) {
                this.glbObj.subheading_id_curr = this.glbObj.subheading_id_lst.get(i).toString();
                this.tlvObj.setTlv(24);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.subhead_name_lst.add(this.log.GetValuesFromTbl("psubheadingtbl.1_subheadingname").get(0).toString());
                this.glbObj.subheading_code_lst.add(this.log.GetValuesFromTbl("psubheadingtbl.2_subheadingcode").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean insert_item_name_itemtbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(25);
        this.log.delim = "\\^";
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("pinvitemtbl^1_itemid");
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_item_name_from_itemtbl() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.glbObj.vnitemid_lst.clear();
            this.tlvObj.setTlv(27);
            this.glbObj.req_type = 1000;
            this.dblib.pme.delim = "\\.";
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.vnitemid_lst = this.log.GetValuesFromTbl("tinvitemtbl.1_vnitemid");
                System.out.println("this.glbObj.item_id--------" + this.glbObj.vnitemid_lst);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.item_name_lst.clear();
            this.glbObj.items_names_lst.clear();
            this.glbObj.items_chid_lst.clear();
            this.glbObj.items_hsn_lst.clear();
            this.glbObj.items_gst_lst.clear();
            this.glbObj.brandname_lst.clear();
            this.glbObj.quantity_lst.clear();
            this.glbObj.mrp_lst.clear();
            this.glbObj.unitdescr_lst.clear();
            this.glbObj.itemsperunit_lst.clear();
            for (int i = 0; i < this.glbObj.vnitemid_lst.size(); ++i) {
                this.glbObj.vnitemid_cur = this.glbObj.vnitemid_lst.get(i).toString();
                this.dblib.pme.delim = "\\^";
                this.tlvObj.setTlv(27);
                this.do_all_network();
                if (this.log.error_code != 0) {
                    this.dblib.pme.delim = "\\.";
                    check = false;
                    continue;
                }
                this.glbObj.items_names_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^1_itemname").get(0).toString());
                this.glbObj.item_name_lst = this.glbObj.items_names_lst;
                this.glbObj.items_chid_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^2_chapterid").get(0).toString());
                this.glbObj.items_hsn_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^3_hsn").get(0).toString());
                this.glbObj.items_gst_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^4_gst").get(0).toString());
                this.glbObj.brandname_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^6_brandname").get(0).toString());
                this.glbObj.quantity_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^7_qnty").get(0).toString());
                this.glbObj.mrp_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^8_mrp").get(0).toString());
                this.glbObj.unitdescr_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9_unitdescr").get(0).toString());
                this.glbObj.itemsperunit_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9a_itemsperunit").get(0).toString());
                this.glbObj.item_invusrid_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9b_invusrid").get(0).toString());
                this.glbObj.items_orgid_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9c_orgid").get(0).toString());
                System.out.println("this.glbObj.item_name_lst--------" + this.glbObj.item_name_lst);
                this.dblib.pme.delim = "\\.";
                check = true;
            }
        }
        this.dblib.pme.delim = "\\.";
        return check;
    }

    public boolean get_all_item_id_from_pitemtable() throws IOException {
        boolean check = false;
        System.out.println("in 29======================\n\n");
        this.tlvObj.setTlv(29);
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (!this.glbObj.get_brandname) {
                this.glbObj.item_names_lst = this.log.GetValuesFromTbl("tinvitemtbl^1_itemname");
                this.glbObj.chapterid_ids_lst = this.log.GetValuesFromTbl("tinvitemtbl^2_chapterid");
                this.glbObj.hsn_lst = this.log.GetValuesFromTbl("tinvitemtbl^3_hsn");
                this.glbObj.gst_lst = this.log.GetValuesFromTbl("tinvitemtbl^4_gst");
            }
            if (this.glbObj.get_brandname) {
                this.glbObj.add_get_brandname = this.log.GetValuesFromTbl("tinvitemtbl^1_brandname");
                this.glbObj.add_item_quantity = this.log.GetValuesFromTbl("tinvitemtbl^2_qnty");
                this.glbObj.add_item_cost = this.log.GetValuesFromTbl("tinvitemtbl^3_mrp");
                System.out.println("brandname list ===============" + this.glbObj.add_get_brandname);
                System.out.println("quantity list ===============" + this.glbObj.add_item_quantity);
                System.out.println("cost list====================" + this.glbObj.add_item_cost);
            }
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            check = true;
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return check;
    }

    public void insert_Stock_items_into_tinvitemtbl() throws IOException {
        boolean check = false;
        String query = "";
        boolean ch = false;
        this.tlvObj.glbObj.req_type = 714;
        if (!this.glbObj.item_equals) {
            query = "insert into trueguide.tinvitemtbl (itemname,chapterid,hsn,gst,invusrid,orgid,qnty,brandname,mrp,unitdescr) values('" + this.glbObj.items_name + "','" + this.glbObj.chapter_ids_cur + "','" + this.glbObj.hsn_cur + "','" + this.glbObj.gst_cur + "','" + this.glbObj.invt_usrid + "','" + this.glbObj.orgid + "','" + this.glbObj.add_item_quantity_cur + "','" + this.glbObj.add_get_brandname_cur + "','" + this.glbObj.item_mrp_cur + "','" + this.glbObj.items_unit_description + "') returning vnitemid ";
        } else if (this.glbObj.item_equals) {
            query = "update trueguide.tinvitemtbl set qnty='" + this.glbObj.add_item_quantity_int + "',mrp='" + this.glbObj.item_mrp_cur + "' where vnitemid='" + this.glbObj.vnitemid_cur + "' returning vnitemid";
        }
        this.tlvObj.glbObj.tlvStr = query;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.glbObj.vnitemid_postdb = this.log.GetValuesFromTbl("X^1_1").get(0).toString();
        System.out.println("this.glbObj.tlvObj.glbObj.tlvStr=+=" + this.tlvObj.glbObj.tlvStr);
    }

    public boolean get_all_items_from_tinvitemtbl() throws IOException {
        boolean check = false;
        System.out.println("ids only=============" + this.glbObj.ids_only);
        System.out.println("");
        if (this.glbObj.ids_only) {
            this.glbObj.items_vnitemid_lst.clear();
            this.tlvObj.setTlv(31);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.items_vnitemid_lst = this.log.GetValuesFromTbl("tinvitemtbl.1_vnitemid");
                System.out.println("this.glbObj.items_id_lst===============" + this.glbObj.items_vnitemid_lst);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            System.out.println("in here false");
            this.glbObj.items_names_lst.clear();
            this.glbObj.items_chid_lst.clear();
            this.glbObj.items_hsn_lst.clear();
            this.glbObj.items_gst_lst.clear();
            this.glbObj.brandname_lst.clear();
            this.glbObj.quantity_lst.clear();
            this.glbObj.mrp_lst.clear();
            this.glbObj.unitdescr_lst.clear();
            this.glbObj.itemsperunit_lst.clear();
            for (int i = 0; i < this.glbObj.items_vnitemid_lst.size(); ++i) {
                this.glbObj.items_vnitemid_cur = this.glbObj.items_vnitemid_lst.get(i).toString();
                this.tlvObj.setTlv(31);
                this.log.delim = "\\^";
                System.out.println("tlv set==" + this.glbObj.tlvStr);
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.items_names_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^1_itemname").get(0).toString());
                this.glbObj.items_chid_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^2_chapterid").get(0).toString());
                this.glbObj.items_hsn_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^3_hsn").get(0).toString());
                this.glbObj.items_gst_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^4_gst").get(0).toString());
                this.glbObj.brandname_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^6_brandname").get(0).toString());
                this.glbObj.quantity_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^7_qnty").get(0).toString());
                this.glbObj.mrp_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^8_mrp").get(0).toString());
                this.glbObj.unitdescr_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9_unitdescr").get(0).toString());
                this.glbObj.itemsperunit_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9a_itemsperunit").get(0).toString());
                this.glbObj.item_invusrid_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9b_invusrid").get(0).toString());
                this.glbObj.items_orgid_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9c_orgid").get(0).toString());
                System.out.println("this.glbObj.items_names_lst===============" + this.glbObj.items_names_lst);
                check = true;
            }
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean update_Stock_Item_Details() throws IOException {
        boolean c;
        boolean check = false;
        this.tlvObj.setTlv(32);
        if (this.glbObj.stock_expense) {
            this.log.delim = "\\.";
        }
        if (this.glbObj.stock_build) {
            this.log.delim = "\\^";
        }
        if (!(c = this.log.check_startup_credentials(this.glbObj.req_type))) {
            return false;
        }
        this.log.AppLock();
        this.dblib.skip_db_exec = true;
        this.do_all_network();
        check = this.log.error_code == 0;
        this.log.AppUnLock();
        this.log.delim = "\\.";
        return check;
    }

    public void get_userid_from_tinventoryusertbl() {
        String feature = "Load vendor";
        this.generic_clear_list_fn(feature);
        feature = "";
        String q = "select invusrname,invusrid,usrid,verticle,orgid,firmname,firmaddress,firmregno,firmgstno,firmid,tfirmtbl.status,expiry,smsquota,remsms,chairpersonname,chairpersonnum,countryid,stateid,districtid,talukid,cityid,area,street,lat,lng,type,firmtype from trueguide.tfirmtbl,trueguide.tinventoryusertbl where firmid=orgid and prev>'0' and tinventoryusertbl.status='1'";
        this.glbObj.req_type = 709;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return;
        }
        if (this.log.error_code == 2) {
            return;
        }
        this.glbObj.username_lst = this.log.GetValuesFromTbl("X^1_1");
        this.glbObj.invt_userid_lst = this.log.GetValuesFromTbl("X^2_2");
        this.glbObj.user_id_lst = this.log.GetValuesFromTbl("X^3_3");
        this.glbObj.invt_verticle_lst = this.log.GetValuesFromTbl("X^4_4");
        this.glbObj.invt_org_lst = this.log.GetValuesFromTbl("X^5_5");
        this.glbObj.firmname_lst = this.log.GetValuesFromTbl("X^6_6");
        this.glbObj.firmaddress_lst = this.log.GetValuesFromTbl("X^7_7");
        this.glbObj.firmregno_lst = this.log.GetValuesFromTbl("X^8_8");
        this.glbObj.firmgstno_lst = this.log.GetValuesFromTbl("X^9_9");
    }

    public void get_vendorname_using_userid_from_usertable() {
        boolean check = false;
        this.glbObj.username_lst.clear();
        for (int i = 0; i < this.glbObj.user_id_lst.size(); ++i) {
            this.glbObj.user_id_cur = this.glbObj.user_id_lst.get(i).toString();
            this.glbObj.invt_org_cur = this.glbObj.invt_org_lst.get(i).toString();
            this.glbObj.invt_verticle_cur = this.glbObj.invt_verticle_lst.get(i).toString();
            String q = "select invusrname from trueguide.tinventoryusertbl where usrid='" + this.glbObj.user_id_cur + "' and orgid='" + this.glbObj.invt_org_cur + "' and verticle='" + this.glbObj.invt_verticle_cur + "'";
            this.glbObj.req_type = 709;
            this.tlvObj.glbObj.tlvStr = q;
            this.tlvObj.glbObj.req_type = this.glbObj.req_type;
            this.dblib.pme.delim = "\\^";
            this.log.delim = "\\^";
            try {
                this.do_all_network();
                System.out.println("rcv=" + this.log.rcv_buff);
            }
            catch (IOException ex) {
                Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.log.error_code != 0) {
                return;
            }
            if (this.log.error_code == 2) {
                return;
            }
            this.glbObj.username_lst.add(this.log.GetValuesFromTbl("X^1_1").get(0).toString());
        }
    }

    public boolean get_chapterid_from_tinvitemtbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(35);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.chaptid_lst = this.log.GetValuesFromTbl("tinvitemtbl.1_distinct chapterid");
            System.out.println("Chapterid List=========>>>>>>" + this.glbObj.chaptid_lst);
            check = true;
        }
        return check;
    }

    public boolean get_chaptname_from_chaptid() throws IOException {
        boolean check = false;
        this.glbObj.chaptname_lst.clear();
        for (int i = 0; i < this.glbObj.chaptid_lst.size(); ++i) {
            this.glbObj.chaptid_cur = this.glbObj.chaptid_lst.get(i).toString();
            this.tlvObj.setTlv(36);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.glbObj.chaptname_lst.add(this.log.GetValuesFromTbl("pchaptertbl.1_chaptername").get(0).toString());
            System.out.println("Chapter name List=========>>>>>>" + this.glbObj.chaptname_lst);
            check = true;
        }
        System.out.println("Chapter name List=========>>>>>>7" + this.glbObj.chaptname_lst);
        return check;
    }

    public boolean get_headingid_from_tinvitemtbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(37);
        this.log.delim = "\\^";
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.headingid_lst = this.log.GetValuesFromTbl("tinvitemtbl^1_distinct headingid");
            System.out.println("headingid List=========>>>>>>" + this.glbObj.headingid_lst);
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_headingname_from_headingid() throws IOException {
        boolean check = false;
        this.glbObj.headingname_lst.clear();
        for (int i = 0; i < this.glbObj.headingid_lst.size(); ++i) {
            this.glbObj.headingid_cur = this.glbObj.headingid_lst.get(i).toString();
            this.tlvObj.setTlv(38);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.glbObj.headingname_lst.add(this.log.GetValuesFromTbl("pheadingtbl.1_headingname").get(0).toString());
            System.out.println("heading name List=========>>>>>>" + this.glbObj.headingname_lst);
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public boolean get_subheadingid_from_tinvitemtbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(39);
        this.log.delim = "\\^";
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.subheadingid_lst = this.log.GetValuesFromTbl("tinvitemtbl^1_distinct subheadingid");
            System.out.println("subheadingid List=========>>>>>>" + this.glbObj.subheadingid_lst);
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_subheadingname_from_subheadingid() throws IOException {
        boolean check = false;
        this.glbObj.subheadingname_lst.clear();
        for (int i = 0; i < this.glbObj.subheadingid_lst.size(); ++i) {
            this.glbObj.subheadingid_cur = this.glbObj.subheadingid_lst.get(i).toString();
            this.tlvObj.setTlv(40);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.glbObj.subheadingname_lst.add(this.log.GetValuesFromTbl("psubheadingtbl.1_subheadingname").get(0).toString());
            System.out.println("subheading name List=========>>>>>>" + this.glbObj.subheadingname_lst);
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public boolean get_itemid_from_tinvitemtbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(41);
        this.log.delim = "\\^";
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.itemid_lst = this.log.GetValuesFromTbl("tinvitemtbl^1_itemid");
            System.out.println("Item id List=========>>>>>>" + this.glbObj.itemid_lst);
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_itemname_from_itemid() throws IOException {
        boolean check = false;
        this.glbObj.itemname_lst.clear();
        this.glbObj.item_hsn_lst.clear();
        this.glbObj.item_brand_lst.clear();
        this.glbObj.item_qnty_lst.clear();
        this.glbObj.item_gst_lst.clear();
        this.glbObj.item_mrp_lst.clear();
        this.glbObj.item_chid_lst.clear();
        this.glbObj.item_headid_lst.clear();
        this.glbObj.item_subheadid_lst.clear();
        this.glbObj.item_unitdescrp_lst.clear();
        this.glbObj.items_perunit_lst.clear();
        for (int i = 0; i < this.glbObj.itemid_lst.size(); ++i) {
            this.glbObj.itemid_cur = this.glbObj.itemid_lst.get(i).toString();
            this.tlvObj.setTlv(42);
            this.log.delim = "\\^";
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.glbObj.itemname_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^1_itemname").get(0).toString());
            this.glbObj.item_hsn_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^2_hsn").get(0).toString());
            this.glbObj.item_brand_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^3_brandname").get(0).toString());
            this.glbObj.item_qnty_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^4_qnty").get(0).toString());
            this.glbObj.item_gst_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^5_gst").get(0).toString());
            this.glbObj.item_mrp_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^6_mrp").get(0).toString());
            this.glbObj.item_chid_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^7_chapterid").get(0).toString());
            this.glbObj.item_headid_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^8_headingid").get(0).toString());
            this.glbObj.item_subheadid_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9_subheadingid").get(0).toString());
            this.glbObj.item_unitdescrp_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9a_unitdescr").get(0).toString());
            this.glbObj.items_perunit_lst.add(this.log.GetValuesFromTbl("tinvitemtbl^9b_itemsperunit").get(0).toString());
            System.out.println("item name List=========>>>>>>" + this.glbObj.itemname_lst);
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_firm_details_of_vendor() throws IOException {
        boolean check = false;
        this.glbObj.firmname_lst.clear();
        this.glbObj.firmaddress_lst.clear();
        this.glbObj.firmregno_lst.clear();
        this.glbObj.firmgstno_lst.clear();
        for (int i = 0; i < this.glbObj.invt_org_lst.size(); ++i) {
            boolean c;
            this.glbObj.org_id_cur = this.glbObj.invt_org_lst.get(i).toString();
            this.glbObj.vertical_cur = this.glbObj.invt_verticle_lst.get(i).toString();
            this.tlvObj.setTlv(43);
            if (this.glbObj.vertical_cur.equals("academic")) {
                this.log.delim = "\\.";
            }
            if (this.glbObj.vertical_cur.equals("non_academic")) {
                this.log.delim = "\\^";
            }
            if (!(c = this.log.check_startup_credentials(this.glbObj.req_type))) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            if (this.glbObj.vertical_cur.equals("academic")) {
                this.glbObj.firmname_lst.add(this.log.GetValuesFromTbl("pinsttbl.1_instname").get(0).toString());
                this.glbObj.firmaddress_lst.add(this.log.GetValuesFromTbl("pinsttbl.2_address").get(0).toString());
                this.glbObj.firmregno_lst.add(this.log.GetValuesFromTbl("pinsttbl.3_regno").get(0).toString());
                this.glbObj.firmgstno_lst.add(this.log.GetValuesFromTbl("pinsttbl.4_gstno").get(0).toString());
            }
            if (this.glbObj.vertical_cur.equals("non_academic")) {
                this.glbObj.firmname_lst.add(this.log.GetValuesFromTbl("tfirmtbl^1_firmname").get(0).toString());
                this.glbObj.firmaddress_lst.add(this.log.GetValuesFromTbl("tfirmtbl^2_firmaddress").get(0).toString());
                this.glbObj.firmregno_lst.add(this.log.GetValuesFromTbl("tfirmtbl^3_firmregno").get(0).toString());
                this.glbObj.firmgstno_lst.add(this.log.GetValuesFromTbl("tfirmtbl^4_firmgstno").get(0).toString());
            }
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean insert_purchase_order_details_into_tinvordertbl() throws IOException {
        boolean check = false;
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yy/MM/dd");
        this.glbObj.date = format.format(date);
        this.glbObj.time = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
        System.out.println("im in the lib now.............");
        this.dblib.pme.delim = "\\^";
        this.tlvObj.setTlv(44);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("tinvordertbl^1_ordid");
            System.out.println("glbObj.porder_id_current===============" + this.dblib.autoIncr);
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_order_id_from_ttinvordertbl() throws IOException {
        boolean check = false;
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yy/MM/dd");
        this.glbObj.date = format.format(date);
        this.glbObj.time = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
        this.tlvObj.setTlv(45);
        this.log.delim = "\\^";
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.orderid_cur = this.log.GetValuesFromTbl("tinvordertbl^1_ordid").get(0).toString();
            System.out.println("orderid_cur=============" + this.glbObj.orderid_cur);
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean insert_purchase_order_item_details_into_tinvorderitemtbl() throws IOException {
        boolean check = false;
        System.out.println("im in lib.............. tlv 46");
        for (int i = 0; i < this.glbObj.pitem_name_list.size(); ++i) {
            this.glbObj.order_vnitm_id_cur = this.glbObj.pitem_vnitemid_list.get(i).toString();
            this.glbObj.order_itm_ch_id_cur = this.glbObj.pitem_chapterid_list.get(i).toString();
            this.glbObj.order_item_name_cur = this.glbObj.pitem_name_list.get(i).toString();
            this.glbObj.order_item_brand_cur = this.glbObj.pitem_brandname_list.get(i).toString();
            this.glbObj.order_item_hsn_cur = this.glbObj.pitem_hsn_list.get(i).toString();
            this.glbObj.order_item_gst_cur = this.glbObj.pitem_gst_list.get(i).toString();
            this.glbObj.order_item_mrp_cur = this.glbObj.pitem_cost_list.get(i).toString();
            this.glbObj.order_total_items_cost_cur = this.glbObj.pitem_total_item_cost_list.get(i).toString();
            this.glbObj.order_item_qty_reqd_cur = this.glbObj.pitem_quantity_list.get(i).toString();
            this.glbObj.order_item_descr_cur = this.glbObj.pitem_unitdescr_cur_list.get(i).toString();
            this.glbObj.order_item_unitdescr_cur = this.glbObj.unitdescr_lst.get(i).toString();
            this.glbObj.order_items_per_unit_cur = this.glbObj.itemsperunit_lst.get(i).toString();
            System.out.println("pitem_quantity_list==============" + this.glbObj.pitem_quantity_list);
            System.out.println("unitdescr_lst==============" + this.glbObj.unitdescr_lst);
            this.tlvObj.setTlv(46);
            this.log.delim = "\\^";
            boolean ch = false;
            this.dblib.skip_db_exec = true;
            this.dblib.get_from_db(this.glbObj.tlvStr);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.dblib.PostDBExec("tinvorderitemtbl^1_orditemid");
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_all_purchase_order_details() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.log.delim = "\\.";
            this.tlvObj.setTlv(47);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.orderid_lst.clear();
                this.glbObj.orderid_lst = this.log.GetValuesFromTbl("tinvordertbl.1_ordid");
                check = true;
            }
            System.out.println("this.glbObj.orderid_lst====" + this.glbObj.orderid_lst);
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.toorgid_list.clear();
            this.glbObj.toorgname_list.clear();
            this.glbObj.toinvusrid_list.clear();
            this.glbObj.orddescr_list.clear();
            this.glbObj.orditem_list.clear();
            this.glbObj.ordcost_list.clear();
            this.glbObj.orddate_list.clear();
            this.glbObj.ordtime_list.clear();
            this.glbObj.refl_tostock_list.clear();
            this.glbObj.fromorgname_list.clear();
            for (int i = 0; i < this.glbObj.orderid_lst.size(); ++i) {
                this.glbObj.orderid_cur = this.glbObj.orderid_lst.get(i).toString();
                this.tlvObj.setTlv(47);
                this.log.delim = "\\^";
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.toorgid_list.add(this.log.GetValuesFromTbl("tinvordertbl^2_toorgid").get(0).toString());
                this.glbObj.toorgname_list.add(this.log.GetValuesFromTbl("tinvordertbl^3_toorgname").get(0).toString());
                this.glbObj.toinvusrid_list.add(this.log.GetValuesFromTbl("tinvordertbl^4_toinvusrid").get(0).toString());
                this.glbObj.orddescr_list.add(this.log.GetValuesFromTbl("tinvordertbl^5_orddescr").get(0).toString());
                this.glbObj.orditem_list.add(this.log.GetValuesFromTbl("tinvordertbl^6_orditems").get(0).toString());
                this.glbObj.ordcost_list.add(this.log.GetValuesFromTbl("tinvordertbl^7_ordcost").get(0).toString());
                this.glbObj.orddate_list.add(this.log.GetValuesFromTbl("tinvordertbl^8_orddate").get(0).toString());
                this.glbObj.ordtime_list.add(this.log.GetValuesFromTbl("tinvordertbl^9_ordtime").get(0).toString());
                this.glbObj.refl_tostock_list.add(this.log.GetValuesFromTbl("tinvordertbl^9a_reflecttostock").get(0).toString());
                this.glbObj.fromorgname_list.add(this.log.GetValuesFromTbl("tinvordertbl^9c_fromorgname").get(0).toString());
                check = true;
            }
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_all_purchase_order_item_details_for_particular_po() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(48);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.orditemid_lst = this.log.GetValuesFromTbl("tinvorderitemtbl.1_orditemid");
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.vnitemid_lst.clear();
            this.glbObj.orditem_name_lst.clear();
            this.glbObj.orditem_hsn_lst.clear();
            this.glbObj.orditem_qty_lst.clear();
            this.glbObj.orditem_gst_lst.clear();
            this.glbObj.orditem_unitcost_lst.clear();
            this.glbObj.orditem_totcost_lst.clear();
            this.glbObj.orditem_descr_list.clear();
            this.glbObj.orditem_chid_list.clear();
            this.glbObj.orditem_headid_list.clear();
            this.glbObj.orditem_subheadid_list.clear();
            for (int i = 0; i < this.glbObj.orditemid_lst.size(); ++i) {
                this.glbObj.orditemid_curr = this.glbObj.orditemid_lst.get(i).toString();
                this.tlvObj.setTlv(48);
                this.log.delim = "\\^";
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.vnitemid_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^2_vnitemid").get(0).toString());
                this.glbObj.orditem_name_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^3_itemname").get(0).toString());
                this.glbObj.orditem_hsn_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^4_hsn").get(0).toString());
                this.glbObj.orditem_qty_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^5_qnty").get(0).toString());
                this.glbObj.orditem_gst_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^6_gst").get(0).toString());
                this.glbObj.orditem_unitcost_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^7_unitcost").get(0).toString());
                this.glbObj.orditem_totcost_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^8_totcost").get(0).toString());
                this.glbObj.orditem_descr_list.add(this.log.GetValuesFromTbl("tinvorderitemtbl^9_itemdescr").get(0).toString());
                this.glbObj.orditem_chid_list.add(this.log.GetValuesFromTbl("tinvorderitemtbl^9a_chapterid").get(0).toString());
                System.out.println("this.glbObj.itmid_lst===>=>=>=>=>=>=>=" + this.glbObj.itmid_lst);
                System.out.println("this.glbObj.orditem_hsn_lst========" + this.glbObj.orditem_hsn_lst);
                System.out.println("this.glbObj.orditem_descr_list========" + this.glbObj.orditem_descr_list);
                check = true;
            }
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_all_purchase_order_details_for_Vendor() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.glbObj.ordrid_lst.clear();
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            this.tlvObj.setTlv(49);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.ordrid_lst = this.log.GetValuesFromTbl("tinvordertbl.1_ordid");
                System.out.println("this.glbObj.ordrid_lst" + this.glbObj.ordrid_lst);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.fromorgid_list.clear();
            this.glbObj.fromorgname_list.clear();
            this.glbObj.frominvusrid_list.clear();
            this.glbObj.ordrdescr_list.clear();
            this.glbObj.ordritems_list.clear();
            this.glbObj.ordrcost_list.clear();
            this.glbObj.ordrdate_list.clear();
            this.glbObj.ordrtime_list.clear();
            this.glbObj.refl_tostock_lst.clear();
            this.glbObj.toinvusrid_list.clear();
            for (int i = 0; i < this.glbObj.ordrid_lst.size(); ++i) {
                this.glbObj.ordrid_cur = this.glbObj.ordrid_lst.get(i).toString();
                this.log.delim = "\\^";
                this.tlvObj.setTlv(49);
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    this.log.delim = "\\.";
                    continue;
                }
                this.glbObj.fromorgid_list.add(this.log.GetValuesFromTbl("tinvordertbl^2_fromorgid").get(0).toString());
                this.glbObj.fromorgname_list.add(this.log.GetValuesFromTbl("tinvordertbl^3_fromorgname").get(0).toString());
                this.glbObj.frominvusrid_list.add(this.log.GetValuesFromTbl("tinvordertbl^4_frominvusrid").get(0).toString());
                this.glbObj.ordrdescr_list.add(this.log.GetValuesFromTbl("tinvordertbl^5_orddescr").get(0).toString());
                this.glbObj.ordritems_list.add(this.log.GetValuesFromTbl("tinvordertbl^6_orditems").get(0).toString());
                this.glbObj.ordrcost_list.add(this.log.GetValuesFromTbl("tinvordertbl^7_ordcost").get(0).toString());
                this.glbObj.ordrdate_list.add(this.log.GetValuesFromTbl("tinvordertbl^8_orddate").get(0).toString());
                this.glbObj.ordrtime_list.add(this.log.GetValuesFromTbl("tinvordertbl^9_ordtime").get(0).toString());
                this.glbObj.refl_tostock_lst.add(this.log.GetValuesFromTbl("tinvordertbl^9a_reflecttostock").get(0).toString());
                this.glbObj.toinvusrid_list.add(this.log.GetValuesFromTbl("tinvordertbl^9d_toinvusrid").get(0).toString());
                check = true;
            }
            this.log.delim = "\\.";
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_all_purchase_order_item_details_for_vendor() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(50);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.ordritemid_lst = this.log.GetValuesFromTbl("tinvorderitemtbl.1_orditemid");
                System.out.println("this.glbObj.item_id_lst========>>>>>>" + this.glbObj.item_id_lst);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.vnitemid_lst.clear();
            this.glbObj.ordritem_name_lst.clear();
            this.glbObj.ordritem_hsn_lst.clear();
            this.glbObj.ordritem_qty_lst.clear();
            this.glbObj.ordritem_gst_lst.clear();
            this.glbObj.ordritem_unitcost_lst.clear();
            this.glbObj.ordritem_totcost_lst.clear();
            this.glbObj.ordritem_descr_list.clear();
            this.glbObj.ordritem_chid_list.clear();
            for (int i = 0; i < this.glbObj.ordritemid_lst.size(); ++i) {
                this.glbObj.ordritemid_curr = this.glbObj.ordritemid_lst.get(i).toString();
                this.tlvObj.setTlv(50);
                this.log.delim = "\\^";
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.vnitemid_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^2_vnitemid").get(0).toString());
                this.glbObj.ordritem_name_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^3_itemname").get(0).toString());
                this.glbObj.ordritem_hsn_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^4_hsn").get(0).toString());
                this.glbObj.ordritem_qty_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^5_qnty").get(0).toString());
                this.glbObj.ordritem_gst_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^6_gst").get(0).toString());
                this.glbObj.ordritem_unitcost_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^7_unitcost").get(0).toString());
                this.glbObj.ordritem_totcost_lst.add(this.log.GetValuesFromTbl("tinvorderitemtbl^8_totcost").get(0).toString());
                this.glbObj.ordritem_descr_list.add(this.log.GetValuesFromTbl("tinvorderitemtbl^9_itemdescr").get(0).toString());
                this.glbObj.ordritem_chid_list.add(this.log.GetValuesFromTbl("tinvorderitemtbl^9a_chapterid").get(0).toString());
                System.out.println("this.glbObj.item_id_lst=====>=>=>=>=>" + this.glbObj.item_id_lst);
                System.out.println("this.glbObj.ordritem_name_lst========>=>=>=>=>>" + this.glbObj.ordritem_name_lst);
                check = true;
            }
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean update_Purchase_order_status_for_vendor() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(51);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        check = this.log.error_code == 0;
        return check;
    }

    public boolean get_quantity_from_itemid_in_stock() throws IOException {
        int oqty;
        boolean c;
        int i;
        boolean check = false;
        if (this.glbObj.from_feature.equals("Sales")) {
            for (i = 0; i < this.glbObj.vnitemid_lst.size(); ++i) {
                this.glbObj.vnitemid_cur = this.glbObj.vnitemid_lst.get(i).toString();
                this.glbObj.ordr_qty_cur = this.glbObj.ordritem_qty_lst.get(i).toString();
                this.glbObj.ordritem_name_cur = this.glbObj.ordritem_name_lst.get(i).toString();
                this.glbObj.ordritem_brand_cur = this.glbObj.ordritem_brand_lst.get(i).toString();
                this.glbObj.ordritem_hsn_cur = this.glbObj.ordritem_hsn_lst.get(i).toString();
                this.glbObj.ordritem_gst_cur = this.glbObj.ordritem_gst_lst.get(i).toString();
                this.glbObj.ordritem_unitcost_cur = this.glbObj.ordritem_unitcost_lst.get(i).toString();
                this.glbObj.ordritem_totcost_cur = this.glbObj.ordritem_totcost_lst.get(i).toString();
                this.glbObj.ordritem_descr_cur = this.glbObj.ordritem_descr_list.get(i).toString();
                this.glbObj.ordritem_chid_cur = this.glbObj.ordritem_chid_list.get(i).toString();
                System.out.println("this.glbObj.vnitem_id_lst==>=>=>=>=>" + this.glbObj.vnitemid_lst);
                this.tlvObj.setTlv(52);
                c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.stock_qnty_cur = this.log.GetValuesFromTbl("tinvitemtbl.1_qnty").get(0).toString();
                this.glbObj.item_vnitemid_curr = this.log.GetValuesFromTbl("tinvitemtbl.2_vnitemid").get(0).toString();
                System.out.println("this.glbObj.stock_qnty_cur=>=>=>=>" + this.glbObj.stock_qnty_cur);
                System.out.println("this.glbObj.item_vnitemid_curr=>=>=>=>" + this.glbObj.item_vnitemid_curr);
                int sqty = Integer.parseInt(this.glbObj.stock_qnty_cur);
                oqty = Integer.parseInt(this.glbObj.ordr_qty_cur);
                this.glbObj.tot_item_qty = sqty - oqty + "";
                System.out.println("this.glbObj.tot_item_qty=======>>>>" + this.glbObj.tot_item_qty);
                this.edit_stock_sales();
                check = true;
            }
        }
        if (this.glbObj.from_feature.equals("Purchase")) {
            this.glbObj.tot_item_qty = "";
            for (i = 0; i < this.glbObj.vnitemid_lst.size(); ++i) {
                this.glbObj.vnitemid_cur = this.glbObj.vnitemid_lst.get(i).toString();
                this.glbObj.orditem_qty_cur = this.glbObj.orditem_qty_lst.get(i).toString();
                this.glbObj.orditem_name_cur = this.glbObj.orditem_name_lst.get(i).toString();
                this.glbObj.orditem_hsn_cur = this.glbObj.orditem_hsn_lst.get(i).toString();
                this.glbObj.orditem_gst_cur = this.glbObj.orditem_gst_lst.get(i).toString();
                this.glbObj.orditem_unitcost_cur = this.glbObj.orditem_unitcost_lst.get(i).toString();
                this.glbObj.orditem_totcost_cur = this.glbObj.orditem_totcost_lst.get(i).toString();
                this.glbObj.orditem_descr_cur = this.glbObj.orditem_descr_list.get(i).toString();
                this.glbObj.orditem_chid_cur = this.glbObj.orditem_chid_list.get(i).toString();
                System.out.println("this.glbObj.item_id_lst========" + this.glbObj.vnitemid_cur);
                System.out.println("this.glbObj.orditem_qty_cur========" + this.glbObj.orditem_qty_cur);
                this.tlvObj.setTlv(52);
                c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                this.do_all_network();
                if (this.log.error_code == 2) {
                    String query = "";
                    query = "insert into trueguide.tinvitemtbl(itemname,chapterid,hsn,gst,invusrid,orgid,qnty,mrp,unitdescr) values('" + this.glbObj.orditem_name_cur + "','" + this.glbObj.orditem_chid_cur + "','" + this.glbObj.orditem_hsn_cur + "','" + this.glbObj.orditem_gst_cur + "','" + this.glbObj.invt_usrid + "','" + this.glbObj.orgid + "','" + this.glbObj.orditem_qty_cur + "','" + this.glbObj.orditem_unitcost_cur + "','1') returning vnitemid;";
                    this.non_select(query);
                    continue;
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.stock_qnty_cur = this.log.GetValuesFromTbl("tinvitemtbl.1_qnty").get(0).toString();
                this.glbObj.item_vnitemid_curr = this.log.GetValuesFromTbl("tinvitemtbl.2_vnitemid").get(0).toString();
                int sqty = Integer.parseInt(this.glbObj.stock_qnty_cur);
                oqty = Integer.parseInt(this.glbObj.orditem_qty_cur);
                System.out.println("sqty===============" + this.glbObj.stock_qnty_cur);
                System.out.println("oqty===============" + this.glbObj.orditem_qty_cur);
                this.glbObj.tot_item_qty = sqty + oqty + "";
                this.glbObj.reflect_totinvitemtblstock = true;
                this.glbObj.insert_stock = true;
                check = true;
            }
        }
        return check;
    }

    public boolean update_reflect_to_stock_status() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(53);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        check = this.log.error_code == 0;
        return check;
    }

    public boolean get_all_the_firm_details() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(54);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.firm_orgid_list = this.log.GetValuesFromTbl("tfirmtbl.1_firmid");
                System.out.println("this.glbObj.firm_name_list==========" + this.glbObj.firm_name_list);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.firm_name_list.clear();
            this.glbObj.firm_addrs_list.clear();
            this.glbObj.firm_regno_list.clear();
            this.glbObj.firm_gstno_list.clear();
            this.glbObj.firm_type_list.clear();
            this.glbObj.firm_status_lst.clear();
            for (int i = 0; i < this.glbObj.firm_orgid_list.size(); ++i) {
                this.glbObj.firm_orgid_curr = this.glbObj.firm_orgid_list.get(i).toString();
                this.tlvObj.setTlv(54);
                this.log.delim = "\\^";
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.firm_name_list.add(this.log.GetValuesFromTbl("tfirmtbl^2_firmname").get(0).toString());
                this.glbObj.firm_addrs_list.add(this.log.GetValuesFromTbl("tfirmtbl^3_firmaddress").get(0).toString());
                this.glbObj.firm_regno_list.add(this.log.GetValuesFromTbl("tfirmtbl^4_firmregno").get(0).toString());
                this.glbObj.firm_gstno_list.add(this.log.GetValuesFromTbl("tfirmtbl^5_firmgstno").get(0).toString());
                this.glbObj.firm_type_list.add(this.log.GetValuesFromTbl("tfirmtbl^6_firmtype").get(0).toString());
                this.glbObj.firm_status_lst.add(this.log.GetValuesFromTbl("tfirmtbl^7_status").get(0).toString());
                System.out.println("this.glbObj.firm_name_list==========" + this.glbObj.firm_name_list);
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean insert_stock_expense_details_into_tinvstockexptbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(55);
        this.log.delim = "\\^";
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("tinvstockexptbl^1_expitemid");
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_all_stock_expense_details() throws IOException {
        boolean check = false;
        this.glbObj.cost_lst.clear();
        this.log.delim = "\\^";
        this.tlvObj.setTlv(56);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            // empty if block
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            check = false;
        } else if (!this.glbObj.ids_only) {
            this.glbObj.items_names_lst = this.log.GetValuesFromTbl("tinvdecremented^1_itemname");
            this.glbObj.mrp_lst = this.log.GetValuesFromTbl("tinvdecremented^2_priceperunit");
            this.glbObj.gst_lst = this.log.GetValuesFromTbl("tinvdecremented^3_gst");
            this.glbObj.decrementedC = this.log.GetValuesFromTbl("tinvdecremented^4_decrementedC");
            this.glbObj.hsn_lst = this.log.GetValuesFromTbl("tinvdecremented^5_hsn");
            this.glbObj.sr_list = this.log.GetValuesFromTbl("tinvdecremented^6_sr");
            this.glbObj.ddate = this.log.GetValuesFromTbl("tinvdecremented^7_ddate");
            this.glbObj.dtime = this.log.GetValuesFromTbl("tinvdecremented^8_dtime");
            this.glbObj.decrementer_remark_list = this.log.GetValuesFromTbl("tinvdecremented^9_remark");
            this.glbObj.decremented_unit_lst = this.log.GetValuesFromTbl("tinvdecremented^9a_unit");
            this.glbObj.cost_lst = this.log.GetValuesFromTbl("tinvdecremented^9b_cost");
            this.log.delim = "\\.";
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean update_decrement_item_count() throws IOException {
        boolean check = false;
        this.dblib.pme.delim = "\\^";
        this.tlvObj.setTlv(10);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.log.AppLock();
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
            this.log.delim = "\\.";
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        this.log.AppUnLock();
        this.log.delim = "\\.";
        return check;
    }

    public boolean insert_decremented_count() throws IOException {
        this.glbObj.cost_lst.clear();
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(67);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            // empty if block
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            check = false;
        } else if (this.glbObj.todays_reports) {
            this.glbObj.items_names_lst = this.log.GetValuesFromTbl("tinvdecremented^1_itemname");
            this.glbObj.mrp_lst = this.log.GetValuesFromTbl("tinvdecremented^2_priceperunit");
            this.glbObj.gst_lst = this.log.GetValuesFromTbl("tinvdecremented^3_gst");
            this.glbObj.decrementedC = this.log.GetValuesFromTbl("tinvdecremented^4_decrementedC");
            this.glbObj.hsn_lst = this.log.GetValuesFromTbl("tinvdecremented^5_hsn");
            this.glbObj.sr_list = this.log.GetValuesFromTbl("tinvdecremented^6_sr");
            this.glbObj.ddate = this.log.GetValuesFromTbl("tinvdecremented^7_ddate");
            this.glbObj.dtime = this.log.GetValuesFromTbl("tinvdecremented^8_dtime");
            this.glbObj.decrementer_remark_list = this.log.GetValuesFromTbl("tinvdecremented^9_remark");
            this.glbObj.decremented_unit_lst = this.log.GetValuesFromTbl("tinvdecremented^9a_unit");
            this.glbObj.cost_lst = this.log.GetValuesFromTbl("tinvdecremented^9b_cost");
            System.out.println("item");
            this.log.delim = "\\.";
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public void insert_Stock_items_into_tinvnewstock() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(57);
        this.log.delim = "\\^";
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (this.glbObj.insert_stock) {
                // empty if block
            }
            if (!this.glbObj.insert_stock) {
                this.dblib.PostDBExec("");
            }
            check = true;
        }
        this.log.delim = "\\.";
    }

    public void new_stock_reorts() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(58);
        this.log.delim = "\\^";
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.items_names_lst = this.log.GetValuesFromTbl("tinvnewstock^1_itemname");
            this.glbObj.brandname_lst = this.log.GetValuesFromTbl("tinvnewstock^2_brand");
            this.glbObj.mrp_lst = this.log.GetValuesFromTbl("tinvnewstock^3_cost");
            this.glbObj.hsn_lst = this.log.GetValuesFromTbl("tinvnewstock^4_hsn");
            this.glbObj.gst_lst = this.log.GetValuesFromTbl("tinvnewstock^5_gst");
            this.glbObj.decrementedC = this.log.GetValuesFromTbl("tinvnewstock^6_quantity");
            this.glbObj.ddate = this.log.GetValuesFromTbl("tinvnewstock^7_ddate");
            this.glbObj.dtime = this.log.GetValuesFromTbl("tinvnewstock^8_dtime");
            System.out.println("item name==============" + this.glbObj.items_names_lst);
            System.out.println("item name==============" + this.glbObj.brandname_lst);
            this.log.delim = "\\.";
            check = true;
        }
        this.log.delim = "\\.";
    }

    public boolean get_selected_items_from_tinvitemtbl() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(59);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            check = false;
        } else {
            this.glbObj.items_names_lst = this.log.GetValuesFromTbl("tinvitemtbl^1_itemname");
            this.glbObj.brandname_lst = this.log.GetValuesFromTbl("tinvitemtbl^2_brandname");
            this.glbObj.mrp_lst = this.log.GetValuesFromTbl("tinvitemtbl^3_mrp");
            this.glbObj.items_gst_lst = this.log.GetValuesFromTbl("tinvitemtbl^4_gst");
            this.glbObj.quantity_lst = this.log.GetValuesFromTbl("tinvitemtbl^5_qnty");
            this.glbObj.unitdescr_lst = this.log.GetValuesFromTbl("tinvitemtbl^6_unitdescr");
            this.glbObj.items_chid_lst = this.log.GetValuesFromTbl("tinvitemtbl^7_chapterid");
            this.glbObj.items_hsn_lst = this.log.GetValuesFromTbl("tinvitemtbl^8_hsn");
            this.glbObj.vnitemid_lst = this.log.GetValuesFromTbl("tinvitemtbl^9_vnitemid");
            this.glbObj.itemsperunit_lst = this.log.GetValuesFromTbl("tinvitemtbl^10_itemsperunit");
            System.out.println("item name==============" + this.glbObj.items_names_lst);
            System.out.println("brandname list==============" + this.glbObj.brandname_lst);
            System.out.println("this.glbObj.mrp_lst==============" + this.glbObj.mrp_lst);
            System.out.println("this.glbObj.gst_lst==============" + this.glbObj.items_gst_lst);
            System.out.println("this.glbObj.unitdescr_lst==============" + this.glbObj.unitdescr_lst);
            check = true;
            this.log.delim = "\\.";
        }
        this.log.delim = "\\.";
        return check;
    }

    public void sales_reports_overall() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(60);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            // empty if block
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.toorgid_list.clear();
            this.glbObj.toorgname_list.clear();
            this.glbObj.toinvusrid_list.clear();
            this.glbObj.orddescr_list.clear();
            this.glbObj.orditem_list.clear();
            this.glbObj.ordcost_list.clear();
            this.glbObj.orddate_list.clear();
            this.glbObj.ordtime_list.clear();
            this.glbObj.refl_tostock_list.clear();
            this.glbObj.toorgid_list = this.log.GetValuesFromTbl("tinvordertbl^1_toorgid");
            this.glbObj.toorgname_list = this.log.GetValuesFromTbl("tinvordertbl^2_toorgname");
            this.glbObj.toinvusrid_list = this.log.GetValuesFromTbl("tinvordertbl^3_toinvusrid");
            this.glbObj.orddescr_list = this.log.GetValuesFromTbl("tinvordertbl^4_orddescr");
            this.glbObj.orditem_list = this.log.GetValuesFromTbl("tinvordertbl^5_orditems");
            this.glbObj.ordcost_list = this.log.GetValuesFromTbl("tinvordertbl^6_ordcost");
            this.glbObj.orddate_list = this.log.GetValuesFromTbl("tinvordertbl^7_orddate");
            this.glbObj.ordtime_list = this.log.GetValuesFromTbl("tinvordertbl^8_ordtime");
            this.glbObj.refl_tostock_list = this.log.GetValuesFromTbl("tinvordertbl^9_reflecttostock");
        }
        this.log.AppUnLock();
        this.log.delim = "\\.";
    }

    public void purchase_reports_overall() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(61);
        boolean ch = false;
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.orditemid_lst.clear();
            this.glbObj.itmid_lst.clear();
            this.glbObj.orditem_name_lst.clear();
            this.glbObj.orditem_brand_lst.clear();
            this.glbObj.orditem_hsn_lst.clear();
            this.glbObj.orditem_qty_lst.clear();
            this.glbObj.orditem_gst_lst.clear();
            this.glbObj.orditem_unitcost_lst.clear();
            this.glbObj.orditem_totcost_lst.clear();
            this.glbObj.orditem_descr_list.clear();
            this.glbObj.orditem_chid_list.clear();
            this.glbObj.orditem_headid_list.clear();
            this.glbObj.orditem_subheadid_list.clear();
            this.glbObj.orderid_lst.clear();
            this.glbObj.orditemid_lst = this.log.GetValuesFromTbl("tinvorderitemtbl^1_orditemid");
            this.glbObj.itmid_lst = this.log.GetValuesFromTbl("tinvorderitemtbl^2_vnitemid");
            this.glbObj.orditem_name_lst = this.log.GetValuesFromTbl("tinvorderitemtbl^3_itemname");
            this.glbObj.orditem_hsn_lst = this.log.GetValuesFromTbl("tinvorderitemtbl^4_hsn");
            this.glbObj.orditem_qty_lst = this.log.GetValuesFromTbl("tinvorderitemtbl^5_qnty");
            this.glbObj.orditem_gst_lst = this.log.GetValuesFromTbl("tinvorderitemtbl^6_gst");
            this.glbObj.orditem_unitcost_lst = this.log.GetValuesFromTbl("tinvorderitemtbl^7_unitcost");
            this.glbObj.orditem_totcost_lst = this.log.GetValuesFromTbl("tinvorderitemtbl^8_totcost");
            this.glbObj.orditem_descr_list = this.log.GetValuesFromTbl("tinvorderitemtbl^9_itemdescr");
            this.glbObj.orditem_chid_list = this.log.GetValuesFromTbl("tinvorderitemtbl^9a_chapterid");
            this.glbObj.orderid_lst = this.log.GetValuesFromTbl("tinvorderitemtbl^9b_ordid");
        }
        this.log.delim = "\\.";
    }

    public boolean get_all_borrow_order_details() throws IOException {
        this.clear_lists_b4_fech();
        boolean check = false;
        this.glbObj.ids_only = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(62);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            // empty if block
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            check = false;
        } else {
            this.glbObj.items_names_lst = this.log.GetValuesFromTbl("tinvdecremented^1_itemname");
            this.glbObj.mrp_lst = this.log.GetValuesFromTbl("tinvdecremented^2_cost");
            this.glbObj.gst_lst = this.log.GetValuesFromTbl("tinvdecremented^3_gst");
            this.glbObj.decrementedC = this.log.GetValuesFromTbl("tinvdecremented^4_decrementedC");
            this.glbObj.hsn_lst = this.log.GetValuesFromTbl("tinvdecremented^5_hsn");
            this.glbObj.sr_list = this.log.GetValuesFromTbl("tinvdecremented^6_sr");
            this.glbObj.ddate = this.log.GetValuesFromTbl("tinvdecremented^7_ddate");
            this.glbObj.dtime = this.log.GetValuesFromTbl("tinvdecremented^8_dtime");
            this.glbObj.decrementer_remark_list = this.log.GetValuesFromTbl("tinvdecremented^9_remark");
            this.glbObj.returndate_lst = this.log.GetValuesFromTbl("tinvdecremented^9a_returndate");
            this.glbObj.returned_lst = this.log.GetValuesFromTbl("tinvdecremented^9b_returned");
            this.glbObj.returnedquantity_lst = this.log.GetValuesFromTbl("tinvdecremented^9c_returnedquantity");
            this.glbObj.items_vnitemid_lst = this.log.GetValuesFromTbl("tinvdecremented^9d_vnitemid");
            this.glbObj.unit_lst = this.log.GetValuesFromTbl("tinvdecremented^9e_unit");
            System.out.println("this.glbObj.items_vnitemid_lst" + this.glbObj.items_vnitemid_lst);
            this.log.delim = "\\.";
            check = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean insert_borrow_summary() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(63);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        check = this.log.error_code == 0;
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_borrow_order_transaction_details() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(64);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.vnitemid_lst.clear();
            this.glbObj.item_qnty_lst.clear();
            this.glbObj.ddate.clear();
            this.glbObj.dtime.clear();
            this.glbObj.return_remark_lst.clear();
            this.glbObj.borrow_unit_lst.clear();
            this.glbObj.vnitemid_lst = this.log.GetValuesFromTbl("tborrowsummary^1_vnitemid");
            this.glbObj.returnedquantity_lst = this.log.GetValuesFromTbl("tborrowsummary^2_quantity");
            this.glbObj.ddate = this.log.GetValuesFromTbl("tborrowsummary^3_returndate");
            this.glbObj.dtime = this.log.GetValuesFromTbl("tborrowsummary^4_returntime");
            this.glbObj.return_remark_lst = this.log.GetValuesFromTbl("tborrowsummary^5_returnremark");
            this.glbObj.borrow_unit_lst = this.log.GetValuesFromTbl("tborrowsummary^6_unit");
            System.out.println("this.glbObj.items_id_lst======" + this.glbObj.items_id_lst);
            System.out.println("this.glbObj.item_qnty_lst======" + this.glbObj.item_qnty_lst);
            System.out.println("this.glbObj.ddate======" + this.glbObj.ddate);
            System.out.println("this.glbObj.dtime======" + this.glbObj.dtime);
            System.out.println("this.glbObj.return_remark_lst======" + this.glbObj.return_remark_lst);
            check = true;
        }
        this.log.AppUnLock();
        this.log.delim = "\\.";
        return check;
    }

    public boolean update_return_status() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(65);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        check = this.log.error_code == 0;
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_curitem_quantity_tinvitemtbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(66);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.borrow_item_quantity = this.log.GetValuesFromTbl("tinvitemtbl.1_qnty").get(0).toString();
            System.out.println("this.glbObj.items_id_lst===============" + this.glbObj.borrow_item_quantity);
            check = true;
        }
        return check;
    }

    public boolean get_all_borrow_details_report() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(68);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            // empty if block
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            check = false;
        } else if (!this.glbObj.ids_only) {
            this.glbObj.items_names_lst = this.log.GetValuesFromTbl("tinvdecremented^1_itemname");
            this.glbObj.mrp_lst = this.log.GetValuesFromTbl("tinvdecremented^2_cost");
            this.glbObj.gst_lst = this.log.GetValuesFromTbl("tinvdecremented^3_gst");
            this.glbObj.decrementedC = this.log.GetValuesFromTbl("tinvdecremented^4_decrementedC");
            this.glbObj.items_id_lst = this.log.GetValuesFromTbl("tinvdecremented^5_vnitemid");
            this.glbObj.hsn_lst = this.log.GetValuesFromTbl("tinvdecremented^6_hsn");
            this.glbObj.sr_list = this.log.GetValuesFromTbl("tinvdecremented^7_sr");
            this.glbObj.ddate = this.log.GetValuesFromTbl("tinvdecremented^8_ddate");
            this.glbObj.dtime = this.log.GetValuesFromTbl("tinvdecremented^9_dtime");
            this.glbObj.decrementer_remark_list = this.log.GetValuesFromTbl("tinvdecremented^9a_remark");
            this.glbObj.returndate_lst = this.log.GetValuesFromTbl("tinvdecremented^9b_returndate");
            this.glbObj.returned_lst = this.log.GetValuesFromTbl("tinvdecremented^9c_returned");
            this.glbObj.returnedquantity_lst = this.log.GetValuesFromTbl("tinvdecremented^9d_returnedquantity");
            this.log.delim = "\\.";
            check = true;
        }
        this.log.AppUnLock();
        this.log.delim = "\\.";
        return check;
    }

    public boolean offerdetails() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(69);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            // empty if block
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            check = false;
        } else {
            this.log.delim = "\\.";
            check = true;
        }
        this.log.AppUnLock();
        this.log.delim = "\\.";
        return check;
    }

    public boolean load_offers() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(70);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                // empty if block
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                this.log.delim = "\\.";
                check = false;
            } else {
                this.glbObj.offerid_lst = this.log.GetValuesFromTbl("addoffers^1_offerid");
                System.out.println("this.glbObj.offerid_lst====" + this.glbObj.offerid_lst);
                this.log.delim = "\\.";
            }
            check = true;
        }
        if (!this.glbObj.ids_only) {
            for (int i = 0; i < this.glbObj.offerid_lst.size(); ++i) {
                this.glbObj.offerid_cur = this.glbObj.offerid_lst.get(i).toString();
                this.log.delim = "\\^";
                this.tlvObj.setTlv(70);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    // empty if block
                }
                this.do_all_network();
                if (this.log.error_code != 0) {
                    this.log.delim = "\\.";
                    check = false;
                    continue;
                }
                this.glbObj.offers_lst.add(this.log.GetValuesFromTbl("addoffers^1_offer").get(0).toString());
                this.glbObj.offercost_lst.add(this.log.GetValuesFromTbl("addoffers^2_cost").get(0).toString());
                this.glbObj.offersdiscount_lst.add(this.log.GetValuesFromTbl("addoffers^3_discount").get(0).toString());
                System.out.println("this.glbObj.offer_lst====" + this.glbObj.offers_lst);
                System.out.println("this.glbObj.offercost_lst====" + this.glbObj.offercost_lst);
                System.out.println("this.glbObj.offersdiscount_lst====" + this.glbObj.offersdiscount_lst);
                this.log.delim = "\\.";
            }
            check = true;
        }
        return check;
    }

    public boolean sms_customers() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(70);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                // empty if block
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                this.log.delim = "\\.";
                check = false;
            } else {
                this.glbObj.smsid_lst = this.log.GetValuesFromTbl("smscustomers^1_smsid");
                System.out.println("this.glbObj.offerid_lst====" + this.glbObj.smsid_lst);
                this.log.delim = "\\.";
            }
            check = true;
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.sms_lst.clear();
            this.glbObj.sms2_lst.clear();
            this.glbObj.sms3_lst.clear();
            for (int i = 0; i < this.glbObj.smsid_lst.size(); ++i) {
                this.glbObj.smsid_cur = this.glbObj.smsid_lst.get(i).toString();
                this.log.delim = "\\^";
                this.tlvObj.setTlv(70);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    // empty if block
                }
                this.do_all_network();
                if (this.log.error_code != 0) {
                    this.log.delim = "\\.";
                    check = false;
                    continue;
                }
                this.glbObj.sms_lst.add(this.log.GetValuesFromTbl("smscustomers^1_customers").get(0).toString());
                this.glbObj.sms2_lst.add(this.log.GetValuesFromTbl("smscustomers^2_contact").get(0).toString());
                this.glbObj.sms3_lst.add(this.log.GetValuesFromTbl("smscustomers^3_address").get(0).toString());
                System.out.println("this.glbObj.sms1_lst====" + this.glbObj.sms_lst);
                System.out.println("this.glbObj.sms2_lst====" + this.glbObj.sms2_lst);
                System.out.println("this.glbObj.sms3_lst====" + this.glbObj.sms3_lst);
                this.log.delim = "\\.";
            }
            check = true;
        }
        return check;
    }

    public boolean load_all_offers() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(71);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                // empty if block
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                this.log.delim = "\\.";
                check = false;
            } else {
                this.glbObj.offerid_lst = this.log.GetValuesFromTbl("addoffers^1_offerid");
                System.out.println("this.glbObj.offerid_lst====" + this.glbObj.offerid_lst);
                this.log.delim = "\\.";
            }
            check = true;
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.offers_lst.clear();
            this.glbObj.offercost_lst.clear();
            this.glbObj.offersdiscount_lst.clear();
            for (int i = 0; i < this.glbObj.offerid_lst.size(); ++i) {
                this.glbObj.offerid_cur = this.glbObj.offerid_lst.get(i).toString();
                this.log.delim = "\\^";
                this.tlvObj.setTlv(71);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    // empty if block
                }
                this.do_all_network();
                if (this.log.error_code != 0) {
                    this.log.delim = "\\.";
                    check = false;
                    continue;
                }
                this.glbObj.offers_lst.add(this.log.GetValuesFromTbl("addoffers^1_offer").get(0).toString());
                this.glbObj.offercost_lst.add(this.log.GetValuesFromTbl("addoffers^2_cost").get(0).toString());
                this.glbObj.offersdiscount_lst.add(this.log.GetValuesFromTbl("addoffers^3_discount").get(0).toString());
                System.out.println("this.glbObj.offers_lst====" + this.glbObj.offers_lst);
                System.out.println("this.glbObj.offercost_lst====" + this.glbObj.offercost_lst);
                System.out.println("this.glbObj.offersdiscount_lst====" + this.glbObj.offersdiscount_lst);
                this.log.delim = "\\.";
            }
            check = true;
        }
        return check;
    }

    public boolean getcontact() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(72);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            // empty if block
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            check = false;
        } else {
            this.glbObj.sms_customer_name = this.log.GetValuesFromTbl("smscustomers^1_customers").get(0).toString();
            this.glbObj.sms_customer_add = this.log.GetValuesFromTbl("smscustomers^2_address").get(0).toString();
            this.glbObj.smsid_cur = this.log.GetValuesFromTbl("smscustomers^3_smsid").get(0).toString();
            System.out.println("this.glbObj.smsid_lst====" + this.glbObj.smsid_lst);
            this.log.delim = "\\.";
        }
        check = true;
        return check;
    }

    public boolean insert_customer_details_smscustomertbl() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(73);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            // empty if block
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            check = false;
        } else {
            this.log.delim = "\\.";
            check = true;
        }
        this.log.AppUnLock();
        this.log.delim = "\\.";
        return check;
    }

    public boolean insert_into_tinvitemdetailstbl() throws IOException {
        boolean check = false;
        this.dblib.pme.delim = "\\.";
        this.tlvObj.setTlv(74);
        boolean ch = false;
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.glbObj.reflect_totinvitemtblstock = false;
            check = false;
        } else {
            if (this.glbObj.insert_stock) {
                // empty if block
            }
            if (!this.glbObj.insert_stock) {
                // empty if block
            }
        }
        this.dblib.pme.delim = "\\.";
        check = true;
        return check;
    }

    public boolean update_hsn_into_tinvitemtbl() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(75);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.log.AppLock();
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        this.log.AppUnLock();
        this.log.delim = "\\.";
        return check;
    }

    public boolean items_insert_excel_into_tinvitemtbl() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(76);
        boolean ch = false;
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.glbObj.reflect_totinvitemtblstock = false;
            check = false;
        } else {
            this.log.delim = "\\.";
            System.out.println("vitemid of the newly inserted item" + this.dblib.autoIncr);
        }
        check = true;
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_all_items_from_tinvitemdetailstbl() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.glbObj.vnitemid_lst.clear();
            this.tlvObj.setTlv(77);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.items_vnitemid_lst = this.glbObj.vnitemid_lst = this.log.GetValuesFromTbl("tinvitemdetailstbl.1_vnitemid");
                System.out.println("this.glbObj.item_id--------" + this.glbObj.vnitemid_lst);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.inwardno_lst.clear();
            this.glbObj.inwarddate_lst.clear();
            this.glbObj.pono_lst.clear();
            this.glbObj.podate_lst.clear();
            this.glbObj.invoiceno_lst.clear();
            this.glbObj.invoicedate_lst.clear();
            this.glbObj.suppliername_lst.clear();
            this.glbObj.receivername_lst.clear();
            this.glbObj.receiveddate_lst.clear();
            this.glbObj.additemremark_lst.clear();
            this.glbObj.transactionmode_lst.clear();
            this.glbObj.bankaccountno_lst.clear();
            this.glbObj.chapter_id_lst.clear();
            this.glbObj.items_names_lst.clear();
            for (int i = 0; i < this.glbObj.vnitemid_lst.size(); ++i) {
                this.glbObj.vnitemid_cur = this.glbObj.vnitemid_lst.get(i).toString();
                this.log.delim = "\\^";
                this.tlvObj.setTlv(77);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    this.log.delim = "\\.";
                    check = false;
                    continue;
                }
                this.glbObj.inwardno_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^1_inwardno").get(0).toString());
                this.glbObj.inwarddate_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^2_inwarddate").get(0).toString());
                this.glbObj.pono_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^3_pono").get(0).toString());
                this.glbObj.podate_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^4_podate").get(0).toString());
                this.glbObj.invoiceno_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^5_invoiceno").get(0).toString());
                this.glbObj.invoicedate_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^6_invoicedate").get(0).toString());
                this.glbObj.suppliername_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^7_suppliername").get(0).toString());
                this.glbObj.receivername_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^8_receivername").get(0).toString());
                this.glbObj.receiveddate_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^9_receiveddate").get(0).toString());
                this.glbObj.additemremark_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^9a_remark").get(0).toString());
                this.glbObj.transactionmode_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^9b_modeofpayment").get(0).toString());
                this.glbObj.bankaccountno_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^9c_bankaccno").get(0).toString());
                this.glbObj.chapter_id_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^9d_chapterid").get(0).toString());
                this.glbObj.items_names_lst.add(this.log.GetValuesFromTbl("tinvitemdetailstbl^9e_itemname").get(0).toString());
                System.out.println("this.glbObj.items_names_lst===" + this.glbObj.items_names_lst);
                System.out.println("this.glbObj.item_name_lst--------" + this.glbObj.item_name_lst);
                this.dblib.PostDBExec(this.log.rcv_buff);
                this.log.delim = "\\.";
                check = true;
            }
        }
        this.log.delim = "\\.";
        return check;
    }

    private void clear_lists_b4_fech() {
        this.glbObj.items_names_lst.clear();
        this.glbObj.mrp_lst.clear();
        this.glbObj.gst_lst.clear();
        this.glbObj.decrementedC.clear();
        this.glbObj.hsn_lst.clear();
        this.glbObj.sr_list.clear();
        this.glbObj.ddate.clear();
        this.glbObj.dtime.clear();
        this.glbObj.decrementer_remark_list.clear();
        this.glbObj.returndate_lst.clear();
        this.glbObj.returned_lst.clear();
        this.glbObj.returnedquantity_lst.clear();
        this.glbObj.items_vnitemid_lst.clear();
        this.glbObj.unit_lst.clear();
    }

    private void generic_clear_list_fn(String type) {
        if (type.equalsIgnoreCase("Load vendor")) {
            this.glbObj.username_lst.clear();
            this.glbObj.invt_userid_lst.clear();
            this.glbObj.user_id_lst.clear();
            this.glbObj.invt_verticle_lst.clear();
            this.glbObj.invt_org_lst.clear();
        } else if (type.equalsIgnoreCase("Load_service_items")) {
            this.glbObj.service_id_lst.clear();
            this.glbObj.service_itemname_lst.clear();
            this.glbObj.service_itemcost_lst.clear();
        } else if (type.equalsIgnoreCase("View_service_items")) {
            this.glbObj.service_id_lst.clear();
            this.glbObj.fromorgid_list.clear();
            this.glbObj.fromorgname_list.clear();
            this.glbObj.frominvusrid_list.clear();
            this.glbObj.toorgid_list.clear();
            this.glbObj.toorgname_list.clear();
            this.glbObj.toinvusrid_list.clear();
            this.glbObj.servdate_lst.clear();
            this.glbObj.servtime_lst.clear();
            this.glbObj.servitem_lst.clear();
            this.glbObj.servitem_cost_lst.clear();
            this.glbObj.servitem_rstatus_lst.clear();
            this.glbObj.servitem_sstatus_lst.clear();
        } else if (type.equalsIgnoreCase("Load_Items")) {
            this.glbObj.items_vnitemid_lst.clear();
            this.glbObj.items_names_lst.clear();
            this.glbObj.items_chid_lst.clear();
            this.glbObj.chaptname_lst.clear();
            this.glbObj.items_hsn_lst.clear();
            this.glbObj.items_gst_lst.clear();
            this.glbObj.quantity_lst.clear();
            this.glbObj.mrp_lst.clear();
            this.glbObj.unitdescr_lst.clear();
            this.glbObj.unit_lst.clear();
        } else if (type.equalsIgnoreCase("Load_Items_by_search")) {
            this.glbObj.items_vnitemid_lst.clear();
            this.glbObj.items_names_lst.clear();
            this.glbObj.items_chid_lst.clear();
            this.glbObj.chaptname_lst.clear();
            this.glbObj.items_hsn_lst.clear();
            this.glbObj.items_gst_lst.clear();
            this.glbObj.quantity_lst.clear();
            this.glbObj.deducted_qnty_lst.clear();
            this.glbObj.mrp_lst.clear();
            this.glbObj.unitdescr_lst.clear();
            this.glbObj.unit_lst.clear();
        } else if (type.equalsIgnoreCase("Load_Items_by_cat")) {
            this.glbObj.items_vnitemid_lst.clear();
            this.glbObj.items_names_lst.clear();
            this.glbObj.items_chid_lst.clear();
            this.glbObj.chaptname_lst.clear();
            this.glbObj.items_hsn_lst.clear();
            this.glbObj.items_gst_lst.clear();
            this.glbObj.quantity_lst.clear();
            this.glbObj.mrp_lst.clear();
            this.glbObj.unitdescr_lst.clear();
            this.glbObj.unit_lst.clear();
        } else if (type.equalsIgnoreCase("Load_Items_by_cat_without_merge")) {
            this.glbObj.items_vnitemid_lst.clear();
            this.glbObj.items_names_lst.clear();
            this.glbObj.items_chid_lst.clear();
            this.glbObj.chaptname_lst.clear();
            this.glbObj.items_hsn_lst.clear();
            this.glbObj.items_gst_lst.clear();
            this.glbObj.quantity_lst.clear();
            this.glbObj.mrp_lst.clear();
            this.glbObj.unitdescr_lst.clear();
            this.glbObj.unit_lst.clear();
        } else if (type.equalsIgnoreCase("Load_vendor_Items")) {
            this.glbObj.items_vnitemid_lst.clear();
            this.glbObj.items_names_lst.clear();
            this.glbObj.items_chid_lst.clear();
            this.glbObj.chaptname_lst.clear();
            this.glbObj.items_hsn_lst.clear();
            this.glbObj.items_gst_lst.clear();
            this.glbObj.quantity_lst.clear();
            this.glbObj.mrp_lst.clear();
            this.glbObj.unitdescr_lst.clear();
            this.glbObj.unit_lst.clear();
        } else if (type.equalsIgnoreCase("Load_Stock_items")) {
            this.glbObj.items_vnitemid_lst.clear();
            this.glbObj.items_names_lst.clear();
            this.glbObj.items_chid_lst.clear();
            this.glbObj.chaptname_lst.clear();
            this.glbObj.items_hsn_lst.clear();
            this.glbObj.items_gst_lst.clear();
            this.glbObj.quantity_lst.clear();
            this.glbObj.mrp_lst.clear();
            this.glbObj.unitdescr_lst.clear();
            this.glbObj.unit_lst.clear();
        } else if (type.equalsIgnoreCase("load_item_details")) {
            this.glbObj.items_vnitemid_lst.clear();
            this.glbObj.items_chid_lst.clear();
            this.glbObj.chaptname_lst.clear();
            this.glbObj.items_names_lst.clear();
            this.glbObj.items_gst_lst.clear();
            this.glbObj.mrp_lst.clear();
            this.glbObj.quantity_lst.clear();
            this.glbObj.unit_lst.clear();
            this.glbObj.inwardno_lst.clear();
            this.glbObj.inwarddate_lst.clear();
            this.glbObj.pono_lst.clear();
            this.glbObj.podate_lst.clear();
            this.glbObj.invoiceno_lst.clear();
            this.glbObj.invoicedate_lst.clear();
            this.glbObj.suppliername_lst.clear();
            this.glbObj.receivername_lst.clear();
            this.glbObj.receiveddate_lst.clear();
            this.glbObj.transactionmode_lst.clear();
            this.glbObj.bankaccountno_lst.clear();
        }
        if (type.equalsIgnoreCase("load_item_purchase_details")) {
            this.glbObj.inwardno_lst.clear();
            this.glbObj.inwarddate_lst.clear();
            this.glbObj.pono_lst.clear();
            this.glbObj.podate_lst.clear();
            this.glbObj.invoiceno_lst.clear();
            this.glbObj.invoicedate_lst.clear();
            this.glbObj.suppliername_lst.clear();
            this.glbObj.receivername_lst.clear();
            this.glbObj.receiveddate_lst.clear();
            this.glbObj.transactionmode_lst.clear();
            this.glbObj.bankaccountno_lst.clear();
            this.glbObj.item_name_lst.clear();
        }
    }

    public void get_service_items() {
        String feature = "Load_service_items";
        this.generic_clear_list_fn(feature);
        feature = "";
        String q = "select sid,itemname,itemcost from trueguide.tserviceitemtbl where vendorid='" + this.glbObj.invusrid_cur + "'";
        this.glbObj.req_type = 709;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return;
        }
        if (this.log.error_code == 2) {
            return;
        }
        this.glbObj.service_id_lst = this.log.GetValuesFromTbl("X^1_1");
        this.glbObj.service_itemname_lst = this.log.GetValuesFromTbl("X^2_2");
        this.glbObj.service_itemcost_lst = this.log.GetValuesFromTbl("X^3_3");
    }

    public void add_into_servicetbl() {
        String q = "insert into trueguide.tservicetbl(itemname,vendorid,vendorname) values('" + this.glbObj.service_itemname + "','" + this.glbObj.invusrid_cur + "','" + this.glbObj.invusrid_cur + "')";
        this.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return;
        }
    }

    public void insert_sr_into_tservicerqsttbl() {
        String q = "insert into trueguide.tservicerqsttbl(fromorgid,fromorgname,frominvusrid,toorgid,toorgname,toinvusrid,servdate,servtime,servitem,servitemcost) values('" + this.glbObj.inventory_orgid_cur + "','" + this.glbObj.org_name + "','" + this.glbObj.from_inv_userid + "','" + this.glbObj.inventory_firm_id + "','" + this.glbObj.invorgname_cur + "','" + this.glbObj.to_inv_userid + "','" + this.glbObj.date + "','" + this.glbObj.time + "','" + this.glbObj.service_itemname + "','" + this.glbObj.service_itemcost + "')";
        this.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return;
        }
    }

    public void get_service_item_details() {
        String feature = "view_service_items";
        this.generic_clear_list_fn(feature);
        feature = "";
        String q = "select servid,fromorgid,fromorgname,frominvusrid,toorgid,toorgname,toinvusrid,servdate,servtime,servitem,servitemcost,rstatus,sstatus from trueguide.tservicerqsttbl where fromorgid='" + this.glbObj.inventory_orgid_cur + "' and rstatus='" + this.glbObj.service_status + "'";
        this.glbObj.req_type = 709;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return;
        }
        if (this.log.error_code == 2) {
            return;
        }
        this.glbObj.service_id_lst = this.log.GetValuesFromTbl("X^1_1");
        this.glbObj.fromorgid_list = this.log.GetValuesFromTbl("X^2_2");
        this.glbObj.fromorgname_list = this.log.GetValuesFromTbl("X^3_3");
        this.glbObj.frominvusrid_list = this.log.GetValuesFromTbl("X^4_4");
        this.glbObj.toorgid_list = this.log.GetValuesFromTbl("X^5_5");
        this.glbObj.toorgname_list = this.log.GetValuesFromTbl("X^6_6");
        this.glbObj.toinvusrid_list = this.log.GetValuesFromTbl("X^7_7");
        this.glbObj.servdate_lst = this.log.GetValuesFromTbl("X^8_8");
        this.glbObj.servtime_lst = this.log.GetValuesFromTbl("X^9_9");
        this.glbObj.servitem_lst = this.log.GetValuesFromTbl("X^10_10");
        this.glbObj.servitem_cost_lst = this.log.GetValuesFromTbl("X^11_11");
        this.glbObj.servitem_rstatus_lst = this.log.GetValuesFromTbl("X^12_12");
        this.glbObj.servitem_sstatus_lst = this.log.GetValuesFromTbl("X^13_13");
    }

    public void update_Service_status_ito_tservicerqsttlb() throws IOException {
        boolean ch = false;
        this.tlvObj.glbObj.req_type = 714;
        if (this.glbObj.rstatus.booleanValue()) {
            this.tlvObj.glbObj.tlvStr = "update trueguide.tservicerqsttbl set rstatus='" + this.glbObj.ordr_status + "' where servid='" + this.glbObj.servid_cur + "';";
        }
        if (this.glbObj.sstatus.booleanValue()) {
            this.tlvObj.glbObj.tlvStr = "update trueguide.tservicerqsttbl set sstatus='" + this.glbObj.status + "' where servid='" + this.glbObj.servid_cur + "';";
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            ch = false;
        } else {
            ch = true;
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
    }

    public void get_firm_details() {
        String q = "select firmid,firmname,firmaddress,firmgstno,firmregno,firmtype,status from trueguide.tfirmtbl where sid=-1 and firmid='" + this.glbObj.inventory_orgid_cur + "'";
        this.glbObj.req_type = 709;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return;
        }
        if (this.log.error_code == 2) {
            return;
        }
        this.glbObj.firm_orgid_curr = this.log.GetValuesFromTbl("X^1_1").get(0).toString();
        this.glbObj.firm_name_curr = this.log.GetValuesFromTbl("X^2_2").get(0).toString();
        this.glbObj.firm_addrs_curr = this.log.GetValuesFromTbl("X^3_3").get(0).toString();
        this.glbObj.firm_gstno_curr = this.log.GetValuesFromTbl("X^4_4").get(0).toString();
        this.glbObj.firm_reg_no_cur = this.log.GetValuesFromTbl("X^5_5").get(0).toString();
        this.glbObj.firm_type_curr = this.log.GetValuesFromTbl("X^6_6").get(0).toString();
        this.glbObj.firm_status_curr = this.log.GetValuesFromTbl("X^7_7").get(0).toString();
    }

    public String non_select(String q) {
        this.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println(" this.glbObj.inc_value=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code == 2) {
            return "-1";
        }
        List l1 = this.log.GetValuesFromTbl("X^1_1");
        System.out.println("l1=>" + l1);
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        if (l1 != null && l1.size() > 0) {
            return l1.get(0).toString();
        }
        return "-1";
    }

    public static int getRecordCount(String x) {
        if (x.contains("ErrorCode")) {
            return 0;
        }
        int r = x.lastIndexOf("record");
        String y = x.substring(r);
        System.out.println("r=" + r + " y=" + y);
        String[] split = y.split("&");
        String[] split1 = split[0].split("#");
        int rec_no = Integer.parseInt(split1[1]);
        System.out.println("REC_NO=" + rec_no);
        return rec_no;
    }

    public void generic_for_load_select(String type) {
        this.generic_clear_list_fn(type);
        this.glbObj.from_row = 0;
        int temp = 0;
        boolean i = false;
        int ret = 0;
        this.glbObj.req_count = 300;
        this.glbObj.from_row = 0;
        this.glbObj.to_row = 0;
        this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
        boolean rem = true;
        while (true) {
            this.get_generic_data_ex(rem, type);
            rem = false;
            this.glbObj.from_row = temp = this.glbObj.to_row;
            this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
            ret = TGInventoryLib.getRecordCount(this.log.rcv_buff);
            this.glbObj.tot_rec += this.glbObj.req_count;
            System.out.println("ret==" + ret + " this.glbObj.req_count=" + this.glbObj.req_count);
            if (ret < this.glbObj.req_count) break;
            System.out.println(">>this.glbObj.count===" + this.glbObj.req_count + "this.glbObj.from_row===" + this.glbObj.from_row + "this.glbObj.to_row===" + this.glbObj.to_row);
        }
        this.glbObj.tot_rec = 0;
    }

    private int getRecLen(String l) {
        String[] split = l.split("&record#2");
        String pr = split[0];
        String[] sp = pr.split("&");
        String last = sp[sp.length - 1];
        String maxRecords = last.split("#")[0].split("_")[1];
        return Integer.parseInt(maxRecords);
    }

    private void get_generic_data_ex(boolean rem, String type) {
        String InvtUsrid;
        String tlvStr = "";
        String tlvStr2 = "";
        this.glbObj.req_type = 709;
        if (type.isEmpty()) {
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        } else if (type.equalsIgnoreCase("Load_Stock_items")) {
            tlvStr = this.glbObj.own_inv ? "select vnitemid,itemname,chapterid,categoryname,hsn,gst,qnty,mrp,unitdescr,unit from trueguide.tinvitemtbl where invusrid='-1' and orgid='" + this.glbObj.orgid + "' limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row : "select vnitemid,itemname,chapterid,categoryname,hsn,gst,qnty,mrp,unitdescr,unit from trueguide.tinvitemtbl where invusrid='" + this.glbObj.invt_usrid + "' and orgid='" + this.glbObj.orgid + "' limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        }
        if (type.equalsIgnoreCase("Load_Items_by_search")) {
            InvtUsrid = this.glbObj.invt_usrid;
            if (this.glbObj.own_inv) {
                InvtUsrid = "-1";
            }
            tlvStr = "select vnitemid,itemname,chapterid,categoryname,hsn,gst,qnty ,mrp,unitdescr,unit from trueguide.tinvitemtbl where tinvitemtbl.invusrid='" + InvtUsrid + "' and orgid='" + this.glbObj.orgid + "' and  UPPER(itemname) like UPPER('%" + this.glbObj.item_search + "%')  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
            type = "Load_Items";
        } else if (type.equalsIgnoreCase("Load_Items_by_cat")) {
            InvtUsrid = this.glbObj.invt_usrid;
            if (this.glbObj.own_inv) {
                InvtUsrid = "-1";
            }
            tlvStr = "select vnitemid,itemname,chapterid,categoryname,hsn,gst,qnty ,mrp,unitdescr,tinvitemtbl.unit from trueguide.tinvitemtbl where tinvitemtbl.invusrid='" + InvtUsrid + "' and orgid='" + this.glbObj.orgid + "' and chapterid='" + this.glbObj.ch_id + "'  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
            type = "Load_Stock_items";
        } else if (type.equalsIgnoreCase("Load_vendor_Items")) {
            tlvStr = "select vnitemid,itemname,chapterid,categoryname,hsn,gst,qnty,mrp,unitdescr,unit from trueguide.tinvitemtbl where invusrid='" + this.glbObj.to_inv_userid + "' and orgid='" + this.glbObj.invt_org_cur + "' limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
            type = "Load_Stock_items";
        } else if (type.equalsIgnoreCase("load_item_details")) {
            InvtUsrid = this.glbObj.invt_usrid;
            if (this.glbObj.own_inv) {
                InvtUsrid = "-1";
            }
            tlvStr = "select tinvitemtbl.vnitemid,tinvitemtbl.chapterid,tinvitemtbl.categoryname,tinvitemtbl.itemname,tinvitemtbl.gst,tinvitemtbl.mrp,tinvitemtbl.qnty,tinvitemtbl.unit,inwardno,inwarddate,pono,podate,invoiceno,invoicedate,suppliername,receivername,receiveddate,modeofpayment,bankaccno from \ntrueguide.tinvitemtbl,trueguide.tinvitemdetailstbl where tinvitemtbl.vnitemid=tinvitemdetailstbl.vnitemid and tinvitemtbl.invusrid='" + InvtUsrid + "' and tinvitemtbl.orgid='" + this.glbObj.orgid + "' group by \n" + "tinvitemtbl.vnitemid,tinvitemtbl.chapterid,tinvitemtbl.categoryname,tinvitemtbl.itemname,tinvitemtbl.gst,tinvitemtbl.mrp,tinvitemtbl.qnty,tinvitemtbl\n" + ".unit,inwardno,inwarddate,pono,podate,invoiceno,invoicedate,suppliername,receivername,receiveddate,modeofpayment,bankaccno limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        } else if (type.equalsIgnoreCase("Load_Items_details_category")) {
            InvtUsrid = this.glbObj.invt_usrid;
            if (this.glbObj.own_inv) {
                InvtUsrid = "-1";
            }
            tlvStr = "select tinvitemtbl.vnitemid,tinvitemtbl.chapterid,tinvitemtbl.categoryname,tinvitemtbl.itemname,tinvitemtbl.gst,tinvitemtbl.mrp,tinvitemtbl.qnty,tinvitemtbl.unit,inwardno,inwarddate,pono,podate,invoiceno,invoicedate,suppliername,receivername,receiveddate,remark,modeofpayment,bankaccno from trueguide.tinvitemtbl,trueguide.tinvitemdetailstbl where tinvitemtbl.vnitemid=tinvitemdetailstbl.vnitemid and tinvitemtbl.invusrid='" + InvtUsrid + "' and tinvitemtbl.orgid='" + this.glbObj.orgid + "' and tinvitemtbl.chapterid='" + this.glbObj.ch_id + "' group by tinvitemtbl.vnitemid,tinvitemtbl.chapterid,tinvitemtbl.categoryname,tinvitemtbl.itemname,tinvitemtbl.gst,tinvitemtbl.mrp,tinvitemtbl.qnty,tinvitemtbl.unit,inwardno,inwarddate,pono,podate,invoiceno,invoicedate,suppliername,receivername,receiveddate,remark,modeofpayment,bankaccno limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
            type = "load_item_details";
            this.generic_clear_list_fn(type);
        } else if (type.equalsIgnoreCase("load_item_purchase_details")) {
            InvtUsrid = this.glbObj.invt_usrid;
            if (this.glbObj.own_inv) {
                InvtUsrid = "-1";
            }
            tlvStr = "select inwardno,inwarddate,pono,podate,invoiceno,invoicedate,suppliername,receivername,receiveddate,modeofpayment,bankaccno,itemname from trueguide.tinvitemdetailstbl where vnitemid='" + this.glbObj.items_vnitemid_cur + "' and invusrid='" + InvtUsrid + "' limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        }
        if (type.equalsIgnoreCase("INV_ACC_LOGIN_DET")) {
            System.out.println("this.glbObj.tlvStr=" + this.glbObj.tlvStr);
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        }
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code == 2) {
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            return;
        }
        int rec_len = 0;
        List l1 = this.log.GetValuesFromTbl("X^1_1");
        int i = 0;
        if (l1 != null && l1.size() > 0 && type.isEmpty()) {
            rec_len = this.getRecLen(this.log.rcv_buff);
            if (type.isEmpty()) {
                System.out.println("RecLen=" + rec_len + " GEN_LOAD");
                String arg = "";
                List tmpL = null;
                for (int z = 1; z <= rec_len; ++z) {
                    arg = "X^" + z + "_" + z;
                    tmpL = this.log.GetValuesFromTbl(arg);
                    if (tmpL == null) {
                        this.dblib.pme.delim = "\\.";
                        this.log.delim = "\\.";
                        return;
                    }
                    ArrayList lst = this.glbObj.genMap.get(z + "");
                    if (lst == null) {
                        lst = new ArrayList();
                        this.glbObj.genMap.put(z + "", lst);
                        lst = this.glbObj.genMap.get(z + "");
                    }
                    for (i = 0; tmpL != null && i < tmpL.size(); ++i) {
                        lst.add(tmpL.get(i).toString());
                    }
                    this.glbObj.genMap.put(z + "", lst);
                }
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
                return;
            }
        }
        List l2 = this.log.GetValuesFromTbl("X^2_2");
        List l3 = this.log.GetValuesFromTbl("X^3_3");
        List l4 = this.log.GetValuesFromTbl("X^4_4");
        List l5 = this.log.GetValuesFromTbl("X^5_5");
        List l6 = this.log.GetValuesFromTbl("X^6_6");
        List l7 = this.log.GetValuesFromTbl("X^7_7");
        List l8 = this.log.GetValuesFromTbl("X^8_8");
        List l9 = this.log.GetValuesFromTbl("X^9_9");
        List l10 = this.log.GetValuesFromTbl("X^10_10");
        List l11 = this.log.GetValuesFromTbl("X^11_11");
        List l12 = this.log.GetValuesFromTbl("X^12_12");
        List l13 = this.log.GetValuesFromTbl("X^13_13");
        List l14 = this.log.GetValuesFromTbl("X^14_14");
        List l15 = this.log.GetValuesFromTbl("X^15_15");
        List l16 = this.log.GetValuesFromTbl("X^16_16");
        List l17 = this.log.GetValuesFromTbl("X^17_17");
        List l18 = this.log.GetValuesFromTbl("X^18_18");
        List l19 = this.log.GetValuesFromTbl("X^19_19");
        List l20 = this.log.GetValuesFromTbl("X^20_20");
        List l21 = this.log.GetValuesFromTbl("X^21_21");
        for (i = 0; i < l1.size(); ++i) {
            if (type.equalsIgnoreCase("Load_Items")) {
                this.glbObj.items_vnitemid_lst.add(l1.get(i).toString());
                this.glbObj.items_names_lst.add(l2.get(i).toString());
                this.glbObj.items_chid_lst.add(l3.get(i).toString());
                this.glbObj.chaptname_lst.add(l4.get(i).toString());
                this.glbObj.items_hsn_lst.add(l5.get(i).toString());
                this.glbObj.items_gst_lst.add(l6.get(i).toString());
                this.glbObj.quantity_lst.add(l7.get(i).toString());
                this.glbObj.mrp_lst.add(l8.get(i).toString());
                this.glbObj.unitdescr_lst.add(l9.get(i).toString());
                this.glbObj.unit_lst.add(l10.get(i).toString());
            }
            if (type.equalsIgnoreCase("Load_Stock_items")) {
                this.glbObj.items_vnitemid_lst.add(l1.get(i).toString());
                this.glbObj.items_names_lst.add(l2.get(i).toString());
                this.glbObj.items_chid_lst.add(l3.get(i).toString());
                this.glbObj.chaptname_lst.add(l4.get(i).toString());
                this.glbObj.items_hsn_lst.add(l5.get(i).toString());
                this.glbObj.items_gst_lst.add(l6.get(i).toString());
                this.glbObj.quantity_lst.add(l7.get(i).toString());
                this.glbObj.mrp_lst.add(l8.get(i).toString());
                this.glbObj.unitdescr_lst.add(l9.get(i).toString());
                this.glbObj.unit_lst.add(l10.get(i).toString());
            }
            if (type.equalsIgnoreCase("load_item_details")) {
                this.glbObj.items_vnitemid_lst.add(l1.get(i).toString());
                this.glbObj.items_chid_lst.add(l2.get(i).toString());
                this.glbObj.chaptname_lst.add(l3.get(i).toString());
                this.glbObj.items_names_lst.add(l4.get(i).toString());
                this.glbObj.items_gst_lst.add(l5.get(i).toString());
                this.glbObj.mrp_lst.add(l6.get(i).toString());
                this.glbObj.quantity_lst.add(l7.get(i).toString());
                this.glbObj.unit_lst.add(l8.get(i).toString());
                this.glbObj.inwardno_lst.add(l9.get(i).toString());
                this.glbObj.inwarddate_lst.add(l10.get(i).toString());
                this.glbObj.pono_lst.add(l11.get(i).toString());
                this.glbObj.podate_lst.add(l12.get(i).toString());
                this.glbObj.invoiceno_lst.add(l13.get(i).toString());
                this.glbObj.invoicedate_lst.add(l14.get(i).toString());
                this.glbObj.suppliername_lst.add(l15.get(i).toString());
                this.glbObj.receivername_lst.add(l16.get(i).toString());
                this.glbObj.receiveddate_lst.add(l17.get(i).toString());
                this.glbObj.transactionmode_lst.add(l18.get(i).toString());
                this.glbObj.bankaccountno_lst.add(l19.get(i).toString());
            }
            if (type.equalsIgnoreCase("INV_ACC_LOGIN_DET")) {
                this.glbObj.slf_pfid.add(l1.get(i).toString());
                this.glbObj.slf_uid.add(l2.get(i).toString());
                this.glbObj.slf_sid.add(l3.get(i).toString());
                this.glbObj.slf_status.add(l4.get(i).toString());
                this.glbObj.slf_season.add(l5.get(i).toString());
                this.glbObj.slf_season_name.add(l6.get(i).toString());
                this.glbObj.slf_factory_name.add(l7.get(i).toString());
            }
            if (!type.equalsIgnoreCase("load_item_purchase_details")) continue;
            this.glbObj.inward_no = l1.get(0).toString();
            this.glbObj.inward_date = l2.get(0).toString();
            this.glbObj.po_no = l3.get(0).toString();
            this.glbObj.po_date = l4.get(0).toString();
            this.glbObj.invoice_no = l5.get(0).toString();
            this.glbObj.invoice_date = l6.get(0).toString();
            this.glbObj.suppliername = l7.get(0).toString();
            this.glbObj.receivername = l8.get(0).toString();
            this.glbObj.received_date = l9.get(0).toString();
            this.glbObj.transaction_mode = l10.get(0).toString();
            this.glbObj.bankaccno = l11.get(0).toString();
            this.glbObj.item_name = l12.get(0).toString();
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
    }

    public void generic_load_for_selected_vendor() {
    }

    public boolean handleLogin_select_user_id_invt() {
        boolean ret = false;
        String q = "select sfadminid,tsfadmintbl.usrid,sid,tusertbl.status From trueguide.tusertbl,trueguide.tsfadmintbl where tusertbl.usrid=tsfadmintbl.usrid and mobno='" + this.loginobj.mobno + "' and password='" + this.loginobj.cnfrmpass + "' and tsfadmintbl.level='21';";
        this.glbObj.tlvStr2 = q = "select sfadminid,tsfadmintbl.usrid,tsfadmintbl.sid,tusertbl.status,seasonid,seasonname,factoryname From trueguide.tusertbl,trueguide.tsfadmintbl,trueguide.tseasontbl,trueguide.tsugarfactorytbl where tseasontbl.status=1 and tusertbl.usrid=tsfadmintbl.usrid and tseasontbl.sid=tsfadmintbl.sid and tsugarfactorytbl.sid=tsfadmintbl.sid  and mobno='" + this.loginobj.mobno + "' and password='" + this.loginobj.cnfrmpass + "' and tsfadmintbl.level='21' ";
        this.get_generic_ex("INV_ACC_LOGIN_DET");
        if (this.log.error_code == 0) {
            return true;
        }
        return ret;
    }

    public boolean get_generic_ex(String loadType) {
        this.glbObj.from_row = 0;
        int temp = 0;
        boolean i = false;
        int ret = 0;
        this.glbObj.req_count = 300;
        this.glbObj.from_row = 0;
        this.glbObj.to_row = 0;
        if (loadType.isEmpty()) {
            this.glbObj.genMap.clear();
        } else if (loadType.equalsIgnoreCase("INV_ACC_LOGIN_DET")) {
            this.glbObj.slf_pfid.clear();
            this.glbObj.slf_uid.clear();
            this.glbObj.slf_sid.clear();
            this.glbObj.slf_status.clear();
            this.glbObj.slf_season.clear();
            this.glbObj.slf_season_name.clear();
            this.glbObj.slf_factory_name.clear();
        }
        this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
        boolean rem = true;
        boolean r = false;
        while (true) {
            this.get_generic_data_ex(rem, loadType);
            rem = false;
            this.glbObj.from_row = temp = this.glbObj.to_row;
            this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
            ret = TGInventoryLib.getRecordCount(this.log.rcv_buff);
            this.glbObj.tot_rec += this.glbObj.req_count;
            System.out.println("ret==" + ret + " this.glbObj.req_count=" + this.glbObj.req_count);
            if (ret < this.glbObj.req_count) break;
            System.out.println(">>this.glbObj.count===" + this.glbObj.req_count + "this.glbObj.from_row===" + this.glbObj.from_row + "this.glbObj.to_row===" + this.glbObj.to_row);
        }
        this.glbObj.tot_rec = 0;
        return r;
    }

    public void get_factory_details() {
        String q = "select sid,factoryname,fctryadd,gstno,factorycin,fctrytype,status from trueguide.tsugarfactorytbl where sid='" + this.glbObj.orgid + "'";
        this.glbObj.req_type = 709;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return;
        }
        if (this.log.error_code == 2) {
            return;
        }
        this.glbObj.firm_orgid_curr = this.log.GetValuesFromTbl("X^1_1").get(0).toString();
        this.glbObj.firm_name_curr = this.log.GetValuesFromTbl("X^2_2").get(0).toString();
        this.glbObj.firm_addrs_curr = this.log.GetValuesFromTbl("X^3_3").get(0).toString();
        this.glbObj.firm_gstno_curr = this.log.GetValuesFromTbl("X^4_4").get(0).toString();
        this.glbObj.firm_reg_no_cur = this.log.GetValuesFromTbl("X^5_5").get(0).toString();
        this.glbObj.firm_type_curr = this.log.GetValuesFromTbl("X^6_6").get(0).toString();
        this.glbObj.firm_status_curr = this.log.GetValuesFromTbl("X^7_7").get(0).toString();
    }

    private void edit_stock_sales() {
        boolean check = false;
        String query = "";
        boolean ch = false;
        this.tlvObj.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = query = "update trueguide.tinvitemtbl set qnty='" + this.glbObj.tot_item_qty + "' where vnitemid='" + this.glbObj.item_vnitemid_curr + "'";
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("this.glbObj.tlvObj.glbObj.tlvStr=+=" + this.tlvObj.glbObj.tlvStr);
    }

    public void initialise_loggedin_detials() {
        this.glbObj.invt_usrid = this.glbObj.temp_usrid;
        this.glbObj.orgid = this.glbObj.temp_orgid;
    }

    public String get_items_binded_count_inbtitemtbl() {
        String count = "";
        String q = "select count(*) from trueguide.tinvitemtbl where invusrid='" + this.glbObj.invt_usrid + "' and orgid='" + this.glbObj.orgid + "' and chapterid='" + this.glbObj.ch_id + "'";
        this.glbObj.req_type = 709;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return "";
        }
        if (this.log.error_code == 2) {
            return "";
        }
        count = this.log.GetValuesFromTbl("X^1_1").get(0).toString();
        return count;
    }

    public String get_decremented_count() {
        this.glbObj.sum_spent_lst.clear();
        this.glbObj.temp_vnitemid_lst.clear();
        String q = "";
        q = "select sum(decrementedc-returnedquantity),vnitemid from trueguide.tinvdecremented where invusrid='" + this.glbObj.invt_usrid + "' group by vnitemid";
        this.glbObj.req_type = 709;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return "";
        }
        if (this.log.error_code == 2) {
            return "";
        }
        this.glbObj.sum_spent_lst = this.log.GetValuesFromTbl("X^1_1");
        this.glbObj.temp_vnitemid_lst = this.log.GetValuesFromTbl("X^2_2");
        System.out.println("sum" + this.glbObj.sum_spent_lst);
        System.out.println("vnitemid" + this.glbObj.temp_vnitemid_lst);
        return "";
    }

    public void delete_item() {
        String q = "";
        if (this.glbObj.delete_item) {
            q = "delete from trueguide.tinvitemtbl where vnitemid='" + this.glbObj.items_vnitemid_cur + "'";
        } else if (!this.glbObj.delete_item) {
            q = "delete from trueguide.tinvitemdetailstbl where vnitemid='" + this.glbObj.items_vnitemid_cur + "'";
        }
        this.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void update_additional_item_details(String q) {
        this.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGInventoryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

