/*
 * Decompiled with CFR 0.152.
 */
package tgcentralizelib;

import fileFormatUtil.fileFormatUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import tgcentralizedblib.TGCentralizeDBLib;
import tgcentralizelib.Reports_Lib;
import tgcentralizelib.TGCentralizeGlb;
import tgcentralizelib.TGCentralizeTlv;
import tgcentralizelib.amntObj;
import tgcentralizelib.feesRepObj;
import trueguidelibrary.TrueGuideLibrary;
import trueguidelogindesktop.TrueGuideLogin;

public class TGCentralizeLib {
    public TGCentralizeGlb glbObj = null;
    public TGCentralizeTlv tlvObj = null;
    public TrueGuideLibrary log = null;
    public TGCentralizeDBLib dblib = null;
    public Reports_Lib Reports_Lib = null;
    public fileFormatUtil excel = null;
    public TrueGuideLogin loginobj = null;
    private String version;

    public TGCentralizeLib(TGCentralizeLib obj) {
        this.excel = new fileFormatUtil();
        this.glbObj = new TGCentralizeGlb();
        this.tlvObj = new TGCentralizeTlv(this.glbObj);
        this.Reports_Lib = new Reports_Lib();
        this.Reports_Lib.glbObj = this.glbObj;
        this.Reports_Lib.tlvObj = this.tlvObj;
        this.Reports_Lib.log = obj.log;
        this.Reports_Lib.dblib = obj.dblib;
        this.Reports_Lib.loginobj = obj.loginobj;
        this.dblib = obj.dblib;
        this.log = obj.log;
        this.loginobj = obj.loginobj;
    }

    public TGCentralizeLib() {
        this.glbObj = new TGCentralizeGlb();
        this.tlvObj = new TGCentralizeTlv(this.glbObj);
        this.log = new TrueGuideLibrary();
        this.loginobj = new TrueGuideLogin(this.log);
        this.dblib = new TGCentralizeDBLib(this.log);
        this.Reports_Lib = new Reports_Lib();
        this.Reports_Lib.log = this.log;
        this.Reports_Lib.dblib = this.dblib;
        this.Reports_Lib.glbObj = this.glbObj;
        this.Reports_Lib.tlvObj = this.tlvObj;
        this.Reports_Lib.loginobj = this.loginobj;
        this.dblib.initParser(this.log);
        this.dblib.CreateCentralizeSchema();
        TrueGuideLibrary.isjava = true;
    }

    public boolean view_bills_for_generated_tag_tbiilstbl() throws IOException {
        boolean ret = false;
        this.log.delim = "\\.";
        this.tlvObj.setTlv(226);
        this.tlvObj.glbObj.req_type = 1000;
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.bill_id_lst = this.log.GetValuesFromTbl("tbillstbl.1_bid");
            this.glbObj.bill_no_lst = this.log.GetValuesFromTbl("tbillstbl.2_billno");
            this.glbObj.bill_tag_lst = this.log.GetValuesFromTbl("tbillstbl.3_billtag");
            this.glbObj.bill_from_date_lst = this.log.GetValuesFromTbl("tbillstbl.4_bfrmdate");
            this.glbObj.bill_to_date_lst = this.log.GetValuesFromTbl("tbillstbl.5_btodate");
            this.glbObj.bill_freez_status_lst = this.log.GetValuesFromTbl("tbillstbl.6_freez");
        }
        System.out.println("billtag List====" + this.glbObj.bill_tag_lst);
        return ret;
    }

    public static int calculateDuration(Date startDate, Date endDate, List weekly_off) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int workDays = 0;
        if (startCal.getTimeInMillis() > endCal.getTimeInMillis()) {
            startCal.setTime(endDate);
            endCal.setTime(startDate);
        }
        int i = 0;
        int sz = weekly_off.size();
        boolean cont = false;
        do {
            cont = false;
            startCal.add(5, 1);
            for (i = 0; i < sz; ++i) {
                int v = Integer.parseInt(weekly_off.get(i).toString());
                if (startCal.get(7) != v) continue;
                cont = true;
                break;
            }
            if (cont) continue;
            ++workDays;
        } while (startCal.getTimeInMillis() <= endCal.getTimeInMillis());
        return workDays;
    }

    public static int tot_workingdays(List weekly_offs) {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2);
        int day = 1;
        c.set(year, month, day);
        int numOfDaysInMonth = c.getActualMaximum(5);
        Date st = c.getTime();
        c.add(5, numOfDaysInMonth - 1);
        Date end = c.getTime();
        int calculateDuration = TGCentralizeLib.calculateDuration(st, end, weekly_offs);
        return calculateDuration;
    }

    public void Set_MobileNumber(String mbl) {
        this.loginobj.tutil.SetMobileNumber(mbl);
    }

    public void Set_passWord(String pass) {
        this.loginobj.tutil.SetPassword(pass);
    }

    public boolean Reg_Get_UserID() throws IOException {
        boolean check = false;
        boolean i = this.loginobj.reg_get_usrid(1);
        this.log.println("Boolean check-->" + i);
        this.glbObj.userid = this.loginobj.tutil.GetUserID();
        this.log.println("error code inside -->" + this.glbObj.userid);
        return check;
    }

    public boolean resend_otp() throws IOException {
        boolean check = this.loginobj.resend_otp();
        return check;
    }

    public boolean Set_OtpFun() throws IOException {
        boolean check = this.loginobj.set_otpfun();
        return check;
    }

    public void setotp(String otp) throws IOException {
        this.loginobj.SetUtilityOpt(otp);
    }

    public boolean ConfirmOtp() throws IOException {
        boolean check = this.loginobj.confirm_otp();
        return check;
    }

    public void init_login(TrueGuideLibrary lg) {
        this.loginobj = new TrueGuideLogin(lg);
    }

    public void Set_ModuleIDAndRoleID() throws IOException {
        this.log.Module_ID = "academic";
        this.log.Role_id = "central";
        this.log.version = this.version = "1";
        this.loginobj.SetttingModuleAndRole(this.log.Module_ID, this.log.Role_id, this.version);
    }

    public boolean do_all_network() throws IOException {
        this.log.error_code = 0;
        this.log.performFulloperation(this.tlvObj.glbObj.req_type, this.tlvObj.glbObj.tlvStr.length(), this.tlvObj.glbObj.tlvStr);
        return true;
    }

    public void set_system_date_and_time() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd#HH:mm:ss");
        Date date = new Date();
        String today_date = dateFormat.format(date);
        String[] dt = today_date.split("#");
        this.glbObj.sysDate = dt[0];
        this.glbObj.sysTime = dt[1];
    }

    public void set_todays_day_and_date() {
        String tdate;
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.glbObj.todays_date = tdate = dateFormat.format(date).toString();
        this.glbObj.todays_day = new SimpleDateFormat("EE", Locale.ENGLISH).format(date.getTime());
    }

    public boolean handleLogin_select_user_id_central() throws IOException {
        boolean check = false;
        this.loginobj.handleLogin_select_user_id();
        this.glbObj.userid = this.loginobj.userid;
        this.glbObj.status = this.loginobj.status;
        return check;
    }

    private void get_generic_data_ex(boolean rem, String loadType) {
        String tlvStr = "";
        String tlvStr2 = "";
        this.glbObj.req_type = 709;
        if (loadType.isEmpty()) {
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
            System.out.println("Generic tlvStr=" + tlvStr);
        }
        if (loadType.equalsIgnoreCase("SF_ACC_LOGIN_DET") || loadType.equalsIgnoreCase("raith_book_info") || loadType.equalsIgnoreCase("ALL_EXPENSE")) {
            System.out.println("this.glbObj.tlvStr=" + this.glbObj.tlvStr);
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        }
        if (loadType.equalsIgnoreCase("GET_INCM_HEADS")) {
            System.out.println("this.glbObj.tlvStr=" + this.glbObj.tlvStr);
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        }
        if (loadType.equalsIgnoreCase("GET_STUD_FEES_PROFILES")) {
            System.out.println("this.glbObj.tlvStr=" + this.glbObj.tlvStr);
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        }
        if (loadType.equalsIgnoreCase("GET_CLASSES")) {
            System.out.println("this.glbObj.tlvStr=" + this.glbObj.tlvStr);
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        }
        if (loadType.equalsIgnoreCase("GET_PROF_DEMAND_SUM")) {
            System.out.println("this.glbObj.tlvStr=" + this.glbObj.tlvStr);
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        }
        if (loadType.equalsIgnoreCase("GET_PROF_CR_DR_SUM")) {
            System.out.println("this.glbObj.tlvStr=" + this.glbObj.tlvStr);
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
        }
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            return;
        }
        int rec_len = 0;
        List l1 = this.log.GetValuesFromTbl("X^1_1");
        int i = 0;
        if (l1 != null && l1.size() > 0 && loadType.isEmpty()) {
            rec_len = this.getRecLen(this.log.rcv_buff);
            if (loadType.isEmpty()) {
                System.out.println("RecLen=" + rec_len + " GEN_LOAD");
                String arg = "";
                List tmpL = null;
                for (int z = 1; z <= rec_len; ++z) {
                    arg = "X^" + z + "_" + z;
                    tmpL = this.log.GetValuesFromTbl(arg);
                    if (tmpL == null) {
                        return;
                    }
                    ArrayList lst = this.glbObj.genMap.get(z + "");
                    if (lst == null) {
                        lst = new ArrayList();
                        this.glbObj.genMap.put(z + "", lst);
                        lst = this.glbObj.genMap.get(z + "");
                    }
                    for (i = 0; tmpL != null && i < tmpL.size(); ++i) {
                        lst.add(tmpL.get(i).toString());
                    }
                    this.glbObj.genMap.put(z + "", lst);
                }
                return;
            }
        }
        List l2 = this.log.GetValuesFromTbl("X^2_2");
        List l3 = this.log.GetValuesFromTbl("X^3_3");
        List l4 = this.log.GetValuesFromTbl("X^4_4");
        List l5 = this.log.GetValuesFromTbl("X^5_5");
        List l6 = this.log.GetValuesFromTbl("X^6_6");
        List l7 = this.log.GetValuesFromTbl("X^7_7");
        List l8 = this.log.GetValuesFromTbl("X^8_8");
        List l9 = this.log.GetValuesFromTbl("X^9_9");
        List l10 = this.log.GetValuesFromTbl("X^10_10");
        List l11 = this.log.GetValuesFromTbl("X^11_11");
        List l12 = this.log.GetValuesFromTbl("X^12_12");
        List l13 = this.log.GetValuesFromTbl("X^13_13");
        List l14 = this.log.GetValuesFromTbl("X^14_14");
        List l15 = this.log.GetValuesFromTbl("X^15_15");
        List l16 = this.log.GetValuesFromTbl("X^16_16");
        List l17 = this.log.GetValuesFromTbl("X^17_17");
        List l18 = this.log.GetValuesFromTbl("X^18_18");
        List l19 = this.log.GetValuesFromTbl("X^19_19");
        List l20 = this.log.GetValuesFromTbl("X^20_20");
        List l21 = this.log.GetValuesFromTbl("X^21_21");
        List l22 = this.log.GetValuesFromTbl("X^22_22");
        List l23 = this.log.GetValuesFromTbl("X^23_23");
        List l24 = this.log.GetValuesFromTbl("X^24_24");
        List l25 = this.log.GetValuesFromTbl("X^25_25");
        List l26 = this.log.GetValuesFromTbl("X^26_26");
        List l27 = this.log.GetValuesFromTbl("X^27_27");
        List l28 = this.log.GetValuesFromTbl("X^28_28");
        List l29 = this.log.GetValuesFromTbl("X^29_29");
        List l30 = this.log.GetValuesFromTbl("X^30_30");
        List l31 = this.log.GetValuesFromTbl("X^31_31");
        List l32 = this.log.GetValuesFromTbl("X^32_32");
        List l33 = this.log.GetValuesFromTbl("X^33_33");
        List l34 = this.log.GetValuesFromTbl("X^34_34");
        List l35 = this.log.GetValuesFromTbl("X^35_35");
        i = 0;
        for (i = 0; i < l1.size(); ++i) {
            amntObj amtobj;
            if (loadType.equalsIgnoreCase("ALL_EXPENSE")) {
                this.glbObj.expn_trans_id_lst.add(l1.get(i).toString());
                this.glbObj.expn_amnt.add(l2.get(i).toString());
                this.glbObj.expn_desc.add(l3.get(i).toString());
                this.glbObj.expn_datte.add(l5.get(i).toString());
                this.glbObj.expnse_type_lst.add(l7.get(i).toString());
                this.glbObj.expnse_mode_lst.add(l8.get(i).toString());
                this.glbObj.expnse_chkno.add(l9.get(i).toString());
                this.glbObj.expnse_chkdt.add(l10.get(i).toString());
                this.glbObj.expnse_bnkname.add(l11.get(i).toString());
                this.glbObj.expnse_ddno_lst.add(l12.get(i).toString());
                this.glbObj.expnse_ddate_lst.add(l13.get(i).toString());
                this.glbObj.expnse_challanno.add(l14.get(i).toString());
                this.glbObj.expnse_acnt_no_lst.add(l15.get(i).toString());
                this.glbObj.expnse_ifsccode_lst.add(l16.get(i).toString());
                this.glbObj.expnse_payee_id_lst.add(l17.get(i).toString());
                this.glbObj.expnse_payee_lst.add(l18.get(i).toString());
                this.glbObj.expnse_vendor_id_lst.add(l19.get(i).toString());
                this.glbObj.expnse_vendor_lst.add(l20.get(i).toString());
                this.glbObj.expnse_entry_type_lst.add(l21.get(i).toString());
                this.glbObj.expense_expected_lst.add(l22.get(i).toString());
                this.glbObj.expense_type_id_lst.add(l23.get(i).toString());
                this.glbObj.jexpnse_transid_lst.add(l25.get(i).toString());
                this.glbObj.expnse_etid_lst.add(l26.get(i).toString());
                this.glbObj.expnse_tvia_lst.add(l27.get(i).toString());
            }
            if (loadType.equalsIgnoreCase("SF_ACC_LOGIN_DET")) {
                this.glbObj.slf_pfid.add(l1.get(i).toString());
                this.glbObj.slf_uid.add(l2.get(i).toString());
                this.glbObj.slf_sid.add(l3.get(i).toString());
                this.glbObj.slf_status.add(l4.get(i).toString());
                this.glbObj.slf_season.add(l5.get(i).toString());
                this.glbObj.slf_season_name.add(l6.get(i).toString());
                this.glbObj.slf_factory_name.add(l7.get(i).toString());
            }
            if (loadType.equalsIgnoreCase("GET_INCM_HEADS")) {
                this.glbObj.incm_heads_prepop_lst.add(l1.get(i).toString());
            }
            if (loadType.equalsIgnoreCase("GET_STUD_FEES_PROFILES")) {
                this.glbObj.icm_profid_lst.add(l1.get(i).toString());
                this.glbObj.icm_profile_name.add(l2.get(i).toString());
            }
            if (loadType.equalsIgnoreCase("GET_CLASSES")) {
                this.glbObj.gen_classid_lst.add(l1.get(i).toString());
                this.glbObj.gen_classname_lst.add(l2.get(i).toString());
                this.glbObj.gen_batch_lst.add(l3.get(i).toString());
                this.glbObj.gen_batchid_lst.add(l4.get(i).toString());
            }
            if (loadType.equalsIgnoreCase("GET_PROF_DEMAND_SUM")) {
                feesRepObj obj = this.glbObj.finRepMap.get(l1.get(i).toString());
                if (obj == null) {
                    obj = new feesRepObj();
                    obj.username = l3.get(i).toString();
                    amtobj = obj.amntMap.get(l4.get(i).toString() + "-" + l1.get(i).toString());
                    if (amtobj == null) {
                        amtobj = new amntObj();
                        amtobj.demand_sum = l2.get(i).toString();
                        amtobj.profilename = l5.get(i).toString();
                        obj.amntMap.put(l4.get(i).toString() + "-" + l1.get(i).toString(), amtobj);
                    }
                    this.glbObj.finRepMap.put(l1.get(i).toString(), obj);
                }
                System.out.println("this.glbObj.finRepMap========" + this.glbObj.finRepMap);
            }
            if (!loadType.equalsIgnoreCase("GET_PROF_CR_DR_SUM")) continue;
            System.out.println("this.glbObj.finRepMap)))))))" + this.glbObj.finRepMap);
            System.out.println("this.glbObj.finRepMap.get(l1.get(i).toString())========" + this.glbObj.finRepMap.get(l1.get(i).toString()));
            System.out.println("l1.get(i).toString()=========" + l1.get(i).toString());
            Map<String, amntObj> mp = this.glbObj.finRepMap.get((Object)l1.get((int)i).toString()).amntMap;
            for (Map.Entry<String, amntObj> entry : mp.entrySet()) {
                String k = entry.getKey();
                String[] sp = k.split("-");
                if (!sp[1].equals(l3.get(i).toString()) || !sp[0].equals(l1.get(i).toString())) continue;
            }
            amtobj = this.glbObj.finRepMap.get((Object)l1.get((int)i).toString()).amntMap.get(l3.get(i).toString() + "-" + l1.get(i).toString());
            if (this.log.error_code == 2) {
                amtobj.credit_sum = "0";
                amtobj.debit_sum = "0";
                continue;
            }
            if (amtobj == null) continue;
            System.out.println("l2.get(i).toString()=======" + l2.get(i).toString());
            System.out.println("l4.get(i).toString()======" + l4.get(i).toString());
            if (l2.get(i).toString().equals("1")) {
                amtobj.credit_sum = l4.get(i).toString();
            }
            if (l2.get(i).toString().equals("0")) {
                amtobj.debit_sum = l4.get(i).toString();
            }
            System.out.println("amtobj.credit_sum----------+" + amtobj.credit_sum);
        }
        System.out.println("this.glbObj.finRepMap======" + this.glbObj.finRepMap);
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
    }

    private int getRecLen(String l) {
        String[] split = l.split("&record#2");
        String pr = split[0];
        String[] sp = pr.split("&");
        String last = sp[sp.length - 1];
        String maxRecords = last.split("#")[0].split("_")[1];
        return Integer.parseInt(maxRecords);
    }

    public static int getRecordCount(String x) {
        if (x.contains("ErrorCode")) {
            return 0;
        }
        int r = x.lastIndexOf("record");
        String y = x.substring(r);
        System.out.println("r=" + r + " y=" + y);
        String[] split = y.split("&");
        String[] split1 = split[0].split("#");
        int rec_no = Integer.parseInt(split1[1]);
        System.out.println("REC_NO=" + rec_no);
        return rec_no;
    }

    public boolean get_generic_ex(String loadType) {
        this.glbObj.from_row = 0;
        int temp = 0;
        boolean i = false;
        int ret = 0;
        this.glbObj.req_count = 300;
        this.glbObj.from_row = 0;
        this.glbObj.to_row = 0;
        if (loadType.isEmpty()) {
            this.glbObj.genMap.clear();
        } else if (loadType.equalsIgnoreCase("SF_ACC_LOGIN_DET")) {
            this.glbObj.slf_pfid.clear();
            this.glbObj.slf_uid.clear();
            this.glbObj.slf_sid.clear();
            this.glbObj.slf_status.clear();
            this.glbObj.slf_season.clear();
            this.glbObj.slf_season_name.clear();
            this.glbObj.slf_factory_name.clear();
        }
        if (loadType.equalsIgnoreCase("GET_INCM_HEADS")) {
            this.glbObj.incm_heads_prepop_lst.clear();
        }
        if (loadType.equalsIgnoreCase("GET_STUD_FEES_PROFILES")) {
            this.glbObj.icm_profid_lst.clear();
            this.glbObj.icm_profile_name.clear();
        }
        if (loadType.equalsIgnoreCase("GET_CLASSES")) {
            this.glbObj.gen_classid_lst.clear();
            this.glbObj.gen_classname_lst.clear();
            this.glbObj.gen_batch_lst.clear();
            this.glbObj.gen_batchid_lst.clear();
        }
        if (loadType.equalsIgnoreCase("GET_PROF_DEMAND_SUM")) {
            this.glbObj.finRepMap.clear();
        }
        if (loadType.equalsIgnoreCase("GET_PROF_CR_DR_SUM")) {
            // empty if block
        }
        if (loadType.equalsIgnoreCase("ALL_EXPENSE")) {
            this.glbObj.expn_trans_id_lst.clear();
            this.glbObj.expn_amnt.clear();
            this.glbObj.expn_desc.clear();
            this.glbObj.expn_datte.clear();
            this.glbObj.expnse_type_lst.clear();
            this.glbObj.expnse_mode_lst.clear();
            this.glbObj.expnse_chkno.clear();
            this.glbObj.expnse_chkdt.clear();
            this.glbObj.expnse_bnkname.clear();
            this.glbObj.expnse_ddno_lst.clear();
            this.glbObj.expnse_ddate_lst.clear();
            this.glbObj.expnse_challanno.clear();
            this.glbObj.expnse_acnt_no_lst.clear();
            this.glbObj.expnse_ifsccode_lst.clear();
            this.glbObj.expnse_payee_id_lst.clear();
            this.glbObj.expnse_payee_lst.clear();
            this.glbObj.expnse_vendor_id_lst.clear();
            this.glbObj.expnse_vendor_lst.clear();
            this.glbObj.expnse_entry_type_lst.clear();
            this.glbObj.expnse_entry_type_lst.clear();
            this.glbObj.expense_expected_lst.clear();
            this.glbObj.expense_type_id_lst.clear();
            this.glbObj.expn_trans_id_lst.clear();
            this.glbObj.jexpnse_transid_lst.clear();
            this.glbObj.expnse_etid_lst.clear();
            this.glbObj.expnse_tvia_lst.clear();
        }
        if (loadType.equalsIgnoreCase("raith_book_info")) {
            this.glbObj.rb_rcode.clear();
            this.glbObj.rb_fullname.clear();
            this.glbObj.rb_accountno.clear();
            this.glbObj.rb_branch.clear();
            this.glbObj.rb_payable.clear();
            this.glbObj.rb_usrid.clear();
        }
        this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
        boolean rem = true;
        while (true) {
            this.get_generic_data_ex(rem, loadType);
            rem = false;
            this.glbObj.from_row = temp = this.glbObj.to_row;
            this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
            this.glbObj.Recs = ret = TGCentralizeLib.getRecordCount(this.log.rcv_buff);
            this.glbObj.tot_rec += this.glbObj.req_count;
            System.out.println("ret==" + ret + " this.glbObj.req_count=" + this.glbObj.req_count);
            if (ret < this.glbObj.req_count) break;
            System.out.println(">>this.glbObj.count===" + this.glbObj.req_count + "this.glbObj.from_row===" + this.glbObj.from_row + "this.glbObj.to_row===" + this.glbObj.to_row);
        }
        this.glbObj.tot_rec = 0;
        System.out.println("this.glbObj.Recs=" + this.glbObj.Recs);
        return true;
    }

    public String non_select(String q) {
        this.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println(" this.glbObj.inc_value=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code == 2) {
            return "-1";
        }
        List l1 = this.log.GetValuesFromTbl("X^1_1");
        System.out.println("l1=>" + l1);
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        if (l1 != null && l1.size() > 0) {
            return l1.get(0).toString();
        }
        return "-1";
    }

    public boolean handleLogin_select_user_id_central_account() {
        boolean ret = false;
        String q = "select sfadminid,tsfadmintbl.usrid,sid,tusertbl.status From trueguide.tusertbl,trueguide.tsfadmintbl where tusertbl.usrid=tsfadmintbl.usrid and mobno='" + this.loginobj.mobno + "' and password='" + this.loginobj.cnfrmpass + "' and tsfadmintbl.level='18';";
        this.glbObj.tlvStr2 = q = "select sfadminid,tsfadmintbl.usrid,tsfadmintbl.sid,tusertbl.status,seasonid,seasonname,factoryname From trueguide.tusertbl,trueguide.tsfadmintbl,trueguide.tseasontbl,trueguide.tsugarfactorytbl where tseasontbl.status=1 and tusertbl.usrid=tsfadmintbl.usrid and tseasontbl.sid=tsfadmintbl.sid and tsugarfactorytbl.sid=tsfadmintbl.sid  and mobno='" + this.loginobj.mobno + "' and password='" + this.loginobj.cnfrmpass + "' and tsfadmintbl.level='18' ";
        this.get_generic_ex("SF_ACC_LOGIN_DET");
        if (this.log.error_code == 0) {
            return true;
        }
        return ret;
    }

    public void get_password_central() throws IOException {
        this.loginobj.get_password();
        this.glbObj.password = this.loginobj.rcv_passwd;
        this.log.error_code = 0;
    }

    public void get_center_details() throws IOException {
        String tlv = "tcenterroletbl.1_crid#?&tcenterroletbl.2_cid#?&tcenterroletbl.3_centername#?&tcenterroletbl.4_status#?&tcenterroletbl.1_usrid_?#='" + this.loginobj.userid + "'";
        this.log.skip_parsing = false;
        this.log.performFulloperation(4, tlv.length(), tlv);
        if (this.log.error_code == 0) {
            this.glbObj.croleid_lst = this.log.GetValuesFromTbl("tcenterroletbl.1_crid");
            this.glbObj.cid_lst = this.log.GetValuesFromTbl("tcenterroletbl.2_cid");
            this.glbObj.centername_lst = this.log.GetValuesFromTbl("tcenterroletbl.3_centername");
            this.glbObj.status_lst = this.log.GetValuesFromTbl("tcenterroletbl.4_status");
            System.out.println("cid========" + this.glbObj.cid_lst);
            System.out.println("centername========" + this.glbObj.centername_lst);
        }
    }

    public void get_sugarfactory_details() throws IOException {
        String tlv = "tsfadmintbl.1_sfadminid#?&tsfadmintbl.2_sid#?&tsfadmintbl.3_status#?&tsfadmintbl.4_usrid#?&tsfadmintbl.5_level#?&tsfadmintbl.6_advid#?&tsfadmintbl.1_usrid_?#='" + this.glbObj.userid + "'";
        this.log.skip_parsing = false;
        this.log.performFulloperation(4, tlv.length(), tlv);
        if (this.log.error_code == 0) {
            this.glbObj.sfadminid = this.log.GetValuesFromTbl("tsfadmintbl.1_sfadminid").get(0).toString();
            this.glbObj.sid = this.log.GetValuesFromTbl("tsfadmintbl.2_sid").get(0).toString();
            this.glbObj.usr_id = this.log.GetValuesFromTbl("tsfadmintbl.4_usrid").get(0).toString();
            this.glbObj.privilage_level_type = this.log.GetValuesFromTbl("tsfadmintbl.5_level").get(0).toString();
            System.out.println("cid========" + this.glbObj.cid_lst);
            System.out.println("centername========" + this.glbObj.centername_lst);
        }
    }

    public boolean get_all_bank_names() throws IOException {
        boolean check;
        block16: {
            int i;
            check = false;
            if (this.glbObj.ids_only) {
                this.tlvObj.setTlv(12);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                this.do_all_network();
                this.log.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) {
                    check = false;
                } else {
                    if (this.glbObj.inst_bank) {
                        this.glbObj.instbank_id_lst = this.log.GetValuesFromTbl("tinstbanktbl.1_instbnkid");
                    } else {
                        this.glbObj.cbank_id_lst = this.log.GetValuesFromTbl("tcenterbanktbl.1_cbankid");
                    }
                    check = true;
                }
                this.log.println("this.glbObj.cbank_id_lst=========" + this.glbObj.cbank_id_lst);
            }
            if (this.glbObj.ids_only) break block16;
            if (this.glbObj.inst_bank) {
                this.glbObj.instbank_name_lst.clear();
                for (i = 0; i < this.glbObj.instbank_id_lst.size(); ++i) {
                    this.glbObj.instbankid_cur = this.glbObj.instbank_id_lst.get(i).toString();
                    this.tlvObj.setTlv(12);
                    boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                    if (!c) {
                        return false;
                    }
                    boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    this.log.println("In Library" + this.log.error_code);
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.instbank_name_lst.add(this.log.GetValuesFromTbl("tinstbanktbl.2_bankname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            } else {
                this.glbObj.cbank_name_lst.clear();
                for (i = 0; i < this.glbObj.cbank_id_lst.size(); ++i) {
                    this.glbObj.cbankid_cur = this.glbObj.cbank_id_lst.get(i).toString();
                    this.tlvObj.setTlv(12);
                    boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                    if (!c) {
                        return false;
                    }
                    boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    this.log.println("In Library" + this.log.error_code);
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.cbank_name_lst.add(this.log.GetValuesFromTbl("tcenterbanktbl.2_bankname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
        }
        return check;
    }

    public boolean get_all_bank_account_names() throws IOException {
        boolean check = false;
        if (this.glbObj.inst_account) {
            this.glbObj.inst_accont_lst_map.clear();
            this.glbObj.inst_ifsc_list_map.clear();
            for (int i = 0; i < this.glbObj.instbank_id_lst.size(); ++i) {
                this.glbObj.instbank_det_id_cur = this.glbObj.instbank_id_lst.get(i).toString();
                this.log.println(" this.glbObj.instbank_det_id_cur------" + this.glbObj.instbank_det_id_cur);
                this.tlvObj.setTlv(13);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                this.log.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                List instbank_accnt_lst = null;
                List instbank_ifsc_lst = null;
                instbank_accnt_lst = this.log.GetValuesFromTbl("tinstbankdetailstbl.1_accntno");
                instbank_ifsc_lst = this.log.GetValuesFromTbl("tinstbankdetailstbl.2_ifsccode");
                this.glbObj.inst_accont_lst_map.put(this.glbObj.instbank_det_id_cur, instbank_accnt_lst);
                this.glbObj.inst_ifsc_list_map.put(this.glbObj.instbank_det_id_cur, instbank_ifsc_lst);
                this.log.println("glbObj.accont_lst==" + this.glbObj.inst_accont_lst_map);
                this.log.println("glbObj.ifsc_list==" + this.glbObj.inst_ifsc_list_map);
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        } else {
            this.glbObj.accont_lst_map.clear();
            this.glbObj.ifsc_list_map.clear();
            for (int i = 0; i < this.glbObj.cbank_id_lst.size(); ++i) {
                this.glbObj.cbank_det_id_cur = this.glbObj.cbank_id_lst.get(i).toString();
                this.log.println(" this.glbObj.cbank_det_id_cur------" + this.glbObj.cbank_det_id_cur);
                this.tlvObj.setTlv(13);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                this.log.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                List cbank_accnt_lst = null;
                List cbank_ifsc_lst = null;
                cbank_accnt_lst = this.log.GetValuesFromTbl("tcenterbankdetailstbl.1_accntno");
                cbank_ifsc_lst = this.log.GetValuesFromTbl("tcenterbankdetailstbl.2_ifsccode");
                this.glbObj.accont_lst_map.put(this.glbObj.cbank_det_id_cur, cbank_accnt_lst);
                this.glbObj.ifsc_list_map.put(this.glbObj.cbank_det_id_cur, cbank_ifsc_lst);
                this.log.println("glbObj.accont_lst==" + this.glbObj.accont_lst_map);
                this.log.println("glbObj.ifsc_list==" + this.glbObj.ifsc_list_map);
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        this.log.println("end of for =====");
        this.log.println("glbObj.accont_lst==" + this.glbObj.accont_lst_map);
        this.log.println("glbObj.ifsc_list==" + this.glbObj.ifsc_list_map);
        return check;
    }

    public boolean get_buyee_and_vendor() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            if (this.glbObj.get_buyee) {
                // empty if block
            }
            if (this.glbObj.get_vendor) {
                // empty if block
            }
            if (this.glbObj.get_payer) {
                // empty if block
            }
            if (this.glbObj.get_institution && this.glbObj.instid_lst != null) {
                return true;
            }
            if (this.glbObj.get_inst_batch && this.glbObj.batchid_lst != null) {
                return true;
            }
            System.out.println("in buyee true");
            this.tlvObj.setTlv(14);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                if (this.glbObj.get_buyee) {
                    this.glbObj.buyeeid_lst = null;
                }
                if (this.glbObj.get_vendor) {
                    this.glbObj.vendorid_lst = null;
                }
                if (this.glbObj.get_payer) {
                    this.glbObj.payerid_lst = null;
                }
                if (this.glbObj.get_institution) {
                    this.glbObj.instid_lst = null;
                }
                if (this.glbObj.get_inst_batch) {
                    this.glbObj.batchid_lst = null;
                    this.glbObj.batchname_lst = null;
                }
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
            } else {
                if (this.glbObj.get_buyee) {
                    this.glbObj.buyeeid_lst = this.log.GetValuesFromTbl("tcenterexpensebuyeetbl.1_buyeeid");
                }
                if (this.glbObj.get_vendor) {
                    this.glbObj.vendorid_lst = this.log.GetValuesFromTbl("tcenterexpensevendortbl.1_vandorid");
                }
                if (this.glbObj.get_payer) {
                    this.glbObj.payerid_lst = this.log.GetValuesFromTbl("tcenterpayertbl.1_payerid");
                }
                if (this.glbObj.get_institution) {
                    this.glbObj.instid_lst = this.log.GetValuesFromTbl("pinsttbl.1_instid");
                }
                if (this.glbObj.get_inst_batch) {
                    this.glbObj.batchid_lst = this.log.GetValuesFromTbl("tbatchtbl.1_batchid");
                    this.glbObj.batchname_lst = this.log.GetValuesFromTbl("tbatchtbl.2_year");
                }
                check = true;
            }
            return check;
        }
        if (!this.glbObj.ids_only) {
            List expense_person_id_lst = null;
            if (this.glbObj.get_buyee) {
                this.glbObj.buyeename_lst.clear();
                expense_person_id_lst = this.glbObj.buyeeid_lst;
            }
            if (this.glbObj.get_vendor) {
                this.glbObj.vendorname_lst.clear();
                expense_person_id_lst = this.glbObj.vendorid_lst;
            }
            if (this.glbObj.get_payer) {
                this.glbObj.payername_lst.clear();
                expense_person_id_lst = this.glbObj.payerid_lst;
            }
            if (this.glbObj.get_institution) {
                this.glbObj.instname_lst.clear();
                expense_person_id_lst = this.glbObj.instid_lst;
            }
            for (int m = 0; m < expense_person_id_lst.size(); ++m) {
                this.glbObj.expense_person_id = expense_person_id_lst.get(m).toString();
                this.tlvObj.setTlv(14);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code == 2) {
                    check = false;
                    continue;
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                if (this.glbObj.get_buyee) {
                    this.glbObj.buyeename_lst.add(this.log.GetValuesFromTbl("tcenterexpensebuyeetbl.2_buyname").get(0).toString());
                }
                if (this.glbObj.get_vendor) {
                    this.glbObj.vendorname_lst.add(this.log.GetValuesFromTbl("tcenterexpensevendortbl.2_vendorname").get(0).toString());
                }
                if (this.glbObj.get_payer) {
                    this.glbObj.payername_lst.add(this.log.GetValuesFromTbl("tcenterpayertbl.2_payername").get(0).toString());
                }
                if (this.glbObj.get_institution) {
                    this.glbObj.instname_lst.add(this.log.GetValuesFromTbl("pinsttbl.2_instname").get(0).toString());
                }
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean add_buyee_and_vendor() throws IOException {
        boolean ch = false;
        this.tlvObj.setTlv(15);
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            if (this.glbObj.add_buyee) {
                this.dblib.PostDBExec("tcenterexpensebuyeetbl.1_buyeeid");
            }
            if (this.glbObj.add_vendor) {
                this.dblib.PostDBExec("tcenterexpensevendortbl.1_vandorid");
            }
            if (this.glbObj.add_payer) {
                this.dblib.PostDBExec("tcenterpayertbl.1_payerid");
            }
            if (this.glbObj.update_payer) {
                this.dblib.PostDBExec("");
            }
            if (this.glbObj.update_payee) {
                this.dblib.PostDBExec("");
            }
            if (this.glbObj.update_vendor) {
                this.dblib.PostDBExec("");
            }
            if (this.glbObj.update_payer_in_depositetbl) {
                this.dblib.PostDBExec("");
            }
            if (this.glbObj.update_payee_in_transtbl) {
                this.dblib.PostDBExec("");
            }
            if (this.glbObj.update_vendor_in_transtbl) {
                this.dblib.PostDBExec("");
            }
            if (this.glbObj.delete_payer) {
                this.dblib.PostDBExec("");
            }
            if (this.glbObj.delete_buyee) {
                this.dblib.PostDBExec("");
            }
            if (this.glbObj.delete_vendor) {
                this.dblib.PostDBExec("");
            }
            ch = true;
        }
        return ch;
    }

    public boolean insert_into_tcentertranstbl() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(16);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ch = false;
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            if (!(this.glbObj.update_interest || this.glbObj.update_status_institute || this.glbObj.update_status_center || !this.glbObj.from_feature.equals("Admission_Fees") && !this.glbObj.from_feature.equals("Scholarship"))) {
                this.dblib.PostDBExec("tcenterdepositetbl^1_dpid");
            }
            ch = true;
        }
        this.log.delim = "\\.";
        return ch;
    }

    public boolean get_cashbook_and_bank_book_entries() throws IOException {
        boolean check = false;
        this.glbObj.enttype_lst.clear();
        this.glbObj.remark_lst.clear();
        this.glbObj.trns_date_lst.clear();
        this.glbObj.amnt_lst.clear();
        this.glbObj.mode_lst.clear();
        this.glbObj.rep_bank_lst.clear();
        this.glbObj.rep_accnt_lst.clear();
        this.glbObj.rep_buyee_lst.clear();
        this.glbObj.rep_vendor_lst.clear();
        this.glbObj.center_lst.clear();
        this.glbObj.payer_name_lst.clear();
        this.glbObj.dep_status_lst.clear();
        this.glbObj.rep_ifsc_lst.clear();
        this.glbObj.fbank_name_lst.clear();
        this.glbObj.faccount_lst.clear();
        this.log.delim = "\\^";
        this.tlvObj.setTlv(17);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code == 2) {
            check = false;
            this.log.delim = "\\.";
        } else if (this.log.error_code != 0) {
            check = false;
            this.log.delim = "\\.";
        } else {
            if (this.glbObj.particular.equals("Cash/Bank Transfer")) {
                this.glbObj.trns_date_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^1_tdysdate");
                this.glbObj.remark_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^2_description");
                this.glbObj.amnt_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^3_amount");
                this.glbObj.center_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^4_center");
                this.glbObj.enttype_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^5_enttype");
                this.glbObj.cby_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^6_cby");
                this.glbObj.payer_name_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^7_payername");
                this.glbObj.dep_status_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^8_status");
                if (!this.glbObj.cash_book_report) {
                    this.glbObj.mode_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9_mode");
                    this.glbObj.rep_bank_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9a_bankname");
                    this.glbObj.rep_accnt_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9b_accountno");
                    this.glbObj.rep_ifsc_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9c_ifsccode");
                    this.glbObj.fbank_name_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9d_fbankname");
                    this.glbObj.faccount_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9e_faccountno");
                    this.glbObj.fifsc_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9f_fifsccode");
                    this.glbObj.tbank_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9g_tbankname");
                    this.glbObj.taccnt_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9h_taccountno");
                    this.glbObj.tifsc_lst = this.log.GetValuesFromTbl("tcenterdepositetbl^9i_tifsccode");
                }
            } else if (this.glbObj.particular.equals("indrctexpns") || this.glbObj.particular.equals("drctexpns") || this.glbObj.particular.equals("pettyexpns")) {
                this.glbObj.enttype_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^4_enttype");
                this.glbObj.remark_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^2_description");
                this.glbObj.trns_date_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^1_tdysdate");
                this.glbObj.amnt_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^3_amount");
                this.glbObj.rep_buyee_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^5_buyname");
                this.glbObj.rep_vendor_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^6_vendorname");
                if (!this.glbObj.cash_book_report) {
                    this.glbObj.mode_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^5_mode");
                    this.glbObj.rep_bank_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^6_bankname");
                    this.glbObj.rep_accnt_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^7_accountno");
                }
            }
            check = true;
            this.log.delim = "\\.";
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_all_epnse_type() throws IOException {
        boolean ret = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(18);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
            } else {
                this.glbObj.expense_type_id_lst = this.log.GetValuesFromTbl("tcenterexpnstypetbl.1_expnstypeid");
                ret = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.expns_type_lst.clear();
            for (int i = 0; i < this.glbObj.expense_type_id_lst.size(); ++i) {
                this.glbObj.exp_type_cur = this.glbObj.expense_type_id_lst.get(i).toString();
                this.tlvObj.setTlv(18);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    ret = false;
                    continue;
                }
                this.glbObj.expns_type_lst.add(this.log.GetValuesFromTbl("tcenterexpnstypetbl.2_type").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                ret = true;
            }
        }
        return ret;
    }

    public boolean get_todays_expenseids_optimized() throws IOException {
        boolean ret = false;
        if (this.glbObj.withdrawl) {
            this.glbObj.w_expn_amnt.clear();
            this.glbObj.w_expn_desc.clear();
            this.glbObj.w_expn_datte.clear();
            this.glbObj.w_expnse_bnkname.clear();
            this.glbObj.w_expnse_acnt_no_lst.clear();
            this.glbObj.w_expnse_ifsccode_lst.clear();
            this.glbObj.w_expnse_etid_lst.clear();
        }
        if (this.glbObj.ids_only) {
            this.log.delim = "\\^";
            this.tlvObj.setTlv(19);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
                this.log.delim = "\\.";
            } else {
                if (this.glbObj.withdrawl) {
                    this.glbObj.w_expn_amnt = this.log.GetValuesFromTbl("tcenterexpnstagtbl^1_tamount");
                    this.glbObj.w_expn_desc = this.log.GetValuesFromTbl("tcenterexpnstagtbl^2_purpose");
                    this.glbObj.w_expn_datte = this.log.GetValuesFromTbl("tcenterexpnstagtbl^3_tdate");
                    this.glbObj.w_expnse_bnkname = this.log.GetValuesFromTbl("tcenterexpnstagtbl^5_tbank");
                    this.glbObj.w_expnse_acnt_no_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl^6_tacntno");
                    this.glbObj.w_expnse_ifsccode_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl^7_tifsc");
                    this.glbObj.w_expnse_etid_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl^4_etid");
                } else {
                    this.glbObj.expn_trans_id_lst = this.log.GetValuesFromTbl("tcenterexpnstranstbl^1_expnstransid");
                }
                this.log.delim = "\\.";
                this.log.println("glbObj.expn_id_lst..==" + this.glbObj.expn_trans_id_lst);
                ret = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.expn_amnt.clear();
            this.glbObj.expn_desc.clear();
            this.glbObj.expn_datte.clear();
            this.glbObj.expnse_type_lst.clear();
            this.glbObj.expnse_mode_lst.clear();
            this.glbObj.expnse_chkno.clear();
            this.glbObj.expnse_chkdt.clear();
            this.glbObj.expnse_bnkname.clear();
            this.glbObj.expnse_ddno_lst.clear();
            this.glbObj.expnse_ddate_lst.clear();
            this.glbObj.expnse_challanno.clear();
            this.glbObj.expnse_acnt_no_lst.clear();
            this.glbObj.expnse_ifsccode_lst.clear();
            this.glbObj.expnse_wid_lst.clear();
            this.glbObj.expnse_entry_type_lst.clear();
            this.glbObj.expnse_payee_lst.clear();
            this.glbObj.expnse_vendor_lst.clear();
            this.glbObj.expnse_payee_id_lst.clear();
            this.glbObj.expnse_vendor_id_lst.clear();
            this.glbObj.jexpnse_transid_lst.clear();
            this.glbObj.expnse_etid_lst.clear();
            this.glbObj.expnse_tvia_lst.clear();
            List ids = null;
            ids = this.glbObj.expn_trans_id_lst;
            for (int i = 0; i < ids.size(); ++i) {
                this.glbObj.expnse_trans_id = ids.get(i).toString();
                this.log.delim = "\\^";
                this.tlvObj.setTlv(19);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                this.do_all_network();
                if (this.log.error_code != 0) {
                    ret = false;
                    continue;
                }
                this.glbObj.expn_amnt.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^2_amount").get(0).toString());
                this.glbObj.expn_desc.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^3_description").get(0).toString());
                this.glbObj.expn_datte.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^5_tdysdate").get(0).toString());
                this.glbObj.expnse_type_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^7_type").get(0).toString());
                this.glbObj.expnse_mode_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^8_mode").get(0).toString());
                this.glbObj.expnse_chkno.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9_checkno").get(0).toString());
                this.glbObj.expnse_chkdt.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9a_checkdate").get(0).toString());
                this.glbObj.expnse_bnkname.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9b_bankname").get(0).toString());
                this.glbObj.expnse_ddno_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9c_ddno").get(0).toString());
                this.glbObj.expnse_ddate_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9d_dddate").get(0).toString());
                this.glbObj.expnse_challanno.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9e_chalanno").get(0).toString());
                this.glbObj.expnse_acnt_no_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9f_accountno").get(0).toString());
                this.glbObj.expnse_ifsccode_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9g_ifsccode").get(0).toString());
                this.glbObj.expnse_entry_type_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9l_enttype").get(0).toString());
                this.glbObj.expnse_payee_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9i_buyname").get(0).toString());
                this.glbObj.expnse_vendor_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9k_vendorname").get(0).toString());
                this.glbObj.expnse_payee_id_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9h_buyeeid").get(0).toString());
                this.glbObj.expnse_vendor_id_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9j_vandorid").get(0).toString());
                this.glbObj.jexpnse_transid_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9p_jexpnstransid").get(0).toString());
                this.glbObj.expnse_etid_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9q_etid").get(0).toString());
                this.glbObj.expnse_tvia_lst.add(this.log.GetValuesFromTbl("tcenterexpnstranstbl^9r_tvia").get(0).toString());
                ret = true;
            }
            this.log.delim = "\\.";
        }
        return ret;
    }

    public boolean get_count_of_type() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(20);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (this.glbObj.get_trans_count_exp) {
                this.glbObj.expns_trans_count = this.log.GetValuesFromTbl("tcenterexpnstranstbl.1_count(*)").get(0).toString();
            } else if (this.glbObj.get_trans_count_exp_inst) {
                this.glbObj.expns_trans_count_inst = this.log.GetValuesFromTbl("texpnstranstbl.1_count(*)").get(0).toString();
            } else if (this.glbObj.get_payee_count) {
                this.glbObj.payee_count = this.log.GetValuesFromTbl("tcenterexpnstranstbl.1_count(*)").get(0).toString();
            } else if (this.glbObj.get_vendor_count) {
                this.glbObj.vendor_count = this.log.GetValuesFromTbl("tcenterexpnstranstbl.1_count(*)").get(0).toString();
            } else if (this.glbObj.get_payer_count) {
                this.glbObj.payer_count = this.log.GetValuesFromTbl("tcenterdepositetbl.1_count(*)").get(0).toString();
            } else if (this.glbObj.get_unconfirmed_count) {
                this.glbObj.unconfirm_count = this.log.GetValuesFromTbl("tcenterdepositetbl.1_count(*)").get(0).toString();
            } else if (this.glbObj.get_inst_expnstype_count) {
                this.glbObj.type_count = this.log.GetValuesFromTbl("tinstexpnstypetbl.1_count(*)").get(0).toString();
            } else {
                this.glbObj.expns_type_count = this.log.GetValuesFromTbl("tcenterexpnstypetbl.1_count(*)").get(0).toString();
            }
            check = true;
        }
        return check;
    }

    public boolean insert_expns_type() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(21);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (this.glbObj.insert_inst_types) {
                if (this.glbObj.delete_expnse_type) {
                    System.out.println("In here=-:::");
                    this.dblib.PostDBExec("");
                } else {
                    this.dblib.PostDBExec("tinstexpnstypetbl.1_expnstypeid");
                }
            } else if (this.glbObj.delete_expnse_type) {
                System.out.println("In here=-:::");
                this.dblib.PostDBExec("");
            } else {
                this.dblib.PostDBExec("tcenterexpnstypetbl.1_expnstypeid");
            }
            ch = true;
        }
        return check;
    }

    public boolean get_total_expense_amount_for_the_withdrawl() throws IOException {
        boolean check = false;
        if (this.glbObj.get_sum_rev_amount) {
            this.log.delim = "\\^";
            this.tlvObj.setTlv(22);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                this.log.delim = "\\.";
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
                this.log.delim = "\\.";
            } else {
                this.glbObj.sum_rev_amount = this.log.GetValuesFromTbl("tcenterexpnstranstbl^1_sum(amount)").get(0).toString();
                check = true;
                this.log.delim = "\\.";
            }
            this.log.delim = "\\.";
        } else if (this.glbObj.total_tagged_amount) {
            this.log.delim = "\\^";
            this.tlvObj.setTlv(22);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                this.log.delim = "\\.";
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
                this.log.delim = "\\.";
            } else {
                this.glbObj.total_tag_amount = this.log.GetValuesFromTbl("tcenterexpnstagtbl^1_sum(tamount)").get(0).toString();
                check = true;
                this.log.delim = "\\.";
            }
            this.log.delim = "\\.";
        } else if (this.glbObj.total_spent_tag) {
            this.log.delim = "\\^";
            this.tlvObj.setTlv(22);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                this.log.delim = "\\.";
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
                this.log.delim = "\\.";
            } else {
                this.glbObj.spent_tag_amount = this.log.GetValuesFromTbl("tcenterexpnstranstbl^1_sum(amount)").get(0).toString();
                check = true;
                this.log.delim = "\\.";
            }
            this.log.delim = "\\.";
        } else {
            if (this.glbObj.get_expns_amount_sum) {
                if (this.glbObj.w_entry_type.equals("0")) {
                    this.glbObj.sum_expense_lst_debit.clear();
                }
                if (this.glbObj.w_entry_type.equals("1")) {
                    this.glbObj.sum_expense_lst_credit.clear();
                }
            }
            String tlvstr = "";
            int i = 0;
            for (i = 0; i < this.glbObj.w_expnse_etid_lst.size(); ++i) {
                this.glbObj.et_id_cur = this.glbObj.w_expnse_etid_lst.get(i).toString();
                this.log.delim = "\\^";
                this.tlvObj.setTlv(22);
                tlvstr = i > 0 ? tlvstr + "~" + this.glbObj.tlvStr : tlvstr + this.glbObj.tlvStr;
            }
            this.glbObj.tlvStr = "";
            this.glbObj.tlvStr = tlvstr;
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                this.log.delim = "\\.";
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
                this.log.delim = "\\.";
            } else {
                if (this.glbObj.get_expns_amount_sum) {
                    if (this.glbObj.w_entry_type.equals("0")) {
                        this.glbObj.sum_expense_lst_debit = this.log.GetValuesFromTbl("tcenterexpnstranstbl^1_sum(amount)");
                        System.out.println("==this.glbObj.sum_expense_lst_debit++++" + this.glbObj.sum_expense_lst_debit);
                    }
                    if (this.glbObj.w_entry_type.equals("1")) {
                        this.glbObj.sum_expense_lst_credit = this.log.GetValuesFromTbl("tcenterexpnstranstbl^1_sum(amount)");
                        System.out.println("===this.glbObj.sum_expense_lst_credit+++" + this.glbObj.sum_expense_lst_credit);
                    }
                }
                check = true;
                this.log.delim = "\\.";
            }
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean delete_expense() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(23);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        return check;
    }

    public boolean insert_expns_transaction_details() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(24);
        boolean ch = false;
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            ch = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_bind_student_to_route() throws IOException {
        this.tlvObj.setTlv(25);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        boolean check = false;
        this.log.println("In Library" + this.log.error_code);
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (this.glbObj.check_deposit) {
                this.glbObj.dep_count = this.log.GetValuesFromTbl("tcenterdepositetbl.1_count(*)").get(0).toString();
            } else if (this.glbObj.check_withdrawal) {
                this.glbObj.withd_count = this.log.GetValuesFromTbl("tcenterpettywithdrawltbl.1_count(*)").get(0).toString();
            }
            check = true;
        }
        return check;
    }

    public boolean get_cashbook_details() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(26);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code == 2) {
            this.glbObj.sum_amount = "None";
            ret = false;
        } else if (this.log.error_code != 0) {
            ret = false;
        } else {
            if (this.glbObj.particular.equals("Cash/Bank Transfer")) {
                this.glbObj.sum_amount = this.log.GetValuesFromTbl("tcenterdepositetbl.1_sum(amount)").get(0).toString();
            }
            if (this.glbObj.particular.equals("exp")) {
                this.glbObj.sum_amount = this.log.GetValuesFromTbl("tcenterexpnstranstbl.1_sum(amount)").get(0).toString();
            }
            if (this.glbObj.particular.equals("withdrawls")) {
                if (this.glbObj.entry_type.equals("0")) {
                    this.glbObj.sum_amount = this.log.GetValuesFromTbl("tcenterpettywithdrawltbl.1_sum(amount)").get(0).toString();
                }
                if (this.glbObj.entry_type.equals("1")) {
                    this.glbObj.sum_amount = this.log.GetValuesFromTbl("tcenterexpnstranstbl.1_sum(amount)").get(0).toString();
                }
            }
            ret = true;
        }
        return ret;
    }

    public boolean get_tcentertranstbl_details() throws IOException {
        System.out.println("In plugin");
        boolean check = false;
        if (this.glbObj.get_sum_tags) {
            String tlvstr = "";
            int i = 0;
            for (i = 0; i < this.glbObj.dpid_list.size(); ++i) {
                this.glbObj.dpid_curr = this.glbObj.dpid_list.get(i).toString();
                this.tlvObj.setTlv(27);
                tlvstr = i > 0 ? tlvstr + "~" + this.glbObj.tlvStr : tlvstr + this.glbObj.tlvStr;
            }
            this.glbObj.tlvStr = "";
            this.glbObj.tlvStr = tlvstr;
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.sum_tags_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.1_sum(tamount)");
            }
        } else {
            this.log.delim = "\\^";
            this.tlvObj.setTlv(27);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                this.log.delim = "\\.";
            } else {
                this.glbObj.dpid_list = this.log.GetValuesFromTbl("tcenterdepositetbl^1_dpid");
                this.glbObj.desc_list = this.log.GetValuesFromTbl("tcenterdepositetbl^2_description");
                this.glbObj.feespaid_list = this.log.GetValuesFromTbl("tcenterdepositetbl^3_amount");
                this.glbObj.mode_list = this.log.GetValuesFromTbl("tcenterdepositetbl^5_mode");
                this.glbObj.trans_date_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9e_tdysdate");
                this.glbObj.status_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9f_status");
                this.glbObj.cby_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9g_cby");
                this.glbObj.payername_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9i_payername");
                this.glbObj.enttype_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9j_enttype");
                this.glbObj.epoch_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9l_epch");
                this.glbObj.checkno_list = this.log.GetValuesFromTbl("tcenterdepositetbl^6_checkno");
                this.glbObj.checkdate_list = this.log.GetValuesFromTbl("tcenterdepositetbl^7_checkdate");
                this.glbObj.bankname_list = this.log.GetValuesFromTbl("tcenterdepositetbl^8_bankname");
                this.glbObj.ddno_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9_ddno");
                this.glbObj.dddate_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9a_dddate");
                this.glbObj.accountno_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9c_accountno");
                this.glbObj.ifsc_list = this.log.GetValuesFromTbl("tcenterdepositetbl^9d_ifsccode");
            }
            check = true;
            this.log.delim = "\\.";
        }
        this.log.delim = "\\.";
        return check;
    }

    public String get_sum(String q, int args) {
        String retStr = "";
        this.glbObj.req_type = 709;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        System.out.println("q=" + q);
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return "-1";
        }
        int i = 1;
        String sum = "";
        String arg = "";
        while (i <= args) {
            arg = "X^" + i + "_" + i;
            System.out.println("arg=" + arg);
            sum = i == 1 ? this.log.GetValuesFromTbl(arg).get(0).toString().trim() : sum + "#" + this.log.GetValuesFromTbl(arg).get(0).toString().trim();
            ++i;
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return sum;
    }

    public boolean insert_into_tcentertranstbl_to_confirm() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.tlvObj.setTlv(28);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (this.glbObj.create_emp_as_user) {
                this.dblib.PostDBExec("tusertbl.1_usrid");
            } else if (this.glbObj.create_emp) {
                this.dblib.PostDBExec("temptbl.1_empid");
            } else if (this.glbObj.update_emp_info) {
                this.dblib.PostDBExec("");
            } else if (this.glbObj.update_emp_info_usertbl) {
                this.dblib.PostDBExec("");
            } else {
                this.dblib.PostDBExec("tcentertranstbl^1_ctransid");
            }
            ch = true;
        }
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_all_tags() throws IOException {
        boolean check = false;
        this.glbObj.emp_id_lst.clear();
        this.glbObj.emp_name_lst.clear();
        this.glbObj.emp_contact_lst.clear();
        this.glbObj.emp_aadhar_lst.clear();
        this.glbObj.emp_panno_lst.clear();
        this.glbObj.emp_status_lst.clear();
        this.glbObj.emp_usrid_lst.clear();
        this.tlvObj.setTlv(29);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        this.log.println("In Library" + this.log.error_code);
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (this.glbObj.get_usrid_by_mobno) {
                this.glbObj.emp_usrid = this.log.GetValuesFromTbl("tusertbl.1_usrid").get(0).toString();
            } else if (this.glbObj.get_expense_types) {
                this.glbObj.inst_expns_type_lst = this.log.GetValuesFromTbl("tinstexpnstypetbl.1_distinct(type)");
                this.glbObj.inst_expns_typeid_lst = this.log.GetValuesFromTbl("tinstexpnstypetbl.2_expnstypeid");
            } else if (this.glbObj.get_employees) {
                this.glbObj.emp_id_lst = this.log.GetValuesFromTbl("temptbl.1_empid");
                this.glbObj.emp_name_lst = this.log.GetValuesFromTbl("temptbl.2_empname");
                this.glbObj.emp_contact_lst = this.log.GetValuesFromTbl("temptbl.3_contactno");
                this.glbObj.emp_aadhar_lst = this.log.GetValuesFromTbl("temptbl.4_aadharno");
                this.glbObj.emp_panno_lst = this.log.GetValuesFromTbl("temptbl.5_panno");
                this.glbObj.emp_status_lst = this.log.GetValuesFromTbl("temptbl.6_status");
                this.glbObj.emp_usrid_lst = this.log.GetValuesFromTbl("temptbl.7_usrid");
            } else {
                this.glbObj.etagid_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.1_etid");
                this.glbObj.tag_tamount_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.2_tamount");
                this.glbObj.tag_purpose_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.3_purpose");
                this.glbObj.tag_tdate_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.5_tdate");
                this.glbObj.tag_tvia_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.6_tvia");
                this.glbObj.tag_tbank_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.7_tbank");
                this.glbObj.tag_taccntno_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.8_tacntno");
                this.glbObj.tag_tifsc_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.9_tifsc");
                this.glbObj.tag_petty_lst = this.log.GetValuesFromTbl("tcenterexpnstagtbl.9a_petty");
            }
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public void get_bank_details() {
        this.glbObj.cbankdetid_lst.clear();
        this.glbObj.accntno_lst.clear();
        this.glbObj.ifsc_code_lst.clear();
        String tlvStr = "";
        if (this.glbObj.get_details.equals("Bank")) {
            tlvStr = "select cbankid,bankname from trueguide.tcenterbanktbl where cid='" + this.glbObj.cid + "'";
        }
        if (this.glbObj.get_details.equals("Account")) {
            tlvStr = "select cbankdetid,accntno,ifsccode from trueguide.tcenterbankdetailstbl where cbankid='" + this.glbObj.cbankid_cur + "' and cid= '" + this.glbObj.cid + "'";
        }
        this.glbObj.req_type = 709;
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.glbObj.get_details.equals("Bank")) {
            this.glbObj.cbankid_lst = this.log.GetValuesFromTbl("X^1_1");
            this.glbObj.cbankname_lst = this.log.GetValuesFromTbl("X^2_2");
        }
        if (this.glbObj.get_details.equals("Account")) {
            this.glbObj.cbankdetid_lst = this.log.GetValuesFromTbl("X^1_1");
            this.glbObj.accntno_lst = this.log.GetValuesFromTbl("X^2_2");
            this.glbObj.ifsc_code_lst = this.log.GetValuesFromTbl("X^3_3");
        }
        this.log.delim = "\\.";
    }

    public boolean add_bank_details() {
        this.glbObj.req_type = 714;
        if (this.glbObj.add_details.equals("Bank")) {
            this.tlvObj.glbObj.tlvStr = "insert into trueguide.tcenterbanktbl(bankname,cid) values('" + this.glbObj.bankname + "','" + this.glbObj.cid + "')";
        }
        if (this.glbObj.add_details.equals("Account")) {
            if (this.glbObj.perform.equals("Insert")) {
                this.tlvObj.glbObj.tlvStr = "insert into trueguide.tcenterbankdetailstbl(cbankid,accntno,ifsccode,cid) values('" + this.glbObj.cbankid_cur + "','" + this.glbObj.accountno + "','" + this.glbObj.ifsc + "','" + this.glbObj.cid + "')";
            } else if (this.glbObj.perform.equals("Update")) {
                this.tlvObj.glbObj.tlvStr = "update trueguide.tcenterbankdetailstbl set accntno='" + this.glbObj.accountno + "' , ifsccode='" + this.glbObj.ifsc + "' where cbankdetid='" + this.glbObj.cbankdetid_cur + "'";
            }
        }
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.log.delim = "\\^";
        try {
            this.do_all_network();
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.log.delim = "\\.";
        return true;
    }

    public boolean delete_details() {
        if (this.glbObj.cbankid_cur.isEmpty()) {
            return false;
        }
        String query = "";
        if (this.glbObj.delete_details.equals("Bank")) {
            query = "delete from trueguide.tcenterbanktbl where cbankid='" + this.glbObj.cbankid_cur + "'";
        }
        if (this.glbObj.delete_details.equals("Bank Accounts")) {
            query = "delete from trueguide.tcenterbankdetailstbl where cbankid='" + this.glbObj.cbankid_cur + "'";
        }
        if (this.glbObj.delete_details.equals("Account")) {
            query = "delete from trueguide.tcenterbankdetailstbl where cbankdetid='" + this.glbObj.cbankdetid_cur + "'";
        }
        this.glbObj.req_type = 714;
        System.out.println(">>>>tlvStr=" + query);
        this.tlvObj.glbObj.tlvStr = query;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.log.delim = "\\.";
        return true;
    }

    public boolean insert_employee_details() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(30);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (this.glbObj.create_emp_as_user) {
                this.dblib.PostDBExec("tusertbl.1_usrid");
            } else if (this.glbObj.create_emp) {
                this.dblib.PostDBExec("temptbl.1_empid");
            } else if (this.glbObj.update_emp_info) {
                this.dblib.PostDBExec("");
            } else if (this.glbObj.update_emp_info_usertbl) {
                this.dblib.PostDBExec("");
            }
            ch = true;
        }
        return check;
    }

    public boolean get_active_ctc_teacher() throws IOException {
        boolean check = false;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        this.tlvObj.setTlv(31);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            check = false;
        } else {
            if (this.glbObj.get_active_ctc) {
                this.glbObj.active_ctc = this.log.GetValuesFromTbl("tteacherctctbl^1_ctc").get(0).toString();
            } else {
                this.glbObj.ctc_lst = this.log.GetValuesFromTbl("tteacherctctbl^1_ctc");
                this.glbObj.st_lst = this.log.GetValuesFromTbl("tteacherctctbl^2_status");
                this.glbObj.ctcid_lst = this.log.GetValuesFromTbl("tteacherctctbl^3_ctcid");
            }
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            check = true;
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return check;
    }

    public boolean add_ctc_teacher() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.dblib.pme.delim = "\\^";
        this.tlvObj.setTlv(32);
        boolean ch = false;
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            this.dblib.pme.delim = "\\.";
            ch = false;
        } else {
            ch = true;
        }
        this.log.delim = "\\.";
        this.dblib.pme.delim = "\\.";
        return ch;
    }

    public boolean insert_into_salarytbl() throws IOException {
        boolean check = false;
        this.log.delim = "\\^";
        this.dblib.pme.delim = "\\^";
        this.tlvObj.setTlv(33);
        boolean ch = false;
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            this.dblib.pme.delim = "\\.";
            ch = false;
        } else {
            this.log.delim = "\\.";
            this.dblib.pme.delim = "\\.";
            ch = true;
        }
        this.log.delim = "\\.";
        this.dblib.pme.delim = "\\.";
        return ch;
    }

    public boolean insert_op_payroll() throws IOException {
        boolean check = false;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        this.tlvObj.setTlv(34);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            check = false;
        } else {
            check = true;
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return check;
    }

    public void get_profiles() {
        if (this.glbObj.get_profiles) {
            this.glbObj.prof_id_lst.clear();
            this.glbObj.prof_name_lst.clear();
        }
        if (this.glbObj.get_types) {
            this.glbObj.leavetype_id_lst.clear();
            this.glbObj.leavetype_lst.clear();
        }
        if (this.glbObj.get_prof_details) {
            this.glbObj.dtl_prof_name_lst.clear();
            this.glbObj.dtl_leavetype_lst.clear();
            this.glbObj.dtl_allocation_lst.clear();
        }
        String tlvStr = "";
        if (this.glbObj.get_profiles) {
            tlvStr = "select profid,profname from trueguide.leaveproftbl where sid='" + this.glbObj.sid + "'";
        }
        if (this.glbObj.get_types) {
            tlvStr = "select leavetypeid,leavetype from trueguide.leavetypetbl where sid='" + this.glbObj.sid + "'";
        }
        if (this.glbObj.get_count) {
            tlvStr = "select count(*) from trueguide.empleaveproftbl where empid='" + this.glbObj.emp_id_cur + "'";
        }
        if (this.glbObj.get_prof_details) {
            tlvStr = "select profname,leavetype,allocation,profid,leavetypeid from trueguide.leaveprofdetailstbl where profid='" + this.glbObj.prof_id_cur + "'";
        }
        if (this.glbObj.type_cnt) {
            tlvStr = "select count(*) from trueguide.leaveprofdetailstbl where profid='" + this.glbObj.prof_id_cur + "' and leavetypeid='" + this.glbObj.leavetype_id_cur + "'";
        }
        this.glbObj.req_type = 709;
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.glbObj.get_profiles) {
            this.glbObj.prof_id_lst = this.log.GetValuesFromTbl("X^1_1");
            this.glbObj.prof_name_lst = this.log.GetValuesFromTbl("X^2_2");
        }
        if (this.glbObj.get_types) {
            this.glbObj.leavetype_id_lst = this.log.GetValuesFromTbl("X^1_1");
            this.glbObj.leavetype_lst = this.log.GetValuesFromTbl("X^2_2");
        }
        if (this.glbObj.get_count) {
            this.glbObj.pro_count = this.log.GetValuesFromTbl("X^1_1").get(0).toString();
        }
        if (this.glbObj.get_prof_details) {
            this.glbObj.dtl_prof_name_lst = this.log.GetValuesFromTbl("X^1_1");
            this.glbObj.dtl_leavetype_lst = this.log.GetValuesFromTbl("X^2_2");
            this.glbObj.dtl_allocation_lst = this.log.GetValuesFromTbl("X^3_3");
            this.glbObj.dtl_leavetypeid_lst = this.log.GetValuesFromTbl("X^4_4");
            this.glbObj.dtl_profid_lst = this.log.GetValuesFromTbl("X^5_5");
        }
        if (this.glbObj.type_cnt) {
            this.glbObj.type_count_cur = this.log.GetValuesFromTbl("X^1_1").get(0).toString();
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
    }

    public boolean create_profile() {
        this.glbObj.req_type = 714;
        if (this.glbObj.create_prof) {
            this.tlvObj.glbObj.tlvStr = "insert into trueguide.leaveproftbl(profname,sid) values('" + this.glbObj.profname + "','" + this.glbObj.sid + "')";
        }
        if (this.glbObj.create_leavetype) {
            this.tlvObj.glbObj.tlvStr = "insert into trueguide.leavetypetbl(leavetype,sid) values('" + this.glbObj.leavetype + "','" + this.glbObj.sid + "')";
        }
        if (this.glbObj.create_prof_details) {
            this.tlvObj.glbObj.tlvStr = "insert into trueguide.leaveprofdetailstbl(profid,leavetypeid,leavetype,allocation,profname) values('" + this.glbObj.prof_id_cur + "','" + this.glbObj.leavetype_id_cur + "','" + this.glbObj.leavetype_cur + "','" + this.glbObj.allocation_days + "','" + this.glbObj.prof_name_cur + "')";
        }
        if (this.glbObj.bind_profile) {
            this.tlvObj.glbObj.tlvStr = "insert into trueguide.empleaveproftbl(profid,empid,sid) values('" + this.glbObj.prof_id_cur + "','" + this.glbObj.emp_id_cur + "','" + this.glbObj.sid + "')";
        }
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return true;
    }

    public boolean delete_profile() {
        if (this.glbObj.prof_id_cur.isEmpty()) {
            return false;
        }
        String query = "";
        if (this.glbObj.delete_prof) {
            query = "delete from trueguide.leaveproftbl where profid='" + this.glbObj.prof_id_cur + "'";
        }
        if (this.glbObj.delete_type) {
            query = "delete from trueguide.leavetypetbl where leavetypeid='" + this.glbObj.leavetype_id_cur + "'";
        }
        this.glbObj.req_type = 714;
        System.out.println(">>>>tlvStr=" + query);
        this.tlvObj.glbObj.tlvStr = query;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public void get_emp_profiles() {
        this.glbObj.prof_id_lst.clear();
        this.glbObj.leavetype_id_lst.clear();
        this.glbObj.leavetype_lst.clear();
        this.glbObj.allocation_lst.clear();
        this.glbObj.prof_name_lst.clear();
        String tlvStr = "";
        tlvStr = "select empleaveproftbl.profid,leavetypeid,leavetype,allocation,profname from trueguide.empleaveproftbl,trueguide.leaveprofdetailstbl where empleaveproftbl.profid=leaveprofdetailstbl.profid and empid='" + this.glbObj.emp_id_cur + "'";
        this.glbObj.req_type = 709;
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.glbObj.prof_id_cur = this.log.GetValuesFromTbl("X^1_1").get(0).toString();
        this.glbObj.leavetype_id_lst = this.log.GetValuesFromTbl("X^2_2");
        this.glbObj.leavetype_lst = this.log.GetValuesFromTbl("X^3_3");
        this.glbObj.allocation_lst = this.log.GetValuesFromTbl("X^4_4");
        this.glbObj.prof_name = this.log.GetValuesFromTbl("X^5_5").get(0).toString();
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
    }

    public boolean apply_leave(String str) {
        this.glbObj.req_type = 714;
        if (this.glbObj.consumed_days_new.equalsIgnoreCase("")) {
            this.glbObj.consumed_days_new = "0";
        }
        System.out.println("this.glbObj.consumed_days_new======" + this.glbObj.consumed_days_new);
        System.out.println("this.glbObj.consumed_days======" + this.glbObj.consumed_days);
        int consumed = Integer.parseInt(this.glbObj.consumed_days_new) + Integer.parseInt(this.glbObj.consumed_days);
        String consumed_days = String.valueOf(consumed);
        System.out.println("consumed_days====" + consumed_days);
        this.tlvObj.glbObj.tlvStr = "insert into trueguide.leaveapptbl (empid,usrid,allocation,consumed,profid,profname,leavetypeid,leavetype,status,remleaves,key) values('" + this.glbObj.emp_id_cur + "','" + this.glbObj.emp_userid_cur + "','" + this.glbObj.total_days + "','" + this.glbObj.consumed_days + "','" + this.glbObj.prof_id_cur + "','" + this.glbObj.prof_name + "','" + this.glbObj.leavetype_id_cur + "','" + this.glbObj.leavetype_cur + "','1','" + this.glbObj.rem_days + "','" + str + "') on conflict(key) do update set consumed='" + consumed_days + "' , remleaves='" + this.glbObj.rem_days + "'";
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return true;
    }

    public boolean add_leave_details_into_leaveappdetailstbl(String str) {
        this.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = "insert into trueguide.leaveappdetailstbl (empid,usrid,applieddate,appliedday,fromdate,tilldate,allocation,consumed,reason,profid,profname,leavetypeid,leavetype,status,remleaves,key) values('" + this.glbObj.emp_id_cur + "','" + this.glbObj.emp_userid_cur + "','" + this.glbObj.cur_date + "','" + this.glbObj.cur_day + "','" + this.glbObj.from_date_leave + "','" + this.glbObj.till_date_leave + "','" + this.glbObj.total_days + "','" + this.glbObj.consumed_days + "','" + this.glbObj.leave_reason + "','" + this.glbObj.prof_id_cur + "','" + this.glbObj.prof_name + "','" + this.glbObj.leavetype_id_cur + "','" + this.glbObj.leavetype_cur + "','1','" + this.glbObj.rem_days + "','" + str + "')";
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return true;
    }

    public void get_applied_leave_details() {
        this.glbObj.req_type = 709;
        String tlvStr = "";
        tlvStr = "select leaveappid,applieddate,appliedday,fromdate,tilldate,allocation,consumed,reason,profid,profname,leavetypeid,leavetype,approvedate,status,remleaves from trueguide.leaveappdetailstbl  where empid='" + this.glbObj.emp_id_cur + "' and usrid='" + this.glbObj.emp_userid_cur + "'";
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.glbObj.leaveappid_lst = this.log.GetValuesFromTbl("X^1_1");
        this.glbObj.applieddate_lst = this.log.GetValuesFromTbl("X^2_2");
        this.glbObj.appliedday_lst = this.log.GetValuesFromTbl("X^3_3");
        this.glbObj.fromdate_lst = this.log.GetValuesFromTbl("X^4_4");
        this.glbObj.tilldate_lst = this.log.GetValuesFromTbl("X^5_5");
        this.glbObj.total_allocation_lst = this.log.GetValuesFromTbl("X^6_6");
        this.glbObj.consumed_lst = this.log.GetValuesFromTbl("X^7_7");
        this.glbObj.reason_lst = this.log.GetValuesFromTbl("X^8_8");
        this.glbObj.profid_lst = this.log.GetValuesFromTbl("X^9_9");
        this.glbObj.profname_lst = this.log.GetValuesFromTbl("X^10_10");
        this.glbObj.leave_typeid_lst = this.log.GetValuesFromTbl("X^11_11");
        this.glbObj.leave_type_lst = this.log.GetValuesFromTbl("X^12_12");
        this.glbObj.approvedate_lst = this.log.GetValuesFromTbl("X^13_13");
        this.glbObj.status_lst = this.log.GetValuesFromTbl("X^14_14");
        this.glbObj.remleaves_lst = this.log.GetValuesFromTbl("X^15_15");
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
    }

    public void get_leave_status() {
        this.glbObj.req_type = 709;
        String tlvStr = "";
        tlvStr = "select allocation,consumed,remleaves from trueguide.leaveapptbl  where empid='" + this.glbObj.emp_id_cur + "' and usrid='" + this.glbObj.emp_userid_cur + "' and leavetypeid='" + this.glbObj.leavetype_id_cur + "'";
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code == 2) {
            return;
        }
        this.glbObj.allocation_days_new = this.log.GetValuesFromTbl("X^1_1").get(0).toString();
        this.glbObj.consumed_days_new = this.log.GetValuesFromTbl("X^2_2").get(0).toString();
        this.glbObj.remleaves_new = this.log.GetValuesFromTbl("X^3_3").get(0).toString();
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
    }

    public void get_department() {
        String tlvStr = "";
        this.glbObj.req_type = 709;
        tlvStr = " select deptid,deptname from trueguide.tiodepttbl order by deptname";
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.glbObj.dept_id_lst = this.log.GetValuesFromTbl("X^1_1");
        this.glbObj.dept_name_lst = this.log.GetValuesFromTbl("X^2_2");
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
    }

    public void get_expense_types() {
        String tlvStr = "";
        this.glbObj.req_type = 709;
        tlvStr = " select type,expnstypeid,descr from trueguide.tinstexpnstypetbl where cid='" + this.glbObj.cid + "' and exptype='" + this.glbObj.exp_type + "' order by type";
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGCentralizeLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            return;
        }
        this.glbObj.inst_expns_type_lst = this.log.GetValuesFromTbl("X^1_1");
        this.glbObj.inst_expns_typeid_lst = this.log.GetValuesFromTbl("X^2_2");
        this.glbObj.inst_expns_descr_lst = this.log.GetValuesFromTbl("X^3_3");
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
    }

    public boolean get_all_batches_for_the_institution() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(35);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.batchid_lst_opt = this.log.GetValuesFromTbl("tbatchtbl.1_batchid");
                System.out.println("or else this is working ===========" + this.glbObj.batchid_lst_opt);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.batchid_lst = new ArrayList();
            this.glbObj.status_lst = new ArrayList();
            this.glbObj.btc_year_lst = new ArrayList();
            this.glbObj.batch_adm_year_lst = new ArrayList();
            this.glbObj.prevbatch_lst = new ArrayList();
            this.glbObj.next_batchid_lst = new ArrayList();
            List batchid_lst = null;
            batchid_lst = this.glbObj.batchid_lst_opt;
            for (int i = 0; i < batchid_lst.size(); ++i) {
                this.glbObj.batch_id_current = batchid_lst.get(i).toString();
                this.tlvObj.setTlv(35);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                this.log.println("Reply buff-->" + this.log.rcv_buff + " boolean->" + ca);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.batchid_lst.add(this.log.GetValuesFromTbl("tbatchtbl.1_batchid").get(0).toString());
                this.glbObj.status_lst.add(this.log.GetValuesFromTbl("tbatchtbl.2_status").get(0).toString());
                this.glbObj.btc_year_lst.add(this.log.GetValuesFromTbl("tbatchtbl.3_year").get(0).toString());
                this.glbObj.prevbatch_lst.add(this.log.GetValuesFromTbl("tbatchtbl.4_prevbatch").get(0).toString());
                this.glbObj.next_batchid_lst.add(this.log.GetValuesFromTbl("tbatchtbl.7_next").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean get_cashbook_details_report() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(36);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code == 2) {
            this.glbObj.sum_amount = "None";
            ret = false;
        } else if (this.log.error_code != 0) {
            ret = false;
        } else {
            if (this.glbObj.particular.equals("admfee")) {
                this.glbObj.sum_amount = this.log.GetValuesFromTbl("tstudfeestranstbl.1_sum(feespaid)").get(0).toString();
            }
            if (this.glbObj.particular.equals("other")) {
                this.glbObj.sum_amount = this.log.GetValuesFromTbl("tstudotherfeestranstbl.1_sum(feespaid)").get(0).toString();
            }
            if (this.glbObj.particular.equals("misc")) {
                this.glbObj.sum_amount = this.log.GetValuesFromTbl("tmiscfeetranstbl.1_sum(feespaid)").get(0).toString();
            }
            if (this.glbObj.particular.equals("exp")) {
                this.glbObj.sum_amount = this.log.GetValuesFromTbl("texpnstranstbl.1_sum(amount)").get(0).toString();
            }
            if (this.glbObj.particular.equals("payroll")) {
                this.glbObj.sum_amount = this.log.GetValuesFromTbl("tsalarytbl.1_sum(amount)").get(0).toString();
            }
            if (this.glbObj.particular.equals("cashtransfer")) {
                this.glbObj.sum_amount = this.log.GetValuesFromTbl("tdepositetbl.1_sum(amount)").get(0).toString();
            }
            ret = true;
        }
        return ret;
    }

    public boolean get_cashbook_and_bank_book_entries_report() throws IOException {
        boolean check = false;
        this.glbObj.enttype_lst.clear();
        this.glbObj.remark_lst.clear();
        this.glbObj.trns_date_lst.clear();
        this.glbObj.amnt_lst.clear();
        this.glbObj.mode_lst.clear();
        this.glbObj.rep_bank_lst.clear();
        this.glbObj.rep_accnt_lst.clear();
        this.glbObj.rep_usrid_lst.clear();
        this.glbObj.rep_secdesc_lst.clear();
        this.glbObj.rep_buyee_lst.clear();
        this.glbObj.rep_vendor_lst.clear();
        this.glbObj.center_lst.clear();
        this.glbObj.payer_name_lst.clear();
        this.glbObj.dep_status_lst.clear();
        this.glbObj.rep_ifsc_lst.clear();
        this.glbObj.fbank_name_lst.clear();
        this.glbObj.faccount_lst.clear();
        this.glbObj.fifsc_lst.clear();
        this.glbObj.tbank_lst.clear();
        this.glbObj.taccnt_lst.clear();
        this.glbObj.tifsc_lst.clear();
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        this.tlvObj.setTlv(37);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code == 2) {
            check = false;
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
        } else if (this.log.error_code != 0) {
            check = false;
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
        } else {
            if (this.glbObj.particular.equals("admfee")) {
                this.glbObj.enttype_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^4_enttype");
                this.glbObj.remark_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^2_remark");
                this.glbObj.trns_date_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^1_transdate");
                this.glbObj.amnt_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^3_feespaid");
                if (this.glbObj.cash_book_report) {
                    this.glbObj.rep_usrid_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^5_usrid");
                    this.glbObj.rep_secdesc_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^6_secdesc");
                }
                if (!this.glbObj.cash_book_report) {
                    this.glbObj.mode_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^5_mode");
                    this.glbObj.rep_bank_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^6_bankname");
                    this.glbObj.rep_accnt_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^7_accountno");
                    this.glbObj.rep_usrid_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^8_usrid");
                    this.glbObj.rep_secdesc_lst = this.log.GetValuesFromTbl("tstudfeestranstbl^9_secdesc");
                }
            } else if (this.glbObj.particular.equals("trnspfee") || this.glbObj.particular.equals("hostelfee")) {
                this.glbObj.enttype_lst = this.log.GetValuesFromTbl("tstudotherfeestranstbl^4_enttype");
                this.glbObj.remark_lst = this.log.GetValuesFromTbl("tstudotherfeestranstbl^2_remark");
                this.glbObj.trns_date_lst = this.log.GetValuesFromTbl("tstudotherfeestranstbl^1_transdate");
                this.glbObj.amnt_lst = this.log.GetValuesFromTbl("tstudotherfeestranstbl^3_feespaid");
                this.glbObj.rep_usrid_lst = this.log.GetValuesFromTbl("tstudotherfeestranstbl^8_usrid");
                this.glbObj.rep_secdesc_lst = this.log.GetValuesFromTbl("tstudotherfeestranstbl^9_secdesc");
                if (!this.glbObj.cash_book_report) {
                    this.glbObj.mode_lst = this.log.GetValuesFromTbl("tstudotherfeestranstbl^5_mode");
                    this.glbObj.rep_bank_lst = this.log.GetValuesFromTbl("tstudotherfeestranstbl^6_bankname");
                    this.glbObj.rep_accnt_lst = this.log.GetValuesFromTbl("tstudotherfeestranstbl^7_accountno");
                }
            } else if (this.glbObj.particular.equals("miscfee")) {
                this.glbObj.enttype_lst = this.log.GetValuesFromTbl("tmiscfeetranstbl^4_enttype");
                this.glbObj.remark_lst = this.log.GetValuesFromTbl("tmiscfeetranstbl^2_remark");
                this.glbObj.trns_date_lst = this.log.GetValuesFromTbl("tmiscfeetranstbl^1_transdate");
                this.glbObj.amnt_lst = this.log.GetValuesFromTbl("tmiscfeetranstbl^3_feespaid");
                this.glbObj.rep_usrid_lst = this.log.GetValuesFromTbl("tmiscfeetranstbl^8_usrid");
                this.glbObj.rep_secdesc_lst = this.log.GetValuesFromTbl("tmiscfeetranstbl^9_secdesc");
                if (!this.glbObj.cash_book_report) {
                    this.glbObj.mode_lst = this.log.GetValuesFromTbl("tmiscfeetranstbl^5_mode");
                    this.glbObj.rep_bank_lst = this.log.GetValuesFromTbl("tmiscfeetranstbl^6_bankname");
                    this.glbObj.rep_accnt_lst = this.log.GetValuesFromTbl("tmiscfeetranstbl^7_accountno");
                }
            } else if (this.glbObj.particular.equals("indrctexpns") || this.glbObj.particular.equals("drctexpns") || this.glbObj.particular.equals("pettyexpns")) {
                this.glbObj.enttype_lst = this.log.GetValuesFromTbl("texpnstranstbl^4_enttype");
                this.glbObj.remark_lst = this.log.GetValuesFromTbl("texpnstranstbl^2_description");
                this.glbObj.trns_date_lst = this.log.GetValuesFromTbl("texpnstranstbl^1_tdysdate");
                this.glbObj.amnt_lst = this.log.GetValuesFromTbl("texpnstranstbl^3_amount");
                this.glbObj.rep_buyee_lst = this.log.GetValuesFromTbl("texpnstranstbl^5_buyname");
                this.glbObj.rep_vendor_lst = this.log.GetValuesFromTbl("texpnstranstbl^6_vendorname");
                if (!this.glbObj.cash_book_report) {
                    this.glbObj.mode_lst = this.log.GetValuesFromTbl("texpnstranstbl^5_mode");
                    this.glbObj.rep_bank_lst = this.log.GetValuesFromTbl("texpnstranstbl^6_bankname");
                    this.glbObj.rep_accnt_lst = this.log.GetValuesFromTbl("texpnstranstbl^7_accountno");
                }
            } else if (this.glbObj.particular.equals("payroll")) {
                this.glbObj.enttype_lst = this.log.GetValuesFromTbl("tsalarytbl^4_enttype");
                this.glbObj.remark_lst = this.log.GetValuesFromTbl("tsalarytbl^2_remark");
                this.glbObj.trns_date_lst = this.log.GetValuesFromTbl("tsalarytbl^1_reldate");
                this.glbObj.amnt_lst = this.log.GetValuesFromTbl("tsalarytbl^3_amount");
                if (!this.glbObj.cash_book_report) {
                    this.glbObj.mode_lst = this.log.GetValuesFromTbl("tsalarytbl^5_mode");
                    this.glbObj.rep_bank_lst = this.log.GetValuesFromTbl("tsalarytbl^6_bankname");
                    this.glbObj.rep_accnt_lst = this.log.GetValuesFromTbl("tsalarytbl^7_accountno");
                }
            } else if (this.glbObj.particular.equals("cashtransfer")) {
                this.glbObj.trns_date_lst = this.log.GetValuesFromTbl("tdepositetbl^1_tdysdate");
                this.glbObj.remark_lst = this.log.GetValuesFromTbl("tdepositetbl^2_description");
                this.glbObj.amnt_lst = this.log.GetValuesFromTbl("tdepositetbl^3_amount");
                this.glbObj.center_lst = this.log.GetValuesFromTbl("tdepositetbl^4_center");
                this.glbObj.enttype_lst = this.log.GetValuesFromTbl("tdepositetbl^5_enttype");
                this.glbObj.cby_lst = this.log.GetValuesFromTbl("tdepositetbl^6_cby");
                this.glbObj.payer_name_lst = this.log.GetValuesFromTbl("tdepositetbl^7_payername");
                this.glbObj.dep_status_lst = this.log.GetValuesFromTbl("tdepositetbl^8_status");
                if (!this.glbObj.cash_book_report) {
                    this.glbObj.mode_lst = this.log.GetValuesFromTbl("tdepositetbl^9_mode");
                    this.glbObj.rep_bank_lst = this.log.GetValuesFromTbl("tdepositetbl^9a_bankname");
                    this.glbObj.rep_accnt_lst = this.log.GetValuesFromTbl("tdepositetbl^9b_accountno");
                    this.glbObj.rep_ifsc_lst = this.log.GetValuesFromTbl("tdepositetbl^9c_ifsccode");
                    this.glbObj.fbank_name_lst = this.log.GetValuesFromTbl("tdepositetbl^9d_fbankname");
                    this.glbObj.faccount_lst = this.log.GetValuesFromTbl("tdepositetbl^9e_faccountno");
                    this.glbObj.fifsc_lst = this.log.GetValuesFromTbl("tdepositetbl^9f_fifsccode");
                    this.glbObj.tbank_lst = this.log.GetValuesFromTbl("tdepositetbl^9g_tbankname");
                    this.glbObj.taccnt_lst = this.log.GetValuesFromTbl("tdepositetbl^9h_taccountno");
                    this.glbObj.tifsc_lst = this.log.GetValuesFromTbl("tdepositetbl^9i_tifsccode");
                }
            }
            check = true;
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_student_info_student_usrid_reports() throws IOException {
        this.glbObj.rep_username_lst.clear();
        this.glbObj.rep_contact_no_lst.clear();
        boolean check = false;
        int j = 0;
        String tlvstr = "";
        for (j = 0; j < this.glbObj.rep_usrid_lst.size(); ++j) {
            this.glbObj.report_stud_usrid = this.glbObj.rep_usrid_lst.get(j).toString();
            this.dblib.pme.delim = "\\^";
            this.log.delim = "\\^";
            this.tlvObj.setTlv(38);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
                check = false;
                continue;
            }
            this.glbObj.rep_username_lst.add(this.log.GetValuesFromTbl("tusertbl^1_usrname").get(0).toString());
            this.glbObj.rep_contact_no_lst.add(this.log.GetValuesFromTbl("tusertbl^9_contactno").get(0).toString());
            this.dblib.PostDBExec(this.log.rcv_buff);
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
            check = true;
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return check;
    }

    public boolean get_treceipttbl_details() throws IOException {
        System.out.println("In plugin");
        boolean check = false;
        if (this.glbObj.get_all_tags) {
            this.tlvObj.setTlv(39);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.etid_list = this.log.GetValuesFromTbl("texpnstagtbl.1_etid");
                this.glbObj.et_amount_lst = this.log.GetValuesFromTbl("texpnstagtbl.2_tamount");
                this.glbObj.et_date_lst = this.log.GetValuesFromTbl("texpnstagtbl.3_tdate");
                this.glbObj.et_via_lst = this.log.GetValuesFromTbl("texpnstagtbl.4_tvia");
                this.glbObj.et_bank_lst = this.log.GetValuesFromTbl("texpnstagtbl.5_tbank");
                this.glbObj.et_account_lst = this.log.GetValuesFromTbl("texpnstagtbl.6_tacntno");
                this.glbObj.et_ifsc_lst = this.log.GetValuesFromTbl("texpnstagtbl.7_tifsc");
                this.glbObj.et_petty_lst = this.log.GetValuesFromTbl("texpnstagtbl.8_petty");
                this.glbObj.et_purpose_lst = this.log.GetValuesFromTbl("texpnstagtbl.9_purpose");
                check = true;
            }
        } else if (this.glbObj.get_sum_tags) {
            String tlvstr = "";
            int i = 0;
            for (i = 0; i < this.glbObj.rcptid_list.size(); ++i) {
                this.glbObj.rcptid_cur = this.glbObj.rcptid_list.get(i).toString();
                this.tlvObj.setTlv(39);
                tlvstr = i > 0 ? tlvstr + "~" + this.glbObj.tlvStr : tlvstr + this.glbObj.tlvStr;
            }
            this.glbObj.tlvStr = "";
            this.glbObj.tlvStr = tlvstr;
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.sum_tags_lst = this.log.GetValuesFromTbl("texpnstagtbl.1_sum(tamount)");
            }
        } else {
            this.tlvObj.setTlv(39);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.rcptid_list = this.log.GetValuesFromTbl("tdepositetbl.1_dpid");
                this.glbObj.trans_date_list = this.log.GetValuesFromTbl("tdepositetbl.9f_tdysdate");
                this.glbObj.feespaid_list = this.log.GetValuesFromTbl("tdepositetbl.2_amount");
                this.glbObj.mode_list = this.log.GetValuesFromTbl("tdepositetbl.6_mode");
                this.glbObj.accno_list = this.log.GetValuesFromTbl("tdepositetbl.9d_accountno");
                this.glbObj.desc_list = this.log.GetValuesFromTbl("tdepositetbl.3_description");
                this.glbObj.payername_list = this.log.GetValuesFromTbl("tdepositetbl.9t_payername");
                this.glbObj.enttype_list = this.log.GetValuesFromTbl("tdepositetbl.9j_enttype");
                this.glbObj.cby_lst = this.log.GetValuesFromTbl("tdepositetbl.9o_cby");
                this.glbObj.c_stat_lst = this.log.GetValuesFromTbl("tdepositetbl.9h_status");
                this.glbObj.c_epch_lst = this.log.GetValuesFromTbl("tdepositetbl.9k_epch");
                this.glbObj.c_bank_name_lst = this.log.GetValuesFromTbl("tdepositetbl.9_bankname");
                this.glbObj.c_ifsc_lst = this.log.GetValuesFromTbl("tdepositetbl.9e_ifsccode");
                check = true;
            }
        }
        return check;
    }

    public boolean get_total_expense_amount_for_the_withdrawl_report() throws IOException {
        boolean check = false;
        if (this.glbObj.get_sum_rev_amount) {
            this.dblib.pme.delim = "\\^";
            this.log.delim = "\\^";
            this.tlvObj.setTlv(40);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            } else {
                this.glbObj.sum_rev_amount = this.log.GetValuesFromTbl("texpnstranstbl^1_sum(amount)").get(0).toString();
                check = true;
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            }
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
        } else if (this.glbObj.total_tagged_amount) {
            this.dblib.pme.delim = "\\^";
            this.log.delim = "\\^";
            this.tlvObj.setTlv(40);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            } else {
                this.glbObj.total_tag_amount = this.log.GetValuesFromTbl("texpnstagtbl^1_sum(tamount)").get(0).toString();
                check = true;
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            }
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
        } else if (this.glbObj.total_spent_tag) {
            this.dblib.pme.delim = "\\^";
            this.log.delim = "\\^";
            this.tlvObj.setTlv(40);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            } else {
                this.glbObj.spent_tag_amount = this.log.GetValuesFromTbl("texpnstranstbl^1_sum(amount)").get(0).toString();
                check = true;
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            }
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
        } else {
            if (this.glbObj.get_expns_amount_sum) {
                if (this.glbObj.w_entry_type.equals("0")) {
                    this.glbObj.sum_expense_lst_debit.clear();
                }
                if (this.glbObj.w_entry_type.equals("1")) {
                    this.glbObj.sum_expense_lst_credit.clear();
                }
            }
            String tlvstr = "";
            int i = 0;
            for (i = 0; i < this.glbObj.w_expnse_etid_lst.size(); ++i) {
                this.glbObj.et_id_cur = this.glbObj.w_expnse_etid_lst.get(i).toString();
                this.dblib.pme.delim = "\\^";
                this.log.delim = "\\^";
                this.tlvObj.setTlv(40);
                tlvstr = i > 0 ? tlvstr + "~" + this.glbObj.tlvStr : tlvstr + this.glbObj.tlvStr;
            }
            this.glbObj.tlvStr = "";
            this.glbObj.tlvStr = tlvstr;
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            } else {
                if (this.glbObj.get_expns_amount_sum) {
                    if (this.glbObj.w_entry_type.equals("0")) {
                        this.glbObj.sum_expense_lst_debit = this.log.GetValuesFromTbl("texpnstranstbl^1_sum(amount)");
                        System.out.println("==this.glbObj.sum_expense_lst_debit++++" + this.glbObj.sum_expense_lst_debit);
                    }
                    if (this.glbObj.w_entry_type.equals("1")) {
                        this.glbObj.sum_expense_lst_credit = this.log.GetValuesFromTbl("texpnstranstbl^1_sum(amount)");
                        System.out.println("===this.glbObj.sum_expense_lst_credit+++" + this.glbObj.sum_expense_lst_credit);
                    }
                }
                check = true;
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            }
        }
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        return check;
    }

    public boolean load_all_institution_batches() throws IOException {
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        boolean check = false;
        this.tlvObj.setTlv(41);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.instbatchid_lst = this.log.GetValuesFromTbl("tinstbatchtbl.1_instbatchid");
            this.glbObj.instbatch_lst = this.log.GetValuesFromTbl("tinstbatchtbl.2_instbatch");
            this.glbObj.get_academic_year_inst_batch = true;
            for (int i = 0; i < this.glbObj.instbatchid_lst.size(); ++i) {
                List academic_year_batchis_lst = new ArrayList();
                this.glbObj.instbatchid_cur_get = this.glbObj.instbatchid_lst.get(i).toString();
                this.tlvObj.setTlv(41);
                c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                this.do_all_network();
                if (this.log.error_code == 2) {
                    this.log.error_code = 0;
                    this.glbObj.instbatchid_years_map.put(this.glbObj.instbatchid_cur_get, null);
                    continue;
                }
                if (this.log.error_code != 0) {
                    check = false;
                } else {
                    academic_year_batchis_lst = this.log.GetValuesFromTbl("tinstclasstbl.1_distinct(classid,batchid)");
                }
                this.glbObj.instbatchid_years_map.put(this.glbObj.instbatchid_cur_get, academic_year_batchis_lst);
            }
            this.glbObj.get_academic_year_inst_batch = false;
        }
        return check;
    }

    public boolean get_buyee_and_vendor_report() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            if (this.glbObj.get_buyee) {
                // empty if block
            }
            if (this.glbObj.get_vendor) {
                // empty if block
            }
            System.out.println("in buyee true");
            this.tlvObj.setTlv(40);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 2) {
                if (this.glbObj.get_buyee) {
                    this.glbObj.buyeeid_lst = null;
                }
                if (this.glbObj.get_vendor) {
                    this.glbObj.vendorid_lst = null;
                }
                check = false;
            } else if (this.log.error_code != 0) {
                check = false;
            } else {
                if (this.glbObj.get_buyee) {
                    this.glbObj.buyeeid_lst = this.log.GetValuesFromTbl("texpensebuyeetbl.1_buyeeid");
                }
                if (this.glbObj.get_vendor) {
                    this.glbObj.vendorid_lst = this.log.GetValuesFromTbl("texpensevendortbl.1_vandorid");
                }
                check = true;
            }
            return check;
        }
        if (!this.glbObj.ids_only) {
            List expense_person_id_lst = null;
            if (this.glbObj.get_buyee) {
                this.glbObj.buyeename_lst.clear();
                expense_person_id_lst = this.glbObj.buyeeid_lst;
            }
            if (this.glbObj.get_vendor) {
                this.glbObj.vendorname_lst.clear();
                expense_person_id_lst = this.glbObj.vendorid_lst;
            }
            for (int m = 0; m < expense_person_id_lst.size(); ++m) {
                this.glbObj.expense_person_id = expense_person_id_lst.get(m).toString();
                this.tlvObj.setTlv(40);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code == 2) {
                    check = false;
                    continue;
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                if (this.glbObj.get_buyee) {
                    this.glbObj.buyeename_lst.add(this.log.GetValuesFromTbl("texpensebuyeetbl.2_buyname").get(0).toString());
                }
                if (this.glbObj.get_vendor) {
                    this.glbObj.vendorname_lst.add(this.log.GetValuesFromTbl("texpensevendortbl.2_vendorname").get(0).toString());
                }
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean get_student_ids_from_server_for_particular_section_opt() throws IOException {
        boolean ret = false;
        if (this.glbObj.oby_aplha) {
            this.log.delim = "\\^";
            this.dblib.pme.delim = "\\^";
        }
        this.tlvObj.setTlv(42);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            if (this.glbObj.oby_aplha) {
                this.glbObj.studids_lst = this.log.GetValuesFromTbl("tstudenttbl,trueguide.tusertbl^1_studid");
                this.glbObj.remarks_lst = this.log.GetValuesFromTbl("tstudenttbl,trueguide.tusertbl^2_remark");
                this.log.delim = "\\.";
                this.dblib.pme.delim = "\\.";
            } else {
                this.glbObj.remarks_lst = this.log.GetValuesFromTbl("tstudenttbl.2_remark");
                this.glbObj.studids_lst = this.log.GetValuesFromTbl("tstudenttbl.1_studid");
            }
            ret = true;
        }
        this.log.delim = "\\.";
        this.dblib.pme.delim = "\\.";
        return ret;
    }

    public boolean get_studentids_userids_for_particular_section() throws IOException {
        this.glbObj.stud_userids_lst.clear();
        this.glbObj.stud_rollno_lst.clear();
        this.glbObj.stud_status_lst.clear();
        this.glbObj.stud_year_lst.clear();
        this.glbObj.subdivision_lst.clear();
        this.glbObj.batch_lst.clear();
        this.glbObj.reason_lst.clear();
        this.glbObj.passing_year_lst.clear();
        this.glbObj.adv_pay_lst.clear();
        this.glbObj.adm_status.clear();
        this.glbObj.afps_lst.clear();
        boolean ret = false;
        int i = 0;
        for (i = 0; i < this.glbObj.studids_lst.size(); ++i) {
            this.glbObj.studid_search = this.glbObj.studids_lst.get(i).toString();
            this.tlvObj.setTlv(43);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                ret = false;
                continue;
            }
            this.glbObj.stud_userids_lst.add(this.log.GetValuesFromTbl("tstudenttbl.2_usrid").get(0).toString());
            this.glbObj.stud_rollno_lst.add(this.log.GetValuesFromTbl("tstudenttbl.3_rollno").get(0).toString());
            this.glbObj.stud_status_lst.add(this.log.GetValuesFromTbl("tstudenttbl.4_status").get(0).toString());
            this.glbObj.stud_year_lst.add(this.log.GetValuesFromTbl("tstudenttbl.8_year").get(0).toString());
            this.glbObj.subdivision_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9a_subdiv").get(0).toString());
            this.glbObj.batch_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9e_batch").get(0).toString());
            this.glbObj.passing_year_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9f_passingyear").get(0).toString());
            this.glbObj.reason_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9h_reason").get(0).toString());
            this.glbObj.adv_pay_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9i_advpay").get(0).toString());
            this.glbObj.adm_status.add(this.log.GetValuesFromTbl("tstudenttbl.9j_admstat").get(0).toString());
            this.glbObj.afps_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9k_afps").get(0).toString());
            this.log.println(" this.glbObj.stud_year_lst=====>>" + this.glbObj.stud_year_lst);
            this.dblib.PostDBExec(this.log.rcv_buff);
            ret = true;
        }
        return ret;
    }

    public boolean select_category_details_userid() throws IOException {
        boolean ret = false;
        this.glbObj.first_name_lst = new ArrayList();
        this.glbObj.father_name_lst = new ArrayList();
        this.glbObj.mother_name_lst = new ArrayList();
        this.glbObj.adm_form_rollno_lst = new ArrayList();
        for (int x = 0; x < this.glbObj.stud_userids_lst.size(); ++x) {
            this.glbObj.adm_form_userid = this.glbObj.stud_userids_lst.get(x).toString();
            this.tlvObj.setTlv(44);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code == 2) {
                this.log.error_code = 0;
                continue;
            }
            if (this.log.error_code != 0) {
                ret = false;
                continue;
            }
            this.glbObj.first_name_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.4_fname").get(0).toString());
            this.glbObj.father_name_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9z_fathername").get(0).toString());
            this.glbObj.mother_name_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9ab_mothername").get(0).toString());
            this.glbObj.adm_form_rollno_lst.add(this.glbObj.stud_rollno_lst.get(x).toString());
            this.dblib.PostDBExec(this.log.rcv_buff);
            ret = true;
        }
        return ret;
    }

    public boolean get_reserv_cat_names() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(45);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            this.log.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                if (this.glbObj.reserved_cat) {
                    this.glbObj.rsvcatid_lst = this.log.GetValuesFromTbl("preservcattbl.1_rsvcatid");
                }
                if (this.glbObj.get_religion) {
                    this.glbObj.relid_lst = this.log.GetValuesFromTbl("preligiontbl.1_relid");
                }
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            boolean ca;
            boolean c;
            int i;
            if (this.glbObj.reserved_cat) {
                this.glbObj.rsvcat_name_lst.clear();
                for (i = 0; i < this.glbObj.rsvcatid_lst.size(); ++i) {
                    this.glbObj.rsvcatid_cur = this.glbObj.rsvcatid_lst.get(i).toString();
                    this.tlvObj.setTlv(45);
                    c = this.log.check_startup_credentials(this.glbObj.req_type);
                    if (!c) {
                        return false;
                    }
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    this.log.println("In Library" + this.log.error_code);
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.rsvcat_name_lst.add(this.log.GetValuesFromTbl("preservcattbl.1_rsvcat").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.get_religion) {
                this.glbObj.rel_name_lst.clear();
                for (i = 0; i < this.glbObj.relid_lst.size(); ++i) {
                    this.glbObj.relid_cur = this.glbObj.relid_lst.get(i).toString();
                    this.tlvObj.setTlv(45);
                    c = this.log.check_startup_credentials(this.glbObj.req_type);
                    if (!c) {
                        return false;
                    }
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    this.log.println("In Library" + this.log.error_code);
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.rel_name_lst.add(this.log.GetValuesFromTbl("preligiontbl.1_religion").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
        }
        return check;
    }

    public boolean get_caste_name() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(46);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            this.log.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.caste_id_lst = this.log.GetValuesFromTbl("pcastetbl.1_casteid");
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.caste_name_lst.clear();
            for (int i = 0; i < this.glbObj.caste_id_lst.size(); ++i) {
                this.glbObj.castid_cur = this.glbObj.caste_id_lst.get(i).toString();
                this.tlvObj.setTlv(46);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                this.log.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.caste_name_lst.add(this.log.GetValuesFromTbl("pcastetbl.2_caste").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean get_occptn() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(47);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            this.log.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.occup_id_lst = this.log.GetValuesFromTbl("poccupationtbl.1_occupid");
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.occup_lst.clear();
            for (int i = 0; i < this.glbObj.occup_id_lst.size(); ++i) {
                this.glbObj.occup_id_cur = this.glbObj.occup_id_lst.get(i).toString();
                this.tlvObj.setTlv(47);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                this.log.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.occup_lst.add(this.log.GetValuesFromTbl("poccupationtbl.2_occupation").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean get_sub_caste_name() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(48);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            this.log.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.sub_caste_id_lst = this.log.GetValuesFromTbl("psubcastetbl.1_subcasteid");
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.sub_caste_name_lst.clear();
            for (int i = 0; i < this.glbObj.sub_caste_id_lst.size(); ++i) {
                this.glbObj.subcastid_cur = this.glbObj.sub_caste_id_lst.get(i).toString();
                this.tlvObj.setTlv(48);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                this.log.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.sub_caste_name_lst.add(this.log.GetValuesFromTbl("psubcastetbl.1_subcaste").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean get_student_details_from_userid_admission_form() throws IOException {
        boolean check = false;
        this.glbObj.first_name_lst = new ArrayList();
        this.glbObj.father_name_lst = new ArrayList();
        this.glbObj.mother_name_lst = new ArrayList();
        this.glbObj.gender_lst = new ArrayList();
        this.glbObj.is_physical_handi_lst = new ArrayList();
        this.glbObj.caste_lst = new ArrayList();
        this.glbObj.reserved_category_lst = new ArrayList();
        this.glbObj.sslc_year_passing_lst = new ArrayList();
        this.glbObj.sslc_month_passing_lst = new ArrayList();
        this.glbObj.sslc_reg_no_lst = new ArrayList();
        this.glbObj.pu_one_sub_part1_lst = new ArrayList();
        this.glbObj.pu_one_comb_lst = new ArrayList();
        this.glbObj.pu_one_medium_lst = new ArrayList();
        this.glbObj.pu_one_instcode_lst = new ArrayList();
        this.glbObj.pu_two_reg_lst = new ArrayList();
        this.glbObj.pu_two_sub_part1_lst = new ArrayList();
        this.glbObj.pu_two_comb_lst = new ArrayList();
        this.glbObj.pu_one_sub_part2_lst = new ArrayList();
        this.glbObj.pu_two_sub_part2_lst = new ArrayList();
        this.glbObj.pu_one_do_adm_lst = new ArrayList();
        this.glbObj.pu_two_do_adm_lst = new ArrayList();
        this.glbObj.pu_two_instcode_lst = new ArrayList();
        this.glbObj.pu_two_medium_lst = new ArrayList();
        this.glbObj.puonestream_lst = new ArrayList();
        this.glbObj.putwostream_lst = new ArrayList();
        for (int i = 0; i < this.glbObj.stud_userids_lst.size(); ++i) {
            this.glbObj.adm_form_userid = this.glbObj.stud_userids_lst.get(i).toString();
            this.tlvObj.setTlv(49);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            this.log.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.glbObj.first_name_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.4_fname").get(0).toString());
            this.glbObj.gender_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.7_gender").get(0).toString());
            this.glbObj.is_physical_handi_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9i_isphyhandi").get(0).toString());
            this.glbObj.caste_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9l_caste").get(0).toString());
            this.glbObj.reserved_category_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9n_rescatg").get(0).toString());
            this.glbObj.father_name_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9z_fathername").get(0).toString());
            this.glbObj.mother_name_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9ab_mothername").get(0).toString());
            this.glbObj.sslc_year_passing_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9af_sslcyearpassing").get(0).toString());
            this.glbObj.sslc_month_passing_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9ag_sslcmonthpassing").get(0).toString());
            this.glbObj.sslc_reg_no_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9ai_sslcreg").get(0).toString());
            this.glbObj.pu_one_sub_part1_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9ak_puonesubp1").get(0).toString());
            this.glbObj.pu_one_comb_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9al_puonecomb").get(0).toString());
            this.glbObj.pu_one_medium_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9am_puonemedium").get(0).toString());
            this.glbObj.pu_one_instcode_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9an_puoneinstcode").get(0).toString());
            this.glbObj.pu_two_reg_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9ao_putworeg").get(0).toString());
            this.glbObj.pu_two_sub_part1_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9ap_putwosubp1").get(0).toString());
            this.glbObj.pu_two_comb_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9aq_putwocomb").get(0).toString());
            this.glbObj.pu_one_sub_part2_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9aac_puonesubp2").get(0).toString());
            this.glbObj.pu_two_sub_part2_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9aad_putwosubp2").get(0).toString());
            this.glbObj.pu_one_do_adm_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9aae_puonedoadm").get(0).toString());
            this.glbObj.pu_two_do_adm_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9aaf_putwodoadm").get(0).toString());
            this.glbObj.pu_two_instcode_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9aag_putwoinstcode").get(0).toString());
            this.glbObj.pu_two_medium_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9aah_putwomedium").get(0).toString());
            this.glbObj.puonestream_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9aaj_puonestream").get(0).toString());
            this.glbObj.putwostream_lst.add(this.log.GetValuesFromTbl("tstudentinformationtbl.9aak_putwostream").get(0).toString());
            check = true;
        }
        return check;
    }

    public boolean get_todays_expenseids_optimized_report() throws IOException {
        boolean c;
        boolean ret = false;
        if (this.glbObj.withdrawl) {
            this.glbObj.w_expn_amnt.clear();
            this.glbObj.w_expn_desc.clear();
            this.glbObj.w_expn_datte.clear();
            this.glbObj.w_expnse_bnkname.clear();
            this.glbObj.w_expnse_acnt_no_lst.clear();
            this.glbObj.w_expnse_ifsccode_lst.clear();
            this.glbObj.w_expnse_etid_lst.clear();
        }
        if (this.glbObj.ids_only) {
            this.dblib.pme.delim = "\\^";
            this.log.delim = "\\^";
            this.tlvObj.setTlv(50);
            c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            } else {
                if (this.glbObj.withdrawl) {
                    this.glbObj.w_expn_amnt = this.log.GetValuesFromTbl("texpnstagtbl^1_tamount");
                    this.glbObj.w_expn_desc = this.log.GetValuesFromTbl("texpnstagtbl^2_purpose");
                    this.glbObj.w_expn_datte = this.log.GetValuesFromTbl("texpnstagtbl^3_tdate");
                    this.glbObj.w_expnse_bnkname = this.log.GetValuesFromTbl("texpnstagtbl^5_tbank");
                    this.glbObj.w_expnse_acnt_no_lst = this.log.GetValuesFromTbl("texpnstagtbl^6_tacntno");
                    this.glbObj.w_expnse_ifsccode_lst = this.log.GetValuesFromTbl("texpnstagtbl^7_tifsc");
                    this.glbObj.w_expnse_etid_lst = this.log.GetValuesFromTbl("texpnstagtbl^4_etid");
                }
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
                this.log.println("glbObj.expn_id_lst..==" + this.glbObj.expn_trans_id_lst);
                ret = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.dblib.pme.delim = "\\^";
            this.log.delim = "\\^";
            this.tlvObj.setTlv(50);
            c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                ret = false;
            } else {
                this.glbObj.expn_trans_id_lst = this.log.GetValuesFromTbl("texpnstranstbl^1_expnstransid");
                this.glbObj.expn_amnt = this.log.GetValuesFromTbl("texpnstranstbl^2_amount");
                this.glbObj.expn_desc = this.log.GetValuesFromTbl("texpnstranstbl^3_description");
                this.glbObj.expn_datte = this.log.GetValuesFromTbl("texpnstranstbl^4_tdysdate");
                this.glbObj.expnse_type_lst = this.log.GetValuesFromTbl("texpnstranstbl^5_type");
                this.glbObj.expnse_mode_lst = this.log.GetValuesFromTbl("texpnstranstbl^6_mode");
                this.glbObj.expnse_chkno = this.log.GetValuesFromTbl("texpnstranstbl^7_checkno");
                this.glbObj.expnse_chkdt = this.log.GetValuesFromTbl("texpnstranstbl^8_checkdate");
                this.glbObj.expnse_bnkname = this.log.GetValuesFromTbl("texpnstranstbl^9_bankname");
                this.glbObj.expnse_ddno_lst = this.log.GetValuesFromTbl("texpnstranstbl^9a_ddno");
                this.glbObj.expnse_ddate_lst = this.log.GetValuesFromTbl("texpnstranstbl^9b_dddate");
                this.glbObj.expnse_acnt_no_lst = this.log.GetValuesFromTbl("texpnstranstbl^9c_accountno");
                this.glbObj.expnse_ifsccode_lst = this.log.GetValuesFromTbl("texpnstranstbl^9d_ifsccode");
                this.glbObj.expnse_entry_type_lst = this.log.GetValuesFromTbl("texpnstranstbl^9j_enttype");
                this.glbObj.expnse_payee_lst = this.log.GetValuesFromTbl("texpnstranstbl^9f_buyname");
                this.glbObj.expnse_vendor_lst = this.log.GetValuesFromTbl("texpnstranstbl^9h_vendorname");
                this.glbObj.expnse_payee_id_lst = this.log.GetValuesFromTbl("texpnstranstbl^9e_buyeeid");
                this.glbObj.expnse_vendor_id_lst = this.log.GetValuesFromTbl("texpnstranstbl^9g_vandorid");
                this.glbObj.expnse_tds_lst = this.log.GetValuesFromTbl("texpnstranstbl^9k_extds");
                this.dblib.PostDBExec(this.log.rcv_buff);
                ret = true;
            }
            this.dblib.pme.delim = "\\.";
            this.log.delim = "\\.";
        }
        return ret;
    }

    public String get_2d_bar(List lst1, List lst2, String label, String lable1, String lable2, int ht) {
        return this.get_2d_bar(lst1, lst2, label, lable1, lable2, "", "", ht);
    }

    public String get_2d_bar(List lst1, List lst2, String label, String lable1, String lable2, String fn, String div, int ht) {
        String dstuf = "";
        int sz = lst1.size();
        int i = 0;
        if (fn.isEmpty()) {
            fn = "drawMultSeries";
        }
        if (div.isEmpty()) {
            div = "chart_div";
        }
        for (i = 0; i < sz; ++i) {
            dstuf = dstuf + "        ['" + lst1.get(i).toString() + "', " + lst2.get(i).toString() + ",'" + this.getGColor(i) + "'],\n";
        }
        String js = "<script type=\"text/javascript\" src=\"https://www.gstatic.com/charts/loader.js\"></script>\n    <script type=\"text/javascript\">\n google.charts.load('current', {packages: ['corechart', 'bar']});\ngoogle.charts.setOnLoadCallback(" + fn + ");\n" + "\n" + "function " + fn + "() {\n" + "      var data = google.visualization.arrayToDataTable([\n" + "        [ '" + lable1 + "', '" + lable2 + "',{ role: 'style' }],\n" + dstuf + "      ]);\n" + "\n" + "      var options = {\n" + "        title: '" + label + "',\n" + "        chartArea: {width: '50%'},\n" + "height:" + ht + ",\n" + "        hAxis: {\n" + "          title: '" + lable1 + "',\n" + "          minValue: 0\n" + "        },\n" + "        vAxis: {\n" + "          title: '" + lable2 + "'\n" + "        }\n" + "      };\n" + "\n" + "   var view = new google.visualization.DataView(data);\n" + "      view.setColumns([0, 1,\n" + "                       { calc: \"stringify\",\n" + "                         sourceColumn: 1,\n" + "                         type: \"string\",\n" + "                         role: \"annotation\" },\n" + "                       2]);" + "      var chart = new google.visualization.BarChart(document.getElementById('" + div + "'));\n" + "      chart.draw(view, options);\n" + "    } </script>";
        return js;
    }

    private String getGColor(int i) {
        String color = "silver";
        Random obj = new Random();
        int rand_num = obj.nextInt(0x1000000);
        color = String.format("#%06x", rand_num);
        return color;
    }
}

