/*
 * Decompiled with CFR 0.152.
 */
package fileFormatUtil;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class fileFormatUtil {
    public static Map<String, List> createExcelHeader2(String[] hdr, List[] lst) {
        HashMap<String, List> map = null;
        map = new HashMap<String, List>();
        int i = 0;
        for (i = 0; i < hdr.length; ++i) {
            map.put(hdr[i], lst[i]);
        }
        return map;
    }

    public static Map<String, List> createExcelHeader(String[] hdr) {
        HashMap<String, List> map = null;
        map = new HashMap<String, List>();
        int i = 0;
        for (i = 0; i < hdr.length; ++i) {
            map.put(hdr[i], null);
        }
        return map;
    }

    public static Map<String, List> readExcel(String excelFile) {
        HashMap map = null;
        try {
            Workbook wrk1 = Workbook.getWorkbook(new File(excelFile));
            int sheets = wrk1.getNumberOfSheets();
            Sheet sheet1 = wrk1.getSheet(0);
            int columns = sheet1.getColumns();
            int rows = sheet1.getRows();
            Cell[] row = sheet1.getRow(0);
            int i = 0;
            int j = 0;
            if (row.length <= 0) {
                return map;
            }
            map = new HashMap();
            for (i = 0; i < row.length; ++i) {
                Cell[] column = sheet1.getColumn(i);
                if (column.length <= 1) continue;
                ArrayList<String> ele = new ArrayList<String>();
                for (j = 1; j < column.length; ++j) {
                    ele.add(column[j].getContents().toString());
                }
                map.put(row[i].getContents().toString().toLowerCase(), ele);
            }
            wrk1.close();
        }
        catch (BiffException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String readExcelCell(String excelFile, int x, int y) {
        String val = "";
        try {
            Workbook wrk1 = Workbook.getWorkbook(new File(excelFile));
            int sheets = wrk1.getNumberOfSheets();
            Sheet sheet1 = wrk1.getSheet(0);
            int columns = sheet1.getColumns();
            int rows = sheet1.getRows();
            Cell[] row = sheet1.getRow(x);
            boolean i = false;
            boolean j = false;
            if (row.length <= 0) {
                return "";
            }
            val = row[y].getContents();
            wrk1.close();
        }
        catch (BiffException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return val;
    }

    public static void dumpMap(Map<String, List> readExcelMap) {
        for (Map.Entry<String, List> pair : readExcelMap.entrySet()) {
            System.out.println("key=" + pair.getKey());
            List list = pair.getValue();
            if (list == null) continue;
            int j = 0;
            for (j = 0; j < list.size(); ++j) {
                System.out.println("\t\t val=" + list.get(j).toString());
            }
        }
    }

    public static List getListByName(Map<String, List> readExcelMap, String colName) {
        for (Map.Entry<String, List> pair : readExcelMap.entrySet()) {
            String key = pair.getKey();
            if (!key.trim().equalsIgnoreCase(colName.trim())) continue;
            return pair.getValue();
        }
        return null;
    }

    public static void clearExcelMap(Map<String, List> readExcelMap) {
        for (Map.Entry<String, List> pair : readExcelMap.entrySet()) {
            List list = pair.getValue();
            list.clear();
        }
        readExcelMap.clear();
    }

    private void addCaption(WritableSheet sheet, int column, int row, String s) throws RowsExceededException, WriteException {
        Label label = new Label(column, row, s);
        sheet.addCell(label);
    }

    static void addFloat(WritableSheet sheet, int column, int row, float n) throws WriteException, RowsExceededException {
        WritableCellFormat floatFormat = new WritableCellFormat(NumberFormats.FLOAT);
        Number number = new Number(column, row, n);
        sheet.addCell(number);
    }

    static void addNumber(WritableSheet sheet, int column, int row, Integer integer) throws WriteException, RowsExceededException {
        Number number = new Number(column, row, (double)integer.intValue());
        sheet.addCell(number);
    }

    public static int checkType(String strNum) {
        int ret = -1;
        if (strNum == null) {
            return ret;
        }
        try {
            double d = Double.parseDouble(strNum);
            ret = 1;
        }
        catch (NumberFormatException nfe) {
            ret = -1;
        }
        if (ret == 1) {
            return ret;
        }
        try {
            int d = Integer.parseInt(strNum);
            ret = 2;
        }
        catch (NumberFormatException nfe) {
            ret = -1;
        }
        if (ret == 2) {
            return ret;
        }
        return 3;
    }

    static void addLabel(WritableSheet sheet, int column, int row, String s) throws WriteException, RowsExceededException {
        int r = fileFormatUtil.checkType(s);
        if (r == 3) {
            Label label = new Label(column, row, s);
            sheet.addCell(label);
        } else if (r == 2) {
            fileFormatUtil.addNumber(sheet, column, row, Integer.parseInt(s));
        } else if (r == 1) {
            fileFormatUtil.addFloat(sheet, column, row, Float.parseFloat(s));
        }
    }

    public static boolean exportToExcel(String FileName, Map<String, List> Datamap) throws IOException, WriteException {
        File exlFile = new File(FileName);
        WritableWorkbook writableWorkbook = Workbook.createWorkbook(exlFile);
        WritableSheet writableSheet = writableWorkbook.createSheet("Sheet1", 0);
        Set<String> keySet = Datamap.keySet();
        Object[] toArray = keySet.toArray();
        Iterator<Map.Entry<String, List>> it = Datamap.entrySet().iterator();
        int i = 0;
        int j = 0;
        int k = 0;
        ArrayList<String> tmpRollLst = new ArrayList<String>();
        for (i = 0; i < toArray.length; ++i) {
            if (toArray[i] == null) continue;
            tmpRollLst.add(toArray[i].toString());
        }
        Collections.sort(tmpRollLst);
        i = 0;
        String key = "";
        List list = null;
        for (k = 0; k < tmpRollLst.size(); ++k) {
            key = ((String)tmpRollLst.get(k)).toString();
            System.out.println("key=" + key);
            list = Datamap.get(key);
            fileFormatUtil.addLabel(writableSheet, i, 0, key);
            if (list != null) {
                for (j = 0; j < list.size(); ++j) {
                    fileFormatUtil.addLabel(writableSheet, i, j + 1, list.get(j).toString());
                }
            }
            ++i;
        }
        writableWorkbook.write();
        writableWorkbook.close();
        return true;
    }

    public static void main(String[] args) throws IOException, WriteException {
        HashMap<String, List> readExcelMap = new HashMap<String, List>();
        readExcelMap.put("a", null);
        readExcelMap.put("b", null);
        readExcelMap.put("c", null);
        fileFormatUtil.exportToExcel("d:\\test_wr.xls", readExcelMap);
        String[] hdr = new String[]{"a", "b", "c"};
        Map<String, List> createExcelHeader = fileFormatUtil.createExcelHeader(hdr);
        ArrayList<String> a = createExcelHeader.get("a");
        ArrayList<String> b = createExcelHeader.get("b");
        ArrayList<String> c = createExcelHeader.get("c");
        a = new ArrayList<String>();
        b = new ArrayList<String>();
        c = new ArrayList<String>();
        a.add("1");
        b.add("1");
        c.add("1");
        createExcelHeader.put("a", a);
        createExcelHeader.put("b", b);
        createExcelHeader.put("c", c);
        fileFormatUtil.exportToExcel("d:\\wr.xls", createExcelHeader);
    }
}

