; NSIS Installer Script for DopaNet + Java 8
; Save as installer.nsi and compile with makensis

!include "FileFunc.nsh"
!include "LogicLib.nsh"

Name "DopaNet Installer"
OutFile "DopaNet_Setup.exe"
InstallDir "$PROGRAMFILES\DopaNet"
InstallDirRegKey HKCU "Software\DopaNet" "Install_Dir"
RequestExecutionLevel admin

; Show install details
ShowInstDetails show
ShowUninstDetails show

; Pages
Page directory
Page instfiles

; Variables
Var INSTALL_PATH

Section "Install DopaNet and Java"
    ; Get chosen path
    StrCpy $INSTALL_PATH "$INSTDIR"

    ; Step 1: Install Java
    DetailPrint "Installing Java 8..."
    SetOutPath "$TEMP"
    File "JavaSetup8u421.exe"
    ExecWait '"$TEMP\JavaSetup8u421.exe" '

    ; Step 2: Copy DopaNet folder
    DetailPrint "Copying DopaNet files..."
    SetOutPath "$INSTALL_PATH"
    File /r "DopaNet\*.*"

    ; Step 3: Save install path in registry
    WriteRegStr HKCU "Software\DopaNet" "Install_Dir" "$INSTALL_PATH"

    ; Step 4: Create desktop shortcut to run.bat
    DetailPrint "Creating desktop shortcut..."
    CreateShortCut "$DESKTOP\DopaNet.lnk" "$INSTALL_PATH\run.bat" "" "$INSTALL_PATH\DopaNet.ico" 0 SW_SHOWNORMAL

SectionEnd

Section "Uninstall"
    ; Remove files
    RMDir /r "$INSTDIR"

    ; Remove registry key
    DeleteRegKey HKCU "Software\DopaNet"

    ; Remove shortcut
    Delete "$DESKTOP\DopaNet.lnk"
SectionEnd
