; NSIS Installer Script with Splash Screen for DopaNet + Java 8

!include "FileFunc.nsh"
!include "LogicLib.nsh"
!include "MUI2.nsh"

Name "DopaNet Installer"
OutFile "DopaNet_Setup.exe"
InstallDir "$PROGRAMFILES\DopaNet"
InstallDirRegKey HKCU "Software\DopaNet" "Install_Dir"
RequestExecutionLevel admin

; Show install details
ShowInstDetails show
ShowUninstDetails show

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "DopaNet\DopaNet.ico"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP "DopaNet\DopaNet.png"

; Pages
Page directory
Page instfiles

Var INSTALL_PATH

Function .onInit
    ; Extract splash image to temp
    InitPluginsDir
    File /oname=$PLUGINSDIR\splash.bmp "DopaNet\DopaNet.png"

    ; Show splash for 3 seconds
    splash::show 3000 $PLUGINSDIR\splash.bmp
FunctionEnd

Section "Install DopaNet and Java"
    StrCpy $INSTALL_PATH "$INSTDIR"

    ; Step 1: Install Java with visible GUI
    DetailPrint "Installing Java 8..."
    SetOutPath "$TEMP"
    File "JavaSetup8u421.exe"
    ExecWait '"$TEMP\JavaSetup8u421.exe"'

    ; Step 2: Copy DopaNet files
    DetailPrint "Copying DopaNet files..."
    SetOutPath "$INSTALL_PATH"
    File /r "DopaNet\*.*"

    ; Step 3: Save path in registry
    WriteRegStr HKCU "Software\DopaNet" "Install_Dir" "$INSTALL_PATH"

    ; Step 4: Create shortcut on desktop
    DetailPrint "Creating desktop shortcut..."
    CreateShortCut "$DESKTOP\DopaNet.lnk" "$INSTALL_PATH\run.bat" "" "$INSTALL_PATH\DopaNet.ico" 0 SW_SHOWNORMAL
SectionEnd

Section "Uninstall"
    RMDir /r "$INSTDIR"
    DeleteRegKey HKCU "Software\DopaNet"
    Delete "$DESKTOP\DopaNet.lnk"
SectionEnd
