/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.callback.CallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStore {
    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string2) {
    }

    public static native KeyStore getInstance(String var0) throws KeyStoreException;

    public static native KeyStore getInstance(String var0, String var1) throws KeyStoreException, NoSuchProviderException;

    public static native KeyStore getInstance(String var0, Provider var1) throws KeyStoreException;

    public static final native String getDefaultType();

    public final native Provider getProvider();

    public final native String getType();

    public final native Key getKey(String var1, char[] var2) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException;

    public final native Certificate[] getCertificateChain(String var1) throws KeyStoreException;

    public final native Certificate getCertificate(String var1) throws KeyStoreException;

    public final native Date getCreationDate(String var1) throws KeyStoreException;

    public final native void setKeyEntry(String var1, Key var2, char[] var3, Certificate[] var4) throws KeyStoreException;

    public final native void setKeyEntry(String var1, byte[] var2, Certificate[] var3) throws KeyStoreException;

    public final native void setCertificateEntry(String var1, Certificate var2) throws KeyStoreException;

    public final native void deleteEntry(String var1) throws KeyStoreException;

    public final native Enumeration<String> aliases() throws KeyStoreException;

    public final native boolean containsAlias(String var1) throws KeyStoreException;

    public final native int size() throws KeyStoreException;

    public final native boolean isKeyEntry(String var1) throws KeyStoreException;

    public final native boolean isCertificateEntry(String var1) throws KeyStoreException;

    public final native String getCertificateAlias(Certificate var1) throws KeyStoreException;

    public final native void store(OutputStream var1, char[] var2) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException;

    public final native void store(LoadStoreParameter var1) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException;

    public final native void load(InputStream var1, char[] var2) throws IOException, NoSuchAlgorithmException, CertificateException;

    public final native void load(LoadStoreParameter var1) throws IOException, NoSuchAlgorithmException, CertificateException;

    public final native Entry getEntry(String var1, ProtectionParameter var2) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException;

    public final native void setEntry(String var1, Entry var2, ProtectionParameter var3) throws KeyStoreException;

    public final native boolean entryInstanceOf(String var1, Class<? extends Entry> var2) throws KeyStoreException;

    public static final class TrustedCertificateEntry
    implements Entry {
        public TrustedCertificateEntry(Certificate certificate) {
        }

        public native Certificate getTrustedCertificate();

        public native String toString();
    }

    public static final class SecretKeyEntry
    implements Entry {
        public SecretKeyEntry(SecretKey secretKey) {
        }

        public native SecretKey getSecretKey();

        public native String toString();
    }

    public static final class PrivateKeyEntry
    implements Entry {
        public PrivateKeyEntry(PrivateKey privateKey, Certificate[] certificateArray) {
        }

        public native PrivateKey getPrivateKey();

        public native Certificate[] getCertificateChain();

        public native Certificate getCertificate();

        public native String toString();
    }

    public static interface ProtectionParameter {
    }

    public static class PasswordProtection
    implements ProtectionParameter,
    Destroyable {
        public PasswordProtection(char[] cArray) {
        }

        public synchronized native char[] getPassword();

        public synchronized native void destroy() throws DestroyFailedException;

        public synchronized native boolean isDestroyed();
    }

    public static interface LoadStoreParameter {
        public ProtectionParameter getProtectionParameter();
    }

    public static interface Entry {
    }

    public static class CallbackHandlerProtection
    implements ProtectionParameter {
        public CallbackHandlerProtection(CallbackHandler callbackHandler) {
        }

        public native CallbackHandler getCallbackHandler();
    }

    public static abstract class Builder {
        protected Builder() {
        }

        public abstract KeyStore getKeyStore() throws KeyStoreException;

        public abstract ProtectionParameter getProtectionParameter(String var1) throws KeyStoreException;

        public static native Builder newInstance(KeyStore var0, ProtectionParameter var1);

        public static native Builder newInstance(String var0, Provider var1, File var2, ProtectionParameter var3);

        public static native Builder newInstance(String var0, Provider var1, ProtectionParameter var2);
    }
}

