/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.BaseColumns;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class MediaStore {
    public static final String AUTHORITY = "media";
    public static final String INTENT_ACTION_MUSIC_PLAYER = "android.intent.action.MUSIC_PLAYER";
    public static final String INTENT_ACTION_MEDIA_SEARCH = "android.intent.action.MEDIA_SEARCH";
    public static final String INTENT_ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";
    public static final String EXTRA_MEDIA_ARTIST = "android.intent.extra.artist";
    public static final String EXTRA_MEDIA_ALBUM = "android.intent.extra.album";
    public static final String EXTRA_MEDIA_TITLE = "android.intent.extra.title";
    public static final String EXTRA_MEDIA_FOCUS = "android.intent.extra.focus";
    public static final String EXTRA_SCREEN_ORIENTATION = "android.intent.extra.screenOrientation";
    public static final String EXTRA_FULL_SCREEN = "android.intent.extra.fullScreen";
    public static final String EXTRA_SHOW_ACTION_ICONS = "android.intent.extra.showActionIcons";
    public static final String EXTRA_FINISH_ON_COMPLETION = "android.intent.extra.finishOnCompletion";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA = "android.media.action.STILL_IMAGE_CAMERA";
    public static final String INTENT_ACTION_VIDEO_CAMERA = "android.media.action.VIDEO_CAMERA";
    public static final String ACTION_IMAGE_CAPTURE = "android.media.action.IMAGE_CAPTURE";
    public static final String ACTION_VIDEO_CAPTURE = "android.media.action.VIDEO_CAPTURE";
    public static final String EXTRA_VIDEO_QUALITY = "android.intent.extra.videoQuality";
    public static final String EXTRA_SIZE_LIMIT = "android.intent.extra.sizeLimit";
    public static final String EXTRA_DURATION_LIMIT = "android.intent.extra.durationLimit";
    public static final String EXTRA_OUTPUT = "output";
    public static final String UNKNOWN_STRING = "<unknown>";
    public static final String MEDIA_SCANNER_VOLUME = "volume";
    public static final String MEDIA_IGNORE_FILENAME = ".nomedia";

    public static native Uri getMediaScannerUri();

    public static native String getVersion(Context var0);

    public static final class Video {
        public static final String DEFAULT_SORT_ORDER = "_display_name";

        public static final native Cursor query(ContentResolver var0, Uri var1, String[] var2);

        public static class Thumbnails
        implements BaseColumns {
            public static final Uri INTERNAL_CONTENT_URI;
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String DEFAULT_SORT_ORDER = "video_id ASC";
            public static final String DATA = "_data";
            public static final String VIDEO_ID = "video_id";
            public static final String KIND = "kind";
            public static final int MINI_KIND = 1;
            public static final int FULL_SCREEN_KIND = 2;
            public static final int MICRO_KIND = 3;
            public static final String WIDTH = "width";
            public static final String HEIGHT = "height";

            public static native void cancelThumbnailRequest(ContentResolver var0, long var1);

            public static native Bitmap getThumbnail(ContentResolver var0, long var1, int var3, BitmapFactory.Options var4);

            public static native Bitmap getThumbnail(ContentResolver var0, long var1, long var3, int var5, BitmapFactory.Options var6);

            public static native void cancelThumbnailRequest(ContentResolver var0, long var1, long var3);

            public static native Uri getContentUri(String var0);
        }

        public static final class Media
        implements VideoColumns {
            public static final Uri INTERNAL_CONTENT_URI;
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/video";
            public static final String DEFAULT_SORT_ORDER = "title";

            public static native Uri getContentUri(String var0);
        }

        public static interface VideoColumns
        extends MediaColumns {
            public static final String DURATION = "duration";
            public static final String ARTIST = "artist";
            public static final String ALBUM = "album";
            public static final String RESOLUTION = "resolution";
            public static final String DESCRIPTION = "description";
            public static final String IS_PRIVATE = "isprivate";
            public static final String TAGS = "tags";
            public static final String CATEGORY = "category";
            public static final String LANGUAGE = "language";
            public static final String LATITUDE = "latitude";
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String BOOKMARK = "bookmark";
        }
    }

    public static final class Audio {
        public static native String keyFor(String var0);

        public static final class Albums
        implements BaseColumns,
        AlbumColumns {
            public static final Uri INTERNAL_CONTENT_URI;
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/albums";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/album";
            public static final String DEFAULT_SORT_ORDER = "album_key";

            public static native Uri getContentUri(String var0);
        }

        public static interface AlbumColumns {
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM = "album";
            public static final String ARTIST = "artist";
            public static final String NUMBER_OF_SONGS = "numsongs";
            public static final String NUMBER_OF_SONGS_FOR_ARTIST = "numsongs_by_artist";
            public static final String FIRST_YEAR = "minyear";
            public static final String LAST_YEAR = "maxyear";
            public static final String ALBUM_KEY = "album_key";
            public static final String ALBUM_ART = "album_art";
        }

        public static final class Artists
        implements BaseColumns,
        ArtistColumns {
            public static final Uri INTERNAL_CONTENT_URI;
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/artists";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/artist";
            public static final String DEFAULT_SORT_ORDER = "artist_key";

            public static native Uri getContentUri(String var0);

            public static final class Albums
            implements AlbumColumns {
                public static final native Uri getContentUri(String var0, long var1);
            }
        }

        public static interface ArtistColumns {
            public static final String ARTIST = "artist";
            public static final String ARTIST_KEY = "artist_key";
            public static final String NUMBER_OF_ALBUMS = "number_of_albums";
            public static final String NUMBER_OF_TRACKS = "number_of_tracks";
        }

        public static final class Playlists
        implements BaseColumns,
        PlaylistsColumns {
            public static final Uri INTERNAL_CONTENT_URI;
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/playlist";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/playlist";
            public static final String DEFAULT_SORT_ORDER = "name";

            public static native Uri getContentUri(String var0);

            public static final class Members
            implements AudioColumns {
                public static final String _ID = "_id";
                public static final String CONTENT_DIRECTORY = "members";
                public static final String AUDIO_ID = "audio_id";
                public static final String PLAYLIST_ID = "playlist_id";
                public static final String PLAY_ORDER = "play_order";
                public static final String DEFAULT_SORT_ORDER = "play_order";

                public static final native Uri getContentUri(String var0, long var1);

                public static final native boolean moveItem(ContentResolver var0, long var1, int var3, int var4);
            }
        }

        public static interface PlaylistsColumns {
            public static final String NAME = "name";
            public static final String DATA = "_data";
            public static final String DATE_ADDED = "date_added";
            public static final String DATE_MODIFIED = "date_modified";
        }

        public static final class Genres
        implements BaseColumns,
        GenresColumns {
            public static final Uri INTERNAL_CONTENT_URI;
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/genre";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/genre";
            public static final String DEFAULT_SORT_ORDER = "name";

            public static native Uri getContentUri(String var0);

            public static native Uri getContentUriForAudioId(String var0, int var1);

            public static final class Members
            implements AudioColumns {
                public static final String CONTENT_DIRECTORY = "members";
                public static final String DEFAULT_SORT_ORDER = "title_key";
                public static final String AUDIO_ID = "audio_id";
                public static final String GENRE_ID = "genre_id";

                public static final native Uri getContentUri(String var0, long var1);
            }
        }

        public static interface GenresColumns {
            public static final String NAME = "name";
        }

        public static final class Media
        implements AudioColumns {
            public static final Uri INTERNAL_CONTENT_URI;
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/audio";
            public static final String DEFAULT_SORT_ORDER = "title_key";
            public static final String RECORD_SOUND_ACTION = "android.provider.MediaStore.RECORD_SOUND";
            public static final String EXTRA_MAX_BYTES = "android.provider.MediaStore.extra.MAX_BYTES";

            public static native Uri getContentUri(String var0);

            public static native Uri getContentUriForPath(String var0);
        }

        public static interface AudioColumns
        extends MediaColumns {
            public static final String TITLE_KEY = "title_key";
            public static final String DURATION = "duration";
            public static final String BOOKMARK = "bookmark";
            public static final String ARTIST_ID = "artist_id";
            public static final String ARTIST = "artist";
            public static final String ARTIST_KEY = "artist_key";
            public static final String COMPOSER = "composer";
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM = "album";
            public static final String ALBUM_KEY = "album_key";
            public static final String ALBUM_ART = "album_art";
            public static final String TRACK = "track";
            public static final String YEAR = "year";
            public static final String IS_MUSIC = "is_music";
            public static final String IS_PODCAST = "is_podcast";
            public static final String IS_RINGTONE = "is_ringtone";
            public static final String IS_ALARM = "is_alarm";
            public static final String IS_NOTIFICATION = "is_notification";
        }
    }

    public static final class Images {

        public static class Thumbnails
        implements BaseColumns {
            public static final Uri INTERNAL_CONTENT_URI;
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String DEFAULT_SORT_ORDER = "image_id ASC";
            public static final String DATA = "_data";
            public static final String IMAGE_ID = "image_id";
            public static final String KIND = "kind";
            public static final int MINI_KIND = 1;
            public static final int FULL_SCREEN_KIND = 2;
            public static final int MICRO_KIND = 3;
            public static final String THUMB_DATA = "thumb_data";
            public static final String WIDTH = "width";
            public static final String HEIGHT = "height";

            public static final native Cursor query(ContentResolver var0, Uri var1, String[] var2);

            public static final native Cursor queryMiniThumbnails(ContentResolver var0, Uri var1, int var2, String[] var3);

            public static final native Cursor queryMiniThumbnail(ContentResolver var0, long var1, int var3, String[] var4);

            public static native void cancelThumbnailRequest(ContentResolver var0, long var1);

            public static native Bitmap getThumbnail(ContentResolver var0, long var1, int var3, BitmapFactory.Options var4);

            public static native void cancelThumbnailRequest(ContentResolver var0, long var1, long var3);

            public static native Bitmap getThumbnail(ContentResolver var0, long var1, long var3, int var5, BitmapFactory.Options var6);

            public static native Uri getContentUri(String var0);
        }

        public static final class Media
        implements ImageColumns {
            public static final Uri INTERNAL_CONTENT_URI;
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/image";
            public static final String DEFAULT_SORT_ORDER = "bucket_display_name";

            public static final native Cursor query(ContentResolver var0, Uri var1, String[] var2);

            public static final native Cursor query(ContentResolver var0, Uri var1, String[] var2, String var3, String var4);

            public static final native Cursor query(ContentResolver var0, Uri var1, String[] var2, String var3, String[] var4, String var5);

            public static final native Bitmap getBitmap(ContentResolver var0, Uri var1) throws FileNotFoundException, IOException;

            public static final native String insertImage(ContentResolver var0, String var1, String var2, String var3) throws FileNotFoundException;

            public static final native String insertImage(ContentResolver var0, Bitmap var1, String var2, String var3);

            public static native Uri getContentUri(String var0);
        }

        public static interface ImageColumns
        extends MediaColumns {
            public static final String DESCRIPTION = "description";
            public static final String PICASA_ID = "picasa_id";
            public static final String IS_PRIVATE = "isprivate";
            public static final String LATITUDE = "latitude";
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            public static final String ORIENTATION = "orientation";
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
        }
    }

    public static final class Files {
        public static native Uri getContentUri(String var0);

        public static final native Uri getContentUri(String var0, long var1);

        public static interface FileColumns
        extends MediaColumns {
            public static final String PARENT = "parent";
            public static final String MIME_TYPE = "mime_type";
            public static final String TITLE = "title";
            public static final String MEDIA_TYPE = "media_type";
            public static final int MEDIA_TYPE_NONE = 0;
            public static final int MEDIA_TYPE_IMAGE = 1;
            public static final int MEDIA_TYPE_AUDIO = 2;
            public static final int MEDIA_TYPE_VIDEO = 3;
            public static final int MEDIA_TYPE_PLAYLIST = 4;
        }
    }

    public static interface MediaColumns
    extends BaseColumns {
        public static final String DATA = "_data";
        public static final String SIZE = "_size";
        public static final String DISPLAY_NAME = "_display_name";
        public static final String TITLE = "title";
        public static final String DATE_ADDED = "date_added";
        public static final String DATE_MODIFIED = "date_modified";
        public static final String MIME_TYPE = "mime_type";
    }
}

