/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import android.util.Pair;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabase
extends SQLiteClosable {
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_NONE = 0;
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    public static final int OPEN_READWRITE = 0;
    public static final int OPEN_READONLY = 1;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    public static final int MAX_SQL_CACHE_SIZE = 100;

    @Override
    protected native void onAllReferencesReleased();

    public static native int releaseMemory();

    public native void setLockingEnabled(boolean var1);

    public native void beginTransaction();

    public native void beginTransactionNonExclusive();

    public native void beginTransactionWithListener(SQLiteTransactionListener var1);

    public native void beginTransactionWithListenerNonExclusive(SQLiteTransactionListener var1);

    public native void endTransaction();

    public native void setTransactionSuccessful();

    public native boolean inTransaction();

    public native boolean isDbLockedByCurrentThread();

    public native boolean isDbLockedByOtherThreads();

    public native boolean yieldIfContended();

    public native boolean yieldIfContendedSafely();

    public native boolean yieldIfContendedSafely(long var1);

    public native Map<String, String> getSyncedTables();

    public static native SQLiteDatabase openDatabase(String var0, CursorFactory var1, int var2);

    public static native SQLiteDatabase openDatabase(String var0, CursorFactory var1, int var2, DatabaseErrorHandler var3);

    public static native SQLiteDatabase openOrCreateDatabase(File var0, CursorFactory var1);

    public static native SQLiteDatabase openOrCreateDatabase(String var0, CursorFactory var1);

    public static native SQLiteDatabase openOrCreateDatabase(String var0, CursorFactory var1, DatabaseErrorHandler var2);

    public static native SQLiteDatabase create(CursorFactory var0);

    public native void close();

    public native int getVersion();

    public native void setVersion(int var1);

    public native long getMaximumSize();

    public native long setMaximumSize(long var1);

    public native long getPageSize();

    public native void setPageSize(long var1);

    public native void markTableSyncable(String var1, String var2);

    public native void markTableSyncable(String var1, String var2, String var3);

    public static native String findEditTable(String var0);

    public native SQLiteStatement compileStatement(String var1) throws SQLException;

    public native Cursor query(boolean var1, String var2, String[] var3, String var4, String[] var5, String var6, String var7, String var8, String var9);

    public native Cursor queryWithFactory(CursorFactory var1, boolean var2, String var3, String[] var4, String var5, String[] var6, String var7, String var8, String var9, String var10);

    public native Cursor query(String var1, String[] var2, String var3, String[] var4, String var5, String var6, String var7);

    public native Cursor query(String var1, String[] var2, String var3, String[] var4, String var5, String var6, String var7, String var8);

    public native Cursor rawQuery(String var1, String[] var2);

    public native Cursor rawQueryWithFactory(CursorFactory var1, String var2, String[] var3, String var4);

    public native long insert(String var1, String var2, ContentValues var3);

    public native long insertOrThrow(String var1, String var2, ContentValues var3) throws SQLException;

    public native long replace(String var1, String var2, ContentValues var3);

    public native long replaceOrThrow(String var1, String var2, ContentValues var3) throws SQLException;

    public native long insertWithOnConflict(String var1, String var2, ContentValues var3, int var4);

    public native int delete(String var1, String var2, String[] var3);

    public native int update(String var1, ContentValues var2, String var3, String[] var4);

    public native int updateWithOnConflict(String var1, ContentValues var2, String var3, String[] var4, int var5);

    public native void execSQL(String var1) throws SQLException;

    public native void execSQL(String var1, Object[] var2) throws SQLException;

    protected native void finalize() throws Throwable;

    public native boolean isReadOnly();

    public native boolean isOpen();

    public native boolean needUpgrade(int var1);

    public final native String getPath();

    public native void setLocale(Locale var1);

    public native void setMaxSqlCacheSize(int var1);

    public native boolean enableWriteAheadLogging();

    public native List<Pair<String, String>> getAttachedDbs();

    public native boolean isDatabaseIntegrityOk();

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }
}

