/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.OnAccountsUpdateListener;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountManager {
    public static final int ERROR_CODE_REMOTE_EXCEPTION = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 3;
    public static final int ERROR_CODE_CANCELED = 4;
    public static final int ERROR_CODE_INVALID_RESPONSE = 5;
    public static final int ERROR_CODE_UNSUPPORTED_OPERATION = 6;
    public static final int ERROR_CODE_BAD_ARGUMENTS = 7;
    public static final int ERROR_CODE_BAD_REQUEST = 8;
    public static final String KEY_ACCOUNT_NAME = "authAccount";
    public static final String KEY_ACCOUNT_TYPE = "accountType";
    public static final String KEY_AUTHTOKEN = "authtoken";
    public static final String KEY_INTENT = "intent";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_ACCOUNTS = "accounts";
    public static final String KEY_ACCOUNT_AUTHENTICATOR_RESPONSE = "accountAuthenticatorResponse";
    public static final String KEY_ACCOUNT_MANAGER_RESPONSE = "accountManagerResponse";
    public static final String KEY_AUTHENTICATOR_TYPES = "authenticator_types";
    public static final String KEY_AUTH_FAILED_MESSAGE = "authFailedMessage";
    public static final String KEY_AUTH_TOKEN_LABEL = "authTokenLabelKey";
    public static final String KEY_BOOLEAN_RESULT = "booleanResult";
    public static final String KEY_ERROR_CODE = "errorCode";
    public static final String KEY_ERROR_MESSAGE = "errorMessage";
    public static final String KEY_USERDATA = "userdata";
    public static final String KEY_CALLER_UID = "callerUid";
    public static final String KEY_CALLER_PID = "callerPid";
    public static final String ACTION_AUTHENTICATOR_INTENT = "android.accounts.AccountAuthenticator";
    public static final String AUTHENTICATOR_META_DATA_NAME = "android.accounts.AccountAuthenticator";
    public static final String AUTHENTICATOR_ATTRIBUTES_NAME = "account-authenticator";
    public static final String LOGIN_ACCOUNTS_CHANGED_ACTION = "android.accounts.LOGIN_ACCOUNTS_CHANGED";

    public static native AccountManager get(Context var0);

    public native String getPassword(Account var1);

    public native String getUserData(Account var1, String var2);

    public native AuthenticatorDescription[] getAuthenticatorTypes();

    public native Account[] getAccounts();

    public native Account[] getAccountsByType(String var1);

    public native AccountManagerFuture<Boolean> hasFeatures(Account var1, String[] var2, AccountManagerCallback<Boolean> var3, Handler var4);

    public native AccountManagerFuture<Account[]> getAccountsByTypeAndFeatures(String var1, String[] var2, AccountManagerCallback<Account[]> var3, Handler var4);

    public native boolean addAccountExplicitly(Account var1, String var2, Bundle var3);

    public native AccountManagerFuture<Boolean> removeAccount(Account var1, AccountManagerCallback<Boolean> var2, Handler var3);

    public native void invalidateAuthToken(String var1, String var2);

    public native String peekAuthToken(Account var1, String var2);

    public native void setPassword(Account var1, String var2);

    public native void clearPassword(Account var1);

    public native void setUserData(Account var1, String var2, String var3);

    public native void setAuthToken(Account var1, String var2, String var3);

    public native String blockingGetAuthToken(Account var1, String var2, boolean var3) throws OperationCanceledException, IOException, AuthenticatorException;

    public native AccountManagerFuture<Bundle> getAuthToken(Account var1, String var2, Bundle var3, Activity var4, AccountManagerCallback<Bundle> var5, Handler var6);

    public native AccountManagerFuture<Bundle> getAuthToken(Account var1, String var2, boolean var3, AccountManagerCallback<Bundle> var4, Handler var5);

    public native AccountManagerFuture<Bundle> addAccount(String var1, String var2, String[] var3, Bundle var4, Activity var5, AccountManagerCallback<Bundle> var6, Handler var7);

    public native AccountManagerFuture<Bundle> confirmCredentials(Account var1, Bundle var2, Activity var3, AccountManagerCallback<Bundle> var4, Handler var5);

    public native AccountManagerFuture<Bundle> updateCredentials(Account var1, String var2, Bundle var3, Activity var4, AccountManagerCallback<Bundle> var5, Handler var6);

    public native AccountManagerFuture<Bundle> editProperties(String var1, Activity var2, AccountManagerCallback<Bundle> var3, Handler var4);

    public native AccountManagerFuture<Bundle> getAuthTokenByFeatures(String var1, String var2, String[] var3, Activity var4, Bundle var5, Bundle var6, AccountManagerCallback<Bundle> var7, Handler var8);

    public native void addOnAccountsUpdatedListener(OnAccountsUpdateListener var1, Handler var2, boolean var3);

    public native void removeOnAccountsUpdatedListener(OnAccountsUpdateListener var1);
}

