/*
 * Decompiled with CFR 0.152.
 */
package dopanet;

import dopanet.Start_Session;
import dopanet.VideoPlayerSwingWidget;
import dopanet.kFoneGLB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Paint;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class VideoPlayerSwingWidget_EXP
extends JFrame {
    private JFXPanel jfxPanel;
    private MediaPlayer mediaPlayer;
    private JLabel muteLabel;
    private String dir = System.getProperty("user.dir");
    private static List videoUrls = new ArrayList();
    private int currentVideoIndex;
    private JLabel videoNameLabel;
    private String closeiconPath = System.getProperty("user.dir") + "\\close.png";
    private String muteiconPath = System.getProperty("user.dir") + "\\mute.png";
    private String unmuteiconPath = System.getProperty("user.dir") + "\\unmute.png";
    private int mouseX;
    private int mouseY;
    private JButton muteButton;

    public VideoPlayerSwingWidget_EXP() {
        this.setUndecorated(true);
        this.setTitle("Video Player");
        this.setSize(350, 190);
        this.setDefaultCloseOperation(3);
        this.setShape(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 25.0, 25.0));
        this.currentVideoIndex = 0;
        this.jfxPanel = new JFXPanel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)this.jfxPanel, "Center");
        this.jfxPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayerSwingWidget_EXP.this.mouseX = e.getX();
                VideoPlayerSwingWidget_EXP.this.mouseY = e.getY();
                System.out.println("Mouse pressed at: " + VideoPlayerSwingWidget_EXP.this.mouseX + ", " + VideoPlayerSwingWidget_EXP.this.mouseY);
            }
        });
        this.jfxPanel.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int newX = VideoPlayerSwingWidget_EXP.this.getLocation().x + e.getX() - VideoPlayerSwingWidget_EXP.this.mouseX;
                int newY = VideoPlayerSwingWidget_EXP.this.getLocation().y + e.getY() - VideoPlayerSwingWidget_EXP.this.mouseY;
                Rectangle screenBounds = VideoPlayerSwingWidget_EXP.this.getScreenBounds();
                if (newX < screenBounds.x) {
                    newX = screenBounds.x;
                }
                if (newY < screenBounds.y) {
                    newY = screenBounds.y;
                }
                if (newX + VideoPlayerSwingWidget_EXP.this.getWidth() > screenBounds.x + screenBounds.width) {
                    newX = screenBounds.x + screenBounds.width - VideoPlayerSwingWidget_EXP.this.getWidth();
                }
                if (newY + VideoPlayerSwingWidget_EXP.this.getHeight() > screenBounds.y + screenBounds.height) {
                    newY = screenBounds.y + screenBounds.height - VideoPlayerSwingWidget_EXP.this.getHeight();
                }
                VideoPlayerSwingWidget_EXP.this.setLocation(newX, newY);
            }
        });
        this.jfxPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    System.out.println("Left-click performed");
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    System.out.println("Right-click performed");
                    VideoPlayerSwingWidget_EXP.this.showPopup(e);
                }
            }
        });
        this.videoNameLabel = new JLabel(Start_Session.brandName);
        this.videoNameLabel.setForeground(Color.BLACK);
        this.videoNameLabel.setHorizontalAlignment(0);
        this.videoNameLabel.setOpaque(false);
        panel.add((Component)this.videoNameLabel, "South");
        this.setAlwaysOnTop(true);
        this.setFocusable(true);
        this.setContentPane(panel);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (VideoPlayerSwingWidget_EXP.this.mediaPlayer != null) {
                    VideoPlayerSwingWidget_EXP.this.mediaPlayer.stop();
                }
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if ((e.getNewState() & 1) == 1) {
                    VideoPlayerSwingWidget_EXP.this.setExtendedState(0);
                }
            }
        });
        Point defaultLocation = this.calculateDefaultLocation();
        this.setLocation(defaultLocation);
        this.setVisible(true);
    }

    public void setVideoName(String videoName) {
        this.videoNameLabel.setText(videoName);
    }

    public void playVideo(String videoUrl) {
        this.stopVideo();
        Platform.runLater(() -> this.initFX(videoUrl));
    }

    public void stopVideo() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    private Point calculateDefaultLocation() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = ge.getMaximumWindowBounds();
        int x = bounds.x + bounds.width - this.getWidth();
        int y = bounds.y + bounds.height - this.getHeight();
        return new Point(x, y);
    }

    private void showPopup(MouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem1 = new JMenuItem("Select Option");
        menuItem1.addActionListener(actionEvent -> System.out.println("Select Option Selected"));
        JMenuItem menuItem2 = new JMenuItem("visit WebPage");
        menuItem2.addActionListener(actionEvent -> System.out.println("visit WebPage Option Selected"));
        JMenuItem menuItem3 = new JMenuItem("get mobno");
        menuItem3.addActionListener(actionEvent -> System.out.println("get mobno Option Selected"));
        JMenuItem menuItem4 = new JMenuItem("Mute/Unmute");
        menuItem4.addActionListener(actionEvent -> {
            System.out.println("Mute Option Selected");
            this.toggleMute();
        });
        JMenuItem menuItem5 = new JMenuItem("Close Advertise");
        menuItem5.addActionListener(actionEvent -> {
            System.out.println("Close Advertise Option Selected");
            this.closeApplication();
        });
        popupMenu.add(menuItem1);
        popupMenu.add(menuItem2);
        popupMenu.add(menuItem3);
        popupMenu.add(menuItem4);
        popupMenu.add(menuItem5);
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void playNextVideo() {
        ++this.currentVideoIndex;
        if (this.currentVideoIndex >= videoUrls.size()) {
            this.currentVideoIndex = 0;
        }
        System.out.println("videoUrls:" + videoUrls.size() + " currentVideoIndex:" + this.currentVideoIndex);
        if (videoUrls.size() > this.currentVideoIndex) {
            Platform.runLater(() -> this.initFX(videoUrls.get(this.currentVideoIndex).toString()));
        }
    }

    private void initFX(String url) {
        try {
            String ex_ex;
            String[] split = url.split("/");
            int l = url.split("/").length;
            String x = split[l - 1];
            String rem = url.toString().replace(x, "");
            System.out.println("XXX:" + x);
            String ex_url = x.replace(" ", "%20");
            url = ex_ex = rem + "" + ex_url;
            System.out.println("ex_ex:::" + ex_ex);
            System.out.println("URL:" + url);
            if (url.contains("http://") || url.contains("https://")) {
                URL videoUrl = new URL(url);
                String mediaUrl = videoUrl.toExternalForm();
                Media media = new Media(mediaUrl);
                this.mediaPlayer = new MediaPlayer(media);
                MediaView mediaView = new MediaView(this.mediaPlayer);
                mediaView.setFitWidth(350.0);
                mediaView.setFitHeight(600.0);
                Scene scene = new Scene((Parent)new Group(new Node[]{mediaView}), (Paint)javafx.scene.paint.Color.TRANSPARENT);
                this.jfxPanel.setScene(scene);
                this.mediaPlayer.setOnEndOfMedia(this::playNextVideo);
                this.mediaPlayer.play();
                this.mediaPlayer.setMute(Start_Session.isMuted);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void toggleMute() {
        if (this.mediaPlayer != null) {
            Start_Session.isMuted = !Start_Session.isMuted;
            this.mediaPlayer.setMute(Start_Session.isMuted);
            this.updateMuteUnmuteIcon();
        }
    }

    private void updateMuteUnmuteIcon() {
        if (Start_Session.isMuted) {
            this.muteButton.setIcon(new ImageIcon(this.unmuteiconPath));
        } else {
            this.muteButton.setIcon(new ImageIcon(this.muteiconPath));
        }
    }

    private void closeApplication() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
        if (kFoneGLB.connectedSocket != null) {
            try {
                kFoneGLB.connectedSocket.shutdownInput();
                kFoneGLB.connectedSocket.shutdownOutput();
                kFoneGLB.connectedSocket.close();
                kFoneGLB.connectedSocket = null;
            }
            catch (IOException ex) {
                Logger.getLogger(VideoPlayerSwingWidget.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.dispose();
        System.exit(0);
    }

    @Override
    public void setExtendedState(int extendedState) {
        if ((extendedState & 1) == 1) {
            return;
        }
        super.setExtendedState(extendedState);
    }

    public static void main(String[] args) {
    }

    private Rectangle getScreenBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        Rectangle bounds = new Rectangle();
        for (GraphicsDevice device : gd) {
            bounds = bounds.union(device.getDefaultConfiguration().getBounds());
        }
        return bounds;
    }
}

