/*
 * Decompiled with CFR 0.152.
 */
package dopanet;

import dopanet.Start_Session;
import dopanet.kFoneGLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VideoPlayerSwingWidget
extends JFrame {
    private final JFXPanel jfxPanel;
    private MediaPlayer mediaPlayer;
    private JLabel muteLabel;
    private String dir = System.getProperty("user.dir");
    private static List videoUrls = new ArrayList();
    private int currentVideoIndex;
    private String closeiconPath = System.getProperty("user.dir") + "\\close.png";
    private String muteiconPath = System.getProperty("user.dir") + "\\mute.png";
    private String unmuteiconPath = System.getProperty("user.dir") + "\\unmute.png";
    private int mouseX;
    private int mouseY;
    private JButton muteButton;

    public VideoPlayerSwingWidget(List<String> videoUrls) {
        this.setUndecorated(false);
        this.setTitle("Video Player");
        this.setSize(250, 150);
        this.setDefaultCloseOperation(3);
        VideoPlayerSwingWidget.videoUrls = videoUrls;
        this.currentVideoIndex = 0;
        this.jfxPanel = new JFXPanel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)this.jfxPanel, "Center");
        this.muteButton = new JButton();
        this.muteButton.setIcon(new ImageIcon(this.muteiconPath));
        this.muteButton.setOpaque(false);
        this.muteButton.setBorderPainted(false);
        this.muteButton.setContentAreaFilled(false);
        this.muteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VideoPlayerSwingWidget.this.toggleMute();
            }
        });
        this.muteButton.setAlignmentX(1.0f);
        panel.add((Component)this.muteButton, "South");
        this.muteButton = new JButton();
        this.muteButton.setIcon(new ImageIcon(this.unmuteiconPath));
        this.muteButton.setOpaque(false);
        this.muteButton.setBorderPainted(false);
        this.muteButton.setContentAreaFilled(false);
        this.muteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VideoPlayerSwingWidget.this.toggleMute();
            }
        });
        this.muteButton.setAlignmentX(1.0f);
        panel.add((Component)this.muteButton, "South");
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayerSwingWidget.this.mouseX = e.getX();
                VideoPlayerSwingWidget.this.mouseY = e.getY();
            }
        });
        panel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                VideoPlayerSwingWidget.this.setLocation(VideoPlayerSwingWidget.this.getLocation().x + e.getX() - VideoPlayerSwingWidget.this.mouseX, VideoPlayerSwingWidget.this.getLocation().y + e.getY() - VideoPlayerSwingWidget.this.mouseY);
            }
        });
        Platform.runLater(() -> this.initFX((String)videoUrls.get(this.currentVideoIndex)));
        this.setContentPane(panel);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void playNextVideo() {
        ++this.currentVideoIndex;
        if (this.currentVideoIndex >= videoUrls.size()) {
            this.currentVideoIndex = 0;
        }
        Platform.runLater(() -> this.initFX(videoUrls.get(this.currentVideoIndex).toString()));
    }

    private JPanel createIconButton(String iconPath, int iconWidth, int iconHeight, Runnable action) {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setOpaque(false);
        ImageIcon icon = new ImageIcon(new ImageIcon(iconPath).getImage().getScaledInstance(iconWidth, iconHeight, 4));
        JButton button = new JButton(icon);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.addActionListener(e -> action.run());
        buttonPanel.add((Component)button, "North");
        return buttonPanel;
    }

    private void initFX(String url) {
        try {
            URL videoUrl = new URL(url);
            String mediaUrl = videoUrl.toExternalForm();
            Media media = new Media(mediaUrl);
            this.mediaPlayer = new MediaPlayer(media);
            MediaView mediaView = new MediaView(this.mediaPlayer);
            mediaView.setFitWidth(250.0);
            mediaView.setFitHeight(150.0);
            Scene scene = new Scene((Parent)new Group(new Node[]{mediaView}), (Paint)Color.TRANSPARENT);
            this.jfxPanel.setScene(scene);
            this.mediaPlayer.setOnEndOfMedia(this::playNextVideo);
            this.mediaPlayer.play();
            this.mediaPlayer.setMute(Start_Session.isMuted);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void toggleMute() {
        if (this.mediaPlayer != null) {
            Start_Session.isMuted = !Start_Session.isMuted;
            this.mediaPlayer.setMute(Start_Session.isMuted);
            this.updateMuteUnmuteIcon();
        }
    }

    private void updateMuteUnmuteIcon() {
        if (Start_Session.isMuted) {
            this.muteButton.setIcon(new ImageIcon(this.unmuteiconPath));
        } else {
            this.muteButton.setIcon(new ImageIcon(this.muteiconPath));
        }
    }

    private void closeApplication() {
        System.out.println("Closing the Adv Window");
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
        if (kFoneGLB.connectedSocket != null) {
            try {
                kFoneGLB.connectedSocket.shutdownInput();
                kFoneGLB.connectedSocket.shutdownOutput();
                kFoneGLB.connectedSocket.close();
                kFoneGLB.connectedSocket = null;
            }
            catch (IOException ex) {
                Logger.getLogger(VideoPlayerSwingWidget.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.dispose();
        System.exit(0);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new VideoPlayerSwingWidget(Start_Session.mainvideoUrls));
    }
}

