/*
 * Decompiled with CFR 0.152.
 */
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.Label;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GmailSwingApp {
    private static final String APPLICATION_NAME = "Gmail API Java Swing App";
    private static final File CREDENTIALS_FILE_PATH = new File("credentials.json");

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Gmail Authentication");
            frame.setDefaultCloseOperation(3);
            frame.setSize(400, 300);
            JButton authButton = new JButton("Authenticate with Gmail");
            authButton.addActionListener(e -> GmailSwingApp.authenticate(frame));
            frame.getContentPane().add((Component)authButton, "Center");
            frame.setVisible(true);
        });
    }

    private static void authenticate(JFrame frame) {
        try {
            Credential credential = GmailSwingApp.getCredentials();
            if (credential != null) {
                Gmail service = new Gmail.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
                String user = "me";
                String label = ((Label)service.users().labels().get(user, "INBOX").execute()).getName();
                JOptionPane.showMessageDialog(frame, "Authentication successful! Inbox label: " + label);
            } else {
                JOptionPane.showMessageDialog(frame, "Authentication failed.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(frame, "An error occurred: " + ex.getMessage());
        }
    }

    private static Credential getCredentials() throws IOException, GeneralSecurityException {
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JacksonFactory.getDefaultInstance(), (Reader)new FileReader(CREDENTIALS_FILE_PATH));
        List<String> scopes = Collections.singletonList("https://www.googleapis.com/auth/gmail.readonly");
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JacksonFactory.getDefaultInstance(), clientSecrets, scopes).setAccessType("offline").build();
        LocalServerReceiver receiver = new LocalServerReceiver.Builder().setPort(8888).build();
        return new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)receiver).authorize("user");
    }
}

