/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.FfmpegIO;
import com.xuggle.xuggler.io.FileProtocolHandlerFactory;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.IURLProtocolHandlerFactory;
import com.xuggle.xuggler.io.NullProtocolHandlerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLProtocolManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, IURLProtocolHandlerFactory> mProtocols = new ConcurrentHashMap<String, IURLProtocolHandlerFactory>();
    public static final String DEFAULT_PROTOCOL = "xugglerfile";
    public static final String NULL_PROTOCOL = "xugglernull";
    private static final URLProtocolManager sManager = new URLProtocolManager();

    public static URLProtocolManager getManager() {
        return sManager;
    }

    public static void init() {
    }

    private URLProtocolManager() {
        this.registerFactory(DEFAULT_PROTOCOL, new FileProtocolHandlerFactory());
        this.registerFactory(NULL_PROTOCOL, new NullProtocolHandlerFactory());
    }

    public IURLProtocolHandlerFactory registerFactory(String protocol, IURLProtocolHandlerFactory factory) {
        IURLProtocolHandlerFactory oldFactory = this.mProtocols.put(protocol, factory);
        this.log.trace("Registering factory for URLProtocol: {}", (Object)protocol);
        if (oldFactory == null) {
            this.log.trace("Letting FFMPEG know about an additional protocol: {}", (Object)protocol);
            FfmpegIO.registerProtocolHandler(protocol, this);
        }
        return oldFactory;
    }

    public IURLProtocolHandler getHandler(String url, int flags) {
        IURLProtocolHandler result = null;
        this.log.trace("looking for protocol handler for: {}", (Object)url);
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("expected valid URL");
        }
        int colonIndex = url.indexOf(":");
        String protocol = null;
        protocol = colonIndex > 0 ? url.substring(0, colonIndex) : DEFAULT_PROTOCOL;
        IURLProtocolHandlerFactory factory = (IURLProtocolHandlerFactory)this.mProtocols.get(protocol);
        if (factory != null) {
            result = factory.getHandler(protocol, url, flags);
        } else {
            this.log.error("asked to get handler for unsupported protocol: {}", (Object)protocol);
        }
        return result;
    }

    public static String getResourceFromURL(String url) {
        String retval = url;
        if (url != null && url.length() > 0) {
            int colonIndex = url.indexOf("://");
            if (colonIndex > 0) {
                retval = url.substring(colonIndex + 3);
            } else {
                colonIndex = url.indexOf(":");
                if (colonIndex > 0) {
                    retval = url.substring(colonIndex + 1);
                }
            }
        }
        return retval;
    }

    public static String getProtocolFromURL(String url) {
        int colonIndex;
        String retval = null;
        if (url != null && url.length() > 0 && (colonIndex = url.indexOf(":")) > 0) {
            retval = url.substring(0, colonIndex);
        }
        return retval;
    }
}

