/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.demos;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class VideoImage
extends JFrame {
    private static final long serialVersionUID = -4752966848100689153L;
    private final ImageComponent mOnscreenPicture = new ImageComponent();

    public VideoImage() {
        this.setDefaultCloseOperation(3);
        this.getContentPane().add(this.mOnscreenPicture);
        this.setVisible(true);
        this.pack();
    }

    public void setImage(BufferedImage aImage) {
        this.mOnscreenPicture.setImage(aImage);
    }

    public class ImageComponent
    extends JComponent {
        private static final long serialVersionUID = 5584422798735147930L;
        private Image mImage;
        private Dimension mSize = new Dimension(0, 0);

        public void setImage(Image image) {
            SwingUtilities.invokeLater(new ImageRunnable(image));
        }

        public void setImageSize(Dimension newSize) {
        }

        public ImageComponent() {
            this.setSize(this.mSize);
        }

        public synchronized void paint(Graphics g) {
            if (this.mImage != null) {
                g.drawImage(this.mImage, 0, 0, this);
            }
        }

        private class ImageRunnable
        implements Runnable {
            private final Image newImage;

            public ImageRunnable(Image newImage) {
                this.newImage = newImage;
            }

            public void run() {
                ImageComponent.this.mImage = this.newImage;
                Dimension newSize = new Dimension(ImageComponent.this.mImage.getWidth(null), ImageComponent.this.mImage.getHeight(null));
                if (!newSize.equals(ImageComponent.this.mSize)) {
                    ImageComponent.this.mSize = newSize;
                    VideoImage.this.setSize(ImageComponent.this.mImage.getWidth(null), ImageComponent.this.mImage.getHeight(null));
                    VideoImage.this.setVisible(true);
                }
                ImageComponent.this.repaint();
            }
        }
    }
}

