/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.XugglerJNI;

public class IVideoPicture
extends IMediaData {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IVideoPicture(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIVideoPictureUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IVideoPicture obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public IVideoPicture copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IVideoPicture retval = null;
        this.acquire();
        try {
            retval = new IVideoPicture(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IVideoPicture) {
            equal = ((IVideoPicture)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("pixel type:" + (Object)((Object)this.getPixelType()) + ";");
        result.append("width:" + this.getWidth() + ";");
        result.append("height:" + this.getHeight() + ";");
        result.append("time stamp:" + this.getTimeStamp() + ";");
        result.append("complete:" + this.isComplete() + ";");
        result.append("size:" + this.getSize() + ";");
        result.append("key:" + this.isKey() + ";");
        result.append("time base:" + IRational.make(1, (int)Global.DEFAULT_PTS_PER_SECOND) + ";");
        result.append("]");
        return result.toString();
    }

    public boolean isKeyFrame() {
        return XugglerJNI.IVideoPicture_isKeyFrame(this.swigCPtr, this);
    }

    public void setKeyFrame(boolean aIsKey) {
        XugglerJNI.IVideoPicture_setKeyFrame(this.swigCPtr, this, aIsKey);
    }

    public boolean isComplete() {
        return XugglerJNI.IVideoPicture_isComplete(this.swigCPtr, this);
    }

    public int getSize() {
        return XugglerJNI.IVideoPicture_getSize(this.swigCPtr, this);
    }

    public int getWidth() {
        return XugglerJNI.IVideoPicture_getWidth(this.swigCPtr, this);
    }

    public int getHeight() {
        return XugglerJNI.IVideoPicture_getHeight(this.swigCPtr, this);
    }

    public IPixelFormat.Type getPixelType() {
        return IPixelFormat.Type.swigToEnum(XugglerJNI.IVideoPicture_getPixelType(this.swigCPtr, this));
    }

    public long getPts() {
        return XugglerJNI.IVideoPicture_getPts(this.swigCPtr, this);
    }

    public void setPts(long value) {
        XugglerJNI.IVideoPicture_setPts(this.swigCPtr, this, value);
    }

    public int getQuality() {
        return XugglerJNI.IVideoPicture_getQuality(this.swigCPtr, this);
    }

    public void setQuality(int newQuality) {
        XugglerJNI.IVideoPicture_setQuality(this.swigCPtr, this, newQuality);
    }

    public int getDataLineSize(int lineNo) {
        return XugglerJNI.IVideoPicture_getDataLineSize(this.swigCPtr, this, lineNo);
    }

    public void setComplete(boolean aIsComplete, IPixelFormat.Type format, int width, int height, long pts) {
        XugglerJNI.IVideoPicture_setComplete(this.swigCPtr, this, aIsComplete, format.swigValue(), width, height, pts);
    }

    public boolean copy(IVideoPicture srcPicture) {
        return XugglerJNI.IVideoPicture_copy(this.swigCPtr, this, IVideoPicture.getCPtr(srcPicture), srcPicture);
    }

    public static IVideoPicture make(IPixelFormat.Type format, int width, int height) {
        long cPtr = XugglerJNI.IVideoPicture_make__SWIG_0(format.swigValue(), width, height);
        return cPtr == 0L ? null : new IVideoPicture(cPtr, false);
    }

    public static IVideoPicture make(IVideoPicture src) {
        long cPtr = XugglerJNI.IVideoPicture_make__SWIG_1(IVideoPicture.getCPtr(src), src);
        return cPtr == 0L ? null : new IVideoPicture(cPtr, false);
    }
}

