/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.XugglerJNI;

public class IStream
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IStream(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIStreamUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IStream obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public IStream copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IStream retval = null;
        this.acquire();
        try {
            retval = new IStream(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IStream) {
            equal = ((IStream)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("index:" + this.getIndex() + ";");
        result.append("id:" + this.getId() + ";");
        result.append("streamcoder:" + this.getStreamCoder() + ";");
        result.append("framerate:" + this.getFrameRate() + ";");
        result.append("timebase:" + this.getTimeBase() + ";");
        result.append("direction:" + (Object)((Object)this.getDirection()) + ";");
        result.append("]");
        return result.toString();
    }

    public Direction getDirection() {
        return Direction.swigToEnum(XugglerJNI.IStream_getDirection(this.swigCPtr, this));
    }

    public int getIndex() {
        return XugglerJNI.IStream_getIndex(this.swigCPtr, this);
    }

    public int getId() {
        return XugglerJNI.IStream_getId(this.swigCPtr, this);
    }

    public IStreamCoder getStreamCoder() {
        long cPtr = XugglerJNI.IStream_getStreamCoder(this.swigCPtr, this);
        return cPtr == 0L ? null : new IStreamCoder(cPtr, false);
    }

    public IRational getFrameRate() {
        long cPtr = XugglerJNI.IStream_getFrameRate(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public IRational getTimeBase() {
        long cPtr = XugglerJNI.IStream_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public long getStartTime() {
        return XugglerJNI.IStream_getStartTime(this.swigCPtr, this);
    }

    public long getDuration() {
        return XugglerJNI.IStream_getDuration(this.swigCPtr, this);
    }

    public long getCurrentDts() {
        return XugglerJNI.IStream_getCurrentDts(this.swigCPtr, this);
    }

    public int getNumIndexEntries() {
        return XugglerJNI.IStream_getNumIndexEntries(this.swigCPtr, this);
    }

    public long getNumFrames() {
        return XugglerJNI.IStream_getNumFrames(this.swigCPtr, this);
    }

    public IRational getSampleAspectRatio() {
        long cPtr = XugglerJNI.IStream_getSampleAspectRatio(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public void setSampleAspectRatio(IRational newRatio) {
        XugglerJNI.IStream_setSampleAspectRatio(this.swigCPtr, this, IRational.getCPtr(newRatio), newRatio);
    }

    public String getLanguage() {
        return XugglerJNI.IStream_getLanguage(this.swigCPtr, this);
    }

    public void setLanguage(String language) {
        XugglerJNI.IStream_setLanguage(this.swigCPtr, this, language);
    }

    public IContainer getContainer() {
        long cPtr = XugglerJNI.IStream_getContainer(this.swigCPtr, this);
        return cPtr == 0L ? null : new IContainer(cPtr, false);
    }

    public int setStreamCoder(IStreamCoder newCoder) {
        return XugglerJNI.IStream_setStreamCoder(this.swigCPtr, this, IStreamCoder.getCPtr(newCoder), newCoder);
    }

    public ParseType getParseType() {
        return ParseType.swigToEnum(XugglerJNI.IStream_getParseType(this.swigCPtr, this));
    }

    public void setParseType(ParseType type) {
        XugglerJNI.IStream_setParseType(this.swigCPtr, this, type.swigValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParseType {
        PARSE_NONE,
        PARSE_FULL,
        PARSE_HEADERS,
        PARSE_TIMESTAMPS;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ParseType swigToEnum(int swigValue) {
            ParseType[] swigValues = (ParseType[])ParseType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ParseType swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ParseType.class + " with value " + swigValue);
        }

        private ParseType() {
            this.swigValue = SwigNext.next++;
        }

        private ParseType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ParseType(ParseType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        INBOUND,
        OUTBOUND;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Direction swigToEnum(int swigValue) {
            Direction[] swigValues = (Direction[])Direction.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Direction swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Direction.class + " with value " + swigValue);
        }

        private Direction() {
            this.swigValue = SwigNext.next++;
        }

        private Direction(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Direction(Direction swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

