/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.XugglerJNI;

public class IRational
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IRational(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIRationalUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IRational obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public IRational copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IRational retval = null;
        this.acquire();
        try {
            retval = new IRational(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IRational) {
            equal = ((IRational)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public String toString() {
        return "" + this.getNumerator() + "/" + this.getDenominator();
    }

    public boolean isPositive() {
        if (this.getDenominator() == 0) {
            return false;
        }
        return this.getDouble() > 0.0;
    }

    public static boolean positive(IRational num) {
        if (num == null) {
            return false;
        }
        return num.isPositive();
    }

    public boolean isNegative() {
        if (this.getDenominator() == 0) {
            return false;
        }
        return this.getDouble() < 0.0;
    }

    public static boolean negative(IRational num) {
        if (num == null) {
            return false;
        }
        return num.isNegative();
    }

    public int getNumerator() {
        return XugglerJNI.IRational_getNumerator(this.swigCPtr, this);
    }

    public int getDenominator() {
        return XugglerJNI.IRational_getDenominator(this.swigCPtr, this);
    }

    public IRational copy() {
        long cPtr = XugglerJNI.IRational_copy(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public int compareTo(IRational other) {
        return XugglerJNI.IRational_compareTo(this.swigCPtr, this, IRational.getCPtr(other), other);
    }

    public static int sCompareTo(IRational a, IRational b) {
        return XugglerJNI.IRational_sCompareTo(IRational.getCPtr(a), a, IRational.getCPtr(b), b);
    }

    public double getDouble() {
        return XugglerJNI.IRational_getDouble(this.swigCPtr, this);
    }

    public int reduce(long num, long den, long max) {
        return XugglerJNI.IRational_reduce(this.swigCPtr, this, num, den, max);
    }

    public static int sReduce(IRational dst, long num, long den, long max) {
        return XugglerJNI.IRational_sReduce(IRational.getCPtr(dst), dst, num, den, max);
    }

    public IRational multiply(IRational arg) {
        long cPtr = XugglerJNI.IRational_multiply(this.swigCPtr, this, IRational.getCPtr(arg), arg);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public static IRational sMultiply(IRational a, IRational b) {
        long cPtr = XugglerJNI.IRational_sMultiply(IRational.getCPtr(a), a, IRational.getCPtr(b), b);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public IRational divide(IRational arg) {
        long cPtr = XugglerJNI.IRational_divide(this.swigCPtr, this, IRational.getCPtr(arg), arg);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public static IRational sDivide(IRational a, IRational b) {
        long cPtr = XugglerJNI.IRational_sDivide(IRational.getCPtr(a), a, IRational.getCPtr(b), b);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public IRational subtract(IRational arg) {
        long cPtr = XugglerJNI.IRational_subtract(this.swigCPtr, this, IRational.getCPtr(arg), arg);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public static IRational sSubtract(IRational a, IRational b) {
        long cPtr = XugglerJNI.IRational_sSubtract(IRational.getCPtr(a), a, IRational.getCPtr(b), b);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public IRational add(IRational arg) {
        long cPtr = XugglerJNI.IRational_add(this.swigCPtr, this, IRational.getCPtr(arg), arg);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public static IRational sAdd(IRational a, IRational b) {
        long cPtr = XugglerJNI.IRational_sAdd(IRational.getCPtr(a), a, IRational.getCPtr(b), b);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public long rescale(long origValue, IRational origBase) {
        return XugglerJNI.IRational_rescale(this.swigCPtr, this, origValue, IRational.getCPtr(origBase), origBase);
    }

    public static long sRescale(long origValue, IRational origBase, IRational newBase) {
        return XugglerJNI.IRational_sRescale(origValue, IRational.getCPtr(origBase), origBase, IRational.getCPtr(newBase), newBase);
    }

    public static IRational make() {
        long cPtr = XugglerJNI.IRational_make__SWIG_0();
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public static IRational make(double d) {
        long cPtr = XugglerJNI.IRational_make__SWIG_1(d);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public static IRational make(IRational src) {
        long cPtr = XugglerJNI.IRational_make__SWIG_2(IRational.getCPtr(src), src);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public static IRational make(int num, int den) {
        long cPtr = XugglerJNI.IRational_make__SWIG_3(num, den);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }
}

