/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.XugglerJNI;

public class IProperty
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IProperty(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIPropertyUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IProperty obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public IProperty copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IProperty retval = null;
        this.acquire();
        try {
            retval = new IProperty(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IProperty) {
            equal = ((IProperty)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public String getName() {
        return XugglerJNI.IProperty_getName(this.swigCPtr, this);
    }

    public String getHelp() {
        return XugglerJNI.IProperty_getHelp(this.swigCPtr, this);
    }

    public String getUnit() {
        return XugglerJNI.IProperty_getUnit(this.swigCPtr, this);
    }

    public Type getType() {
        return Type.swigToEnum(XugglerJNI.IProperty_getType(this.swigCPtr, this));
    }

    public int getFlags() {
        return XugglerJNI.IProperty_getFlags(this.swigCPtr, this);
    }

    public long getDefault() {
        return XugglerJNI.IProperty_getDefault(this.swigCPtr, this);
    }

    public double getDefaultAsDouble() {
        return XugglerJNI.IProperty_getDefaultAsDouble(this.swigCPtr, this);
    }

    public int getNumFlagSettings() {
        return XugglerJNI.IProperty_getNumFlagSettings(this.swigCPtr, this);
    }

    public IProperty getFlagConstant(int position) {
        long cPtr = XugglerJNI.IProperty_getFlagConstant__SWIG_0(this.swigCPtr, this, position);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    public IProperty getFlagConstant(String name) {
        long cPtr = XugglerJNI.IProperty_getFlagConstant__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flags {
        FLAG_ENCODING_PARAM(XugglerJNI.IProperty_FLAG_ENCODING_PARAM_get()),
        FLAG_DECODING_PARAM(XugglerJNI.IProperty_FLAG_DECODING_PARAM_get()),
        FLAG_METADATA(XugglerJNI.IProperty_FLAG_METADATA_get()),
        FLAG_AUDIO_PARAM(XugglerJNI.IProperty_FLAG_AUDIO_PARAM_get()),
        FLAG_VIDEO_PARAM(XugglerJNI.IProperty_FLAG_VIDEO_PARAM_get()),
        FLAG_SUBTITLE_PARAM(XugglerJNI.IProperty_FLAG_SUBTITLE_PARAM_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flags swigToEnum(int swigValue) {
            Flags[] swigValues = (Flags[])Flags.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flags swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flags.class + " with value " + swigValue);
        }

        private Flags() {
            this.swigValue = SwigNext.next++;
        }

        private Flags(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flags(Flags swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PROPERTY_FLAGS,
        PROPERTY_INT,
        PROPERTY_INT64,
        PROPERTY_DOUBLE,
        PROPERTY_FLOAT,
        PROPERTY_STRING,
        PROPERTY_RATIONAL,
        PROPERTY_BINARY,
        PROPERTY_CONST(XugglerJNI.IProperty_PROPERTY_CONST_get()),
        PROPERTY_UNKNOWN(XugglerJNI.IProperty_PROPERTY_UNKNOWN_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

