/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.XugglerJNI;

public class IMediaDataWrapper
extends IMediaData {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IMediaDataWrapper(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIMediaDataWrapperUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IMediaDataWrapper obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public IMediaDataWrapper copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IMediaDataWrapper retval = null;
        this.acquire();
        try {
            retval = new IMediaDataWrapper(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IMediaDataWrapper) {
            equal = ((IMediaDataWrapper)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public IMediaData get() {
        IMediaData retval = null;
        retval = this.getVideoPicture();
        if (retval == null && (retval = this.getAudioSamples()) == null && (retval = this.getPacket()) == null && (retval = this.getMediaDataWrapper()) == null) {
            retval = null;
        }
        return retval;
    }

    public IMediaData unwrap() {
        IMediaData retval = null;
        retval = this.unwrapVideoPicture();
        if (retval == null && (retval = this.unwrapAudioSamples()) == null && (retval = this.unwrapPacket()) == null && (retval = this.unwrapMediaDataWrapper()) == null) {
            retval = null;
        }
        return retval;
    }

    public void wrap(IMediaData aObj) {
        XugglerJNI.IMediaDataWrapper_wrap(this.swigCPtr, this, IMediaData.getCPtr(aObj), aObj);
    }

    public void setKey(boolean aIsKey) {
        XugglerJNI.IMediaDataWrapper_setKey(this.swigCPtr, this, aIsKey);
    }

    public static IMediaDataWrapper make(IMediaData obj) {
        long cPtr = XugglerJNI.IMediaDataWrapper_make(IMediaData.getCPtr(obj), obj);
        return cPtr == 0L ? null : new IMediaDataWrapper(cPtr, false);
    }

    protected IPacket getPacket() {
        long cPtr = XugglerJNI.IMediaDataWrapper_getPacket(this.swigCPtr, this);
        return cPtr == 0L ? null : new IPacket(cPtr, false);
    }

    protected IAudioSamples getAudioSamples() {
        long cPtr = XugglerJNI.IMediaDataWrapper_getAudioSamples(this.swigCPtr, this);
        return cPtr == 0L ? null : new IAudioSamples(cPtr, false);
    }

    protected IVideoPicture getVideoPicture() {
        long cPtr = XugglerJNI.IMediaDataWrapper_getVideoPicture(this.swigCPtr, this);
        return cPtr == 0L ? null : new IVideoPicture(cPtr, false);
    }

    protected IMediaDataWrapper getMediaDataWrapper() {
        long cPtr = XugglerJNI.IMediaDataWrapper_getMediaDataWrapper(this.swigCPtr, this);
        return cPtr == 0L ? null : new IMediaDataWrapper(cPtr, false);
    }

    protected IPacket unwrapPacket() {
        long cPtr = XugglerJNI.IMediaDataWrapper_unwrapPacket(this.swigCPtr, this);
        return cPtr == 0L ? null : new IPacket(cPtr, false);
    }

    protected IAudioSamples unwrapAudioSamples() {
        long cPtr = XugglerJNI.IMediaDataWrapper_unwrapAudioSamples(this.swigCPtr, this);
        return cPtr == 0L ? null : new IAudioSamples(cPtr, false);
    }

    protected IVideoPicture unwrapVideoPicture() {
        long cPtr = XugglerJNI.IMediaDataWrapper_unwrapVideoPicture(this.swigCPtr, this);
        return cPtr == 0L ? null : new IVideoPicture(cPtr, false);
    }

    protected IMediaDataWrapper unwrapMediaDataWrapper() {
        long cPtr = XugglerJNI.IMediaDataWrapper_unwrapMediaDataWrapper(this.swigCPtr, this);
        return cPtr == 0L ? null : new IMediaDataWrapper(cPtr, false);
    }
}

