/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.JNIReference;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.XugglerJNI;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMediaData
extends RefCounted {
    private volatile long swigCPtr;
    private static final long TIME_OFFSET = -Calendar.getInstance().getTimeZone().getRawOffset();
    public static final String DEFALUT_TIME_STAMP_FORMAT = "%1$tH:%1$tM:%1$tS.%1$tL";

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IMediaData(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIMediaDataUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IMediaData obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IMediaData copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IMediaData retval = null;
        this.acquire();
        try {
            retval = new IMediaData(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IMediaData) {
            equal = ((IMediaData)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.put(src, srcPos, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, byte[] dest, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.get(srcPos, dest, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(char[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.put(src, srcPos, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, char[] dest, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.get(srcPos, dest, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(short[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.put(src, srcPos, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, short[] dest, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.get(srcPos, dest, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.put(src, srcPos, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, int[] dest, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.get(srcPos, dest, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.put(src, srcPos, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, long[] dest, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.get(srcPos, dest, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(float[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.put(src, srcPos, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, float[] dest, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.get(srcPos, dest, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(double[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.put(src, srcPos, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, double[] dest, int destPos, int length) {
        IBuffer buffer = this.getData();
        try {
            if (buffer == null) {
                return;
            }
            buffer.get(srcPos, dest, destPos, length);
            return;
        }
        finally {
            if (buffer != null) {
                buffer.delete();
            }
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.getByteBuffer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer(AtomicReference<JNIReference> ref) {
        IBuffer buf;
        if (ref != null) {
            ref.set(null);
        }
        if ((buf = this.getData()) == null) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = buf.getByteBuffer(0, this.getSize(), ref);
            if (byteBuffer != null) {
                byteBuffer.position(0);
                byteBuffer.mark();
                byteBuffer.limit(this.getSize());
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            buf.delete();
        }
    }

    public String getFormattedTimeStamp() {
        return this.getFormattedTimeStamp(DEFALUT_TIME_STAMP_FORMAT);
    }

    public String getFormattedTimeStamp(String format) {
        Formatter formatter = new Formatter();
        return formatter.format(format, (long)((double)this.getTimeStamp() * this.getTimeBase().getDouble() * 1000.0) + TIME_OFFSET).toString();
    }

    public long getTimeStamp() {
        return XugglerJNI.IMediaData_getTimeStamp(this.swigCPtr, this);
    }

    public void setTimeStamp(long aTimeStamp) {
        XugglerJNI.IMediaData_setTimeStamp(this.swigCPtr, this, aTimeStamp);
    }

    public IRational getTimeBase() {
        long cPtr = XugglerJNI.IMediaData_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public void setTimeBase(IRational aBase) {
        XugglerJNI.IMediaData_setTimeBase(this.swigCPtr, this, IRational.getCPtr(aBase), aBase);
    }

    public IBuffer getData() {
        long cPtr = XugglerJNI.IMediaData_getData(this.swigCPtr, this);
        return cPtr == 0L ? null : new IBuffer(cPtr, false);
    }

    public int getSize() {
        return XugglerJNI.IMediaData_getSize(this.swigCPtr, this);
    }

    public boolean isKey() {
        return XugglerJNI.IMediaData_isKey(this.swigCPtr, this);
    }
}

