/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.XugglerJNI;

public class IContainerParameters
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IContainerParameters(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIContainerParametersUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IContainerParameters obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public IContainerParameters copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IContainerParameters retval = null;
        this.acquire();
        try {
            retval = new IContainerParameters(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IContainerParameters) {
            equal = ((IContainerParameters)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public IRational getTimeBase() {
        long cPtr = XugglerJNI.IContainerParameters_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public void setTimeBase(IRational base) {
        XugglerJNI.IContainerParameters_setTimeBase(this.swigCPtr, this, IRational.getCPtr(base), base);
    }

    public int getAudioSampleRate() {
        return XugglerJNI.IContainerParameters_getAudioSampleRate(this.swigCPtr, this);
    }

    public void setAudioSampleRate(int sampleRate) {
        XugglerJNI.IContainerParameters_setAudioSampleRate(this.swigCPtr, this, sampleRate);
    }

    public int getAudioChannels() {
        return XugglerJNI.IContainerParameters_getAudioChannels(this.swigCPtr, this);
    }

    public void setAudioChannels(int channels) {
        XugglerJNI.IContainerParameters_setAudioChannels(this.swigCPtr, this, channels);
    }

    public int getVideoWidth() {
        return XugglerJNI.IContainerParameters_getVideoWidth(this.swigCPtr, this);
    }

    public void setVideoWidth(int width) {
        XugglerJNI.IContainerParameters_setVideoWidth(this.swigCPtr, this, width);
    }

    public int getVideoHeight() {
        return XugglerJNI.IContainerParameters_getVideoHeight(this.swigCPtr, this);
    }

    public void setVideoHeight(int height) {
        XugglerJNI.IContainerParameters_setVideoHeight(this.swigCPtr, this, height);
    }

    public IPixelFormat.Type getPixelFormat() {
        return IPixelFormat.Type.swigToEnum(XugglerJNI.IContainerParameters_getPixelFormat(this.swigCPtr, this));
    }

    public void setPixelFormat(IPixelFormat.Type type) {
        XugglerJNI.IContainerParameters_setPixelFormat(this.swigCPtr, this, type.swigValue());
    }

    public int getTVChannel() {
        return XugglerJNI.IContainerParameters_getTVChannel(this.swigCPtr, this);
    }

    public void setTVChannel(int channel) {
        XugglerJNI.IContainerParameters_setTVChannel(this.swigCPtr, this, channel);
    }

    public String getTVStandard() {
        return XugglerJNI.IContainerParameters_getTVStandard(this.swigCPtr, this);
    }

    public void setTVStandard(String standard) {
        XugglerJNI.IContainerParameters_setTVStandard(this.swigCPtr, this, standard);
    }

    public boolean isMPEG2TSRaw() {
        return XugglerJNI.IContainerParameters_isMPEG2TSRaw(this.swigCPtr, this);
    }

    public void setMPEG2TSRaw(boolean setting) {
        XugglerJNI.IContainerParameters_setMPEG2TSRaw(this.swigCPtr, this, setting);
    }

    public boolean isMPEG2TSComputePCR() {
        return XugglerJNI.IContainerParameters_isMPEG2TSComputePCR(this.swigCPtr, this);
    }

    public void setMPEG2TSComputePCR(boolean setting) {
        XugglerJNI.IContainerParameters_setMPEG2TSComputePCR(this.swigCPtr, this, setting);
    }

    public boolean isInitialPause() {
        return XugglerJNI.IContainerParameters_isInitialPause(this.swigCPtr, this);
    }

    public void setInitialPause(boolean setting) {
        XugglerJNI.IContainerParameters_setInitialPause(this.swigCPtr, this, setting);
    }

    public static IContainerParameters make() {
        long cPtr = XugglerJNI.IContainerParameters_make();
        return cPtr == 0L ? null : new IContainerParameters(cPtr, false);
    }
}

