/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IConfigurable;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IContainerParameters;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IProperty;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.XugglerJNI;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.XugglerIO;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.ByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IContainer
extends RefCounted
implements IConfigurable {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IContainer(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIContainerUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IContainer obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public IContainer copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IContainer retval = null;
        this.acquire();
        try {
            retval = new IContainer(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IContainer) {
            equal = ((IContainer)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("url:" + this.getURL() + ";");
        result.append("type:" + (Object)((Object)this.getType()) + ";");
        result.append("format:" + this.getContainerFormat() + ";");
        result.append("]");
        return result.toString();
    }

    public int open(IURLProtocolHandler handler, Type type, IContainerFormat format) {
        return this.open(XugglerIO.map(handler), type, format);
    }

    public int open(OutputStream output, IContainerFormat format) {
        return this.open(XugglerIO.map(output), Type.WRITE, format);
    }

    public int open(InputStream input, IContainerFormat format) {
        return this.open(XugglerIO.map(input), Type.READ, format);
    }

    public int open(DataOutput output, IContainerFormat format) {
        return this.open(XugglerIO.map(output), Type.WRITE, format);
    }

    public int open(DataOutputStream output, IContainerFormat format) {
        return this.open(XugglerIO.map(output), Type.WRITE, format);
    }

    public int open(DataInput input, IContainerFormat format) {
        return this.open(XugglerIO.map(input), Type.READ, format);
    }

    public int open(DataInputStream input, IContainerFormat format) {
        return this.open(XugglerIO.map(input), Type.READ, format);
    }

    public int open(RandomAccessFile file, Type type, IContainerFormat format) {
        return this.open(XugglerIO.map(file), type, format);
    }

    public int open(WritableByteChannel output, IContainerFormat format) {
        return this.open(XugglerIO.map(output), Type.WRITE, format);
    }

    public int open(ReadableByteChannel input, IContainerFormat format) {
        return this.open(XugglerIO.map(input), Type.READ, format);
    }

    public int open(ByteChannel channel, Type type, IContainerFormat format) {
        return this.open(XugglerIO.map(channel), type, format);
    }

    public int open(IURLProtocolHandler handler, Type type, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(handler), type, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(OutputStream output, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(output), Type.WRITE, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(InputStream input, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(input), Type.READ, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(DataOutput output, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(output), Type.WRITE, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(DataOutputStream output, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(output), Type.WRITE, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(DataInput input, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(input), Type.READ, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(DataInputStream input, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(input), Type.READ, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(RandomAccessFile file, Type type, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(file), type, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(WritableByteChannel output, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(output), Type.WRITE, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(ReadableByteChannel input, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(input), Type.READ, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(ByteChannel channel, Type type, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(channel), type, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int setInputBufferLength(long size) {
        return XugglerJNI.IContainer_setInputBufferLength(this.swigCPtr, this, size);
    }

    public long getInputBufferLength() {
        return XugglerJNI.IContainer_getInputBufferLength(this.swigCPtr, this);
    }

    public boolean isOpened() {
        return XugglerJNI.IContainer_isOpened(this.swigCPtr, this);
    }

    public boolean isHeaderWritten() {
        return XugglerJNI.IContainer_isHeaderWritten(this.swigCPtr, this);
    }

    public int open(String url, Type type, IContainerFormat pContainerFormat) {
        return XugglerJNI.IContainer_open__SWIG_0(this.swigCPtr, this, url, type.swigValue(), IContainerFormat.getCPtr(pContainerFormat), pContainerFormat);
    }

    public int open(String url, Type type, IContainerFormat pContainerFormat, boolean aStreamsCanBeAddedDynamically, boolean aQueryStreamMetaData) {
        return XugglerJNI.IContainer_open__SWIG_1(this.swigCPtr, this, url, type.swigValue(), IContainerFormat.getCPtr(pContainerFormat), pContainerFormat, aStreamsCanBeAddedDynamically, aQueryStreamMetaData);
    }

    public IContainerFormat getContainerFormat() {
        long cPtr = XugglerJNI.IContainer_getContainerFormat(this.swigCPtr, this);
        return cPtr == 0L ? null : new IContainerFormat(cPtr, false);
    }

    public int close() {
        return XugglerJNI.IContainer_close(this.swigCPtr, this);
    }

    public Type getType() {
        return Type.swigToEnum(XugglerJNI.IContainer_getType(this.swigCPtr, this));
    }

    public int getNumStreams() {
        return XugglerJNI.IContainer_getNumStreams(this.swigCPtr, this);
    }

    public IStream getStream(long streamIndex) {
        long cPtr = XugglerJNI.IContainer_getStream(this.swigCPtr, this, streamIndex);
        return cPtr == 0L ? null : new IStream(cPtr, false);
    }

    public IStream addNewStream(int id) {
        long cPtr = XugglerJNI.IContainer_addNewStream(this.swigCPtr, this, id);
        return cPtr == 0L ? null : new IStream(cPtr, false);
    }

    public int writeHeader() {
        return XugglerJNI.IContainer_writeHeader(this.swigCPtr, this);
    }

    public int writeTrailer() {
        return XugglerJNI.IContainer_writeTrailer(this.swigCPtr, this);
    }

    public int readNextPacket(IPacket packet) {
        return XugglerJNI.IContainer_readNextPacket(this.swigCPtr, this, IPacket.getCPtr(packet), packet);
    }

    public int writePacket(IPacket packet, boolean forceInterleave) {
        return XugglerJNI.IContainer_writePacket__SWIG_0(this.swigCPtr, this, IPacket.getCPtr(packet), packet, forceInterleave);
    }

    public int writePacket(IPacket packet) {
        return XugglerJNI.IContainer_writePacket__SWIG_1(this.swigCPtr, this, IPacket.getCPtr(packet), packet);
    }

    public static IContainer make() {
        long cPtr = XugglerJNI.IContainer_make();
        return cPtr == 0L ? null : new IContainer(cPtr, false);
    }

    public int queryStreamMetaData() {
        return XugglerJNI.IContainer_queryStreamMetaData(this.swigCPtr, this);
    }

    public int seekKeyFrame(int streamIndex, long timestamp, int flags) {
        return XugglerJNI.IContainer_seekKeyFrame(this.swigCPtr, this, streamIndex, timestamp, flags);
    }

    public long getDuration() {
        return XugglerJNI.IContainer_getDuration(this.swigCPtr, this);
    }

    public long getStartTime() {
        return XugglerJNI.IContainer_getStartTime(this.swigCPtr, this);
    }

    public long getFileSize() {
        return XugglerJNI.IContainer_getFileSize(this.swigCPtr, this);
    }

    public int getBitRate() {
        return XugglerJNI.IContainer_getBitRate(this.swigCPtr, this);
    }

    public int getNumProperties() {
        return XugglerJNI.IContainer_getNumProperties(this.swigCPtr, this);
    }

    public IProperty getPropertyMetaData(int propertyNo) {
        long cPtr = XugglerJNI.IContainer_getPropertyMetaData__SWIG_0(this.swigCPtr, this, propertyNo);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    public IProperty getPropertyMetaData(String name) {
        long cPtr = XugglerJNI.IContainer_getPropertyMetaData__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    public int setProperty(String name, String value) {
        return XugglerJNI.IContainer_setProperty__SWIG_0(this.swigCPtr, this, name, value);
    }

    public int setProperty(String name, double value) {
        return XugglerJNI.IContainer_setProperty__SWIG_1(this.swigCPtr, this, name, value);
    }

    public int setProperty(String name, long value) {
        return XugglerJNI.IContainer_setProperty__SWIG_2(this.swigCPtr, this, name, value);
    }

    public int setProperty(String name, boolean value) {
        return XugglerJNI.IContainer_setProperty__SWIG_3(this.swigCPtr, this, name, value);
    }

    public int setProperty(String name, IRational value) {
        return XugglerJNI.IContainer_setProperty__SWIG_4(this.swigCPtr, this, name, IRational.getCPtr(value), value);
    }

    public String getPropertyAsString(String name) {
        return XugglerJNI.IContainer_getPropertyAsString(this.swigCPtr, this, name);
    }

    public double getPropertyAsDouble(String name) {
        return XugglerJNI.IContainer_getPropertyAsDouble(this.swigCPtr, this, name);
    }

    public long getPropertyAsLong(String name) {
        return XugglerJNI.IContainer_getPropertyAsLong(this.swigCPtr, this, name);
    }

    public IRational getPropertyAsRational(String name) {
        long cPtr = XugglerJNI.IContainer_getPropertyAsRational(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public boolean getPropertyAsBoolean(String name) {
        return XugglerJNI.IContainer_getPropertyAsBoolean(this.swigCPtr, this, name);
    }

    public int getFlags() {
        return XugglerJNI.IContainer_getFlags(this.swigCPtr, this);
    }

    public void setFlags(int newFlags) {
        XugglerJNI.IContainer_setFlags(this.swigCPtr, this, newFlags);
    }

    public boolean getFlag(Flags flag) {
        return XugglerJNI.IContainer_getFlag(this.swigCPtr, this, flag.swigValue());
    }

    public void setFlag(Flags flag, boolean value) {
        XugglerJNI.IContainer_setFlag(this.swigCPtr, this, flag.swigValue(), value);
    }

    public String getURL() {
        return XugglerJNI.IContainer_getURL(this.swigCPtr, this);
    }

    public int flushPackets() {
        return XugglerJNI.IContainer_flushPackets(this.swigCPtr, this);
    }

    public int getReadRetryCount() {
        return XugglerJNI.IContainer_getReadRetryCount(this.swigCPtr, this);
    }

    public void setReadRetryCount(int count) {
        XugglerJNI.IContainer_setReadRetryCount(this.swigCPtr, this, count);
    }

    public IContainerParameters getParameters() {
        long cPtr = XugglerJNI.IContainer_getParameters(this.swigCPtr, this);
        return cPtr == 0L ? null : new IContainerParameters(cPtr, false);
    }

    public void setParameters(IContainerParameters parameters) {
        XugglerJNI.IContainer_setParameters(this.swigCPtr, this, IContainerParameters.getCPtr(parameters), parameters);
    }

    public boolean canStreamsBeAddedDynamically() {
        return XugglerJNI.IContainer_canStreamsBeAddedDynamically(this.swigCPtr, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flags {
        FLAG_GENPTS(XugglerJNI.IContainer_FLAG_GENPTS_get()),
        FLAG_IGNIDX(XugglerJNI.IContainer_FLAG_IGNIDX_get()),
        FLAG_NONBLOCK(XugglerJNI.IContainer_FLAG_NONBLOCK_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flags swigToEnum(int swigValue) {
            Flags[] swigValues = (Flags[])Flags.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flags swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flags.class + " with value " + swigValue);
        }

        private Flags() {
            this.swigValue = SwigNext.next++;
        }

        private Flags(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flags(Flags swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        READ,
        WRITE;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

