/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.XugglerJNI;

public class IAudioSamples
extends IMediaData {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IAudioSamples(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIAudioSamplesUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IAudioSamples obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public IAudioSamples copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IAudioSamples retval = null;
        this.acquire();
        try {
            retval = new IAudioSamples(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IAudioSamples) {
            equal = ((IAudioSamples)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("sample rate:" + this.getSampleRate() + ";");
        result.append("channels:" + this.getChannels() + ";");
        result.append("format:" + (Object)((Object)this.getFormat()) + ";");
        result.append("time stamp:" + this.getTimeStamp() + ";");
        result.append("complete:" + this.isComplete() + ";");
        result.append("num samples:" + this.getNumSamples() + ";");
        result.append("size:" + this.getSize() + ";");
        result.append("key:" + this.isKey() + ";");
        result.append("time base:" + IRational.make(1, (int)Global.DEFAULT_PTS_PER_SECOND) + ";");
        result.append("]");
        return result.toString();
    }

    public boolean isComplete() {
        return XugglerJNI.IAudioSamples_isComplete(this.swigCPtr, this);
    }

    public int getSampleRate() {
        return XugglerJNI.IAudioSamples_getSampleRate(this.swigCPtr, this);
    }

    public int getChannels() {
        return XugglerJNI.IAudioSamples_getChannels(this.swigCPtr, this);
    }

    public long getSampleBitDepth() {
        return XugglerJNI.IAudioSamples_getSampleBitDepth(this.swigCPtr, this);
    }

    public Format getFormat() {
        return Format.swigToEnum(XugglerJNI.IAudioSamples_getFormat(this.swigCPtr, this));
    }

    public long getNumSamples() {
        return XugglerJNI.IAudioSamples_getNumSamples(this.swigCPtr, this);
    }

    public long getMaxBufferSize() {
        return XugglerJNI.IAudioSamples_getMaxBufferSize(this.swigCPtr, this);
    }

    public long getMaxSamples() {
        return XugglerJNI.IAudioSamples_getMaxSamples(this.swigCPtr, this);
    }

    public long getSampleSize() {
        return XugglerJNI.IAudioSamples_getSampleSize(this.swigCPtr, this);
    }

    public long getPts() {
        return XugglerJNI.IAudioSamples_getPts(this.swigCPtr, this);
    }

    public void setPts(long aValue) {
        XugglerJNI.IAudioSamples_setPts(this.swigCPtr, this, aValue);
    }

    public long getNextPts() {
        return XugglerJNI.IAudioSamples_getNextPts(this.swigCPtr, this);
    }

    public void setComplete(boolean complete, long numSamples, int sampleRate, int channels, Format format, long pts) {
        XugglerJNI.IAudioSamples_setComplete(this.swigCPtr, this, complete, numSamples, sampleRate, channels, format.swigValue(), pts);
    }

    public int setSample(long sampleIndex, int channel, Format format, int sample) {
        return XugglerJNI.IAudioSamples_setSample(this.swigCPtr, this, sampleIndex, channel, format.swigValue(), sample);
    }

    public int getSample(long sampleIndex, int channel, Format format) {
        return XugglerJNI.IAudioSamples_getSample(this.swigCPtr, this, sampleIndex, channel, format.swigValue());
    }

    public static long findSampleBitDepth(Format format) {
        return XugglerJNI.IAudioSamples_findSampleBitDepth(format.swigValue());
    }

    public static IAudioSamples make(long numSamples, long numChannels) {
        long cPtr = XugglerJNI.IAudioSamples_make(numSamples, numChannels);
        return cPtr == 0L ? null : new IAudioSamples(cPtr, false);
    }

    public static long samplesToDefaultPts(long samples, int sampleRate) {
        return XugglerJNI.IAudioSamples_samplesToDefaultPts(samples, sampleRate);
    }

    public static long defaultPtsToSamples(long duration, int sampleRate) {
        return XugglerJNI.IAudioSamples_defaultPtsToSamples(duration, sampleRate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelLayout {
        CH_FRONT_LEFT(XugglerJNI.IAudioSamples_CH_FRONT_LEFT_get()),
        CH_FRONT_RIGHT(XugglerJNI.IAudioSamples_CH_FRONT_RIGHT_get()),
        CH_FRONT_CENTER(XugglerJNI.IAudioSamples_CH_FRONT_CENTER_get()),
        CH_LOW_FREQUENCY(XugglerJNI.IAudioSamples_CH_LOW_FREQUENCY_get()),
        CH_BACK_LEFT(XugglerJNI.IAudioSamples_CH_BACK_LEFT_get()),
        CH_BACK_RIGHT(XugglerJNI.IAudioSamples_CH_BACK_RIGHT_get()),
        CH_FRONT_LEFT_OF_CENTER(XugglerJNI.IAudioSamples_CH_FRONT_LEFT_OF_CENTER_get()),
        CH_FRONT_RIGHT_OF_CENTER(XugglerJNI.IAudioSamples_CH_FRONT_RIGHT_OF_CENTER_get()),
        CH_BACK_CENTER(XugglerJNI.IAudioSamples_CH_BACK_CENTER_get()),
        CH_SIDE_LEFT(XugglerJNI.IAudioSamples_CH_SIDE_LEFT_get()),
        CH_SIDE_RIGHT(XugglerJNI.IAudioSamples_CH_SIDE_RIGHT_get()),
        CH_TOP_CENTER(XugglerJNI.IAudioSamples_CH_TOP_CENTER_get()),
        CH_TOP_FRONT_LEFT(XugglerJNI.IAudioSamples_CH_TOP_FRONT_LEFT_get()),
        CH_TOP_FRONT_CENTER(XugglerJNI.IAudioSamples_CH_TOP_FRONT_CENTER_get()),
        CH_TOP_FRONT_RIGHT(XugglerJNI.IAudioSamples_CH_TOP_FRONT_RIGHT_get()),
        CH_TOP_BACK_LEFT(XugglerJNI.IAudioSamples_CH_TOP_BACK_LEFT_get()),
        CH_TOP_BACK_CENTER(XugglerJNI.IAudioSamples_CH_TOP_BACK_CENTER_get()),
        CH_TOP_BACK_RIGHT(XugglerJNI.IAudioSamples_CH_TOP_BACK_RIGHT_get()),
        CH_STEREO_LEFT(XugglerJNI.IAudioSamples_CH_STEREO_LEFT_get()),
        CH_STEREO_RIGHT(XugglerJNI.IAudioSamples_CH_STEREO_RIGHT_get()),
        CH_LAYOUT_MONO(XugglerJNI.IAudioSamples_CH_LAYOUT_MONO_get()),
        CH_LAYOUT_STEREO(XugglerJNI.IAudioSamples_CH_LAYOUT_STEREO_get()),
        CH_LAYOUT_2_1(XugglerJNI.IAudioSamples_CH_LAYOUT_2_1_get()),
        CH_LAYOUT_SURROUND(XugglerJNI.IAudioSamples_CH_LAYOUT_SURROUND_get()),
        CH_LAYOUT_4POINT0(XugglerJNI.IAudioSamples_CH_LAYOUT_4POINT0_get()),
        CH_LAYOUT_2_2(XugglerJNI.IAudioSamples_CH_LAYOUT_2_2_get()),
        CH_LAYOUT_QUAD(XugglerJNI.IAudioSamples_CH_LAYOUT_QUAD_get()),
        CH_LAYOUT_5POINT0(XugglerJNI.IAudioSamples_CH_LAYOUT_5POINT0_get()),
        CH_LAYOUT_5POINT1(XugglerJNI.IAudioSamples_CH_LAYOUT_5POINT1_get()),
        CH_LAYOUT_5POINT0_BACK(XugglerJNI.IAudioSamples_CH_LAYOUT_5POINT0_BACK_get()),
        CH_LAYOUT_5POINT1_BACK(XugglerJNI.IAudioSamples_CH_LAYOUT_5POINT1_BACK_get()),
        CH_LAYOUT_7POINT1(XugglerJNI.IAudioSamples_CH_LAYOUT_7POINT1_get()),
        CH_LAYOUT_7POINT1_WIDE(XugglerJNI.IAudioSamples_CH_LAYOUT_7POINT1_WIDE_get()),
        CH_LAYOUT_STEREO_DOWNMIX(XugglerJNI.IAudioSamples_CH_LAYOUT_STEREO_DOWNMIX_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ChannelLayout swigToEnum(int swigValue) {
            ChannelLayout[] swigValues = (ChannelLayout[])ChannelLayout.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ChannelLayout swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ChannelLayout.class + " with value " + swigValue);
        }

        private ChannelLayout() {
            this.swigValue = SwigNext.next++;
        }

        private ChannelLayout(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ChannelLayout(ChannelLayout swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        FMT_NONE(XugglerJNI.IAudioSamples_FMT_NONE_get()),
        FMT_U8,
        FMT_S16,
        FMT_S24,
        FMT_S32,
        FMT_FLT;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Format swigToEnum(int swigValue) {
            Format[] swigValues = (Format[])Format.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Format swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Format.class + " with value " + swigValue);
        }

        private Format() {
            this.swigValue = SwigNext.next++;
        }

        private Format(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Format(Format swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

