/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.XugglerJNI;

public class IAudioResampler
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IAudioResampler(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIAudioResamplerUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IAudioResampler obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public IAudioResampler copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IAudioResampler retval = null;
        this.acquire();
        try {
            retval = new IAudioResampler(this.swigCPtr, false);
        }
        catch (Throwable t) {
            this.release();
            throw new RuntimeException(t);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IAudioResampler) {
            equal = ((IAudioResampler)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public int getOutputChannels() {
        return XugglerJNI.IAudioResampler_getOutputChannels(this.swigCPtr, this);
    }

    public int getOutputRate() {
        return XugglerJNI.IAudioResampler_getOutputRate(this.swigCPtr, this);
    }

    public int getInputChannels() {
        return XugglerJNI.IAudioResampler_getInputChannels(this.swigCPtr, this);
    }

    public int getInputRate() {
        return XugglerJNI.IAudioResampler_getInputRate(this.swigCPtr, this);
    }

    public int resample(IAudioSamples outputSamples, IAudioSamples inputSamples, long numSamples) {
        return XugglerJNI.IAudioResampler_resample(this.swigCPtr, this, IAudioSamples.getCPtr(outputSamples), outputSamples, IAudioSamples.getCPtr(inputSamples), inputSamples, numSamples);
    }

    public static IAudioResampler make(int outputChannels, int inputChannels, int outputRate, int inputRate) {
        long cPtr = XugglerJNI.IAudioResampler_make__SWIG_0(outputChannels, inputChannels, outputRate, inputRate);
        return cPtr == 0L ? null : new IAudioResampler(cPtr, false);
    }

    public IAudioSamples.Format getOutputFormat() {
        return IAudioSamples.Format.swigToEnum(XugglerJNI.IAudioResampler_getOutputFormat(this.swigCPtr, this));
    }

    public IAudioSamples.Format getInputFormat() {
        return IAudioSamples.Format.swigToEnum(XugglerJNI.IAudioResampler_getInputFormat(this.swigCPtr, this));
    }

    public int getFilterLen() {
        return XugglerJNI.IAudioResampler_getFilterLen(this.swigCPtr, this);
    }

    public int getLog2PhaseCount() {
        return XugglerJNI.IAudioResampler_getLog2PhaseCount(this.swigCPtr, this);
    }

    public boolean isLinear() {
        return XugglerJNI.IAudioResampler_isLinear(this.swigCPtr, this);
    }

    public double getCutoffFrequency() {
        return XugglerJNI.IAudioResampler_getCutoffFrequency(this.swigCPtr, this);
    }

    public static IAudioResampler make(int outputChannels, int inputChannels, int outputRate, int inputRate, IAudioSamples.Format outputFmt, IAudioSamples.Format inputFmt) {
        long cPtr = XugglerJNI.IAudioResampler_make__SWIG_1(outputChannels, inputChannels, outputRate, inputRate, outputFmt.swigValue(), inputFmt.swigValue());
        return cPtr == 0L ? null : new IAudioResampler(cPtr, false);
    }

    public static IAudioResampler make(int outputChannels, int inputChannels, int outputRate, int inputRate, IAudioSamples.Format outputFmt, IAudioSamples.Format inputFmt, int filterLen, int log2PhaseCount, boolean isLinear, double cutoffFrequency) {
        long cPtr = XugglerJNI.IAudioResampler_make__SWIG_2(outputChannels, inputChannels, outputRate, inputRate, outputFmt.swigValue(), inputFmt.swigValue(), filterLen, log2PhaseCount, isLinear, cutoffFrequency);
        return cPtr == 0L ? null : new IAudioResampler(cPtr, false);
    }
}

