/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioResampler;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.io.URLProtocolManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Converter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private IContainer mIContainer = null;
    private IContainer mOContainer = null;
    private IStream[] mIStreams = null;
    private IStreamCoder[] mICoders = null;
    private IStream[] mOStreams = null;
    private IStreamCoder[] mOCoders = null;
    private IVideoPicture[] mIVideoPictures = null;
    private IVideoPicture[] mOVideoPictures = null;
    private IAudioSamples[] mISamples = null;
    private IAudioSamples[] mOSamples = null;
    private IAudioResampler[] mASamplers = null;
    private IVideoResampler[] mVSamplers = null;
    private boolean mHasAudio = true;
    private boolean mHasVideo = true;
    private final boolean mForceInterleave = true;

    public Options defineOptions() {
        Options options = new Options();
        Option help = new Option("help", "print this message");
        OptionBuilder.withArgName((String)"container-format");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"output container format to use (e.g. \"mov\")");
        Option containerFormat = OptionBuilder.create((String)"containerformat");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"no audio");
        Option ano = OptionBuilder.create((String)"ano");
        OptionBuilder.withArgName((String)"codec");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"audio codec to encode with (e.g. \"libmp3lame\")");
        Option acodec = OptionBuilder.create((String)"acodec");
        OptionBuilder.withArgName((String)"sample-rate");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"audio sample rate to (up/down) encode with (in hz) (e.g. \"22050\")");
        Option asamplerate = OptionBuilder.create((String)"asamplerate");
        OptionBuilder.withArgName((String)"channels");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"number of audio channels (1 or 2) to encode with (e.g. \"2\")");
        Option achannels = OptionBuilder.create((String)"achannels");
        OptionBuilder.withArgName((String)"abit-rate");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"bit rate to encode audio with (in bps) (e.g. \"60000\")");
        Option abitrate = OptionBuilder.create((String)"abitrate");
        OptionBuilder.withArgName((String)"stream");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"if multiple audio streams of a given type, this is the stream you want to output");
        Option astream = OptionBuilder.create((String)"astream");
        OptionBuilder.withArgName((String)"quality");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"quality setting to use for audio.  0 means same as source; higher numbers are (perversely) lower quality.  Defaults to 0.");
        Option aquality = OptionBuilder.create((String)"aquality");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"no video");
        Option vno = OptionBuilder.create((String)"vno");
        OptionBuilder.withArgName((String)"codec");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"video codec to encode with (e.g. \"mpeg4\")");
        Option vcodec = OptionBuilder.create((String)"vcodec");
        OptionBuilder.withArgName((String)"factor");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"scaling factor to scale output video by (e.g. \"0.75\")");
        Option vscaleFactor = OptionBuilder.create((String)"vscalefactor");
        OptionBuilder.withArgName((String)"vbitrate");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"bit rate to encode video with (in bps) (e.g. \"60000\")");
        Option vbitrate = OptionBuilder.create((String)"vbitrate");
        OptionBuilder.withArgName((String)"vbitratetolerance");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"bit rate tolerance the bitstream is allowed to diverge from the reference (in bits) (e.g. \"1200000\")");
        Option vbitratetolerance = OptionBuilder.create((String)"vbitratetolerance");
        OptionBuilder.withArgName((String)"stream");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"if multiple video streams of a given type, this is the stream you want to output");
        Option vstream = OptionBuilder.create((String)"vstream");
        OptionBuilder.withArgName((String)"quality");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"quality setting to use for video.  0 means same as source; higher numbers are (perversely) lower quality.  Defaults to 0.");
        Option vquality = OptionBuilder.create((String)"vquality");
        options.addOption(help);
        options.addOption(containerFormat);
        options.addOption(ano);
        options.addOption(acodec);
        options.addOption(asamplerate);
        options.addOption(achannels);
        options.addOption(abitrate);
        options.addOption(astream);
        options.addOption(aquality);
        options.addOption(vno);
        options.addOption(vcodec);
        options.addOption(vscaleFactor);
        options.addOption(vbitrate);
        options.addOption(vbitratetolerance);
        options.addOption(vstream);
        options.addOption(vquality);
        return options;
    }

    public CommandLine parseOptions(Options opt, String[] args) throws ParseException {
        CommandLine cmdLine = null;
        GnuParser parser = new GnuParser();
        cmdLine = parser.parse(opt, args);
        if (cmdLine.hasOption("help")) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("Xuggler [options] input_url output_url", opt);
            System.exit(1);
        }
        if (cmdLine.getArgs().length != 2) {
            throw new ParseException("missing input or output url");
        }
        return cmdLine;
    }

    private int getIntOptionValue(CommandLine cmdLine, String key, int defaultVal) {
        int retval = defaultVal;
        String optValue = cmdLine.getOptionValue(key);
        if (optValue != null) {
            try {
                retval = Integer.parseInt(optValue);
            }
            catch (Exception ex) {
                this.log.warn("Option \"{}\" value \"{}\" cannot be converted to integer; using {} instead", new Object[]{key, optValue, defaultVal});
            }
        }
        return retval;
    }

    private double getDoubleOptionValue(CommandLine cmdLine, String key, double defaultVal) {
        double retval = defaultVal;
        String optValue = cmdLine.getOptionValue(key);
        if (optValue != null) {
            try {
                retval = Double.parseDouble(optValue);
            }
            catch (Exception ex) {
                this.log.warn("Option \"{}\" value \"{}\" cannot be converted to double; using {} instead", new Object[]{key, optValue, defaultVal});
            }
        }
        return retval;
    }

    int setupStreams(CommandLine cmdLine) {
        String inputURL = cmdLine.getArgs()[0];
        String outputURL = cmdLine.getArgs()[1];
        this.mHasAudio = !cmdLine.hasOption("ano");
        this.mHasVideo = !cmdLine.hasOption("vno");
        String acodec = cmdLine.getOptionValue("acodec");
        String vcodec = cmdLine.getOptionValue("vcodec");
        String containerFormat = cmdLine.getOptionValue("containerformat");
        int astream = this.getIntOptionValue(cmdLine, "astream", -1);
        int aquality = this.getIntOptionValue(cmdLine, "aquality", 0);
        int sampleRate = this.getIntOptionValue(cmdLine, "asamplerate", 0);
        int channels = this.getIntOptionValue(cmdLine, "achannels", 0);
        int abitrate = this.getIntOptionValue(cmdLine, "abitrate", 0);
        int vbitrate = this.getIntOptionValue(cmdLine, "vbitrate", 0);
        int vbitratetolerance = this.getIntOptionValue(cmdLine, "vbitratetolerance", 0);
        int vquality = this.getIntOptionValue(cmdLine, "vquality", 0);
        int vstream = this.getIntOptionValue(cmdLine, "vstream", -1);
        double vscaleFactor = this.getDoubleOptionValue(cmdLine, "vscalefactor", 1.0);
        int retval = 0;
        this.mIContainer = IContainer.make();
        this.mOContainer = IContainer.make();
        IContainerFormat oFmt = null;
        retval = this.mIContainer.open(inputURL, IContainer.Type.READ, null);
        if (retval < 0) {
            throw new RuntimeException("could not open url: " + inputURL);
        }
        if (containerFormat != null && (retval = (oFmt = IContainerFormat.make()).setOutputFormat(containerFormat, outputURL, null)) < 0) {
            throw new RuntimeException("could not find output container format: " + containerFormat);
        }
        retval = this.mOContainer.open(outputURL, IContainer.Type.WRITE, oFmt);
        if (retval < 0) {
            throw new RuntimeException("could not open output url: " + outputURL);
        }
        int numStreams = this.mIContainer.getNumStreams();
        if (numStreams <= 0) {
            throw new RuntimeException("not streams in input url: " + inputURL);
        }
        this.mIStreams = new IStream[numStreams];
        this.mICoders = new IStreamCoder[numStreams];
        this.mOStreams = new IStream[numStreams];
        this.mOCoders = new IStreamCoder[numStreams];
        this.mASamplers = new IAudioResampler[numStreams];
        this.mVSamplers = new IVideoResampler[numStreams];
        this.mIVideoPictures = new IVideoPicture[numStreams];
        this.mOVideoPictures = new IVideoPicture[numStreams];
        this.mISamples = new IAudioSamples[numStreams];
        this.mOSamples = new IAudioSamples[numStreams];
        for (int i = 0; i < numStreams; ++i) {
            IStreamCoder oc;
            IStream os;
            IStream is = this.mIContainer.getStream(i);
            IStreamCoder ic = is.getStreamCoder();
            ICodec.Type cType = ic.getCodecType();
            this.mIStreams[i] = is;
            this.mICoders[i] = ic;
            this.mOStreams[i] = null;
            this.mOCoders[i] = null;
            this.mASamplers[i] = null;
            this.mVSamplers[i] = null;
            this.mIVideoPictures[i] = null;
            this.mOVideoPictures[i] = null;
            this.mISamples[i] = null;
            this.mOSamples[i] = null;
            if (cType == ICodec.Type.CODEC_TYPE_AUDIO && this.mHasAudio && (astream == -1 || astream == i)) {
                ICodec codec;
                os = this.mOContainer.addNewStream(i);
                oc = os.getStreamCoder();
                this.mOStreams[i] = os;
                this.mOCoders[i] = oc;
                if (acodec != null) {
                    codec = null;
                    codec = ICodec.findEncodingCodecByName(acodec);
                    if (codec == null || codec.getType() != cType) {
                        throw new RuntimeException("could not find encoder: " + acodec);
                    }
                    oc.setCodec(codec);
                } else {
                    codec = ICodec.guessEncodingCodec(oFmt, null, outputURL, null, cType);
                    if (codec == null) {
                        throw new RuntimeException("could not guess " + (Object)((Object)cType) + " encoder for: " + outputURL);
                    }
                    oc.setCodec(codec);
                }
                if (sampleRate == 0) {
                    sampleRate = ic.getSampleRate();
                }
                oc.setSampleRate(sampleRate);
                if (abitrate == 0) {
                    abitrate = ic.getBitRate();
                }
                oc.setBitRate(abitrate);
                if (channels == 0) {
                    channels = ic.getChannels();
                }
                oc.setChannels(channels);
                oc.setGlobalQuality(aquality);
                if (oc.getChannels() != ic.getChannels() || oc.getSampleRate() != ic.getSampleRate()) {
                    this.mASamplers[i] = IAudioResampler.make(oc.getChannels(), ic.getChannels(), oc.getSampleRate(), ic.getSampleRate());
                    if (this.mASamplers[i] == null) {
                        throw new RuntimeException("could not open audio resampler for stream: " + i);
                    }
                } else {
                    this.mASamplers[i] = null;
                }
                this.mISamples[i] = IAudioSamples.make(1024L, ic.getChannels());
                this.mOSamples[i] = IAudioSamples.make(1024L, oc.getChannels());
            } else if (cType == ICodec.Type.CODEC_TYPE_VIDEO && this.mHasVideo && (vstream == -1 || vstream == i)) {
                ICodec codec;
                os = this.mOContainer.addNewStream(i);
                oc = os.getStreamCoder();
                this.mOStreams[i] = os;
                this.mOCoders[i] = oc;
                if (vcodec != null) {
                    codec = null;
                    codec = ICodec.findEncodingCodecByName(vcodec);
                    if (codec == null || codec.getType() != cType) {
                        throw new RuntimeException("could not find encoder: " + vcodec);
                    }
                    oc.setCodec(codec);
                    oc.setGlobalQuality(0);
                } else {
                    codec = ICodec.guessEncodingCodec(oFmt, null, outputURL, null, cType);
                    if (codec == null) {
                        throw new RuntimeException("could not guess " + (Object)((Object)cType) + " encoder for: " + outputURL);
                    }
                    oc.setCodec(codec);
                }
                if (vbitrate == 0) {
                    vbitrate = ic.getBitRate();
                }
                oc.setBitRate(vbitrate);
                if (vbitratetolerance > 0) {
                    oc.setBitRateTolerance(vbitratetolerance);
                }
                int oWidth = ic.getWidth();
                int oHeight = ic.getHeight();
                if (oHeight <= 0 || oWidth <= 0) {
                    throw new RuntimeException("could not find width or height in url: " + inputURL);
                }
                oc.setPixelType(ic.getPixelType());
                if (vscaleFactor != 1.0) {
                    oWidth = (int)((double)oWidth * vscaleFactor);
                    oHeight = (int)((double)oHeight * vscaleFactor);
                    this.mVSamplers[i] = IVideoResampler.make(oWidth, oHeight, oc.getPixelType(), ic.getWidth(), ic.getHeight(), ic.getPixelType());
                    if (this.mVSamplers[i] == null) {
                        throw new RuntimeException("This version of Xuggler does not support video resampling " + i);
                    }
                } else {
                    this.mVSamplers[i] = null;
                }
                oc.setHeight(oHeight);
                oc.setWidth(oWidth);
                oc.setFlag(IStreamCoder.Flags.FLAG_QSCALE, true);
                oc.setGlobalQuality(vquality);
                IRational num = null;
                num = ic.getFrameRate();
                oc.setFrameRate(num);
                oc.setTimeBase(IRational.make(num.getDenominator(), num.getNumerator()));
                num = null;
                this.mIVideoPictures[i] = IVideoPicture.make(ic.getPixelType(), ic.getWidth(), ic.getHeight());
                this.mOVideoPictures[i] = IVideoPicture.make(oc.getPixelType(), oc.getWidth(), oc.getHeight());
            } else {
                this.log.warn("Ignoring input stream {} of type {}", (Object)i, (Object)cType);
            }
            if (this.mOCoders[i] == null) continue;
            retval = this.mOCoders[i].open();
            if (retval < 0) {
                throw new RuntimeException("could not open output encoder for stream: " + i);
            }
            retval = this.mICoders[i].open();
            if (retval >= 0) continue;
            throw new RuntimeException("could not open input decoder for stream: " + i);
        }
        retval = this.mOContainer.writeHeader();
        if (retval < 0) {
            throw new RuntimeException("Could not write header for: " + outputURL);
        }
        return numStreams;
    }

    void closeStreams() {
        int numStreams = 0;
        int i = 0;
        numStreams = this.mIContainer.getNumStreams();
        for (i = 0; i < numStreams; ++i) {
            if (this.mOCoders[i] == null) continue;
            IPacket oPacket = IPacket.make();
            if (this.mOCoders[i].getCodecType() == ICodec.Type.CODEC_TYPE_AUDIO) {
                this.mOCoders[i].encodeAudio(oPacket, null, 0L);
            } else {
                this.mOCoders[i].encodeVideo(oPacket, null, 0);
            }
            if (!oPacket.isComplete()) continue;
            this.mOContainer.writePacket(oPacket, true);
        }
        int retval = this.mOContainer.writeTrailer();
        if (retval < 0) {
            throw new RuntimeException("Could not write trailer to output file");
        }
        for (i = 0; i < numStreams; ++i) {
            if (this.mOCoders[i] != null) {
                this.mOCoders[i].close();
            }
            this.mOCoders[i] = null;
            if (this.mICoders[i] != null) {
                this.mICoders[i].close();
            }
            this.mICoders[i] = null;
        }
        this.mOContainer.close();
        this.mIContainer.close();
        this.mOContainer = null;
        this.mIContainer = null;
        this.mISamples = null;
        this.mOSamples = null;
        this.mIVideoPictures = null;
        this.mOVideoPictures = null;
        this.mOCoders = null;
        this.mICoders = null;
        this.mASamplers = null;
        this.mVSamplers = null;
    }

    protected IAudioSamples alterAudioFrame(IAudioSamples audioFrame) {
        return audioFrame;
    }

    protected IVideoPicture alterVideoFrame(IVideoPicture videoFrame) {
        return videoFrame;
    }

    public void run(CommandLine cmdLine) {
        this.setupStreams(cmdLine);
        IPacket iPacket = IPacket.make();
        IPacket oPacket = IPacket.make();
        IAudioSamples inSamples = null;
        IAudioSamples outSamples = null;
        IAudioSamples reSamples = null;
        int retval = 0;
        IStreamCoder ic = null;
        IStreamCoder oc = null;
        IAudioResampler as = null;
        IVideoResampler vs = null;
        IVideoPicture inFrame = null;
        IVideoPicture reFrame = null;
        while (this.mIContainer.readNextPacket(iPacket) == 0) {
            int i = iPacket.getStreamIndex();
            int offset = 0;
            IStream stream = this.mIContainer.getStream(i);
            long tsOffset = 0L;
            if (stream.getStartTime() != Global.NO_PTS && stream.getStartTime() > 0L && stream.getTimeBase() != null) {
                IRational defTimeBase = IRational.make(1, (int)Global.DEFAULT_PTS_PER_SECOND);
                tsOffset = defTimeBase.rescale(stream.getStartTime(), stream.getTimeBase());
            }
            ic = this.mICoders[i];
            oc = this.mOCoders[i];
            as = this.mASamplers[i];
            vs = this.mVSamplers[i];
            inFrame = this.mIVideoPictures[i];
            reFrame = this.mOVideoPictures[i];
            inSamples = this.mISamples[i];
            reSamples = this.mOSamples[i];
            if (oc == null) continue;
            ICodec.Type cType = ic.getCodecType();
            if (cType == ICodec.Type.CODEC_TYPE_AUDIO && this.mHasAudio) {
                while (offset < iPacket.getSize()) {
                    retval = ic.decodeAudio(inSamples, iPacket, offset);
                    if (retval <= 0) {
                        throw new RuntimeException("could not decode audio.  stream: " + i);
                    }
                    if (inSamples.getTimeStamp() != Global.NO_PTS) {
                        inSamples.setTimeStamp(inSamples.getTimeStamp() - tsOffset);
                    }
                    this.log.trace("packet:{}; samples:{}; offset:{}", new Object[]{iPacket, inSamples, tsOffset});
                    offset += retval;
                    int numSamplesConsumed = 0;
                    if (as != null && inSamples.getNumSamples() > 0L) {
                        retval = as.resample(reSamples, inSamples, inSamples.getNumSamples());
                        outSamples = reSamples;
                    } else {
                        outSamples = inSamples;
                    }
                    outSamples = this.alterAudioFrame(outSamples);
                    while ((long)numSamplesConsumed < outSamples.getNumSamples()) {
                        retval = oc.encodeAudio(oPacket, outSamples, numSamplesConsumed);
                        if (retval <= 0) {
                            throw new RuntimeException("Could not encode any audio: " + retval);
                        }
                        numSamplesConsumed += retval;
                        if (!oPacket.isComplete()) continue;
                        this.log.trace("out packet:{}; samples:{}; offset:{}", new Object[]{oPacket, outSamples, tsOffset});
                        retval = this.mOContainer.writePacket(oPacket, true);
                        if (retval >= 0) continue;
                        throw new RuntimeException("could not write output packet");
                    }
                }
                continue;
            }
            if (cType == ICodec.Type.CODEC_TYPE_VIDEO && this.mHasVideo) {
                IVideoPicture outFrame = null;
                while (offset < iPacket.getSize()) {
                    retval = ic.decodeVideo(inFrame, iPacket, offset);
                    if (retval <= 0) {
                        throw new RuntimeException("could not decode any video.  stream: " + i);
                    }
                    this.log.trace("decoded vid ts: {}; pkts ts: {}", (Object)inFrame.getTimeStamp(), (Object)iPacket.getTimeStamp());
                    if (inFrame.getTimeStamp() != Global.NO_PTS) {
                        inFrame.setTimeStamp(inFrame.getTimeStamp() - tsOffset);
                    }
                    offset += retval;
                    if (!inFrame.isComplete()) continue;
                    if (vs != null) {
                        retval = vs.resample(reFrame, inFrame);
                        if (retval < 0) {
                            throw new RuntimeException("could not resample video");
                        }
                        outFrame = reFrame;
                    } else {
                        outFrame = inFrame;
                    }
                    outFrame = this.alterVideoFrame(outFrame);
                    outFrame.setQuality(0);
                    retval = oc.encodeVideo(oPacket, outFrame, 0);
                    if (retval < 0) {
                        throw new RuntimeException("could not encode video");
                    }
                    if (!oPacket.isComplete() || (retval = this.mOContainer.writePacket(oPacket, true)) >= 0) continue;
                    throw new RuntimeException("could not write video packet");
                }
                continue;
            }
            this.log.trace("ignoring packet of type: {}", (Object)cType);
        }
        this.closeStreams();
    }

    public static void main(String[] args) {
        Converter converter = new Converter();
        try {
            Options options = converter.defineOptions();
            CommandLine cmdLine = converter.parseOptions(options, args);
            converter.run(cmdLine);
        }
        catch (Exception exception) {
            System.err.printf("Error: %s\n", exception.getMessage());
        }
    }

    static {
        URLProtocolManager.getManager();
    }
}

