/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IConfigurable;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IProperty;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoResampler;
import java.io.File;
import java.io.PrintStream;
import java.util.Collection;

public class Configuration {
    private Configuration() {
    }

    public static void main(String[] args) {
        Configuration.printHelp(System.out);
    }

    public static void printHelp(PrintStream stream) {
        Configuration.printSupportedFormats(stream);
        Configuration.printSupportedCodecs(stream);
        Configuration.printSupportedContainerProperties(stream);
        Configuration.printSupportedStreamCoderProperties(stream);
        Configuration.printSupportedVideoResamplerProperties(stream);
    }

    private static void printSupportedFormats(PrintStream stream) {
        stream.println("=======================================");
        stream.println("  Demuxable Formats");
        stream.println("=======================================");
        Collection<IContainerFormat> inputFormats = IContainerFormat.getInstalledInputFormats();
        for (IContainerFormat inputFormat : inputFormats) {
            stream.printf("  \"%s\": %s\n", inputFormat.getInputFormatShortName(), inputFormat.getInputFormatLongName());
        }
        stream.println("=======================================");
        stream.println("  Muxable Formats");
        stream.println("=======================================");
        Collection<IContainerFormat> outputFormats = IContainerFormat.getInstalledOutputFormats();
        for (IContainerFormat outputFormat : outputFormats) {
            stream.printf("  \"%s\": %s\n", outputFormat.getOutputFormatShortName(), outputFormat.getOutputFormatLongName());
        }
    }

    private static void printSupportedCodecs(PrintStream stream) {
        Collection<ICodec> codecs = ICodec.getInstalledCodecs();
        stream.println("=======================================");
        stream.println("  Decodeable Codecs");
        stream.println("=======================================");
        for (ICodec codec : codecs) {
            if (!codec.canDecode()) continue;
            stream.printf("%s %s (%s): %s\n", new Object[]{codec.getType(), codec.getID(), codec.getName(), codec.getLongName()});
        }
        stream.println("=======================================");
        stream.println("  Encodeable Codecs");
        stream.println("=======================================");
        for (ICodec codec : codecs) {
            if (!codec.canEncode()) continue;
            stream.printf("%s %s (%s): %s\n", new Object[]{codec.getType(), codec.getID(), codec.getName(), codec.getLongName()});
        }
    }

    private static void printSupportedVideoResamplerProperties(PrintStream stream) {
        if (IVideoResampler.isSupported(IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            Configuration.printConfigurable(stream, IVideoResampler.make(100, 100, IPixelFormat.Type.YUV420P, 200, 200, IPixelFormat.Type.RGB24));
        }
    }

    private static void printSupportedStreamCoderProperties(PrintStream stream) {
        Configuration.printConfigurable(stream, IStreamCoder.make(IStreamCoder.Direction.ENCODING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSupportedContainerProperties(PrintStream stream) {
        try {
            IContainer container = IContainer.make();
            File tmpFile = File.createTempFile("xuggler", ".flv");
            try {
                String filename = tmpFile.getAbsolutePath();
                container.open(filename, IContainer.Type.WRITE, null);
                Configuration.printConfigurable(stream, container);
                tmpFile.delete();
            }
            catch (Throwable throwable) {
                tmpFile.delete();
                throw throwable;
            }
        }
        finally {
            return;
        }
    }

    private static void printConfigurable(PrintStream stream, IConfigurable configObj) {
        stream.println("=======================================");
        stream.println("  " + configObj.getClass().getName() + " Properties");
        stream.println("=======================================");
        int numOptions = configObj.getNumProperties();
        for (int i = 0; i < numOptions; ++i) {
            IProperty prop = configObj.getPropertyMetaData(i);
            Configuration.printOption(stream, configObj, prop);
        }
    }

    public static void printOption(PrintStream stream, IConfigurable configObj, IProperty prop) {
        if (prop.getType() != IProperty.Type.PROPERTY_FLAGS) {
            stream.printf("  %s %s: %s\n", new Object[]{prop.getType(), prop.getName(), configObj.getPropertyAsString(prop.getName())});
        } else {
            stream.printf("  %s %s: %d (", new Object[]{prop.getType(), prop.getName(), configObj.getPropertyAsLong(prop.getName())});
            int numSettings = prop.getNumFlagSettings();
            long value = configObj.getPropertyAsLong(prop.getName());
            for (int i = 0; i < numSettings; ++i) {
                IProperty fprop = prop.getFlagConstant(i);
                long flagMask = fprop.getDefault();
                boolean isSet = (value & flagMask) > 0L;
                stream.printf("%s%s; ", isSet ? "+" : "-", fprop.getName());
            }
            stream.printf(")\n", new Object[0]);
        }
    }
}

