/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.mediatool.IMediaDebugListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.MediaDebugListener;
import com.xuggle.mediatool.MediaReader;
import com.xuggle.mediatool.MediaViewer;
import com.xuggle.mediatool.MediaWriter;
import com.xuggle.xuggler.IContainer;
import java.io.File;

public class ToolFactory {
    private ToolFactory() {
    }

    public static IMediaReader makeReader(String url) {
        return new MediaReader(url);
    }

    public static IMediaReader makeReader(IContainer container) {
        return new MediaReader(container);
    }

    public static IMediaWriter makeWriter(String url, IMediaReader reader) {
        return new MediaWriter(url, reader);
    }

    public static IMediaWriter makeWriter(String url, IContainer inputContainer) {
        return new MediaWriter(url, inputContainer);
    }

    public static IMediaWriter makeWriter(String url) {
        return new MediaWriter(url);
    }

    public static IMediaViewer makeViewer() {
        return new MediaViewer();
    }

    public static IMediaViewer makeViewer(IMediaViewer.Mode mode) {
        return new MediaViewer(mode);
    }

    public static IMediaViewer makeViewer(boolean showStats) {
        return new MediaViewer(showStats);
    }

    public static IMediaViewer makeViewer(IMediaViewer.Mode mode, boolean showStats) {
        return new MediaViewer(mode, showStats);
    }

    public static IMediaViewer makeViewer(boolean showStats, int defaultCloseOperation) {
        return new MediaViewer(showStats, defaultCloseOperation);
    }

    public static IMediaViewer makeViewer(IMediaViewer.Mode mode, boolean showStats, int defaultCloseOperation) {
        return new MediaViewer(mode, showStats, defaultCloseOperation);
    }

    public static IMediaDebugListener makeDebugListener() {
        return new MediaDebugListener();
    }

    public static IMediaDebugListener makeDebugListener(IMediaDebugListener.Event ... events) {
        return new MediaDebugListener(events);
    }

    public static IMediaDebugListener makeDebugListener(IMediaDebugListener.Mode mode, IMediaDebugListener.Event ... events) {
        return new MediaDebugListener(mode, events);
    }

    public static void main(String[] args) {
        File source;
        if (args.length < 1) {
            System.out.println("Must enter at least one Source File to read.");
            System.exit(0);
        }
        if (!(source = new File(args[0])).exists()) {
            System.out.println("Source file does not exist: " + source);
            System.exit(0);
        }
        IMediaReader reader = ToolFactory.makeReader(args[0]);
        reader.addListener(ToolFactory.makeViewer(true));
        for (int i = 1; i < args.length; ++i) {
            reader.addListener(ToolFactory.makeWriter(args[i], reader));
        }
        while (reader.readPacket() == null) {
        }
    }

    public static void setTurboCharged(boolean turbo) {
        if (turbo) {
            JNIMemoryManager.setMemoryModel(JNIMemoryManager.MemoryModel.NATIVE_BUFFERS);
        } else {
            JNIMemoryManager.setMemoryModel(JNIMemoryManager.MemoryModel.JAVA_STANDARD_HEAP);
        }
    }

    public static boolean isTurboCharged() {
        return JNIMemoryManager.getMemoryModel() != JNIMemoryManager.MemoryModel.JAVA_STANDARD_HEAP;
    }
}

