/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.FerryJNI;
import com.xuggle.ferry.JNINativeFinalizer;
import com.xuggle.ferry.JNIReference;

public class RefCounted {
    private volatile long swigCPtr;
    protected boolean swigCMemOwn;
    private JNIReference mRefCounter;
    private Long mLifecycleReference;
    private JNINativeFinalizer mObjectToForceFinalize;

    protected RefCounted(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
        if (this.swigCPtr != 0L) {
            this.mObjectToForceFinalize = new JNINativeFinalizer();
            this.mLifecycleReference = new Long(this.swigCPtr);
            this.mRefCounter = JNIReference.createReference(this.mLifecycleReference, this.swigCPtr);
        }
    }

    public static long getCPtr(RefCounted obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new NullPointerException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            RefCounted object = this;
            if (object instanceof RefCounted && this.mRefCounter != null) {
                this.mRefCounter.delete();
            } else if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
        }
        this.mRefCounter = null;
        this.mObjectToForceFinalize = null;
        this.mLifecycleReference = null;
        this.swigCPtr = 0L;
    }

    protected int acquire() {
        return FerryJNI.RefCounted_acquire(this.swigCPtr, this);
    }

    protected int release() {
        return FerryJNI.RefCounted_release(this.swigCPtr, this);
    }

    public RefCounted copyReference() {
        long cPtr = FerryJNI.RefCounted_copyReference(this.swigCPtr, this);
        return cPtr == 0L ? null : new RefCounted(cPtr, false);
    }

    public int getCurrentRefCount() {
        return FerryJNI.RefCounted_getCurrentRefCount(this.swigCPtr, this);
    }
}

