/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLogger {
    private static final Logger log = LoggerFactory.getLogger(NativeLogger.class);
    private final Logger mLogger;

    public static NativeLogger getLogger(String loggerName) {
        log.trace("Native code asked for logger: {}", (Object)loggerName);
        NativeLogger retval = null;
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger != null) {
            retval = new NativeLogger(logger);
        }
        return retval;
    }

    private NativeLogger(Logger logger) {
        this.mLogger = logger;
    }

    public String getName() {
        return this.mLogger.getName();
    }

    public boolean log(int level, String msg) {
        boolean didLog = false;
        log.trace("log level: {}, msg: {}", (Object)level, (Object)msg);
        switch (level) {
            case 1: {
                if (!this.mLogger.isWarnEnabled()) break;
                this.mLogger.warn(msg);
                didLog = true;
                break;
            }
            case 2: {
                if (!this.mLogger.isInfoEnabled()) break;
                this.mLogger.info(msg);
                didLog = true;
                break;
            }
            case 3: {
                if (!this.mLogger.isDebugEnabled()) break;
                this.mLogger.debug(msg);
                didLog = true;
                break;
            }
            case 4: {
                if (!this.mLogger.isTraceEnabled()) break;
                this.mLogger.trace(msg);
                didLog = true;
                break;
            }
            default: {
                if (!this.mLogger.isErrorEnabled()) break;
                this.mLogger.error(msg);
                didLog = true;
            }
        }
        return didLog;
    }
}

