/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.FerryJNI;
import com.xuggle.ferry.JNIMemoryAllocator;
import com.xuggle.ferry.JNIMemoryManager;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNIReference
extends WeakReference<Object> {
    private AtomicLong mSwigCPtr = new AtomicLong(0L);
    private volatile JNIMemoryAllocator mMemAllocator;
    private final boolean mIsFerryObject;

    private JNIReference(Object aReferent, long nativeVal, boolean isFerry) {
        super(aReferent, JNIMemoryManager.getMgr().getQueue());
        this.mIsFerryObject = isFerry;
        this.mSwigCPtr.set(nativeVal);
        if (FerryJNI.RefCounted_getCurrentRefCount(nativeVal, null) == 1) {
            this.mMemAllocator = new JNIMemoryAllocator();
            JNIMemoryAllocator.setAllocator(nativeVal, this.mMemAllocator);
        } else {
            this.mMemAllocator = JNIMemoryAllocator.getAllocator(nativeVal);
        }
    }

    static JNIMemoryManager getMgr() {
        return JNIMemoryManager.getMgr();
    }

    static JNIReference createReference(Object aReferent, long swigCPtr, boolean isFerry) {
        JNIMemoryManager.getMgr().gc();
        JNIReference ref = new JNIReference(aReferent, swigCPtr, isFerry);
        JNIMemoryManager.getMgr().addReference(ref);
        return ref;
    }

    static JNIReference createReference(Object aReferent, long swigCPtr) {
        return JNIReference.createReference(aReferent, swigCPtr, true);
    }

    static JNIReference createNonFerryReference(Object aReferent, long swigCPtr) {
        return JNIReference.createReference(aReferent, swigCPtr, false);
    }

    public void delete() {
        long swigPtr = 0L;
        swigPtr = this.mSwigCPtr.getAndSet(0L);
        if (swigPtr != 0L) {
            FerryJNI.RefCounted_release(swigPtr, null);
            this.mMemAllocator = null;
            JNIMemoryManager.getMgr().removeReference(this);
        }
    }

    boolean isFerryObject() {
        return this.mIsFerryObject;
    }
}

