/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.FerryJNI;
import com.xuggle.ferry.JNIReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNIMemoryManager {
    private static final JNIMemoryManager mMgr = new JNIMemoryManager();
    private static final Logger log = LoggerFactory.getLogger(JNIMemoryManager.class);
    private final ReferenceQueue<Object> mRefQueue;
    private final Set<JNIReference> mRefList;
    private final AtomicLong mNumPinnedObjects = new AtomicLong(0L);
    private final ReentrantLock mLock;
    private volatile Thread mCollectionThread = null;

    public static JNIMemoryManager getMgr() {
        return mMgr;
    }

    public static void collect() {
        JNIMemoryManager.getMgr().gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToBuffer(JNIReference ref) {
        boolean result = false;
        this.mLock.lock();
        try {
            this.mNumPinnedObjects.incrementAndGet();
            result = this.mRefList.add(ref);
        }
        finally {
            this.mLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromBuffer(JNIReference ref) {
        boolean result;
        this.mLock.lock();
        try {
            this.mNumPinnedObjects.decrementAndGet();
            result = this.mRefList.remove(ref);
        }
        finally {
            this.mLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBuffer() {
        this.mLock.lock();
        try {
            this.mRefList.clear();
            this.mNumPinnedObjects.set(0L);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() {
        HashSet<JNIReference> refs = new HashSet<JNIReference>();
        this.mLock.lock();
        try {
            refs.addAll(this.mRefList);
        }
        finally {
            this.mLock.unlock();
        }
        for (JNIReference ref : refs) {
            if (ref == null) continue;
            ref.delete();
        }
    }

    JNIMemoryManager() {
        this.mRefQueue = new ReferenceQueue();
        this.mRefList = new HashSet<JNIReference>();
        this.mLock = new ReentrantLock();
    }

    ReferenceQueue<Object> getQueue() {
        return this.mRefQueue;
    }

    public long getNumPinnedObjects() {
        long retval = this.mNumPinnedObjects.get();
        return retval;
    }

    public void finalize() {
        log.trace("destroying: {}", (Object)this);
        this.clearBuffer();
        this.gc();
        this.gc();
    }

    boolean addReference(JNIReference ref) {
        return this.addToBuffer(ref);
    }

    boolean removeReference(JNIReference ref) {
        return this.removeFromBuffer(ref);
    }

    public void gc() {
        JNIReference ref = null;
        while ((ref = (JNIReference)this.mRefQueue.poll()) != null) {
            ref.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCollectionThread() {
        JNIMemoryManager jNIMemoryManager = this;
        synchronized (jNIMemoryManager) {
            if (this.mCollectionThread != null) {
                throw new RuntimeException("Thread already running");
            }
            this.mCollectionThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    JNIReference ref = null;
                    try {
                        while (true) {
                            if ((ref = (JNIReference)JNIMemoryManager.this.mRefQueue.remove()) == null) {
                                continue;
                            }
                            ref.delete();
                        }
                    }
                    catch (InterruptedException ex) {
                        JNIMemoryManager jNIMemoryManager = JNIMemoryManager.this;
                        synchronized (jNIMemoryManager) {
                            JNIMemoryManager.this.mCollectionThread = null;
                            Thread.currentThread().interrupt();
                        }
                        return;
                    }
                }
            }, "Xuggle Ferry Collection Thread");
            this.mCollectionThread.setDaemon(true);
            this.mCollectionThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCollectionThread() {
        JNIMemoryManager jNIMemoryManager = this;
        synchronized (jNIMemoryManager) {
            if (this.mCollectionThread != null) {
                this.mCollectionThread.interrupt();
            }
        }
    }

    public static MemoryModel getMemoryModel() {
        int model = 0;
        model = FerryJNI.getMemoryModel();
        MemoryModel retval = MemoryModel.JAVA_STANDARD_HEAP;
        for (MemoryModel candidate : MemoryModel.values()) {
            if (candidate.getNativeValue() != model) continue;
            retval = candidate;
        }
        return retval;
    }

    public static void setMemoryModel(MemoryModel model) {
        FerryJNI.setMemoryModel(model.getNativeValue());
    }

    public void flush() {
        this.flushBuffer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MemoryModel {
        JAVA_STANDARD_HEAP(0),
        JAVA_DIRECT_BUFFERS(1),
        JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION(2),
        NATIVE_BUFFERS(3),
        NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION(4);

        private final int mNativeValue;

        private MemoryModel(int nativeValue) {
            this.mNativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.mNativeValue;
        }
    }
}

