/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.FerryJNI;
import com.xuggle.ferry.JNIReference;
import com.xuggle.ferry.RefCounted;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBuffer
extends RefCounted {
    private volatile long swigCPtr;

    public IBuffer(long ignore1, boolean ignore2) {
        super(FerryJNI.SWIGIBufferUpcast(ignore1), ignore2);
        this.swigCPtr = ignore1;
    }

    public static long getCPtr(IBuffer obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IBuffer copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        IBuffer retval = new IBuffer(this.swigCPtr, false);
        retval.acquire();
        return retval;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IBuffer) {
            equal = ((IBuffer)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    private void validateArgs(Object array, int arrayLength, int arrayPos, int bufferSize, int bufferPos, int length) {
        if (arrayPos < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bufferPos < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (arrayPos + length > arrayLength) {
            throw new IndexOutOfBoundsException();
        }
        if (bufferPos + length > bufferSize) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer buffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (buffer == null) {
                return;
            }
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, byte[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer buffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (buffer == null) {
                return;
            }
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(short[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            ShortBuffer buffer = bbuffer.asShortBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, short[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            ShortBuffer buffer = bbuffer.asShortBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            IntBuffer buffer = bbuffer.asIntBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, int[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            IntBuffer buffer = bbuffer.asIntBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            LongBuffer buffer = bbuffer.asLongBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, long[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            LongBuffer buffer = bbuffer.asLongBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(double[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            DoubleBuffer buffer = bbuffer.asDoubleBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, double[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            DoubleBuffer buffer = bbuffer.asDoubleBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(float[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            FloatBuffer buffer = bbuffer.asFloatBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, float[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            FloatBuffer buffer = bbuffer.asFloatBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(char[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            CharBuffer buffer = bbuffer.asCharBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, char[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            CharBuffer buffer = bbuffer.asCharBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    public ByteBuffer getByteBuffer(int offset, int length) {
        return this.getByteBuffer(offset, length, null);
    }

    public ByteBuffer getByteBuffer(int offset, int length, AtomicReference<JNIReference> referenceReturn) {
        ByteBuffer retval = this.java_getByteBuffer(offset, length);
        if (retval != null) {
            FerryJNI.RefCounted_acquire(this.swigCPtr, null);
            JNIReference ref = JNIReference.createNonFerryReference(retval, this.swigCPtr);
            if (referenceReturn != null) {
                referenceReturn.set(ref);
            }
            retval.order(ByteOrder.nativeOrder());
        }
        return retval;
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public int getBufferSize() {
        return FerryJNI.IBuffer_getBufferSize(this.swigCPtr, this);
    }

    public static IBuffer make(RefCounted requestor, int bufferSize) {
        long cPtr = FerryJNI.IBuffer_make__SWIG_0(RefCounted.getCPtr(requestor), requestor, bufferSize);
        return cPtr == 0L ? null : new IBuffer(cPtr, false);
    }

    public ByteBuffer java_getByteBuffer(int offset, int length) {
        return FerryJNI.IBuffer_java_getByteBuffer(this.swigCPtr, this, offset, length);
    }

    public byte[] getByteArray(int offset, int length) {
        return FerryJNI.IBuffer_getByteArray(this.swigCPtr, this, offset, length);
    }

    public static IBuffer make(RefCounted requestor, byte[] buffer, int offset, int length) {
        long cPtr = FerryJNI.IBuffer_make__SWIG_1(RefCounted.getCPtr(requestor), requestor, buffer, offset, length);
        return cPtr == 0L ? null : new IBuffer(cPtr, false);
    }

    public static IBuffer make(RefCounted requestor, ByteBuffer directByteBuffer, int offset, int length) {
        long cPtr = FerryJNI.IBuffer_make__SWIG_2(RefCounted.getCPtr(requestor), requestor, directByteBuffer, offset, length);
        return cPtr == 0L ? null : new IBuffer(cPtr, false);
    }
}

