/*
 * Decompiled with CFR 0.152.
 */
package tglibrarylib;

import fileFormatUtil.fileFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import librarydbllibdesktop.LibraryDBlLibDesktop;
import tglibrarylib.TGLibraryGlobal;
import tglibrarylib.TGLibraryTLV;
import trueguidelibrary.TrueGuideLibrary;
import trueguidelogindesktop.TrueGuideLogin;

public class TGLibraryLib {
    public TGLibraryGlobal glbObj = new TGLibraryGlobal();
    public TGLibraryTLV tlvObj = new TGLibraryTLV(this.glbObj);
    public TrueGuideLibrary log = null;
    public LibraryDBlLibDesktop dblib = null;
    public TrueGuideLogin loginobj = null;
    private String version;
    public String basePath = "";
    public String htmlPath = "";
    public String filepath = "";
    public fileFormatUtil excel = null;
    public TGLibraryLib ReportsObj = null;

    public TGLibraryLib(TGLibraryLib obj) {
        this.ReportsObj = new TGLibraryLib();
        this.dblib = obj.dblib;
        this.log = obj.log;
        this.loginobj = obj.loginobj;
        TrueGuideLibrary.tgVer = 1;
    }

    public TGLibraryLib() {
        this.excel = new fileFormatUtil();
        this.log = new TrueGuideLibrary();
        this.loginobj = new TrueGuideLogin(this.log);
        this.dblib = new LibraryDBlLibDesktop(this.log);
        this.dblib.initParser(this.log);
        this.dblib.CreateAcademicSchema();
        this.excel = new fileFormatUtil();
        TrueGuideLibrary.isjava = true;
    }

    public boolean do_all_network() throws IOException {
        this.log.error_code = 0;
        this.log.performFulloperation(this.tlvObj.glbObj.req_type, this.tlvObj.glbObj.tlvStr.length(), this.tlvObj.glbObj.tlvStr);
        return true;
    }

    public void Set_ModuleIDAndRoleID() throws IOException {
        this.log.Module_ID = "academic";
        this.log.Role_id = "library";
        this.log.version = this.version = "1.0.0.0";
        this.loginobj.SetttingModuleAndRole(this.log.Module_ID, this.log.Role_id, this.version);
    }

    public boolean handleLogin_select_user_id() throws IOException {
        boolean check = false;
        this.loginobj.handleLogin_select_user_id();
        this.glbObj.userid = this.loginobj.tutil.GetUserID();
        this.glbObj.status = this.loginobj.tutil.GetStatus();
        return check;
    }

    public void GetPassword() throws IOException {
        this.loginobj.get_password();
        this.glbObj.password = this.loginobj.rcv_passwd;
        this.log.error_code = 0;
        System.out.println("Get password func--->" + this.glbObj.password);
    }

    public File upload_and_exec2(String path) {
        try {
            this.glbObj.req_type = 1008;
            this.glbObj.tlvStr = "";
            this.do_all_network();
            this.glbObj.req_type = 557;
            this.glbObj.tlvStr = path;
            this.do_all_network();
            this.log.sendImage(100, path);
            System.out.println("Sending 1002 ===" + path);
        }
        catch (IOException ex) {
            Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        File DFile = null;
        try {
            DFile = this.Download_File("/var/trueguide/pic/ins_err.txt", "ins_err.txt");
        }
        catch (IOException ex) {
            Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        return DFile;
    }

    public File upload_and_exec(String path) {
        this.glbObj.req_type = 557;
        this.glbObj.tlvStr = path;
        try {
            this.do_all_network();
            this.log.sendImage(100, path);
            this.glbObj.req_type = 1002;
            this.glbObj.tlvStr = path;
            this.do_all_network();
        }
        catch (IOException ex) {
            Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        File DFile = null;
        try {
            DFile = this.Download_File("/var/trueguide/pic/ins_err.txt", "ins_err.txt");
        }
        catch (IOException ex) {
            Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        return DFile;
    }

    public File Download_File(String server_path, String localpath) throws IOException {
        this.tlvObj.setTlv(558);
        this.glbObj.tlvStr = server_path;
        Path pathToFile = Paths.get(this.getCwd() + localpath, new String[0]);
        Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(pathToFile);
        Files.createFile(pathToFile, new FileAttribute[0]);
        this.log.println("working======" + pathToFile);
        System.out.println("working======" + pathToFile);
        this.log.skip_comp = true;
        this.do_all_network();
        this.log.skip_comp = false;
        this.log.println("Pulling file=======");
        this.log.save_image_replace(559, this.getCwd() + localpath);
        return pathToFile.toAbsolutePath().toFile();
    }

    public boolean get_teachername() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(11);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        System.out.println("Reply buff-->" + this.log.rcv_buff + " boolean->" + ca);
        if (!ca) {
            this.do_all_network();
        }
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.teachername = this.log.GetValuesFromTbl("tusertbl.2_usrname").get(0).toString();
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public boolean handleLogin_select_librarian_instid() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(12);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.librarian_status_lst = this.log.GetValuesFromTbl("tlibrariantbl.2_status");
            this.glbObj.librarian_Cur_lst = this.log.GetValuesFromTbl("tlibrariantbl.1_librarianid");
            this.glbObj.librarian_libid_lst = this.log.GetValuesFromTbl("tlibrariantbl.4_libid");
            this.glbObj.librarian_libname_lst = this.log.GetValuesFromTbl("tlibrariantbl.5_libraryname");
            this.glbObj.instid_lst = this.log.GetValuesFromTbl("tlibrariantbl.6_instid");
            ret = true;
        }
        return ret;
    }

    public boolean handleLogin_get_institute_names_lib() throws IOException {
        boolean check = false;
        String tlvstr = "";
        int i = 0;
        for (i = 0; i < this.glbObj.librarian_instid_lst.size(); ++i) {
            this.glbObj.library_instid_cur = this.glbObj.librarian_instid_lst.get(i).toString();
            this.tlvObj.setTlv(13);
            tlvstr = i > 0 ? tlvstr + "~" + this.glbObj.tlvStr : tlvstr + this.glbObj.tlvStr;
        }
        this.glbObj.tlvStr = "";
        this.glbObj.tlvStr = tlvstr;
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.library_instname_lst = this.log.GetValuesFromTbl("pinsttbl.1_instname");
            this.glbObj.library_insttype_lst = this.log.GetValuesFromTbl("pinsttbl.2_type");
            this.glbObj.library_inst_expiry_lst = this.log.GetValuesFromTbl("pinsttbl.3_expiry");
            this.glbObj.library_inst_status_lst = this.log.GetValuesFromTbl("pinsttbl.4_status");
            check = true;
        }
        return check;
    }

    public boolean insert_bookcategory() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(14);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        }
        return check;
    }

    public boolean insert_book_name_tbooktbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(15);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("tbooktbl.1_bookid");
            this.glbObj.book_id = this.dblib.autoIncr;
            ch = true;
        }
        return check;
    }

    public boolean load_bookcategory() throws IOException {
        boolean ret = false;
        System.out.println("this.glbObj.ids_only==========" + this.glbObj.ids_only);
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(16);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
            } else {
                this.glbObj.book_cat_id_lst = this.log.GetValuesFromTbl("tbookcategorytbl.1_tbookcatid");
                ret = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.book_cat_name_lst.clear();
            for (int i = 0; i < this.glbObj.book_cat_id_lst.size(); ++i) {
                this.glbObj.book_cat_id_cur = this.glbObj.book_cat_id_lst.get(i).toString();
                this.tlvObj.setTlv(16);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    ret = false;
                    continue;
                }
                this.glbObj.book_cat_name_lst.add(this.log.GetValuesFromTbl("tbookcategorytbl.1_bookcategoryname").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                ret = true;
            }
        }
        return ret;
    }

    public boolean delete_bookcategory_name() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(17);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        check = this.log.error_code == 0;
        return check;
    }

    public boolean get_book_details_tbooktbl() throws IOException {
        boolean ret = false;
        if (this.glbObj.ids_only) {
            this.glbObj.ubookid_lst.clear();
            this.tlvObj.setTlv(18);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
            } else {
                this.glbObj.ubookid_lst = this.log.GetValuesFromTbl("tuniquebooktbl.1_ubookid");
                System.out.println("ubookid lis======" + this.glbObj.ubookid_lst);
                ret = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.librarian_bookname_lst.clear();
            this.glbObj.librarian_author_lst.clear();
            this.glbObj.librarian_id_lst.clear();
            this.glbObj.bstatus_lst.clear();
            this.glbObj.book_publishername_lst.clear();
            this.glbObj.book_dateofpublicaion_lst.clear();
            this.glbObj.book_dateofreceipt_lst.clear();
            this.glbObj.book_price_lst.clear();
            for (int i = 0; i < this.glbObj.ubookid_lst.size(); ++i) {
                this.glbObj.ubookid_cur = this.glbObj.ubookid_lst.get(i).toString();
                this.tlvObj.setTlv(18);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    ret = false;
                    continue;
                }
                this.glbObj.librarian_bookname_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.1_bname").get(0).toString());
                this.glbObj.librarian_author_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.2_author").get(0).toString());
                this.glbObj.librarian_id_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.3_bookid").get(0).toString());
                this.glbObj.tbookcatid_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.4_tbookcatid").get(0).toString());
                this.glbObj.instid_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.5_libid").get(0).toString());
                this.glbObj.bstatus_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.7_bstatus").get(0).toString());
                this.glbObj.book_publishername_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.8_publisher").get(0).toString());
                this.glbObj.book_dateofpublicaion_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.9_dateofpublication").get(0).toString());
                this.glbObj.book_dateofreceipt_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.10_dateofreceipt").get(0).toString());
                this.glbObj.book_price_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.11_price").get(0).toString());
                System.out.println("bname------" + this.glbObj.librarian_bookname_lst);
                System.out.println("Author------" + this.glbObj.librarian_author_lst);
                System.out.println("book_publishername_lst------" + this.glbObj.book_publishername_lst);
                System.out.println("book_dateofpublicaion_lst------" + this.glbObj.book_dateofpublicaion_lst);
                System.out.println("book_dateofreceipt_lst------" + this.glbObj.book_dateofreceipt_lst);
                System.out.println("book_price_lst------" + this.glbObj.book_price_lst);
                System.out.println("tbookcatid_lst------" + this.glbObj.tbookcatid_lst);
                this.dblib.PostDBExec(this.log.rcv_buff);
                ret = true;
            }
        }
        return ret;
    }

    public boolean update_books_tbooktbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(19);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.log.AppLock();
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        this.log.AppUnLock();
        return check;
    }

    public boolean get_all_batches_for_the_institution() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(20);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                if (this.glbObj.feature.equals("sms") || this.glbObj.feature.equals("app") || this.glbObj.feature.equals("groups") || this.glbObj.feature.equals("suballot")) {
                    this.glbObj.batchid_batchname = this.log.GetValuesFromTbl("tinstclasstbl.1_distinct(batchid)");
                } else {
                    this.glbObj.batchid_lst_opt = this.log.GetValuesFromTbl("tbatchtbl.1_batchid");
                }
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            if (this.glbObj.feature.equals("sms") || this.glbObj.feature.equals("app") || this.glbObj.feature.equals("groups") || this.glbObj.feature.equals("suballot")) {
                this.glbObj.noti_batchid_lst = new ArrayList();
                this.glbObj.noti_btc_year_lst = new ArrayList();
                this.glbObj.noti_batch_stats_lst = new ArrayList();
            } else {
                this.glbObj.batchid_lst = new ArrayList();
                this.glbObj.status_lst = new ArrayList();
                this.glbObj.btc_year_lst = new ArrayList();
                this.glbObj.batch_adm_year_lst = new ArrayList();
                this.glbObj.prevbatch_lst = new ArrayList();
                this.glbObj.next_batchid_lst = new ArrayList();
            }
            List batchid_lst = null;
            if (this.glbObj.feature.equals("sms") || this.glbObj.feature.equals("app") || this.glbObj.feature.equals("groups") || this.glbObj.feature.equals("suballot")) {
                System.out.println("ids only false======");
                batchid_lst = this.glbObj.batchid_batchname;
                System.out.println("addsinged noti batchids====" + batchid_lst);
            } else {
                batchid_lst = this.glbObj.batchid_lst_opt;
            }
            for (int i = 0; i < batchid_lst.size(); ++i) {
                this.glbObj.batch_id_current = batchid_lst.get(i).toString();
                this.tlvObj.setTlv(20);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                System.out.println("Reply buff-->" + this.log.rcv_buff + " boolean->" + ca);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                if (this.glbObj.feature.equals("sms") || this.glbObj.feature.equals("app") || this.glbObj.feature.equals("groups") || this.glbObj.feature.equals("suballot")) {
                    this.glbObj.noti_batchid_lst.add(this.log.GetValuesFromTbl("tbatchtbl.1_batchid").get(0).toString());
                    this.glbObj.noti_btc_year_lst.add(this.log.GetValuesFromTbl("tbatchtbl.3_year").get(0).toString());
                    this.glbObj.noti_batch_stats_lst.add(this.log.GetValuesFromTbl("tbatchtbl.2_status").get(0).toString());
                } else {
                    this.glbObj.batchid_lst.add(this.log.GetValuesFromTbl("tbatchtbl.1_batchid").get(0).toString());
                    this.glbObj.status_lst.add(this.log.GetValuesFromTbl("tbatchtbl.2_status").get(0).toString());
                    this.glbObj.btc_year_lst.add(this.log.GetValuesFromTbl("tbatchtbl.3_year").get(0).toString());
                    this.glbObj.prevbatch_lst.add(this.log.GetValuesFromTbl("tbatchtbl.4_prevbatch").get(0).toString());
                    this.glbObj.next_batchid_lst.add(this.log.GetValuesFromTbl("tbatchtbl.7_next").get(0).toString());
                }
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean set_student_status_to_re_admission() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(21);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        return check;
    }

    public boolean create_student_new_current_batch() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(22);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("tstudenttbl.1_studid");
            ch = true;
        }
        return ch;
    }

    public boolean get_classids_from_libid_opt() throws IOException {
        this.tlvObj.setTlv(23);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        boolean check = false;
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (this.glbObj.from_feature.equals("add_del_sub")) {
                this.glbObj.add_del_classid_lst = this.log.GetValuesFromTbl("pclasstbl.1_classid");
                this.glbObj.add_del_classname_lst = this.log.GetValuesFromTbl("pclasstbl.2_classname");
            } else if (this.glbObj.from_feature.equals("Deployment")) {
                this.glbObj.inst_classid_lst_opt = this.log.GetValuesFromTbl("tinstclasstbl.1_instclassid");
            } else {
                if (this.glbObj.visible) {
                    this.glbObj.inst_classid_lst_opt = this.log.GetValuesFromTbl("tinstclasstbl.1_instclassid");
                }
                if (!this.glbObj.visible) {
                    if (this.glbObj.manage_detaine_classes && !this.glbObj.latest_detained_classes) {
                        this.glbObj.classid_lst = this.log.GetValuesFromTbl("pclasstbl.1_classid");
                        this.glbObj.class_names_list = this.log.GetValuesFromTbl("pclasstbl.2_classname");
                        this.glbObj.next_classids = this.log.GetValuesFromTbl("pclasstbl.4_next");
                    } else if (!this.glbObj.manage_detaine_classes || this.glbObj.manage_detaine_classes && this.glbObj.latest_detained_classes) {
                        this.glbObj.inst_classid_lst_opt = this.log.GetValuesFromTbl("tinstclasstbl.1_instclassid");
                    } else {
                        this.glbObj.config_classid_lst = this.log.GetValuesFromTbl("pclasstbl.1_classid");
                        this.glbObj.config_class_names_list = this.log.GetValuesFromTbl("pclasstbl.2_classname");
                    }
                }
            }
            check = true;
        }
        return check;
    }

    public boolean get_classids_from_libid() throws IOException {
        this.glbObj.config_classid_lst.clear();
        this.glbObj.config_atttype_lst.clear();
        this.glbObj.config_batch_id_lst.clear();
        this.glbObj.config_batch_name_lst.clear();
        this.glbObj.config_ctype_lst.clear();
        this.glbObj.promote_from_batchid_lst.clear();
        this.glbObj.atttype_lst.clear();
        this.glbObj.batch_id_lst.clear();
        this.glbObj.batch_name_lst.clear();
        this.glbObj.op_lst.clear();
        this.glbObj.promote_from_lst.clear();
        this.glbObj.promote_from_class_lst.clear();
        this.glbObj.class_op_lst.clear();
        this.glbObj.next_classid_lst.clear();
        this.glbObj.promote_from_next_class_lst.clear();
        this.glbObj.ctype_lst.clear();
        this.glbObj.dep_ctype_lst.clear();
        this.glbObj.prevbatch.clear();
        this.glbObj.visible_lst.clear();
        this.glbObj.mng_classid_lst.clear();
        this.glbObj.mng_atttype_lst.clear();
        if (!this.glbObj.manage_detaine_classes || !this.glbObj.latest_detained_classes) {
            this.glbObj.next_classids = new ArrayList();
            this.glbObj.classid_lst = new ArrayList();
        }
        boolean check = false;
        for (int i = 0; i < this.glbObj.inst_classid_lst_opt.size(); ++i) {
            this.glbObj.inst_class_id_opt = this.glbObj.inst_classid_lst_opt.get(i).toString();
            this.tlvObj.setTlv(24);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            if (this.glbObj.from_feature.equals("configure")) {
                this.glbObj.config_classid_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.1_classid").get(0).toString());
                this.glbObj.config_atttype_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.4_atttype").get(0).toString());
                this.glbObj.config_batch_id_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.5_batchid").get(0).toString());
                this.glbObj.config_batch_name_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.6_batch").get(0).toString());
                this.glbObj.config_ctype_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.9d_ctype").get(0).toString());
            }
            if (this.glbObj.from_feature.equals("Deployment")) {
                this.glbObj.classid_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.1_classid").get(0).toString());
                this.glbObj.atttype_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.4_atttype").get(0).toString());
                this.glbObj.batch_id_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.5_batchid").get(0).toString());
                this.glbObj.batch_name_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.6_batch").get(0).toString());
                this.glbObj.op_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.8_op").get(0).toString());
                this.glbObj.promote_from_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.9_pfromclassid").get(0).toString());
                this.glbObj.promote_from_class_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.9a_pfromclass").get(0).toString());
                this.glbObj.next_classid_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.9b_next").get(0).toString());
                this.glbObj.promote_from_next_class_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.9c_fromclassnext").get(0).toString());
                this.glbObj.dep_ctype_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.9d_ctype").get(0).toString());
                this.glbObj.promote_from_batchid_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.9f_frombatchid").get(0).toString());
            } else if (this.glbObj.manage_detaine_classes && this.glbObj.latest_detained_classes) {
                this.glbObj.mng_classid_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.1_classid").get(0).toString());
                this.glbObj.mng_atttype_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.4_atttype").get(0).toString());
            } else {
                this.glbObj.classid_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.1_classid").get(0).toString());
                this.glbObj.atttype_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.4_atttype").get(0).toString());
                this.glbObj.batch_id_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.5_batchid").get(0).toString());
                this.glbObj.batch_name_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.6_batch").get(0).toString());
                this.glbObj.class_op_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.8_op").get(0).toString());
                this.glbObj.ctype_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.9d_ctype").get(0).toString());
                this.glbObj.prevbatch.add(this.log.GetValuesFromTbl("tinstclasstbl.9e_prevbatch").get(0).toString());
                this.glbObj.next_classids.add(this.log.GetValuesFromTbl("tinstclasstbl.9b_next").get(0).toString());
                this.glbObj.visible_lst.add(this.log.GetValuesFromTbl("tinstclasstbl.7_visible").get(0).toString());
            }
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public boolean get_classname_from_classid_studereg() throws IOException {
        boolean check = false;
        int j = 0;
        String tlvstr = "";
        this.glbObj.tlvStr = "";
        List classid = null;
        classid = this.glbObj.from_feature.equals("configure") ? this.glbObj.config_classid_lst : this.glbObj.classid_lst;
        for (j = 0; j < classid.size(); ++j) {
            this.glbObj.classid = classid.get(j).toString();
            this.tlvObj.setTlv(25);
            tlvstr = j > 0 ? tlvstr + "~" + this.glbObj.tlvStr : tlvstr + this.glbObj.tlvStr;
        }
        this.glbObj.tlvStr = "";
        this.glbObj.tlvStr = tlvstr;
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        if (this.log.error_code != 0) {
            check = false;
        } else {
            if (this.glbObj.from_feature.equals("configure")) {
                this.glbObj.config_class_names_list = this.log.GetValuesFromTbl("pclasstbl.1_classname");
            } else {
                this.glbObj.class_names_list = this.log.GetValuesFromTbl("pclasstbl.1_classname");
            }
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public boolean select_secdesc_tclasectbl_ids() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(26);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.clasec_id_lst = this.log.GetValuesFromTbl("tclasectbl.1_clasecid");
            ret = true;
        }
        return ret;
    }

    public void upload_file(String serverPath, String path) {
        this.glbObj.req_type = 557;
        this.glbObj.tlvStr = serverPath;
        try {
            this.do_all_network();
            this.log.sendImage(100, path);
        }
        catch (IOException ex) {
            Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean select_secdesc_tclasectbl() throws IOException {
        boolean ret = false;
        this.glbObj.sec_id_lst.clear();
        this.glbObj.sec_desc_batch_lst.clear();
        for (int i = 0; i < this.glbObj.clasec_id_lst.size(); ++i) {
            this.glbObj.clasecid_cur = this.glbObj.clasec_id_lst.get(i).toString();
            this.tlvObj.setTlv(26);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                ret = false;
                continue;
            }
            this.glbObj.sec_id_lst.add(this.log.GetValuesFromTbl("tclasectbl.1_secdesc").get(0).toString());
            this.glbObj.sec_desc_batch_lst.add(this.log.GetValuesFromTbl("tclasectbl.8_batch").get(0).toString());
            this.dblib.PostDBExec(this.log.rcv_buff);
            ret = true;
        }
        return ret;
    }

    public boolean add_section_to_class_for_batch() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(27);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("tclasectbl.1_clasecid");
            ch = true;
        }
        return ch;
    }

    public boolean get_student_ids_from_server_for_particular_class_opt() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(28);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.studids_lst = this.log.GetValuesFromTbl("tstudenttbl.1_studid");
            ret = true;
        }
        return ret;
    }

    public boolean get_studentids_userids_for_parcular_class() throws IOException {
        boolean ret = false;
        int i = 0;
        this.glbObj.stud_userids_lst = new ArrayList();
        this.glbObj.stud_secdesc_classwise_lst = new ArrayList();
        this.glbObj.stud_rollno_lst = new ArrayList();
        this.glbObj.stud_status_lst = new ArrayList();
        this.glbObj.stud_year_lst = new ArrayList();
        this.glbObj.stud_no_lst = new ArrayList();
        this.glbObj.stud_usn_no_lst = new ArrayList();
        this.glbObj.reason_lst = new ArrayList();
        this.glbObj.subdivision_lst.clear();
        this.glbObj.batch_lst.clear();
        this.glbObj.passing_year_lst.clear();
        if (this.glbObj.selected_class_stud) {
            this.glbObj.sel_stud_userids_lst.clear();
            this.glbObj.sel_stud_secdesc_classwise_lst.clear();
            this.glbObj.sel_stud_rollno_lst.clear();
        }
        if (this.glbObj.next_class_stud) {
            this.glbObj.next_stud_userids_lst.clear();
            this.glbObj.next_stud_secdesc_classwise_lst.clear();
            this.glbObj.next_stud_rollno_lst.clear();
        }
        System.out.println("studid_lst======" + this.glbObj.studids_lst);
        for (i = 0; i < this.glbObj.studids_lst.size(); ++i) {
            this.glbObj.studid_search = this.glbObj.studids_lst.get(i).toString();
            this.tlvObj.setTlv(29);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                ret = false;
                continue;
            }
            if (this.glbObj.from_feature.equals("Add_students")) {
                if (this.glbObj.selected_class_stud) {
                    this.glbObj.sel_stud_userids_lst.add(this.log.GetValuesFromTbl("tstudenttbl.2_usrid").get(0).toString());
                    this.glbObj.sel_stud_secdesc_classwise_lst.add(this.log.GetValuesFromTbl("tstudenttbl.3_secdesc").get(0).toString());
                    this.glbObj.sel_stud_rollno_lst.add(this.log.GetValuesFromTbl("tstudenttbl.4_rollno").get(0).toString());
                }
                if (this.glbObj.next_class_stud) {
                    this.glbObj.next_stud_userids_lst.add(this.log.GetValuesFromTbl("tstudenttbl.2_usrid").get(0).toString());
                    this.glbObj.next_stud_secdesc_classwise_lst.add(this.log.GetValuesFromTbl("tstudenttbl.3_secdesc").get(0).toString());
                    this.glbObj.next_stud_rollno_lst.add(this.log.GetValuesFromTbl("tstudenttbl.4_rollno").get(0).toString());
                }
            } else {
                this.glbObj.stud_userids_lst.add(this.log.GetValuesFromTbl("tstudenttbl.2_usrid").get(0).toString());
                this.glbObj.stud_secdesc_classwise_lst.add(this.log.GetValuesFromTbl("tstudenttbl.3_secdesc").get(0).toString());
                this.glbObj.stud_rollno_lst.add(this.log.GetValuesFromTbl("tstudenttbl.4_rollno").get(0).toString());
                this.glbObj.stud_status_lst.add(this.log.GetValuesFromTbl("tstudenttbl.5_status").get(0).toString());
                this.glbObj.stud_year_lst.add(this.log.GetValuesFromTbl("tstudenttbl.8_year").get(0).toString());
                this.glbObj.stud_no_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9a_studno").get(0).toString());
                this.glbObj.stud_usn_no_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9b_studusnno").get(0).toString());
                this.glbObj.subdivision_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9c_subdiv").get(0).toString());
                this.glbObj.batch_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9e_batch").get(0).toString());
                this.glbObj.passing_year_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9f_passingyear").get(0).toString());
                this.glbObj.reason_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9h_reason").get(0).toString());
            }
            this.dblib.PostDBExec(this.log.rcv_buff);
            ret = true;
        }
        System.out.println("Selected class stud usrid==========" + this.glbObj.sel_stud_userids_lst);
        System.out.println("Next class stud usrid==========" + this.glbObj.next_stud_userids_lst);
        return ret;
    }

    public boolean get_student_ids_from_server_for_particular_section_opt() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(30);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.studids_lst = this.log.GetValuesFromTbl("tstudenttbl.1_studid");
            ret = true;
        }
        return ret;
    }

    public boolean get_studentids_userids_for_particular_section() throws IOException {
        this.glbObj.stud_userids_lst.clear();
        this.glbObj.stud_rollno_lst.clear();
        this.glbObj.stud_status_lst.clear();
        this.glbObj.stud_year_lst.clear();
        this.glbObj.subdivision_lst.clear();
        this.glbObj.stud_no_lst.clear();
        this.glbObj.stud_usn_no_lst.clear();
        this.glbObj.batch_lst.clear();
        this.glbObj.reason_lst.clear();
        this.glbObj.passing_year_lst.clear();
        boolean ret = false;
        int i = 0;
        for (i = 0; i < this.glbObj.studids_lst.size(); ++i) {
            this.glbObj.studid_search = this.glbObj.studids_lst.get(i).toString();
            this.tlvObj.setTlv(31);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                ret = false;
                continue;
            }
            this.glbObj.stud_userids_lst.add(this.log.GetValuesFromTbl("tstudenttbl.2_usrid").get(0).toString());
            this.glbObj.stud_rollno_lst.add(this.log.GetValuesFromTbl("tstudenttbl.3_rollno").get(0).toString());
            this.glbObj.stud_status_lst.add(this.log.GetValuesFromTbl("tstudenttbl.4_status").get(0).toString());
            this.glbObj.stud_year_lst.add(this.log.GetValuesFromTbl("tstudenttbl.8_year").get(0).toString());
            this.glbObj.subdivision_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9a_subdiv").get(0).toString());
            this.glbObj.stud_no_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9b_studno").get(0).toString());
            this.glbObj.stud_usn_no_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9c_studusnno").get(0).toString());
            this.glbObj.batch_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9e_batch").get(0).toString());
            this.glbObj.passing_year_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9f_passingyear").get(0).toString());
            this.glbObj.reason_lst.add(this.log.GetValuesFromTbl("tstudenttbl.9h_reason").get(0).toString());
            System.out.println(" this.glbObj.stud_year_lst=====>>" + this.glbObj.stud_year_lst);
            this.dblib.PostDBExec(this.log.rcv_buff);
            ret = true;
        }
        return ret;
    }

    public boolean get_all_user_details_from_userids(String role) throws IOException {
        List usrids = null;
        if (role.equals("Student")) {
            if (this.glbObj.from_feature.equals("Add_students")) {
                if (this.glbObj.selected_class_stud) {
                    usrids = null;
                    this.glbObj.sel_username_lst.clear();
                    usrids = this.glbObj.sel_stud_userids_lst;
                }
                if (this.glbObj.next_class_stud) {
                    usrids = null;
                    this.glbObj.next_username_lst.clear();
                    usrids = this.glbObj.next_stud_userids_lst;
                }
            } else {
                this.glbObj.username_lst.clear();
                this.glbObj.mobno_lst.clear();
                this.glbObj.pan_lst.clear();
                this.glbObj.dl_lst.clear();
                this.glbObj.adhar_lst.clear();
                this.glbObj.pwd_lst.clear();
                this.glbObj.contact_no_lst.clear();
                usrids = this.glbObj.stud_userids_lst;
                this.glbObj.stud_addrs_lst.clear();
            }
        }
        if (role.equals("driver")) {
            this.glbObj.driver_username_lst.clear();
            this.glbObj.driver_mobno_lst.clear();
            this.glbObj.driver_pan_lst.clear();
            this.glbObj.driver_dl_lst.clear();
            this.glbObj.driver_adhar_lst.clear();
            this.glbObj.driver_pwd_lst.clear();
            this.glbObj.driver_contact_no_lst.clear();
            usrids = this.glbObj.driver_usrid_lst;
        }
        if (role.equals("teacher")) {
            this.glbObj.teacher_username_lst.clear();
            this.glbObj.teacher_mobno_lst.clear();
            this.glbObj.teacher_pan_lst.clear();
            this.glbObj.teacher_dl_lst.clear();
            this.glbObj.teacher_adhar_lst.clear();
            this.glbObj.teacher_pwd_lst.clear();
            this.glbObj.teacher_contact_no_lst.clear();
            usrids = this.glbObj.noti_usrid_lst;
        }
        if (role.equals("leave")) {
            this.glbObj.leave_teacher_username_lst.clear();
            usrids = this.glbObj.leave_usrid_lst;
        }
        if (role.equals("cashbook")) {
            this.glbObj.cashbook_stud_username_lst.clear();
            usrids = this.glbObj.ctrl_userid_lst;
        }
        if (role.equals("sub_division")) {
            this.glbObj.sub_divi_stud_username_lst.clear();
            usrids = this.glbObj.subdiv_usr_ids;
        }
        if (role.equals("event")) {
            this.glbObj.event_teacher_username_lst.clear();
            usrids = this.glbObj.noti_usrid_lst;
        }
        boolean check = false;
        int j = 0;
        String tlvstr = "";
        for (j = 0; j < usrids.size(); ++j) {
            this.glbObj.stud_usrid = usrids.get(j).toString();
            this.tlvObj.setTlv(32);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            if (role.equals("Student")) {
                if (this.glbObj.from_feature.equals("Add_students")) {
                    if (this.glbObj.selected_class_stud) {
                        this.glbObj.sel_username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
                    }
                    if (this.glbObj.next_class_stud) {
                        this.glbObj.next_username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
                    }
                } else {
                    this.glbObj.username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
                    this.glbObj.mobno_lst.add(this.log.GetValuesFromTbl("tusertbl.2_mobno").get(0).toString());
                    this.glbObj.pan_lst.add(this.log.GetValuesFromTbl("tusertbl.3_pan").get(0).toString());
                    this.glbObj.dl_lst.add(this.log.GetValuesFromTbl("tusertbl.4_dl").get(0).toString());
                    this.glbObj.adhar_lst.add(this.log.GetValuesFromTbl("tusertbl.5_adhar").get(0).toString());
                    this.glbObj.pwd_lst.add(this.log.GetValuesFromTbl("tusertbl.6_password").get(0).toString());
                    this.glbObj.contact_no_lst.add(this.log.GetValuesFromTbl("tusertbl.9_contactno").get(0).toString());
                    this.glbObj.stud_addrs_lst.add(this.log.GetValuesFromTbl("tusertbl.9a_street").get(0).toString());
                }
            }
            if (role.equals("driver")) {
                this.glbObj.driver_username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
                this.glbObj.driver_mobno_lst.add(this.log.GetValuesFromTbl("tusertbl.2_mobno").get(0).toString());
                this.glbObj.driver_pan_lst.add(this.log.GetValuesFromTbl("tusertbl.3_pan").get(0).toString());
                this.glbObj.driver_dl_lst.add(this.log.GetValuesFromTbl("tusertbl.4_dl").get(0).toString());
                this.glbObj.driver_adhar_lst.add(this.log.GetValuesFromTbl("tusertbl.5_adhar").get(0).toString());
                this.glbObj.driver_pwd_lst.add(this.log.GetValuesFromTbl("tusertbl.6_password").get(0).toString());
                this.glbObj.driver_contact_no_lst.add(this.log.GetValuesFromTbl("tusertbl.9_contactno").get(0).toString());
            }
            if (role.equals("teacher")) {
                this.glbObj.teacher_username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
                this.glbObj.teacher_mobno_lst.add(this.log.GetValuesFromTbl("tusertbl.2_mobno").get(0).toString());
                this.glbObj.teacher_pan_lst.add(this.log.GetValuesFromTbl("tusertbl.3_pan").get(0).toString());
                this.glbObj.teacher_dl_lst.add(this.log.GetValuesFromTbl("tusertbl.4_dl").get(0).toString());
                this.glbObj.teacher_adhar_lst.add(this.log.GetValuesFromTbl("tusertbl.5_adhar").get(0).toString());
                this.glbObj.teacher_pwd_lst.add(this.log.GetValuesFromTbl("tusertbl.6_password").get(0).toString());
                this.glbObj.teacher_contact_no_lst.add(this.log.GetValuesFromTbl("tusertbl.9_contactno").get(0).toString());
            }
            if (role.equals("leave")) {
                this.glbObj.leave_teacher_username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
            }
            if (role.equals("cashbook")) {
                this.glbObj.cashbook_stud_username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
            }
            if (role.equals("sub_division")) {
                this.glbObj.sub_divi_stud_username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
                System.out.println("glbObj.sub_divi_stud_username_lst=" + this.glbObj.sub_divi_stud_username_lst);
            }
            if (role.equals("event")) {
                this.glbObj.event_teacher_username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
                System.out.println("glbObj.sub_divi_stud_username_lst=" + this.glbObj.event_teacher_username_lst);
            }
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public boolean get_count_check_duplicate_exam_name() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(58);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        }
        if (this.glbObj.section_dup) {
            this.glbObj.section_count = this.log.GetValuesFromTbl("tclasectbl.1_count(*)").get(0).toString();
            check = true;
        } else {
            this.glbObj.exam_count_add_exam = this.log.GetValuesFromTbl("texamtbl.1_count(*)").get(0).toString();
            check = true;
        }
        return check;
    }

    public boolean get_parentids_from_student_usrids() throws IOException {
        boolean check = false;
        this.glbObj.parentids_lst.clear();
        for (int i = 0; i < this.glbObj.stud_userids_lst.size(); ++i) {
            this.glbObj.stud_userids_cur = this.glbObj.stud_userids_lst.get(i).toString();
            this.tlvObj.setTlv(33);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = true;
                continue;
            }
            this.glbObj.parentids_lst.add(this.log.GetValuesFromTbl("tparentstudtbl.1_parentid").get(0).toString());
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = false;
        }
        return check;
    }

    public boolean get_parent_usrids_from_parentids() throws IOException {
        boolean check = false;
        this.glbObj.parent_userid_lst.clear();
        for (int i = 0; i < this.glbObj.parentids_lst.size(); ++i) {
            this.glbObj.parentids_cur = this.glbObj.parentids_lst.get(i).toString();
            this.tlvObj.setTlv(34);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = true;
                continue;
            }
            this.glbObj.parent_userid_lst.add(this.log.GetValuesFromTbl("tparenttbl.1_usrid").get(0).toString());
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = false;
        }
        return check;
    }

    public boolean get_parent_details_from_parent_usrids() throws IOException {
        boolean check = false;
        this.glbObj.parent_username_lst.clear();
        this.glbObj.parent_contact_no_lst.clear();
        this.glbObj.parent_street_lst.clear();
        for (int i = 0; i < this.glbObj.parent_userid_lst.size(); ++i) {
            this.glbObj.parent_userid_cur = this.glbObj.parent_userid_lst.get(i).toString();
            this.tlvObj.setTlv(35);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
            if (!ca) {
                this.do_all_network();
            }
            if (this.log.error_code != 0) {
                check = true;
                continue;
            }
            this.glbObj.parent_username_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
            this.glbObj.parent_contact_no_lst.add(this.log.GetValuesFromTbl("tusertbl.9_contactno").get(0).toString());
            this.glbObj.parent_street_lst.add(this.log.GetValuesFromTbl("tusertbl.9a_street").get(0).toString());
            System.out.println("parent_street_lst>>/" + this.glbObj.parent_street_lst);
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = false;
        }
        return check;
    }

    public void delete_create_Student_Details_Control_Panel_html() {
        this.filepath = ".\\Student_Details_Control\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "Student_Details_Control.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public boolean handleLogin_select_user_id_ctrl_panel() throws IOException {
        this.tlvObj.setTlv(36);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.ctrl_userid_cur = this.log.GetValuesFromTbl("tusertbl.1_usrid").get(0).toString();
            this.glbObj.ctrl_user_name_cur = this.log.GetValuesFromTbl("tusertbl.3_usrname").get(0).toString();
            this.glbObj.ctrl_status = this.log.GetValuesFromTbl("tusertbl.2_status").get(0).toString();
            this.glbObj.ctrl_pan = this.log.GetValuesFromTbl("tusertbl.4_pan").get(0).toString();
            this.glbObj.ctrl_dl = this.log.GetValuesFromTbl("tusertbl.5_dl").get(0).toString();
            this.glbObj.ctrl_adhar = this.log.GetValuesFromTbl("tusertbl.6_adhar").get(0).toString();
            this.glbObj.ctrl_password = this.log.GetValuesFromTbl("tusertbl.7_password").get(0).toString();
            this.glbObj.ctrl_student_contact_no = this.log.GetValuesFromTbl("tusertbl.8_contactno").get(0).toString();
            this.glbObj.stud_address = this.log.GetValuesFromTbl("tusertbl.9a_street").get(0).toString();
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean check_whether_user_exists_as_a_student_ctrl_panel() throws IOException {
        this.tlvObj.setTlv(37);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.stud_exist_count = this.log.GetValuesFromTbl("tstudenttbl.1_count(*)").get(0).toString();
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean handleLogin_select_student_id_info_ctrl_panel() throws IOException {
        this.tlvObj.setTlv(38);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.studid_ctrlpnl_lst = this.log.GetValuesFromTbl("tstudenttbl.1_studid");
            this.glbObj.classid_ctrlpnl_lst = this.log.GetValuesFromTbl("tstudenttbl.2_classid");
            this.glbObj.secdesc_ctrlpnl_lst = this.log.GetValuesFromTbl("tstudenttbl.3_secdesc");
            this.glbObj.rollno_ctrlpnl_lst = this.log.GetValuesFromTbl("tstudenttbl.4_rollno");
            this.glbObj.stud_status_ctrlpnl_lst = this.log.GetValuesFromTbl("tstudenttbl.5_status");
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean get_classname_from_classid_ctrl_panel() throws IOException {
        boolean check = false;
        String tlvstr = "";
        System.out.println("class id lst]]]]]]]]]]]]]" + this.glbObj.classid_ctrlpnl_lst);
        int i = 0;
        for (i = 0; i < this.glbObj.classid_ctrlpnl_lst.size(); ++i) {
            this.glbObj.ClassIds_cur = this.glbObj.classid_ctrlpnl_lst.get(i).toString();
            if (this.glbObj.ClassIds_cur.equalsIgnoreCase("None")) {
                this.tlvObj.glbObj.classname_control_panel_lst.add("None");
                continue;
            }
            this.tlvObj.setTlv(39);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.glbObj.classname_control_panel_lst.add(this.log.GetValuesFromTbl("pclasstbl.1_classname").get(0).toString());
            System.out.println("classname------------>" + this.tlvObj.glbObj.classname_control_panel_lst);
            check = true;
        }
        return check;
    }

    public boolean handleLogin_select_user_id_parent_ctrl_panel() throws IOException {
        this.tlvObj.setTlv(40);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.ctrl_parent_userid_cur = this.log.GetValuesFromTbl("tusertbl.1_usrid").get(0).toString();
            this.glbObj.ctrl_parent_user_name_cur = this.log.GetValuesFromTbl("tusertbl.3_usrname").get(0).toString();
            this.glbObj.ctrl_parent_status = this.log.GetValuesFromTbl("tusertbl.2_status").get(0).toString();
            this.glbObj.ctrl_parent_pan = this.log.GetValuesFromTbl("tusertbl.4_pan").get(0).toString();
            this.glbObj.ctrl_parent_dl = this.log.GetValuesFromTbl("tusertbl.5_dl").get(0).toString();
            this.glbObj.ctrl_parent_adhar = this.log.GetValuesFromTbl("tusertbl.6_adhar").get(0).toString();
            this.glbObj.ctrl_parent_password = this.log.GetValuesFromTbl("tusertbl.7_password").get(0).toString();
            this.glbObj.ctrl_parent_contact_no = this.log.GetValuesFromTbl("tusertbl.8_contactno").get(0).toString();
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean check_whether_user_exists_as_a_parent_ctrl_panel() throws IOException {
        this.tlvObj.setTlv(41);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.parent_exist_count = this.log.GetValuesFromTbl("tparenttbl.1_count(*)").get(0).toString();
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean get_parentid_from_usertbl() throws IOException {
        this.tlvObj.setTlv(42);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.ctrl_parentid_cur = this.log.GetValuesFromTbl("tparenttbl.1_parentid").get(0).toString();
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean get_usrid_from_parenttbl() throws IOException {
        this.tlvObj.setTlv(43);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.control_student_usrid_lst = this.log.GetValuesFromTbl("tparentstudtbl.1_usrid");
            System.out.println("student usr id===" + this.glbObj.control_student_usrid);
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean get_student_details_from_parentstudtbl() throws IOException {
        this.glbObj.classid_ctrlpnl_lst.clear();
        this.glbObj.secdesc_ctrlpnl_lst.clear();
        this.glbObj.rollno_ctrlpnl_lst.clear();
        this.glbObj.studid_ctrlpnl_lst.clear();
        this.glbObj.stud_status_ctrlpnl_lst.clear();
        boolean check = false;
        for (int i = 0; i < this.glbObj.control_student_usrid_lst.size(); ++i) {
            this.glbObj.control_student_usrid_cur = this.glbObj.control_student_usrid_lst.get(i).toString();
            System.out.println("student usr id===" + this.glbObj.control_student_usrid);
            this.tlvObj.setTlv(44);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code == 0) {
                this.glbObj.classid_ctrlpnl_lst.add(this.log.GetValuesFromTbl("tstudenttbl.1_classid").get(0).toString());
                this.glbObj.secdesc_ctrlpnl_lst.add(this.log.GetValuesFromTbl("tstudenttbl.2_secdesc").get(0).toString());
                this.glbObj.rollno_ctrlpnl_lst.add(this.log.GetValuesFromTbl("tstudenttbl.3_rollno").get(0).toString());
                this.glbObj.studid_ctrlpnl_lst.add(this.log.GetValuesFromTbl("tstudenttbl.4_studid").get(0).toString());
                this.glbObj.stud_status_ctrlpnl_lst.add(this.log.GetValuesFromTbl("tstudenttbl.5_status").get(0).toString());
                check = true;
                continue;
            }
            check = false;
        }
        return check;
    }

    public boolean enable_disable_current_studentid() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(45);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        return check;
    }

    public boolean make_class_section_invisible() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(46);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        return check;
    }

    public boolean insert_borrowedbook_tbookborrowtbl() throws IOException {
        boolean check = false;
        for (int i = 0; i < this.glbObj.borrow_books_lst.size(); ++i) {
            this.glbObj.book_id = this.glbObj.borrow_books_lst.get(i).toString();
            this.glbObj.book_author = this.glbObj.borrow_author_lst.get(i).toString();
            this.glbObj.bk_name = this.glbObj.tbook_name_lst.get(i).toString();
            this.glbObj.due_date = this.glbObj.tbookdetl_due_date_lst.get(i).toString();
            this.tlvObj.setTlv(47);
            boolean ch = false;
            this.dblib.skip_db_exec = true;
            this.dblib.get_from_db(this.glbObj.tlvStr);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.dblib.PostDBExec("tbookborrowtbl.1_borrowid");
            boolean bl = true;
        }
        return check;
    }

    public boolean insert_into_tbookdetailtbl() throws IOException {
        boolean check = false;
        System.out.println("admin.glbObj.borrow_books_lst==" + this.glbObj.borrow_books_lst);
        System.out.println("admin.glbObj.borrow_author_lst===" + this.glbObj.borrow_author_lst);
        System.out.println("admin.glbObj.borrow_count_list==" + this.glbObj.borrow_count_list);
        System.out.println("admin.glbObj.borrow_quantity_lst===" + this.glbObj.borrow_quantity_lst);
        System.out.println("admin.glbObj.tbook_name_lst==" + this.glbObj.tbook_name_lst);
        System.out.println("admin.glbObj.tbookdetl_due_date_lst===" + this.glbObj.tbookdetl_due_date_lst);
        for (int i = 0; i < this.glbObj.borrow_books_lst.size(); ++i) {
            this.glbObj.bookid = this.glbObj.borrow_books_lst.get(i).toString();
            System.out.println(i + "===========this.glbObj.bookid===" + this.glbObj.bookid);
            this.glbObj.author = this.glbObj.borrow_author_lst.get(i).toString();
            this.glbObj.borrow_qty = this.glbObj.borrow_quantity_lst.get(i).toString();
            this.glbObj.bookname = this.glbObj.tbook_name_lst.get(i).toString();
            System.out.println(i + "==========bookname======" + this.glbObj.bookname);
            this.glbObj.due_date = this.glbObj.tbookdetl_due_date_lst.get(i).toString();
            int qty = Integer.parseInt(this.glbObj.borrow_qty);
            for (int j = 0; j < qty; ++j) {
                this.tlvObj.setTlv(48);
                boolean ch = false;
                this.dblib.skip_db_exec = true;
                this.dblib.get_from_db(this.glbObj.tlvStr);
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.dblib.PostDBExec("tbookdetailtbl.1_tbdid");
                ch = true;
            }
        }
        return check;
    }

    public boolean update_book_count_tbooktbl() throws IOException {
        System.out.println("admin.glbObj.borrow_books_lst==" + this.glbObj.borrow_books_lst);
        System.out.println("admin.glbObj.borrow_author_lst===" + this.glbObj.borrow_author_lst);
        System.out.println("admin.glbObj.borrow_count_list==" + this.glbObj.borrow_count_list);
        System.out.println("admin.glbObj.borrow_quantity_lst===" + this.glbObj.borrow_quantity_lst);
        System.out.println("admin.glbObj.tbook_name_lst==" + this.glbObj.tbook_name_lst);
        System.out.println("admin.glbObj.tbookdetl_due_date_lst===" + this.glbObj.tbookdetl_due_date_lst);
        boolean check = false;
        for (int i = 0; i < this.glbObj.borrow_books_lst.size(); ++i) {
            this.glbObj.rem_qty = this.glbObj.rem_qty_lst.get(i).toString();
            this.glbObj.book_id = this.glbObj.borrow_books_lst.get(i).toString();
            this.tlvObj.setTlv(49);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.log.AppLock();
            this.dblib.skip_db_exec = true;
            this.dblib.get_from_db(this.glbObj.tlvStr);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.dblib.PostDBExec("");
            check = true;
        }
        this.log.AppUnLock();
        return check;
    }

    public boolean insert_borrowedbook_tfacultybookborrowtbl() throws IOException {
        boolean check = false;
        for (int i = 0; i < this.glbObj.borrow_books_lst.size(); ++i) {
            this.glbObj.book_id = this.glbObj.borrow_books_lst.get(i).toString();
            this.glbObj.book_author = this.glbObj.borrow_author_lst.get(i).toString();
            this.glbObj.bk_name = this.glbObj.tbook_name_lst.get(i).toString();
            this.glbObj.due_date = this.glbObj.tbookdetl_due_date_lst.get(i).toString();
            this.tlvObj.setTlv(50);
            boolean ch = false;
            this.dblib.skip_db_exec = true;
            this.dblib.get_from_db(this.glbObj.tlvStr);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.dblib.PostDBExec("tfacultybookborrowtbl.1_borrowid");
            boolean bl = true;
        }
        return check;
    }

    public boolean select_borrowid_tfacultybookborrowtbl() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(51);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.fac_borrow_id = this.log.GetValuesFromTbl("tfacultybookborrowtbl.1_borrowid").get(0).toString();
            ret = true;
        }
        return ret;
    }

    public boolean update_rem_count_tbooktbl() throws IOException {
        boolean check = false;
        for (int i = 0; i < this.glbObj.librarian_id_lst.size(); ++i) {
            this.glbObj.book_id = this.glbObj.borrow_books_lst.get(i).toString();
            this.glbObj.borrowquantity = this.glbObj.borrow_qty_lst.get(i).toString();
            this.tlvObj.setTlv(52);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (c) continue;
            return false;
        }
        this.log.AppLock();
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        this.log.AppUnLock();
        return check;
    }

    public boolean get_issudetails_tbookborrowtbl() throws IOException {
        boolean ret = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(53);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
            } else {
                this.glbObj.book_borrow_lst = this.log.GetValuesFromTbl("tbookborrowtbl.1_borrowid");
                System.out.println("this.glbObj.book_borrow_lst=====" + this.glbObj.book_borrow_lst);
                ret = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.book_issuedate_lst.clear();
            this.glbObj.book_status_lst.clear();
            for (int i = 0; i < this.glbObj.book_borrow_lst.size(); ++i) {
                this.glbObj.book_borrow_lst_cur = this.glbObj.book_borrow_lst.get(i).toString();
                this.tlvObj.setTlv(53);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                this.do_all_network();
                if (this.log.error_code != 0) {
                    ret = false;
                    continue;
                }
                this.glbObj.book_issuedate_lst.add(this.log.GetValuesFromTbl("tbookborrowtbl.1_issuedate").get(0).toString());
                this.glbObj.book_status_lst.add(this.log.GetValuesFromTbl("tbookborrowtbl.2_status").get(0).toString());
                System.out.println("this.glbObj.book_issuedate_lst=======" + this.glbObj.book_issuedate_lst);
                System.out.println("this.glbObj.book_status_lst=======" + this.glbObj.book_status_lst);
                ret = true;
            }
        }
        return ret;
    }

    public boolean get_bookdetails_tbookdetailstbl() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(54);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.issuebookid__lst = this.log.GetValuesFromTbl("tbookborrowtbl.1_ubookid");
            this.glbObj.issuebookname_lst = this.log.GetValuesFromTbl("tbookborrowtbl.2_bookname");
            this.glbObj.issueauthor_lst = this.log.GetValuesFromTbl("tbookborrowtbl.3_author");
            this.glbObj.issueduedate_lst = this.log.GetValuesFromTbl("tbookborrowtbl.4_duedate");
            this.glbObj.issuestatus_lst = this.log.GetValuesFromTbl("tbookborrowtbl.5_status");
            this.glbObj.issue_delydays_lst = this.log.GetValuesFromTbl("tbookborrowtbl.6_nodelaydays");
            this.glbObj.issue_fine_lst = this.log.GetValuesFromTbl("tbookborrowtbl.7_fine");
            this.glbObj.issueborrow_id_lst = this.log.GetValuesFromTbl("tbookborrowtbl.8_borrowid");
            ret = true;
        }
        return ret;
    }

    public boolean update_status_tbookdetailtbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(55);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        this.log.AppLock();
        this.do_all_network();
        check = this.log.error_code == 0;
        this.log.AppUnLock();
        return check;
    }

    public boolean get_book_count_tbooktbl() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(56);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.return_book_count = this.log.GetValuesFromTbl("tbooktbl.3_count").get(0).toString();
            ret = true;
        }
        return ret;
    }

    public boolean update_returnbook_count_tbooktbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(57);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.log.AppLock();
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        this.log.AppUnLock();
        return check;
    }

    public String getIdPhotoPath() {
        String imgBasePath = this.getCwd() + "\\images\\photoes\\" + this.glbObj.libid + "\\" + this.glbObj.batch_id + "\\" + this.glbObj.classname_search + "\\" + this.glbObj.secid_search + "\\";
        File file = new File(imgBasePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.glbObj.tmpPath = imgBasePath + "\\" + this.glbObj.roll_num_id + ".png";
        return "file:\\" + imgBasePath + "\\" + this.glbObj.roll_num_id + ".png";
    }

    String getCwd() {
        return Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
    }

    public String getInstLogoPath() {
        String imgBasePath = this.getCwd() + "\\images\\logo\\";
        File file = new File(imgBasePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.glbObj.tmpPath = imgBasePath + "\\" + this.glbObj.libid + ".png";
        return "file:\\" + imgBasePath + "\\" + this.glbObj.libid + ".png";
    }

    public void set_system_date_and_time() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd#HH:mm:ss");
        Date date = new Date();
        String today_date = dateFormat.format(date);
        String[] dt = today_date.split("#");
        this.glbObj.sysDate = dt[0];
        this.glbObj.sysTime = dt[1];
    }

    public String create_Student_Details_Control_Panel_html() {
        this.filepath = ".\\Student_Details_Control\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "Student_Details_Control.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        int type = Integer.parseInt(this.glbObj.inst_type);
        this.create_Student_Details_Control_Panel_html(writer);
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    public PrintWriter get_writer_stream() {
        File file = new File(this.filepath);
        if (!file.exists()) {
            file.mkdirs();
        }
        File htmlFile = new File(this.htmlPath);
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        if (htmlFile.exists()) {
            System.out.println("File exists ");
            return null;
        }
        System.out.println("creating html in==" + this.htmlPath);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(this.htmlPath, "utf-8");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        return writer;
    }

    private void create_Student_Details_Control_Panel_html(PrintWriter writer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLogoPath() {
        String imgBasePath = this.getCwd() + "\\images\\logo\\" + this.glbObj.libid + "\\";
        File file = new File(imgBasePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.glbObj.tmpPath = imgBasePath + "\\logo.png";
        return "file:\\" + imgBasePath + "\\logo.png";
    }

    private String get_header_html() {
        String hdrFile = this.getHdrPath();
        boolean hdr = this.checkIfFileExists(this.glbObj.hdrPath);
        String html = "";
        if (hdr) {
            html = "<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 500px;\"><tbody><tr><td><img  src=\"" + hdrFile + "\" alt=\"upload institute icon\"/></td></tr></tbody></table>";
        } else {
            this.glbObj.logoPath = this.getInstLogoPath();
            html = "<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 600px;\"><tbody><tr><td><img alt=\"Icon\" src=\"" + this.glbObj.logoPath + "\"style=\"width: 80px; height: 80px; border-width: 1px; border-style: solid; margin: 25px;\" alt=\"upload institute icon\"/></td><td>&nbsp; &nbsp; &nbsp; &nbsp;  " + this.glbObj.inst_name + "</td></tr></tbody></table>";
        }
        return html;
    }

    public String getHdrPath() {
        String imgBasePath = this.getCwd() + "\\images\\hdr\\" + this.glbObj.libid + "\\";
        File file = new File(imgBasePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.glbObj.hdrPath = imgBasePath + "\\hdr.png";
        return "file:\\" + imgBasePath + "\\hdr.png";
    }

    public boolean checkIfFileExists(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public boolean handleLogin_select_user_id_teacher_ctrl_panel() throws IOException {
        this.tlvObj.setTlv(59);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.ctrl_teacher_userid = this.log.GetValuesFromTbl("tusertbl.1_usrid").get(0).toString();
            this.glbObj.ctrl_teacher_user_name = this.log.GetValuesFromTbl("tusertbl.3_usrname").get(0).toString();
            this.glbObj.ctrl_teacher_status = this.log.GetValuesFromTbl("tusertbl.2_status").get(0).toString();
            this.glbObj.teacher_ctrl_pan = this.log.GetValuesFromTbl("tusertbl.4_pan").get(0).toString();
            this.glbObj.teacher_ctrl_dl = this.log.GetValuesFromTbl("tusertbl.5_dl").get(0).toString();
            this.glbObj.teacher_ctrl_adhar = this.log.GetValuesFromTbl("tusertbl.6_adhar").get(0).toString();
            this.glbObj.teacher_ctrl_password = this.log.GetValuesFromTbl("tusertbl.7_password").get(0).toString();
            this.glbObj.ctrl_teacher_contact_no = this.log.GetValuesFromTbl("tusertbl.8_contactno").get(0).toString();
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean check_whether_user_exists_as_a_teacher_ctrl_panel() throws IOException {
        this.tlvObj.setTlv(60);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.teacher_exist_count = this.log.GetValuesFromTbl("tteachertbl.1_count(*)").get(0).toString();
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean handleLogin_select_teacher_id_info_ctrl_panel() throws IOException {
        this.tlvObj.setTlv(61);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        boolean check = false;
        if (this.log.error_code == 0) {
            this.glbObj.noti_teacherid_lst = this.log.GetValuesFromTbl("tteachertbl.1_teacherid");
            this.glbObj.teacher_status_ctrlpnl_lst = this.log.GetValuesFromTbl("tteachertbl.2_status");
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        } else {
            check = false;
        }
        return check;
    }

    public boolean get_all_teachers_for_current_institution() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(62);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.noti_teacherid_lst = this.log.GetValuesFromTbl("tteachertbl.1_teacherid");
            this.glbObj.noti_usrid_lst = this.log.GetValuesFromTbl("tteachertbl.2_usrid");
            this.glbObj.teacher_status_ctrlpnl_lst = this.log.GetValuesFromTbl("tteachertbl.3_status");
            this.glbObj.staff_type_lst = this.log.GetValuesFromTbl("tteachertbl.5_stafftype");
            check = true;
        }
        return check;
    }

    public boolean get_count_from_teacherdcstbl() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(63);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            if (this.glbObj.count_chck.equals("1")) {
                this.glbObj.tteacherdcsstbl_count = this.log.GetValuesFromTbl("tteacherdcsstbl.1_count(*)").get(0).toString();
                System.out.println("this.glbObj.tteacherdcsstbl_count===" + this.glbObj.tteacherdcsstbl_count);
            }
            if (this.glbObj.count_chck.equals("2")) {
                this.glbObj.stud_class_stdlst = this.log.GetValuesFromTbl("tstudenttbl.1_studid");
                this.glbObj.stud_class_usrlst = this.log.GetValuesFromTbl("tstudenttbl.2_usrid");
                System.out.println("this.glbObj.stud_class_stdlst===" + this.glbObj.stud_class_stdlst);
                System.out.println("stud_class_usrlst===" + this.glbObj.stud_class_usrlst);
            }
            if (this.glbObj.count_chck.equals("3")) {
                this.glbObj.backsub_count = this.log.GetValuesFromTbl("tinstdcstbl.1_count(*)").get(0).toString();
                System.out.println("this.glbObj.backsub_count===" + this.glbObj.backsub_count);
            }
            ret = true;
        }
        return ret;
    }

    public boolean delete_teacher_from_tteacherdcsstbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(64);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("");
            ch = true;
        }
        return ch;
    }

    public boolean get_count_from_time_table() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(65);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.timetbl_count = this.log.GetValuesFromTbl("ttimetbl.1_count(*)").get(0).toString();
            System.out.println("this.glbObj.ttimetbl.1_count(*)===" + this.glbObj.tteacherdcsstbl_count);
            ret = true;
        }
        return ret;
    }

    public boolean delete_teacher_from_ttimetbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(66);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("");
            ch = true;
        }
        return ch;
    }

    public boolean delete_teacher() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(67);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("");
            ch = true;
        }
        return ch;
    }

    public boolean get_active_batchid_for_institution() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(68);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.dep_inst_batch_id = this.log.GetValuesFromTbl("tbatchtbl.1_batchid").get(0).toString();
            this.glbObj.dep_inst_batch_name = this.log.GetValuesFromTbl("tbatchtbl.2_year").get(0).toString();
            check = true;
        }
        return check;
    }

    public boolean get_issudetails_tfacultybookborrowtbl() throws IOException {
        boolean ret = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(69);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
            } else {
                this.glbObj.fac_book_borrow_lst = this.log.GetValuesFromTbl("tfacultybookborrowtbl.1_borrowid");
                ret = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.fac_book_issuedate_lst.clear();
            this.glbObj.fac_book_status_lst.clear();
            for (int i = 0; i < this.glbObj.fac_book_borrow_lst.size(); ++i) {
                this.glbObj.fac_book_borrow_lst_cur = this.glbObj.fac_book_borrow_lst.get(i).toString();
                this.tlvObj.setTlv(69);
                boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                if (!c) {
                    return false;
                }
                this.do_all_network();
                if (this.log.error_code != 0) {
                    ret = false;
                    continue;
                }
                this.glbObj.fac_book_issuedate_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.1_issuedate").get(0).toString());
                this.glbObj.fac_book_status_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.2_status").get(0).toString());
                ret = true;
            }
        }
        return ret;
    }

    public boolean insert_into_tfacultybookdetailtbl() throws IOException {
        boolean check = false;
        System.out.println("admin.glbObj.borrow_books_lst==" + this.glbObj.borrow_books_lst);
        System.out.println("admin.glbObj.borrow_author_lst===" + this.glbObj.borrow_author_lst);
        System.out.println("admin.glbObj.borrow_count_list==" + this.glbObj.borrow_count_list);
        System.out.println("admin.glbObj.borrow_quantity_lst===" + this.glbObj.borrow_quantity_lst);
        System.out.println("admin.glbObj.tbook_name_lst==" + this.glbObj.tbook_name_lst);
        System.out.println("admin.glbObj.tbookdetl_due_date_lst===" + this.glbObj.tbookdetl_due_date_lst);
        for (int i = 0; i < this.glbObj.borrow_books_lst.size(); ++i) {
            this.glbObj.bookid = this.glbObj.borrow_books_lst.get(i).toString();
            System.out.println(i + "===========this.glbObj.bookid===" + this.glbObj.bookid);
            this.glbObj.author = this.glbObj.borrow_author_lst.get(i).toString();
            this.glbObj.borrow_qty = this.glbObj.borrow_quantity_lst.get(i).toString();
            this.glbObj.bookname = this.glbObj.tbook_name_lst.get(i).toString();
            System.out.println(i + "==========bookname======" + this.glbObj.bookname);
            this.glbObj.due_date = this.glbObj.tbookdetl_due_date_lst.get(i).toString();
            int qty = Integer.parseInt(this.glbObj.borrow_qty);
            for (int j = 0; j < qty; ++j) {
                this.tlvObj.setTlv(70);
                boolean ch = false;
                this.dblib.skip_db_exec = true;
                this.dblib.get_from_db(this.glbObj.tlvStr);
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.dblib.PostDBExec("tfacultybookdetailtbl.1_ftbdid");
                ch = true;
            }
        }
        return check;
    }

    public boolean get_bookdetails_tfacultybookdetailtbl() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(71);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.fac_issuebookid_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.1_ubookid").get(0).toString());
            this.glbObj.fac_issuebookname_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.2_bookname").get(0).toString());
            this.glbObj.fac_issueauthor_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.3_author").get(0).toString());
            this.glbObj.fac_issueduedate_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.4_duedate").get(0).toString());
            this.glbObj.fac_issuestatus_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.5_status").get(0).toString());
            this.glbObj.fac_issue_delydays_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.6_nodelaydays").get(0).toString());
            this.glbObj.fac_issue_fine_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.7_fine").get(0).toString());
            this.glbObj.fac_issueborrow_id_lst.add(this.log.GetValuesFromTbl("tfacultybookborrowtbl.8_borrowid").get(0).toString());
            ret = true;
        }
        return ret;
    }

    public boolean update_status_tfacultybookdetailtbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(72);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.log.AppLock();
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("");
            check = true;
        }
        this.log.AppUnLock();
        return check;
    }

    public boolean insert_bk_details() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(73);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.dblib.PostDBExec("tbooktbl.1_bookid");
            System.out.println("this.glbObj.book_bookid===" + this.glbObj.book_bookid);
            ch = true;
        }
        return check;
    }

    public void delete_create_tbook_details_html() {
        this.filepath = ".\\book_details\\" + this.glbObj.libid + "\\";
        this.htmlPath = this.filepath + "book_details.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public String create_tbook_details_html() {
        this.filepath = ".\\book_details\\" + this.glbObj.libid + "\\";
        this.htmlPath = this.filepath + "book_details.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        this.create_tbook_details_html(writer);
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    void create_tbook_details_html(PrintWriter writer) {
        this.set_system_date_and_time();
        String html = "";
        Object[] unique_array = this.glbObj.uniquebookcatlist.toArray();
        for (int i = 0; i < unique_array.length; ++i) {
            String catid = unique_array[i].toString();
            int cat_ind = this.glbObj.all_book_cat_id_lst.indexOf(catid);
            System.out.println("glbObj.book_cat_name_lst==" + this.glbObj.book_cat_name_lst);
            String category = this.glbObj.book_cat_name_lst.get(cat_ind).toString();
            System.out.println("category==" + category);
            html = html + "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"width: 1200px;\">";
            html = html + "<tbody>";
            html = html + "<tr >";
            html = html + "<td><center>" + category + "</td>";
            html = html + "</tr >";
            html = html + "</tbody>";
            html = html + "</table>";
            html = html + "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"width: 1200px;\">";
            html = html + "<tbody>";
            html = html + "<tr >";
            html = html + "<td>&nbsp; Sl No</td>";
            html = html + "<td>&nbsp; Books Name</td>";
            html = html + "<td>&nbsp; Author Name</td>";
            html = html + "<td>&nbsp; publisher</td>";
            html = html + "<td>&nbsp;Price</td>";
            html = html + "<td>&nbsp;Editiont</td>";
            html = html + "<td>&nbsp;Pages</td>";
            html = html + "<td>&nbsp;Source</td>";
            html = html + "<td>&nbsp;Bill No</td>";
            html = html + "<td>&nbsp;Bill Date</td>";
            html = html + "<td>&nbsp;Class</td>";
            html = html + "<td>&nbsp;Book No</td>";
            html = html + "<td>&nbsp;Subject/Remark</td>";
            html = html + "<td>&nbsp;ACCN No</td>";
            html = html + "<td>&nbsp;ACCN DAte</td>";
            html = html + "</tr>";
            for (int j = 0; j < this.glbObj.book_bookid.size(); ++j) {
                if (!catid.equals(this.glbObj.all_book_cat_id_lst.get(j).toString())) continue;
                String book_name = "";
                String athrname = "";
                String publish = "";
                String price = "";
                String edition = "";
                String pages = "";
                String src = "";
                String billno = "";
                String bildt = "";
                String clas = "";
                String bokno = "";
                String subrem = "";
                String accno = "";
                String accdt = "";
                book_name = this.glbObj.librarian_bookname_lst.get(j).toString().isEmpty() || this.glbObj.librarian_bookname_lst.get(j).toString() == null || this.glbObj.librarian_bookname_lst.get(j).toString().equalsIgnoreCase("") ? "NA" : this.glbObj.librarian_bookname_lst.get(j).toString();
                athrname = this.glbObj.librarian_author_lst.get(j).toString().isEmpty() || this.glbObj.librarian_author_lst.get(j).toString() == null || this.glbObj.librarian_author_lst.get(j).toString().equalsIgnoreCase("") ? "NA" : this.glbObj.librarian_author_lst.get(j).toString();
                publish = this.glbObj.librarian_totalbooks_lst.get(j).toString().isEmpty() || this.glbObj.librarian_totalbooks_lst.get(j).toString() == null || this.glbObj.librarian_totalbooks_lst.get(j).toString().equalsIgnoreCase("") ? "NA" : this.glbObj.librarian_totalbooks_lst.get(j).toString();
                price = this.glbObj.book_price_lst.get(j).toString().isEmpty() || this.glbObj.book_price_lst.get(j).toString() == null || this.glbObj.book_price_lst.get(j).toString().equalsIgnoreCase("") ? "NA" : this.glbObj.book_price_lst.get(j).toString();
                edition = this.glbObj.edition_lst.get(j).toString().isEmpty() || this.glbObj.edition_lst.get(j).toString() == null || this.glbObj.edition_lst.get(j).toString().equalsIgnoreCase("") ? "NA" : this.glbObj.edition_lst.get(j).toString();
                if (this.glbObj.nopage_lst.get(j).toString().isEmpty() || this.glbObj.nopage_lst.get(j).toString() == null || this.glbObj.nopage_lst.get(j).toString().equalsIgnoreCase("")) {
                    book_name = "NA";
                } else {
                    pages = this.glbObj.nopage_lst.get(j).toString();
                }
                if (this.glbObj.source_lst.get(j).toString().isEmpty() || this.glbObj.source_lst.get(j).toString() == null || this.glbObj.source_lst.get(j).toString().equalsIgnoreCase("")) {
                    book_name = "NA";
                } else {
                    src = this.glbObj.source_lst.get(j).toString();
                }
                if (this.glbObj.billno_lst.get(j).toString().isEmpty() || this.glbObj.billno_lst.get(j).toString() == null || this.glbObj.billno_lst.get(j).toString().equalsIgnoreCase("")) {
                    book_name = "NA";
                } else {
                    billno = this.glbObj.billno_lst.get(j).toString();
                }
                if (this.glbObj.billdt_lst.get(j).toString().isEmpty() || this.glbObj.billdt_lst.get(j).toString() == null || this.glbObj.billdt_lst.get(j).toString().equalsIgnoreCase("")) {
                    book_name = "NA";
                } else {
                    bildt = this.glbObj.billdt_lst.get(j).toString();
                }
                if (this.glbObj.classno_lst.get(j).toString().isEmpty() || this.glbObj.classno_lst.get(j).toString() == null || this.glbObj.classno_lst.get(j).toString().equalsIgnoreCase("")) {
                    book_name = "NA";
                } else {
                    clas = this.glbObj.classno_lst.get(j).toString();
                }
                if (this.glbObj.bookno_lst.get(j).toString().isEmpty() || this.glbObj.bookno_lst.get(j).toString() == null || this.glbObj.bookno_lst.get(j).toString().equalsIgnoreCase("")) {
                    book_name = "NA";
                } else {
                    bokno = this.glbObj.bookno_lst.get(j).toString();
                }
                if (this.glbObj.subjrem_lst.get(j).toString().isEmpty() || this.glbObj.subjrem_lst.get(j).toString() == null || this.glbObj.subjrem_lst.get(j).toString().equalsIgnoreCase("")) {
                    book_name = "NA";
                } else {
                    subrem = this.glbObj.subjrem_lst.get(j).toString();
                }
                if (this.glbObj.accno_lst.get(j).toString().isEmpty() || this.glbObj.accno_lst.get(j).toString() == null || this.glbObj.accno_lst.get(j).toString().equalsIgnoreCase("")) {
                    book_name = "NA";
                } else {
                    accno = this.glbObj.accno_lst.get(j).toString();
                }
                accdt = this.glbObj.accdt_lst.get(j).toString().isEmpty() || this.glbObj.accdt_lst.get(j).toString() == null || this.glbObj.accdt_lst.get(j).toString().equalsIgnoreCase("") ? "NA" : this.glbObj.accdt_lst.get(j).toString();
                if (book_name.isEmpty() || book_name.equalsIgnoreCase("")) {
                    book_name = "NA";
                }
                if (athrname.isEmpty() || athrname.equalsIgnoreCase("")) {
                    athrname = "NA";
                }
                if (publish.isEmpty() || publish.equalsIgnoreCase("")) {
                    publish = "NA";
                }
                if (price.isEmpty() || price.equalsIgnoreCase("")) {
                    price = "NA";
                }
                int k = j + 1;
                html = html + "<TR><TD>&nbsp;&nbsp;" + k + "</TD><TD>&nbsp;&nbsp;" + book_name + "</TD><TD>&nbsp;&nbsp;" + athrname + "</TD><TD>&nbsp;&nbsp;" + publish + "</TD><TD>&nbsp;&nbsp;" + price + "</TD><TD>&nbsp;&nbsp;" + edition + "</TD><TD>&nbsp;&nbsp;" + pages + "</TD><TD>&nbsp;&nbsp;" + src + "</TD><TD>&nbsp;&nbsp;" + billno + "</TD><TD>&nbsp;&nbsp;" + bildt + "</TD><TD>&nbsp;&nbsp;" + clas + "</TD><TD>&nbsp;&nbsp;" + bokno + "</TD><TD>&nbsp;&nbsp;" + subrem + "</TD><TD>&nbsp;&nbsp;" + accno + "</TD><TD>&nbsp;&nbsp;" + accdt + "</td></TR>";
            }
            html = html + "</tbody>";
            html = html + "</table>";
            html = html + "<br><br>";
        }
        writer.println("<html><body>");
        String hdrHtml = this.get_header_html();
        writer.println(hdrHtml);
        writer.println("<p>&nbsp;</p><p align=\"middle\">&nbsp;<FONT COLOR=#000000><strong><u>BOOKS DETAILS</u></strong></FONT></p>" + html + "  <p>&nbsp;</p><p>Date :&nbsp; &nbsp; " + this.glbObj.sysDate + "&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p>Time :&nbsp; &nbsp; " + this.glbObj.sysTime + "&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p align=\"right\">Signature : &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>");
        writer.println("</body></html>");
    }

    public void delete_create_student_fine_details_html() {
        this.filepath = ".\\student_fine_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "student_fine_details.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public String create_student_fine_details_html() {
        this.filepath = ".\\student_fine_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "student_fine_details.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        this.create_student_fine_details_html(writer);
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    void create_student_fine_details_html(PrintWriter writer) {
        this.set_system_date_and_time();
        String html = "";
        float grand_total = 0.0f;
        String return_date_cur = "";
        String returndate = "";
        for (int i = 0; i < this.glbObj.booknm_rep_lst.size(); ++i) {
            grand_total += Float.parseFloat(this.glbObj.fine_rep_lst.get(i).toString());
            returndate = this.glbObj.returndate_rep_lst.get(i).toString();
            if (!returndate.equalsIgnoreCase("Not Returned")) {
                Date return_date = null;
                try {
                    return_date = new SimpleDateFormat("yyyy-MM-dd").parse(returndate);
                }
                catch (ParseException ex) {
                    Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
                }
                SimpleDateFormat tdf = new SimpleDateFormat("dd-MM-yyyy");
                return_date_cur = tdf.format(return_date);
            } else {
                return_date_cur = "Not Returned";
            }
            html = html + "<TR><TD>&nbsp;&nbsp;" + (i + 1) + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.booknm_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.auth_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fine_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + return_date_cur + "</TD></TR>";
        }
        html = html + "<TR><TD>&nbsp;&nbsp;Grand Total</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;" + grand_total + "</TD><TD>&nbsp;&nbsp;</TD></TR>";
        writer.println("<html><body>");
        String hdrHtml = this.get_header_html();
        writer.println(hdrHtml);
        writer.println("<p>&nbsp;</p><p align=\"middle\">&nbsp;<FONT COLOR=#EF1E1E><strong><u>STUDENT FINE REPORT</u></strong></FONT></p><table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 800px;\"><tbody><tr BGCOLOR=#096734><td><FONT COLOR=#FEFFFE>&nbsp; Sr.No&nbsp;</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Books Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Author Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Fine</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Return Date</FONT></td></tr>" + html + "</tbody></table>  <p>&nbsp;</p><p>Date :&nbsp; &nbsp; " + this.glbObj.sysDate + "&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p>Time :&nbsp; &nbsp; " + this.glbObj.sysTime + "&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p align=\"right\">Signature : &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>");
        writer.println("</body></html>");
    }

    public boolean get_fine_author_from_tbookdetailtbl() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(74);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.booknm_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.1_bookname");
            this.glbObj.auth_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.2_author");
            this.glbObj.fine_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.3_fine");
            this.glbObj.returndate_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.4_returndate");
            this.dblib.PostDBExec(this.log.rcv_buff);
            ret = true;
        }
        return ret;
    }

    public void delete_create_tbook_details_html1() {
        this.filepath = ".\\book_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "book_details.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public String create_tbook_details_html1() {
        this.filepath = ".\\book_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "book_details.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        int type = Integer.parseInt(this.glbObj.inst_type);
        this.create_tbook_details_html(writer);
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    void create_tbook_details_html1(PrintWriter writer) {
        this.set_system_date_and_time();
        String html = "";
        for (int i = 0; i < this.glbObj.librarian_bookname_lst.size(); ++i) {
            html = html + "<TR><TD>&nbsp;&nbsp;" + (i + 1) + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.librarian_bookname_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.librarian_author_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.librarian_count_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.librarian_totalbooks_lst.get(i).toString() + "</TD></TR>";
        }
        writer.println("<html><body>");
        String hdrHtml = this.get_header_html();
        writer.println(hdrHtml);
        writer.println("<p>&nbsp;</p><p align=\"middle\">&nbsp;<FONT COLOR=#EF1E1E><strong><u>BOOKS DETAILS</u></strong></FONT></p><table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 800px;\"><tbody><tr BGCOLOR=#096734><td><FONT COLOR=#FEFFFE>&nbsp; Sr.No&nbsp;</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Books Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Author Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Remaining Books</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Total Books</FONT></td></tr>" + html + "</tbody></table>  <p>&nbsp;</p><p>Date :&nbsp; &nbsp; " + this.glbObj.sysDate + "&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p>Time :&nbsp; &nbsp; " + this.glbObj.sysTime + "&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p align=\"right\">Signature : &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>");
        writer.println("</body></html>");
    }

    public void delete_create_student_duedate_details_html() {
        this.filepath = ".\\student_batchwise_fine_details\\" + this.glbObj.libid + "\\";
        this.htmlPath = this.filepath + "student_batchwise_fine_details.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public String create_student_duedate_details_html() {
        this.filepath = ".\\student_batchwise_fine_details\\" + this.glbObj.libid + "\\";
        this.htmlPath = this.filepath + "student_batchwise_fine_details.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        this.create_student_duedate_details_html(writer);
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    void create_student_duedate_details_html(PrintWriter writer) {
        this.set_system_date_and_time();
        String html = "";
        String duedate = "";
        for (int i = 0; i < this.glbObj.booknm_rep_lst.size(); ++i) {
            System.out.println("this.glbObj.book_name_lst==" + this.glbObj.booknm_rep_lst);
            duedate = this.glbObj.borrow_duedate_lst.get(i).toString();
            Date due_date = null;
            try {
                due_date = new SimpleDateFormat("yyyy-MM-dd").parse(duedate);
            }
            catch (ParseException ex) {
                Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
            }
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
            String due_date_cur = df.format(due_date);
            html = html + "<TR><TD>&nbsp;&nbsp;" + (i + 1) + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.booknm_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.auth_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.userid_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + due_date_cur + "</TD></TR>";
        }
        writer.println("<html><body>");
        String hdrHtml = this.get_header_html();
        writer.println(hdrHtml);
        writer.println("<p>&nbsp;</p><p align=\"middle\">&nbsp;<FONT COLOR=#EF1E1E><strong><u>Student Duedate Report</u></strong></FONT></p><table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 800px;\"><tbody><tr BGCOLOR=#096734><td><FONT COLOR=#FEFFFE>&nbsp; Sr.No&nbsp;</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Books Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Author Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; User-Id</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Due-Date Exceeded</FONT></td></tr>" + html + "</tbody></table>  <p>&nbsp;</p><p>Date :&nbsp; &nbsp; " + this.glbObj.sysDate + "&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p>Time :&nbsp; &nbsp; " + this.glbObj.sysTime + "&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p align=\"right\">Signature : &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>");
        writer.println("</body></html>");
    }

    public boolean get_fine_batchwise_tbookdetailtbl() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(75);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.booknm_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.1_bookname");
            this.glbObj.auth_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.2_author");
            this.glbObj.fine_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.3_fine");
            this.glbObj.returndate_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.4_returndate");
            this.glbObj.userid_lst = this.log.GetValuesFromTbl("tbookborrowtbl.5_userid");
            this.glbObj.bstatus_lst = this.log.GetValuesFromTbl("tbookborrowtbl.6_status");
            ret = true;
        }
        return ret;
    }

    public boolean get_username_from_usertbl() throws IOException {
        boolean ret = false;
        this.glbObj.username_lib_lst.clear();
        for (int i = 0; i < this.glbObj.userid_lst.size(); ++i) {
            this.glbObj.userid_cur = this.glbObj.userid_lst.get(i).toString();
            this.tlvObj.setTlv(76);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
                continue;
            }
            this.glbObj.username_lib_lst.add(this.log.GetValuesFromTbl("tusertbl.1_usrname").get(0).toString());
            ret = true;
        }
        return ret;
    }

    public void delete_create_faculty_fine_details_html() {
        this.filepath = ".\\faculty_fine_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "faculty_fine_details.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public String create_faculty_fine_details_html() {
        this.filepath = ".\\faculty_fine_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "faculty_fine_details.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        int type = Integer.parseInt(this.glbObj.inst_type);
        this.create_faculty_fine_details_html(writer);
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    void create_faculty_fine_details_html(PrintWriter writer) {
        this.set_system_date_and_time();
        String html = "";
        float grand_total = 0.0f;
        System.out.println("glbObj.fac_booknm_rep_lst///" + this.glbObj.fac_booknm_rep_lst);
        System.out.println("glbObj.fac_auth_rep_lst///" + this.glbObj.fac_auth_rep_lst);
        System.out.println("glbObj.fac_fine_rep_lst///" + this.glbObj.fac_fine_rep_lst);
        System.out.println("glbObj.fac_returndate_rep_lst///" + this.glbObj.fac_returndate_rep_lst);
        for (int i = 0; i < this.glbObj.fac_booknm_rep_lst.size(); ++i) {
            grand_total += Float.parseFloat(this.glbObj.fac_fine_rep_lst.get(i).toString());
            html = html + "<TR><TD>&nbsp;&nbsp;" + (i + 1) + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_booknm_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_auth_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_fine_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_returndate_rep_lst.get(i).toString() + "</TD></TR>";
        }
        html = html + "<TR><TD>&nbsp;&nbsp;Grand Total</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;" + grand_total + "</TD><TD>&nbsp;&nbsp;</TD></TR>";
        System.out.println("help--->>>----");
        writer.println("<html><body>");
        String hdrHtml = this.get_header_html();
        writer.println(hdrHtml);
        writer.println("<p>&nbsp;</p><p align=\"middle\">&nbsp;<FONT COLOR=#EF1E1E><strong><u>Faculty Fine Report</u></strong></FONT></p><table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 800px;\"><tbody><tr BGCOLOR=#096734><td><FONT COLOR=#FEFFFE>&nbsp; Sr.No&nbsp;</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Books Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Author Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Fine</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Return Date</FONT></td></tr>" + html + "</tbody></table>  <p>&nbsp;</p><p>Date :&nbsp; &nbsp; " + this.glbObj.sysDate + "&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p>Time :&nbsp; &nbsp; " + this.glbObj.sysTime + "&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p align=\"right\">Signature : &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>");
        writer.println("</body></html>");
    }

    public boolean get_fine_author_from_tfacultybookdetailtbl() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(77);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
        if (!ca) {
            this.do_all_network();
        }
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.fac_booknm_rep_lst = this.log.GetValuesFromTbl("tfacultybookborrowtbl.1_bookname");
            this.glbObj.fac_auth_rep_lst = this.log.GetValuesFromTbl("tfacultybookborrowtbl.2_author");
            this.glbObj.fac_fine_rep_lst = this.log.GetValuesFromTbl("tfacultybookborrowtbl.3_fine");
            this.glbObj.fac_returndate_rep_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.4_returndate");
            this.glbObj.fac_returndate_rep_lst = this.log.GetValuesFromTbl("tfacultybookborrowtbl.5_userid");
            this.glbObj.fac_returndate_rep_lst = this.log.GetValuesFromTbl("tfacultybookborrowtbl.6_status");
            this.dblib.PostDBExec(this.log.rcv_buff);
            ret = true;
        }
        return ret;
    }

    public void delete_create_faculty_namewise_fine_details_html() {
        this.filepath = ".\\faculty_namewise_fine_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "faculty_namewise_fine_details.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public String create_faculty_namewise_fine_details_html() {
        this.filepath = ".\\faculty_namewise_fine_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "faculty_namewise_fine_details.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        int type = Integer.parseInt(this.glbObj.inst_type);
        this.create_faculty_namewise_fine_details_html(writer);
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    void create_faculty_namewise_fine_details_html(PrintWriter writer) {
        this.set_system_date_and_time();
        String html = "";
        float grand_total = 0.0f;
        System.out.println("this.glbObj.booknm_rep_lst==" + this.glbObj.fac_booknm_rep_lst);
        System.out.println("this.glbObj.fine_rep_lst==" + this.glbObj.fac_fine_rep_lst);
        System.out.println("this.glbObj.fac_auth_rep_lst==" + this.glbObj.fac_auth_rep_lst);
        System.out.println("this.glbObj.fac_returndate_rep_lst==" + this.glbObj.fac_returndate_rep_lst);
        System.out.println("this.glbObj.teacher_username_cur==" + this.glbObj.teacher_username_cur);
        for (int i = 0; i < this.glbObj.fac_fine_rep_lst.size(); ++i) {
            String fine_int = this.glbObj.fac_fine_rep_lst.get(i).toString();
            if (fine_int.equals("None")) {
                fine_int = "0";
            }
            grand_total += Float.parseFloat(fine_int);
            String book_stat = "";
            if (this.glbObj.fac_bstatus_lst.get(i).toString().equals("0")) {
                book_stat = "BORROWED";
            }
            if (this.glbObj.fac_bstatus_lst.get(i).toString().equals("1")) {
                book_stat = "RETURN";
            }
            html = html + "<TR><TD>&nbsp;&nbsp;" + (i + 1) + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.teacher_username_cur + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_booknm_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_auth_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_fine_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_returndate_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + book_stat + "</TD></TR>";
        }
        html = html + "<TR><TD>&nbsp;&nbsp;Grand Total</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;" + grand_total + "</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;</TD></TR>";
        writer.println("<html><body>");
        String hdrHtml = this.get_header_html();
        writer.println(hdrHtml);
        writer.println("<p>&nbsp;</p><p align=\"middle\">&nbsp;<FONT COLOR=#EF1E1E><strong><u>BOOKS DETAILS</u></strong></FONT></p><table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 800px;\"><tbody><tr BGCOLOR=#096734><td><FONT COLOR=#FEFFFE>&nbsp; Sr.No&nbsp;</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Faculty Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Books Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Author Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Fine</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Return Date</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Status</FONT></td></tr>" + html + "</tbody></table>  <p>&nbsp;</p><p>Date :&nbsp; &nbsp; " + this.glbObj.sysDate + "&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p>Time :&nbsp; &nbsp; " + this.glbObj.sysTime + "&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p align=\"right\">Signature : &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>");
        writer.println("</body></html>");
    }

    public void delete_create_faculty_details_html() {
        this.filepath = ".\\faculty_namewise_fine_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "faculty_namewise_fine_details.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public String create_faculty_details_html() {
        this.filepath = ".\\faculty_namewise_fine_details\\" + this.glbObj.libid + "\\" + this.glbObj.classid_ctrlpnl + "\\" + this.glbObj.secdesc_ctrlpnl + "\\";
        this.htmlPath = this.filepath + "faculty_namewise_fine_details.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        this.glbObj.all_fac = "2";
        System.out.println("1st visit");
        this.create_faculty_details_html(writer);
        System.out.println("2ndst visit");
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    void create_faculty_details_html(PrintWriter writer) {
        this.set_system_date_and_time();
        String html = "";
        float grand_total = 0.0f;
        for (int i = 0; i < this.glbObj.fac_usrid_lst.size(); ++i) {
            System.out.println("this.glbObj.fac_usrid_lst.size()--" + this.glbObj.fac_usrid_lst);
            String fine_int = this.glbObj.fac_fine_rep_lst.get(i).toString();
            if (fine_int.equals("None")) {
                fine_int = "0";
            }
            grand_total += Float.parseFloat(fine_int);
            String book_stat = "";
            if (this.glbObj.fac_bstatus_lst.get(i).toString().equals("0")) {
                book_stat = "BORROWED";
            }
            if (this.glbObj.fac_bstatus_lst.get(i).toString().equals("1")) {
                book_stat = "RETURN";
            }
            html = html + "<TR><TD>&nbsp;&nbsp;" + (i + 1) + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_usrname_Lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_booknm_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_auth_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_fine_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + this.glbObj.fac_returndate_rep_lst.get(i).toString() + "</TD><TD>&nbsp;&nbsp;" + book_stat + "</TD></TR>";
        }
        html = html + "<TR><TD>&nbsp;&nbsp;Grand Total</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;" + grand_total + "</TD><TD>&nbsp;&nbsp;</TD><TD>&nbsp;&nbsp;</TD></TR>";
        writer.println("<html><body>");
        String hdrHtml = this.get_header_html();
        writer.println(hdrHtml);
        writer.println("<p>&nbsp;</p><p align=\"middle\">&nbsp;<FONT COLOR=#EF1E1E><strong><u>BOOKS DETAILS</u></strong></FONT></p><table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 800px;\"><tbody><tr BGCOLOR=#096734><td><FONT COLOR=#FEFFFE>&nbsp; Sr.No&nbsp;</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Faculty Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Books Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Author Name</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Fine</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Return Date</FONT></td><td><FONT COLOR=#FEFFFE>&nbsp; Status</FONT></td></tr>" + html + "</tbody></table>  <p>&nbsp;</p><p>Date :&nbsp; &nbsp; " + this.glbObj.sysDate + "&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p>Time :&nbsp; &nbsp; " + this.glbObj.sysTime + "&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </p><p align=\"right\">Signature : &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>");
        writer.println("</body></html>");
    }

    public boolean faculty_namewise_fine_details() throws IOException {
        boolean c;
        boolean ret = false;
        if (this.glbObj.all_fac.equals("1")) {
            this.tlvObj.setTlv(78);
            c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
            } else {
                this.glbObj.fac_booknm_rep_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.1_bookname");
                this.glbObj.fac_auth_rep_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.2_author");
                this.glbObj.fac_fine_rep_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.3_fine");
                this.glbObj.fac_returndate_rep_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.4_returningdate");
                this.glbObj.fac_bstatus_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.6_bstatus");
                ret = true;
            }
        }
        if (this.glbObj.all_fac.equals("2")) {
            System.out.println("222 all fac");
            this.tlvObj.setTlv(78);
            c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
            } else {
                this.glbObj.fac_booknm_rep_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.1_bookname");
                this.glbObj.fac_auth_rep_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.2_author");
                this.glbObj.fac_fine_rep_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.3_fine");
                this.glbObj.fac_returndate_rep_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.4_returningdate");
                this.glbObj.fac_usrid_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.5_userid");
                this.glbObj.fac_bstatus_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.6_bstatus");
                this.glbObj.fac_usrname_Lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.7_usrname");
                ret = true;
            }
        }
        return ret;
    }

    public boolean get_all_teachers_from_tfactultydetailtbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(79);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.fac_usrname_Lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.1_distinct(usrname)");
            this.glbObj.fac_usrid_lst = this.log.GetValuesFromTbl("tfacultybookdetailtbl.2_userid");
            System.out.println("glbObj.fac_usrid_lst==" + this.glbObj.fac_usrid_lst);
            System.out.println("glbObj.fac_usrname_Lst==" + this.glbObj.fac_usrname_Lst);
            check = true;
        }
        return check;
    }

    public void delete_create_student_QR_html() {
        this.filepath = ".\\student_QR\\" + this.glbObj.libid;
        this.htmlPath = this.filepath + "student_QR.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public String create_student_QR_html() {
        this.filepath = ".\\student_QR\\" + this.glbObj.libid;
        this.htmlPath = this.filepath + "student_QR.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        this.create_student_QR_html(writer);
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    private void create_student_QR_html(PrintWriter writer) {
        String html = "";
        String data = "";
        String uniquebookid = "";
        String qr_codescript = "";
        qr_codescript = qr_codescript + "<table>";
        qr_codescript = qr_codescript + "<tbody>";
        for (int i = 0; i < this.glbObj.ubookid_lst.size(); ++i) {
            this.glbObj.book_name = this.glbObj.librarian_bookname_lst.get(i).toString();
            this.glbObj.book_id = this.glbObj.librarian_id_lst.get(i).toString();
            this.glbObj.ubookid_cur = this.glbObj.ubookid_lst.get(i).toString();
            this.glbObj.tbookcatid_cur = this.glbObj.tbookcatid_lst.get(i).toString();
            qr_codescript = qr_codescript + "<TR><TD>";
            data = this.glbObj.ubookid_cur + this.glbObj.tbookcatid_cur + this.glbObj.libid;
            System.out.println("data==" + data);
            uniquebookid = this.glbObj.book_id + "";
            qr_codescript = qr_codescript + "book Name :" + this.glbObj.book_name + "";
            qr_codescript = qr_codescript + "<br>";
            qr_codescript = qr_codescript + this.generate_qr_code_book(data, uniquebookid);
            qr_codescript = qr_codescript + "</TD></TR>";
        }
        qr_codescript = qr_codescript + "</table>";
        qr_codescript = qr_codescript + "</body>";
        writer.println("<html><body>");
        writer.println("<p>&nbsp;</p>" + qr_codescript);
        writer.println("</body></html>");
    }

    public String generate_qr_code_book(String data, String uniquebookid) {
        String str = "";
        str = str + "<script src=\"http://ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js\"></script> ";
        str = str + "<script type=\"text/javascript\"> ";
        str = str + "function generateBarCode() ";
        str = str + "{ ";
        str = str + "var nric = $('#text').val(); ";
        System.out.println("var nric===" + str);
        str = str + "} ";
        str = str + " </script>";
        str = str + " <type=\"text\"";
        str = str + "style=\"Width:40%\"";
        str = str + " onblur='generateBarCode();'/>";
        str = str + " <img id='barcode'";
        str = str + " src=\"https://api.qrserver.com/v1/create-qr-code/?data=" + data + "&amp;size=100x100\"";
        str = str + " alt=\"\"";
        str = str + " title=\"HELLO\"";
        str = str + " width=\"100\"";
        str = str + " height=\"100\"/>";
        return str;
    }

    public boolean insert_bookdetail_into_uniquebook_details() throws IOException {
        int temp_count = Integer.parseInt(this.glbObj.bk_count);
        System.out.println("temp_count==" + temp_count);
        boolean check = false;
        for (int i = 0; i < temp_count; ++i) {
            this.tlvObj.setTlv(80);
            boolean ch = false;
            this.do_all_network();
            if (this.log.error_code == 0) continue;
            check = false;
        }
        return check;
    }

    public boolean get_complete_book_details_tbooktbl() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(81);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.book_name = this.log.GetValuesFromTbl("tbooktbl.1_bname").get(0).toString();
            this.glbObj.bk_author = this.log.GetValuesFromTbl("tbooktbl.2_author").get(0).toString();
            this.glbObj.lib_totbk_cur = this.log.GetValuesFromTbl("tbooktbl.3_totalbooks").get(0).toString();
            System.out.println("this.glbObj.lib_bookname_cur==" + this.glbObj.lib_bookname_cur);
            System.out.println("this.glbObj.lib_authr_cur==" + this.glbObj.lib_authr_cur);
            System.out.println("this.glbObj.lib_totbk_cur==" + this.glbObj.lib_totbk_cur);
            ret = true;
        }
        return ret;
    }

    public boolean update_bookstatus_tuniquebookbl() throws IOException {
        boolean check = false;
        for (int i = 0; i < this.glbObj.borrow_books_lst.size(); ++i) {
            this.glbObj.book_id = this.glbObj.borrow_books_lst.get(i).toString();
            this.tlvObj.setTlv(82);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.log.AppLock();
            this.dblib.skip_db_exec = true;
            this.dblib.get_from_db(this.glbObj.tlvStr);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.dblib.PostDBExec("");
                check = true;
            }
            this.log.AppUnLock();
        }
        return check;
    }

    public boolean insert_uniquebook_details() throws IOException {
        int temp_count = Integer.parseInt(this.glbObj.bk_count);
        boolean check = false;
        for (int i = 0; i < temp_count; ++i) {
            this.tlvObj.setTlv(83);
            boolean ch = false;
            this.do_all_network();
            if (this.log.error_code == 0) continue;
            check = false;
        }
        return check;
    }

    public boolean update_returnbookstatus_into_tuniqueboktbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(84);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        this.log.AppLock();
        this.do_all_network();
        check = this.log.error_code == 0;
        this.log.AppUnLock();
        return check;
    }

    public boolean get_book_details_tbooktbl_report() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(85);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.librarian_bookname_lst = this.log.GetValuesFromTbl("tbooktbl.1_bname");
            this.glbObj.librarian_author_lst = this.log.GetValuesFromTbl("tbooktbl.2_author");
            this.glbObj.librarian_totalbooks_lst = this.log.GetValuesFromTbl("tbooktbl.3_publisher");
            this.glbObj.book_cat_id_lst = this.log.GetValuesFromTbl("tbooktbl.4_tbookcatid");
            this.glbObj.book_bookid = this.log.GetValuesFromTbl("tbooktbl.5_bookid");
            this.glbObj.book_price_lst = this.log.GetValuesFromTbl("tbooktbl.6_price");
            System.out.println("this.glbObj.lib_bookname_cur==" + this.glbObj.librarian_bookname_lst);
            System.out.println("this.glbObj.lib_authr_cur==" + this.glbObj.librarian_author_lst);
            System.out.println("this.glbObj.lib_totbk_cur==" + this.glbObj.librarian_totalbooks_lst);
            System.out.println("this.glbObj.this.glbObj.book_bookid==" + this.glbObj.book_bookid);
            System.out.println("this.glbObj.lib_totbk_cur==" + this.glbObj.book_price_lst);
            ret = true;
        }
        return ret;
    }

    public boolean get_fine_details_tbookborrowtbl_report() throws IOException {
        this.log.delim = "//.";
        this.dblib.pme.delim = "//.";
        boolean ret = false;
        this.tlvObj.setTlv(86);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.booknm_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.1_bookname");
            this.glbObj.auth_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.2_author");
            this.glbObj.fine_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.3_fine");
            this.glbObj.returndate_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.4_returndate");
            this.glbObj.userid_lst = this.log.GetValuesFromTbl("tbookborrowtbl.5_userid");
            this.glbObj.bstatus_lst = this.log.GetValuesFromTbl("tbookborrowtbl.6_status");
            ret = true;
        }
        return ret;
    }

    public boolean get_student_duedate_tbookborrowtbl_report() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(87);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.booknm_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.1_bookname");
            this.glbObj.auth_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.2_author");
            this.glbObj.userid_lst = this.log.GetValuesFromTbl("tbookborrowtbl.3_userid");
            this.glbObj.borrow_duedate_lst = this.log.GetValuesFromTbl("tbookborrowtbl.4_duedate");
            ret = true;
        }
        return ret;
    }

    public boolean get_faculty_duedate_tfacultybookborrowtbl_report() throws IOException {
        boolean ret = false;
        this.tlvObj.setTlv(88);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.do_all_network();
        if (this.log.error_code != 0) {
            ret = false;
        } else {
            this.glbObj.booknm_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.1_bookname");
            this.glbObj.auth_rep_lst = this.log.GetValuesFromTbl("tbookborrowtbl.2_author");
            this.glbObj.userid_lst = this.log.GetValuesFromTbl("tbookborrowtbl.3_userid");
            this.glbObj.borrow_duedate_lst = this.log.GetValuesFromTbl("tbookborrowtbl.4_duedate");
            ret = true;
        }
        return ret;
    }

    public boolean get_book_count_tuniquebooktbl_report() throws IOException {
        boolean ret = false;
        this.glbObj.book_count_lst.clear();
        for (int i = 0; i < this.glbObj.book_bookid.size(); ++i) {
            this.glbObj.book_id = this.glbObj.book_bookid.get(i).toString();
            this.tlvObj.setTlv(89);
            boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
            if (!c) {
                return false;
            }
            this.do_all_network();
            if (this.log.error_code != 0) {
                ret = false;
                continue;
            }
            this.glbObj.book_count_lst.add(this.log.GetValuesFromTbl("tuniquebooktbl.1_count(*)").get(0).toString());
            System.out.println("this.glbObj.book_count_lst===" + this.glbObj.book_count_lst);
            ret = true;
        }
        return ret;
    }

    public String get_sum(String q, int args) {
        String retStr = "";
        this.glbObj.req_type = 709;
        this.glbObj.tlvStr = q;
        this.glbObj.req_type = this.glbObj.req_type;
        this.log.delim = "\\^";
        System.out.println("q=" + q);
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code != 0) {
            return "-1";
        }
        int i = 1;
        String sum = "";
        String arg = "";
        while (i <= args) {
            arg = "X^" + i + "_" + i;
            System.out.println("arg=" + arg);
            sum = i == 1 ? this.log.GetValuesFromTbl(arg).get(0).toString().trim() : sum + "#" + this.log.GetValuesFromTbl(arg).get(0).toString().trim();
            ++i;
        }
        this.log.delim = "\\.";
        return sum;
    }

    public void createReport(String tableStr, String fileName) {
        File file = new File(this.filepath + "/" + fileName);
        if (file.exists()) {
            file.delete();
        }
        PrintWriter writer = null;
        this.htmlPath = this.filepath + "/" + fileName;
        String watermark = "<div id=\"background\">\n  <p id=\"bg-text\">" + this.glbObj.inst_name + "</p>\n\t</div>";
        writer = this.get_writer_stream();
        writer.println("<html><body><style>\n#background{\n    position:absolute;\n    z-index:0;\n    background:white;\n    display:block;\n    min-height:50%; \n    min-width:50%;\n    color:yellow;\n}\n\n#content{\n    position:absolute;\n    z-index:1;\n}\n\n#bg-text\n{\n    color:lightgrey;\n    font-size:120px;\n    transform:rotate(300deg);\n    -webkit-transform:rotate(300deg);\n}table {\n border: 1px solid black;\n  width: 85%;\n}\n\nth, td {\n  text-align: left;\n  padding: 8px;\n}\n\ntr:nth-child(even){background-color:  #f2f2f2}\n\nth {\n  background-color: #4CAF50;\n  color: white;\n}\nbody {\n  margin: 1;\n  padding: 0;\n\n}\n\n* {\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n}\n\n.page {\n  width: 21cm;\n  min-height: 29.7cm;\n  padding: 2cm;\n  margin: 1cm auto;\n  border: 1px #D3D3D3 solid;\n  border-radius: 5px;\n  background: white;\n  box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);\n}\n\n.subpage {\n  padding: 1cm;\n  border: 5px red solid;\n  height: 256mm;\n  outline: 2cm #FFEAEA solid;\n}\n@page {\n  size: A4;\n  margin: 0;\n}\n\n@media print {\n  html, body {\n    width: 210mm;\n    height: 297mm;\n  }\n  }\n</style>");
        String hdrHtml = this.get_header_html();
        writer.println("" + hdrHtml + "<center><table align=\"center\"  style=\"width:80%\" border=\"1\">" + tableStr + "</table></center>");
        writer.println("</body></html>");
        writer.close();
    }

    public void createBlankReport(String tableStr, String fileName) {
        File file = new File(this.filepath + "/" + fileName);
        if (file.exists()) {
            file.delete();
        }
        PrintWriter writer = null;
        this.htmlPath = this.filepath + "/" + fileName;
        writer = this.get_writer_stream();
        writer.println(tableStr);
        writer.close();
    }

    public boolean get_generic_ex(String loadType) {
        this.glbObj.from_row = 0;
        int temp = 0;
        boolean i = false;
        int ret = 0;
        this.glbObj.req_count = 300;
        this.glbObj.from_row = 0;
        this.glbObj.to_row = 0;
        if (loadType.isEmpty()) {
            this.glbObj.genMap.clear();
        }
        this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
        boolean rem = true;
        while (true) {
            this.get_generic_data_ex(rem, loadType);
            rem = false;
            this.glbObj.from_row = temp = this.glbObj.to_row;
            this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
            this.glbObj.Recs = ret = TGLibraryLib.getRecordCount(this.log.rcv_buff);
            if (ret <= 0) {
                this.glbObj.tot_rec = 0;
                break;
            }
            this.glbObj.tot_rec += this.glbObj.req_count;
            System.out.println("ret==" + ret + " this.glbObj.req_count=" + this.glbObj.req_count);
            if (ret < this.glbObj.req_count) {
                this.glbObj.tot_rec = 0;
                break;
            }
            System.out.println(">>this.glbObj.count===" + this.glbObj.req_count + "this.glbObj.from_row===" + this.glbObj.from_row + "this.glbObj.to_row===" + this.glbObj.to_row);
        }
        System.out.println("this.glbObj.Recs=" + this.glbObj.Recs);
        return true;
    }

    private void get_generic_data_ex(boolean rem, String loadType) {
        String tlvStr = "";
        String tlvStr2 = "";
        this.glbObj.req_type = 709;
        if (loadType.isEmpty()) {
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
            System.out.println("Generic tlvStr=" + tlvStr);
        }
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.glbObj.tlvStr = tlvStr;
        this.glbObj.req_type = this.glbObj.req_type;
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.log.error_code != 0) {
            this.log.delim = "\\.";
            return;
        }
        int rec_len = 0;
        List l1 = this.log.GetValuesFromTbl("X^1_1");
        int i = 0;
        if (l1 != null && l1.size() > 0 && loadType.isEmpty()) {
            rec_len = this.getRecLen(this.log.rcv_buff);
            if (loadType.isEmpty()) {
                System.out.println("RecLen=" + rec_len + " GEN_LOAD");
                String arg = "";
                List tmpL = null;
                for (int z = 1; z <= rec_len; ++z) {
                    arg = "X^" + z + "_" + z;
                    tmpL = this.log.GetValuesFromTbl(arg);
                    if (tmpL == null) {
                        this.log.delim = "\\.";
                        return;
                    }
                    ArrayList lst = this.glbObj.genMap.get(z + "");
                    if (lst == null) {
                        lst = new ArrayList();
                        this.glbObj.genMap.put(z + "", lst);
                        lst = this.glbObj.genMap.get(z + "");
                    }
                    for (i = 0; tmpL != null && i < tmpL.size(); ++i) {
                        lst.add(tmpL.get(i).toString());
                    }
                    this.glbObj.genMap.put(z + "", lst);
                }
                this.log.delim = "\\.";
                return;
            }
        }
        this.log.delim = "\\.";
    }

    private int getRecLen(String l) {
        String[] split = l.split("&record#2");
        String pr = split[0];
        String[] sp = pr.split("&");
        String last = sp[sp.length - 1];
        String maxRecords = last.split("#")[0].split("_")[1];
        return Integer.parseInt(maxRecords);
    }

    public static int getRecordCount(String x) {
        if (x == null || x.isEmpty()) {
            return 0;
        }
        if (x.contains("ErrorCode")) {
            return 0;
        }
        int r = x.lastIndexOf("record");
        if (r < 0) {
            return 0;
        }
        String y = x.substring(r);
        System.out.println("r=" + r + " y=" + y);
        String[] split = y.split("&");
        if (split == null || split.length == 0) {
            return 0;
        }
        String[] split1 = split[0].split("#");
        if (split1 == null || split1.length == 0) {
            return 0;
        }
        int rec_no = Integer.parseInt(split1[1]);
        System.out.println("REC_NO=" + rec_no);
        return rec_no;
    }

    public String non_select(String q) {
        this.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.dblib.pme.delim = "\\^";
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println(" this.glbObj.inc_value=" + this.log.rcv_buff);
        }
        catch (IOException ex) {
            Logger.getLogger(TGLibraryLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.log.error_code == 2) {
            return "-1";
        }
        List l1 = this.log.GetValuesFromTbl("X^1_1");
        System.out.println("l1=>" + l1);
        this.dblib.pme.delim = "\\.";
        this.log.delim = "\\.";
        if (l1 != null && l1.size() > 0) {
            return l1.get(0).toString();
        }
        return "-1";
    }

    public void delete_create_student_BAR_CODE_html() {
        this.filepath = ".\\student_bar_code\\" + this.glbObj.libid;
        this.htmlPath = this.filepath + "student_bar_code.html";
        File file = new File(this.htmlPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public String create_student_BAR_CODE_html() {
        this.filepath = ".\\student_bar_code\\" + this.glbObj.libid;
        this.htmlPath = this.filepath + "student_bar_code.html";
        PrintWriter writer = this.get_writer_stream();
        System.out.println("filepath=" + this.filepath);
        this.glbObj.logoPath = this.getLogoPath();
        if (writer == null) {
            System.out.println("File Exists");
            return this.htmlPath;
        }
        this.create_student_BAR_CODE_html(writer);
        writer.close();
        System.out.println("filepath=" + this.filepath + "  htmlPath=" + this.htmlPath);
        return this.htmlPath;
    }

    private void create_student_BAR_CODE_html(PrintWriter writer) {
        String html = "";
        String data = "";
        String uniquebookid = "";
        String qr_codescript = "";
        qr_codescript = qr_codescript + "<table>";
        qr_codescript = qr_codescript + "<tbody>";
        for (int i = 0; i < this.glbObj.ubookid_lst.size(); ++i) {
            this.glbObj.book_name = this.glbObj.librarian_bookname_lst.get(i).toString();
            this.glbObj.book_id = this.glbObj.librarian_id_lst.get(i).toString();
            this.glbObj.ubookid_cur = this.glbObj.ubookid_lst.get(i).toString();
            this.glbObj.tbookcatid_cur = this.glbObj.tbookcatid_lst.get(i).toString();
            qr_codescript = qr_codescript + "<TR><TD>";
            data = this.glbObj.ubookid_cur + this.glbObj.tbookcatid_cur + this.glbObj.libid;
            System.out.println("data==" + data);
            uniquebookid = i + "";
            qr_codescript = qr_codescript + "book Name :" + this.glbObj.book_name + "";
            qr_codescript = qr_codescript + "<br>";
            qr_codescript = qr_codescript + this.generate_bar_code_book(data, uniquebookid);
            qr_codescript = qr_codescript + "</TD></TR>";
        }
        qr_codescript = qr_codescript + "</table>";
        qr_codescript = qr_codescript + "</body>";
        writer.println("<html><body>");
        writer.println("<p>&nbsp;</p>" + qr_codescript);
        writer.println("</body></html>");
    }

    public String generate_bar_code_book(String data, String uniquebookid) {
        String str = "";
        str = str + "<script src=\"http://ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js\"></script> ";
        str = str + "<script type=\"text/javascript\"> ";
        str = str + "function generateBarCode() ";
        str = str + "{ ";
        str = str + "var nric = $('#text').val(); ";
        System.out.println("var nric===" + str);
        str = str + "} ";
        str = str + " </script>";
        str = str + " <type=\"text\"";
        str = str + "style=\"Width:40%\"";
        str = str + " onblur='generateBarCode();'/>";
        str = str + " <img id='barcode'";
        str = str + "src=\"https://www.barcodesinc.com/generator/image.php?code=" + data + "&style=197&type=C128B&width=100&height=100&xres=1&font=3\"";
        str = str + " alt=\"\"";
        str = str + " title=\"HELLO\"";
        str = str + " width=\"100\"";
        str = str + " height=\"100\"/>";
        return str;
    }
}

