/*
 * Decompiled with CFR 0.152.
 */
package leaderlib;

import academicerrorlib.AcademicErrorLib;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Environment;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import leaderdblib.LeaderDBLib;
import leaderlib.LeaderGlb;
import leaderlib.LeaderTlv;
import sqliteDB.sqliteDB;
import trueguidelibrary.TrueGuideLibrary;
import trueguidelogin.TrueGuideLogin;

public class LeaderLib
extends ContextWrapper {
    public LeaderGlb glbObj = new LeaderGlb();
    public LeaderTlv tlvObj = new LeaderTlv(this.glbObj);
    String configFileName = Environment.getExternalStorageDirectory() + "/TrueGuide/Databases/config.txt";
    public TrueGuideLibrary log = new TrueGuideLibrary(this.configFileName);
    public TrueGuideLogin loginobj = new TrueGuideLogin(this.log);
    public AcademicErrorLib error;
    public String version = "0";
    public String[] feature = new String[]{"", ""};
    public sqliteDB db = null;
    public LeaderDBLib dblib = null;
    Map<String, List> ListMap = null;
    public boolean thread_call = false;
    public static String version_id = "TGA-W-10thOct17";
    public static String libname = "StudentLib";

    public LeaderLib(Context base) {
        super(base);
        this.loginobj.InitDbHandler(base);
        TrueGuideLibrary.DBfile = "LeaderDB.db";
        TrueGuideLibrary.tgVer = 1;
        this.dblib = new LeaderDBLib(base, this.log);
        this.db = this.dblib.dbhand;
        this.dblib.initParser(this.log);
        this.dblib.CreateLeaderSchema();
        this.error = new AcademicErrorLib(this.log);
        TrueGuideLibrary.addVersionInfo(libname, version_id);
    }

    public void Set_MobileNumber(String mbl) {
        this.loginobj.tutil.SetMobileNumber(mbl);
    }

    public void Set_passWord(String pass) {
        this.loginobj.tutil.SetPassword(pass);
    }

    public boolean Reg_Get_UserID() throws IOException {
        boolean check = false;
        boolean i = this.loginobj.reg_get_usrid();
        System.out.println("Boolean check-->" + i);
        this.glbObj.userid = this.loginobj.tutil.GetUserID();
        System.out.println("error code inside -->" + this.glbObj.userid);
        return check;
    }

    public boolean save_login_details() {
        this.loginobj.save_login_details();
        return true;
    }

    public boolean isAutoLogin() {
        boolean islogin = this.loginobj.isAutoLogin();
        String u = TrueGuideLibrary.configMap.get("U");
        String p = TrueGuideLibrary.configMap.get("P");
        this.glbObj.mobno = u;
        this.glbObj.cnfrmpass = p;
        System.out.println("log.configMap=" + TrueGuideLibrary.configMap);
        if (u != null && p != null) {
            return true;
        }
        if (islogin) {
            this.glbObj.mobno = this.log.MobileNumber;
            this.glbObj.cnfrmpass = this.log.Password;
        }
        return islogin;
    }

    public boolean resend_otp() throws IOException {
        boolean check = this.loginobj.resend_otp();
        return check;
    }

    public boolean Set_OtpFun() throws IOException {
        boolean check = this.loginobj.set_otpfun();
        return check;
    }

    public void setotp(String otp) throws IOException {
        this.loginobj.SetUtilityOpt(otp);
    }

    public boolean ConfirmOtp() throws IOException {
        boolean check = this.loginobj.confirm_otp();
        return check;
    }

    public void Set_ModuleIDAndRoleID() throws IOException {
        this.log.Module_ID = "election";
        this.log.Role_id = "leaderapp";
        this.log.version = this.version = "1.0.0.0";
        this.loginobj.SetttingModuleAndRole(this.log.Module_ID, this.log.Role_id, this.version);
    }

    public boolean do_all_network() throws IOException {
        System.out.println("thread call-=--------" + this.thread_call);
        if (this.thread_call) {
            this.log.rcv_buff = this.log.do_all_network_thread(this.tlvObj.glbObj.req_type, this.tlvObj.glbObj.tlvStr);
            this.thread_call = false;
        } else {
            this.log.performFulloperation(this.tlvObj.glbObj.req_type, this.tlvObj.glbObj.tlvStr.length(), this.tlvObj.glbObj.tlvStr);
        }
        System.out.println("The received buffer is =:" + this.log.rcv_buff);
        return true;
    }

    public boolean check_otp_generated() throws IOException {
        boolean ret = true;
        this.loginobj.tutil.SetMobileNumber(this.glbObj.mobileno);
        this.loginobj.check_otp_generated();
        this.glbObj.check_opt_gen = this.loginobj.tutil.GetOTP();
        if (this.glbObj.check_opt_gen.equals("None")) {
            ret = false;
        }
        return ret;
    }

    public void set_system_date_and_time() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd#HH:mm:ss");
        Date date = new Date();
        String today_date = dateFormat.format(date);
        String[] dt = today_date.split("#");
        this.glbObj.sysDate = dt[0];
        this.glbObj.sysTime = dt[1];
    }

    public void GetPassword() throws IOException {
        this.loginobj.get_password_leader();
        this.glbObj.password = this.loginobj.rcv_passwd;
        this.log.error_code = 0;
        System.out.println("Get password func--->" + this.glbObj.password);
    }

    public boolean check_number_already_registered_or_approved() throws IOException {
        boolean check = false;
        this.loginobj.check_number_already_registered_or_approved();
        this.glbObj.userid = this.loginobj.tutil.GetUserID();
        this.glbObj.status = this.loginobj.tutil.GetStatus();
        return check;
    }

    public boolean get_generic_ex(String loadType) {
        this.glbObj.from_row = 0;
        int temp = 0;
        boolean i = false;
        int ret = 0;
        this.glbObj.req_count = 300;
        this.glbObj.from_row = 0;
        this.glbObj.to_row = 0;
        if (loadType.isEmpty()) {
            this.glbObj.genMap.clear();
        }
        this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
        boolean rem = true;
        while (true) {
            this.get_generic_data_ex(rem, loadType);
            rem = false;
            this.glbObj.from_row = temp = this.glbObj.to_row;
            this.glbObj.to_row = this.glbObj.from_row + this.glbObj.req_count;
            this.glbObj.Recs = ret = LeaderLib.getRecordCount(this.log.rcv_buff);
            if (ret <= 0) {
                this.glbObj.tot_rec = 0;
                break;
            }
            this.glbObj.tot_rec += this.glbObj.req_count;
            System.out.println("ret==" + ret + " this.glbObj.req_count=" + this.glbObj.req_count);
            if (ret < this.glbObj.req_count) {
                this.glbObj.tot_rec = 0;
                break;
            }
            System.out.println(">>this.glbObj.count===" + this.glbObj.req_count + "this.glbObj.from_row===" + this.glbObj.from_row + "this.glbObj.to_row===" + this.glbObj.to_row);
        }
        System.out.println("this.glbObj.Recs=" + this.glbObj.Recs);
        return true;
    }

    public String non_select(String q) {
        this.glbObj.req_type = 714;
        this.tlvObj.glbObj.tlvStr = q;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.log.delim = "\\^";
        try {
            this.do_all_network();
        }
        catch (IOException ex) {
            Logger.getLogger(LeaderLib.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println(" this.glbObj.inc_value=" + this.log.rcv_buff);
        if (this.log.error_code == 2) {
            this.log.delim = "\\.";
            return "-1";
        }
        List l1 = this.log.GetValuesFromTbl("X^1_1");
        System.out.println("l1=>" + l1);
        this.log.delim = "\\.";
        if (l1 != null && l1.size() > 0) {
            return l1.get(0).toString();
        }
        return "-1";
    }

    public List get_list(String val) {
        Map<String, List> ListMap = null;
        Map<String, Map<String, List>> screenMap = null;
        String screen = LeaderGlb.screen;
        String uid = LeaderGlb.uid;
        System.out.println("screen==>" + screen + " uid==>" + uid);
        if (!screen.isEmpty() && !uid.isEmpty()) {
            screenMap = LeaderGlb.opt_map.get(screen);
            if (screenMap != null) {
                ListMap = screenMap.get(uid);
            } else {
                screenMap = new HashMap<String, Map<String, List>>();
                LeaderGlb.opt_map.put(screen, screenMap);
            }
            if (ListMap == null) {
                ListMap = new HashMap<String, List>();
                screenMap.put(uid, ListMap);
            }
            if (ListMap.size() <= 0) {
                return null;
            }
        }
        if (ListMap == null) {
            return this.glbObj.genMap.get(val);
        }
        List lst = (List)ListMap.get(val);
        if (lst == null) {
            lst = this.glbObj.genMap.get(val);
        }
        return lst;
    }

    public boolean isOptimised() {
        boolean opt = false;
        String screen = "";
        String uid = "";
        Map<String, Map<String, List>> screenMap = null;
        Map<String, List> ListMapTmp = null;
        if (!LeaderGlb.screen.isEmpty()) {
            if (!LeaderGlb.uid.isEmpty()) {
                opt = true;
                screen = LeaderGlb.screen;
                uid = LeaderGlb.uid;
            }
        }
        System.out.println("XXX optimised screen=" + screen + " uid==" + uid + " >>" + LeaderGlb.screen);
        if (!screen.isEmpty() && !uid.isEmpty()) {
            screenMap = LeaderGlb.opt_map.get(screen);
            if (screenMap != null) {
                ListMapTmp = screenMap.get(uid);
            } else {
                screenMap = new HashMap<String, Map<String, List>>();
                LeaderGlb.opt_map.put(screen, screenMap);
            }
            System.out.println("XXX ListMap=" + ListMapTmp);
            if (ListMapTmp == null) {
                ListMapTmp = new HashMap<String, List>();
                screenMap.put(uid, ListMapTmp);
                LeaderGlb.opt_map.put(screen, screenMap);
                this.ListMap = ListMapTmp;
                return false;
            }
            this.ListMap = ListMapTmp;
            int sz = this.ListMap.size();
            if (sz > 0) {
                List r = this.ListMap.get("records");
                int cnt = 0;
                if (r != null) {
                    cnt = Integer.parseInt(r.get(0).toString());
                }
                System.out.println("XXX SZZZ=" + sz + " CNNT=" + cnt);
                if (sz - 1 == cnt) {
                    return true;
                }
                this.ListMap.clear();
                screenMap.put(uid, null);
                LeaderGlb.opt_map.put(screen, null);
            }
        }
        return false;
    }

    private void get_generic_data_ex(boolean rem, String loadType) {
        String tlvStr = "";
        String tlvStr2 = "";
        boolean optimised = this.isOptimised();
        System.out.println("XXX optimised==>" + optimised);
        if (optimised) {
            this.log.error_code = 0;
            return;
        }
        this.glbObj.req_type = 709;
        if (loadType.isEmpty()) {
            tlvStr = this.glbObj.tlvStr2 + "  limit  " + this.glbObj.req_count + " offset " + this.glbObj.from_row;
            System.out.println("Generic tlvStr=" + tlvStr);
        }
        System.out.println(">>>>tlvStr=" + tlvStr);
        this.tlvObj.glbObj.tlvStr = tlvStr;
        this.tlvObj.glbObj.req_type = this.glbObj.req_type;
        this.log.delim = "\\^";
        try {
            this.do_all_network();
            System.out.println("rcv=" + this.log.rcv_buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.log.error_code != 0) {
            LeaderGlb.screen = "";
            LeaderGlb.uid = "";
            this.log.delim = "\\.";
            return;
        }
        int rec_len = 0;
        List l1 = this.log.GetValuesFromTbl("X^1_1");
        int i = 0;
        if (l1 != null && l1.size() > 0 && loadType.isEmpty()) {
            rec_len = this.getRecLen(this.log.rcv_buff);
            if (this.ListMap != null) {
                ArrayList<String> x = new ArrayList<String>();
                x.add(rec_len + "");
                this.ListMap.put("records", x);
            }
            if (loadType.isEmpty()) {
                System.out.println("RecLen=" + rec_len + " GEN_LOAD");
                String arg = "";
                List tmpL = null;
                for (int z = 1; z <= rec_len; ++z) {
                    arg = "X^" + z + "_" + z;
                    tmpL = this.log.GetValuesFromTbl(arg);
                    if (tmpL == null) {
                        this.log.delim = "\\.";
                        return;
                    }
                    ArrayList lst = this.glbObj.genMap.get(z + "");
                    if (lst == null) {
                        lst = new ArrayList();
                        this.glbObj.genMap.put(z + "", lst);
                        lst = this.glbObj.genMap.get(z + "");
                    }
                    for (i = 0; tmpL != null && i < tmpL.size(); ++i) {
                        lst.add(tmpL.get(i).toString());
                    }
                    this.glbObj.genMap.put(z + "", lst);
                    if (this.ListMap == null) continue;
                    this.ListMap.put(z + "", lst);
                }
                this.log.delim = "\\.";
                return;
            }
        }
        this.log.delim = "\\.";
    }

    private int getRecLen(String l) {
        String[] split = l.split("&record#2");
        String pr = split[0];
        String[] sp = pr.split("&");
        String last = sp[sp.length - 1];
        String maxRecords = last.split("#")[0].split("_")[1];
        return Integer.parseInt(maxRecords);
    }

    public static int getRecordCount(String x) {
        if (x == null || x.isEmpty()) {
            return 0;
        }
        if (x.contains("ErrorCode")) {
            return 0;
        }
        int r = x.lastIndexOf("record");
        if (r < 0) {
            return 0;
        }
        String y = x.substring(r);
        System.out.println("r=" + r + " y=" + y);
        String[] split = y.split("&");
        if (split == null || split.length == 0) {
            return 0;
        }
        String[] split1 = split[0].split("#");
        if (split1 == null || split1.length == 0) {
            return 0;
        }
        int rec_no = Integer.parseInt(split1[1]);
        System.out.println("REC_NO=" + rec_no);
        return rec_no;
    }

    public boolean handleLogin_select_user_id() throws IOException {
        boolean check = false;
        this.loginobj.handleLogin_select_user_id_leader();
        this.glbObj.Luid = this.loginobj.leader_id;
        this.glbObj.leader_name = this.loginobj.leader_name;
        this.glbObj.otp_status = this.loginobj.status;
        this.glbObj.candidate_id = this.loginobj.candidate_id;
        this.glbObj.candidate_name = this.loginobj.candidate_name;
        this.glbObj.elebatch_id = this.loginobj.elebatch_id;
        this.glbObj.batch_name = this.loginobj.batch_name;
        this.glbObj.survey_pvg = this.loginobj.survey_pvg;
        this.glbObj.campaign_pvg = this.loginobj.campaign_pvg;
        this.glbObj.polling_pvg = this.loginobj.polling_pvg;
        return check;
    }

    public boolean get_leader_authentication() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(11);
        System.out.println("set tlv====" + this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.leaderid = this.log.GetValuesFromTbl("tleadertbl.1_leaderid").get(0).toString();
            this.glbObj.leaderstatus = this.log.GetValuesFromTbl("tleadertbl.2_status").get(0).toString();
            this.glbObj.candidateid = this.log.GetValuesFromTbl("tleadertbl.3_candid").get(0).toString();
            this.glbObj.leadername = this.log.GetValuesFromTbl("tleadertbl.4_leadername").get(0).toString();
            check = true;
        }
        return check;
    }

    public boolean get_subleaders() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            if (this.glbObj.subleaderid_list != null) {
                return true;
            }
            this.tlvObj.setTlv(12);
            System.out.println("set tlv====" + this.glbObj.tlvStr);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.subleaderid_list = this.log.GetValuesFromTbl("tsubleadertbl.1_subleaderid");
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.subleadername_list.clear();
            check = false;
            for (int i = 0; i < this.glbObj.subleaderid_list.size(); ++i) {
                this.glbObj.subleaderid_cur = this.glbObj.subleaderid_list.get(i).toString();
                this.tlvObj.setTlv(12);
                System.out.println("set tlv====" + this.glbObj.tlvStr);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.subleadername_list.add(this.log.GetValuesFromTbl("tsubleadertbl.2_subleadername").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean insert_subleader_details() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(13);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("tsubleadertbl.1_subleaderid");
            ch = true;
        }
        return ch;
    }

    public boolean get_regions() throws IOException {
        boolean check = false;
        if (this.glbObj.survey_setup) {
            this.tlvObj.setTlv(14);
            this.do_all_network();
            System.out.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                List lst = this.log.GetValuesFromTbl("tleaderregiontbl.1_distinct(regionid,regionname)");
                this.glbObj.regionid_list = new ArrayList();
                this.glbObj.regionname_list = new ArrayList();
                for (int i = 0; i < lst.size(); ++i) {
                    String str = lst.get(i).toString();
                    String[] tup = str.split(",");
                    String tup1 = tup[0].replace("(", "");
                    String tup2 = tup[1].replace(")", "");
                    this.glbObj.regionid_list.add(tup1);
                    this.glbObj.regionname_list.add(tup2);
                }
                this.glbObj.distname_lst = this.log.GetValuesFromTbl("tleaderregiontbl.2_distname");
                this.glbObj.taluk_lst = this.log.GetValuesFromTbl("tleaderregiontbl.3_taluk");
            }
        } else if (this.glbObj.ids_only) {
            this.glbObj.tlvStr2 = "select lregid,regionid,regionname,boothid,boothname,distname,taluk,leaderid,elebatchid,leadername from trueguide.tleaderregiontbl where lregid in (select lregid from trueguide.tleaderregiontbl where leaderid='" + this.glbObj.Luid + "' and elebatchid='" + this.glbObj.elebatch_id + "')";
            this.get_generic_ex("");
            if (this.log.error_code == 101) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Internet Connection";
                return false;
            }
            if (this.log.error_code == 2) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Data Found..." + this.log.error_code;
                return false;
            }
            if (this.log.error_code != 0) {
                this.log.toastBox = true;
                this.log.toastMsg = "Something went wrong:" + this.log.error_code;
                return false;
            }
            this.glbObj.leader_regid_list = this.get_list("1");
            this.glbObj.regionid_list = this.get_list("2");
            this.glbObj.regionname_list = this.get_list("3");
            this.glbObj.boothid_list = this.get_list("4");
            this.glbObj.boothname_list = this.get_list("5");
            this.glbObj.distname_lst = this.get_list("6");
            this.glbObj.taluk_lst = this.get_list("7");
            check = true;
        }
        return check;
    }

    public boolean get_assigned_regions() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.glbObj.subleader_regid_list = this.glbObj.subleader_to_subleader_region_tbl_map.get(this.glbObj.subleaderid_curr);
            if (this.glbObj.subleader_regid_list != null) {
                return true;
            }
            this.tlvObj.setTlv(15);
            this.do_all_network();
            System.out.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.subleader_regid_list = null;
                this.glbObj.subleader_regid_list = this.log.GetValuesFromTbl("tsubleaderregiontbl.1_slregid");
                this.glbObj.subleader_to_subleader_region_tbl_map.put(this.glbObj.subleaderid_curr, this.glbObj.subleader_regid_list);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.slid_list.clear();
            this.glbObj.slregionid_list.clear();
            this.glbObj.slregionname_list.clear();
            this.glbObj.slboothid_list.clear();
            this.glbObj.slboothname_list.clear();
            this.glbObj.slelebatchid_list.clear();
            this.glbObj.slleader_regid_list.clear();
            this.glbObj.subleader_regid_list = this.glbObj.subleader_to_subleader_region_tbl_map.get(this.glbObj.subleaderid_curr);
            check = false;
            for (int i = 0; i < this.glbObj.subleader_regid_list.size(); ++i) {
                this.glbObj.subleader_regid_curr = this.glbObj.subleader_regid_list.get(i).toString();
                this.tlvObj.setTlv(15);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                System.out.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.slid_list.add(this.log.GetValuesFromTbl("tsubleaderregiontbl.2_subleaderid").get(0).toString());
                this.glbObj.slregionid_list.add(this.log.GetValuesFromTbl("tsubleaderregiontbl.3_regionid").get(0).toString());
                this.glbObj.slregionname_list.add(this.log.GetValuesFromTbl("tsubleaderregiontbl.4_regionname").get(0).toString());
                this.glbObj.slboothid_list.add(this.log.GetValuesFromTbl("tsubleaderregiontbl.5_boothid").get(0).toString());
                this.glbObj.slboothname_list.add(this.log.GetValuesFromTbl("tsubleaderregiontbl.6_boothname").get(0).toString());
                this.glbObj.slelebatchid_list.add(this.log.GetValuesFromTbl("tsubleaderregiontbl.7_elebatchid").get(0).toString());
                this.glbObj.slleader_regid_list.add(this.log.GetValuesFromTbl("tsubleaderregiontbl.8_lregid").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean insert_into_subleaderregiontbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(16);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("tsubleaderregiontbl.1_slregid");
            ch = true;
        }
        return ch;
    }

    public boolean get_booths() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(17);
            System.out.println("set tlv====" + this.glbObj.tlvStr);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                if (this.glbObj.booths) {
                    this.glbObj.boothid_lst = this.log.GetValuesFromTbl("pregionboothtbl.1_boothid");
                }
                if (this.glbObj.group_type) {
                    this.glbObj.prepop_gtypeid_lst = this.log.GetValuesFromTbl("tgrouptypetbl.1_gtypeid");
                }
                if (this.glbObj.religion) {
                    this.glbObj.relid_lst = this.log.GetValuesFromTbl("pemreligiontbl.1_relid");
                }
                if (this.glbObj.groups) {
                    this.glbObj.groupid_lst = this.log.GetValuesFromTbl("tregiongrouptbl.1_groupid");
                }
                if (this.glbObj.get_orientation) {
                    this.glbObj.inflid_lst = this.log.GetValuesFromTbl("tinflorienttbl.1_infoid");
                }
                if (this.glbObj.get_factor) {
                    this.glbObj.orient_factorid_lst = this.log.GetValuesFromTbl("torientfactorstbl.1_ofid");
                }
                if (this.glbObj.get_party) {
                    this.glbObj.partyid_lst = this.log.GetValuesFromTbl("tpartytbl.1_ptid");
                }
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            boolean ca;
            int i;
            if (this.glbObj.booths) {
                this.glbObj.boothname_lst.clear();
                check = false;
                for (i = 0; i < this.glbObj.boothid_lst.size(); ++i) {
                    this.glbObj.boothid_curr = this.glbObj.boothid_lst.get(i).toString();
                    this.tlvObj.setTlv(17);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.boothname_lst.add(this.log.GetValuesFromTbl("pregionboothtbl.2_boothname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.group_type) {
                this.glbObj.prepop_gtype_lst.clear();
                check = false;
                for (i = 0; i < this.glbObj.prepop_gtypeid_lst.size(); ++i) {
                    this.glbObj.prepop_gtypeid_cur = this.glbObj.prepop_gtypeid_lst.get(i).toString();
                    this.tlvObj.setTlv(17);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.prepop_gtype_lst.add(this.log.GetValuesFromTbl("tgrouptypetbl.2_gtype").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.religion) {
                this.glbObj.relname_lst.clear();
                check = false;
                for (i = 0; i < this.glbObj.relid_lst.size(); ++i) {
                    this.glbObj.relid_cur = this.glbObj.relid_lst.get(i).toString();
                    this.tlvObj.setTlv(17);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.relname_lst.add(this.log.GetValuesFromTbl("pemreligiontbl.2_relname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.groups) {
                this.glbObj.grouptype_lst.clear();
                this.glbObj.groupname_lst.clear();
                this.glbObj.group_relname_lst.clear();
                this.glbObj.group_relid_lst.clear();
                this.glbObj.group_boothid_lst.clear();
                this.glbObj.group_boothname_lst.clear();
                this.glbObj.group_count_lst.clear();
                this.glbObj.group_party_lst.clear();
                check = false;
                for (i = 0; i < this.glbObj.groupid_lst.size(); ++i) {
                    this.glbObj.groupid_cur = this.glbObj.groupid_lst.get(i).toString();
                    this.tlvObj.setTlv(17);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.grouptype_lst.add(this.log.GetValuesFromTbl("tregiongrouptbl.2_gtype").get(0).toString());
                    this.glbObj.groupname_lst.add(this.log.GetValuesFromTbl("tregiongrouptbl.3_groupname").get(0).toString());
                    this.glbObj.group_relname_lst.add(this.log.GetValuesFromTbl("tregiongrouptbl.4_relname").get(0).toString());
                    this.glbObj.group_relid_lst.add(this.log.GetValuesFromTbl("tregiongrouptbl.5_relid").get(0).toString());
                    this.glbObj.group_boothid_lst.add(this.log.GetValuesFromTbl("tregiongrouptbl.6_boothid").get(0).toString());
                    this.glbObj.group_boothname_lst.add(this.log.GetValuesFromTbl("tregiongrouptbl.7_boothname").get(0).toString());
                    this.glbObj.group_count_lst.add(this.log.GetValuesFromTbl("tregiongrouptbl.9k_gcount").get(0).toString());
                    this.glbObj.group_party_lst.add(this.log.GetValuesFromTbl("tregiongrouptbl.9l_gparty").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.get_orientation) {
                this.glbObj.orient_lst.clear();
                this.glbObj.crit_lst.clear();
                check = false;
                for (i = 0; i < this.glbObj.inflid_lst.size(); ++i) {
                    this.glbObj.inflid_cur = this.glbObj.inflid_lst.get(i).toString();
                    this.tlvObj.setTlv(17);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.orient_lst.add(this.log.GetValuesFromTbl("tinflorienttbl.2_orientation").get(0).toString());
                    this.glbObj.crit_lst.add(this.log.GetValuesFromTbl("tinflorienttbl.3_criteria").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.get_factor) {
                this.glbObj.factor_lst.clear();
                check = false;
                for (i = 0; i < this.glbObj.orient_factorid_lst.size(); ++i) {
                    this.glbObj.orient_factorid_cur = this.glbObj.orient_factorid_lst.get(i).toString();
                    this.tlvObj.setTlv(17);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.factor_lst.add(this.log.GetValuesFromTbl("torientfactorstbl.2_factor").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.get_party) {
                this.glbObj.partyname_lst.clear();
                check = false;
                for (i = 0; i < this.glbObj.partyid_lst.size(); ++i) {
                    this.glbObj.partyid_cur = this.glbObj.partyid_lst.get(i).toString();
                    this.tlvObj.setTlv(17);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.partyname_lst.add(this.log.GetValuesFromTbl("tpartytbl.2_partyname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
        }
        return check;
    }

    public boolean get_sectors() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(18);
        System.out.println("set tlv====" + this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.regsectorid_list = this.log.GetValuesFromTbl("pregionsectortbl.1_sectorid");
            this.glbObj.regsectorname_list = this.log.GetValuesFromTbl("pregionsectortbl.2_sectorname");
            check = true;
        }
        return check;
    }

    public boolean get_subleaderid() throws IOException {
        this.glbObj.ids_only = true;
        if (true) {
            this.glbObj.tlvStr2 = "select subleadername from trueguide.tsubleadertbl where subleaderid in (select subleaderid from trueguide.tsubleaderregiontbl where regionid='" + this.glbObj.regionid_cur + "' and boothid='" + this.glbObj.boothid_cur + "')";
            this.get_generic_ex("");
            if (this.log.error_code == 101) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Internet Connection";
                return false;
            }
            if (this.log.error_code == 2) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Data Found..." + this.log.error_code;
                return false;
            }
            if (this.log.error_code != 0) {
                this.log.toastBox = true;
                this.log.toastMsg = "Something went wrong:" + this.log.error_code;
                return false;
            }
            this.glbObj.subleaderid_lst = this.get_list("1");
            this.glbObj.subleader_name_lst = this.get_list("2");
        }
        return true;
    }

    public boolean get_subleader_name() throws IOException {
        boolean check = false;
        this.glbObj.subleader_name_lst.clear();
        for (int i = 0; i < this.glbObj.subleaderid_lst.size(); ++i) {
            this.glbObj.subleaderid_cur = this.glbObj.subleaderid_lst.get(i).toString();
            this.tlvObj.setTlv(20);
            System.out.println("set tlv====" + this.glbObj.tlvStr);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
                continue;
            }
            this.glbObj.subleader_name_lst.add(this.log.GetValuesFromTbl("tsubleadertbl.1_subleadername").get(0).toString());
            this.dblib.PostDBExec(this.log.rcv_buff);
            check = true;
        }
        return check;
    }

    public boolean get_voters_list() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            if (this.glbObj.survey_process && this.glbObj.leader_pro_mode_cur.equals("0")) {
                this.glbObj.iiid_lst = this.glbObj.booth_to_voterid_map_specific_survey.get(this.glbObj.boothid_cur + this.glbObj.process_id);
                if (this.glbObj.iiid_lst != null) {
                    return true;
                }
            } else if (this.glbObj.survey_process && this.glbObj.leader_pro_mode_cur.equals("1")) {
                this.glbObj.voter_id_list = this.glbObj.booth_to_voterid_map_processes.get(this.glbObj.boothid_cur + this.glbObj.process_id + this.glbObj.filter_str);
                if (this.glbObj.voter_id_list != null) {
                    return true;
                }
            } else if (this.glbObj.polling_distinct_voter) {
                this.glbObj.polling_voter_id_list = this.glbObj.booth_to_voterid_map_processes.get(this.glbObj.boothid_cur + "vbpolling");
                if (this.glbObj.polling_voter_id_list != null) {
                    return true;
                }
            } else if (this.glbObj.polling_process && !this.glbObj.set_voter_filter) {
                this.glbObj.voter_id_list = this.glbObj.booth_to_voterid_map.get(this.glbObj.boothid_cur + "polling");
                if (this.glbObj.voter_id_list != null) {
                    return true;
                }
            } else if (this.glbObj.polling_process && this.glbObj.set_voter_filter) {
                System.out.println("polling filter========" + this.glbObj.booth_to_voterid_map);
                this.glbObj.voter_id_list = this.glbObj.booth_to_voterid_map.get(this.glbObj.boothid_cur + "polling" + this.glbObj.voter_orientation);
                if (this.glbObj.voter_id_list != null) {
                    return true;
                }
            } else {
                this.glbObj.voter_id_list = this.glbObj.booth_to_voterid_map.get(this.glbObj.boothid_cur + this.glbObj.filter_str);
                if (this.glbObj.voter_id_list != null) {
                    return true;
                }
            }
            this.tlvObj.setTlv(21);
            this.do_all_network();
            if (this.log.error_code != 0) {
                check = false;
            } else {
                if (this.glbObj.survey_process) {
                    if (this.glbObj.leader_pro_mode_cur.equals("1")) {
                        this.glbObj.voter_id_list = new ArrayList();
                        this.glbObj.voter_id_list = this.log.GetValuesFromTbl("tsurveystattbl.1_voterid");
                    }
                    if (this.glbObj.leader_pro_mode_cur.equals("0")) {
                        this.glbObj.iiid_lst = new ArrayList();
                        this.glbObj.iiid_lst = this.log.GetValuesFromTbl("tsurveystattbl.1_iiid");
                    }
                } else if (this.glbObj.polling_distinct_voter) {
                    this.glbObj.polling_voter_id_list = new ArrayList();
                    this.glbObj.polling_voter_id_list = this.log.GetValuesFromTbl("tvoterbatchwiseorientattbl.1_voterid");
                } else if (this.glbObj.polling_process && this.glbObj.set_voter_filter) {
                    this.glbObj.voter_id_list = new ArrayList();
                    this.glbObj.voter_id_list = this.log.GetValuesFromTbl("tvoterbatchwiseorientattbl.1_voterid");
                } else if (this.glbObj.polling_process && !this.glbObj.set_voter_filter) {
                    this.glbObj.voter_id_list = new ArrayList();
                    this.glbObj.voter_id_list = this.log.GetValuesFromTbl("tvotertbl.1_voterid");
                } else {
                    this.glbObj.voter_id_list = new ArrayList();
                    this.glbObj.voter_id_list = this.log.GetValuesFromTbl("tvotertbl.1_voterid");
                }
                if (this.glbObj.survey_process && this.glbObj.leader_pro_mode_cur.equals("0")) {
                    this.glbObj.booth_to_voterid_map_specific_survey.put(this.glbObj.boothid_cur + this.glbObj.process_id, this.glbObj.iiid_lst);
                } else if (this.glbObj.survey_process && this.glbObj.leader_pro_mode_cur.equals("1")) {
                    this.glbObj.booth_to_voterid_map_processes.put(this.glbObj.boothid_cur + this.glbObj.process_id + this.glbObj.filter_str, this.glbObj.voter_id_list);
                } else if (this.glbObj.polling_distinct_voter) {
                    this.glbObj.booth_to_voterid_map_processes.put(this.glbObj.boothid_cur + "vbpolling", this.glbObj.polling_voter_id_list);
                } else if (this.glbObj.polling_process && !this.glbObj.set_voter_filter) {
                    this.glbObj.booth_to_voterid_map.put(this.glbObj.boothid_cur + "polling", this.glbObj.voter_id_list);
                } else if (this.glbObj.polling_process && this.glbObj.set_voter_filter) {
                    this.glbObj.booth_to_voterid_map.put(this.glbObj.boothid_cur + "polling" + this.glbObj.voter_orientation, this.glbObj.voter_id_list);
                    System.out.println("polling filter set map=========" + this.glbObj.booth_to_voterid_map);
                } else {
                    this.glbObj.booth_to_voterid_map.put(this.glbObj.boothid_cur + this.glbObj.filter_str, this.glbObj.voter_id_list);
                }
                check = true;
                System.out.println("voter table map=======" + this.glbObj.booth_to_voterid_map);
                System.out.println("process table map=======" + this.glbObj.booth_to_voterid_map_processes);
            }
        }
        if (!this.glbObj.ids_only) {
            if (this.glbObj.survey_process) {
                this.glbObj.first_name_list.clear();
                this.glbObj.mid_name_list.clear();
                this.glbObj.last_name_list.clear();
            }
            if (this.glbObj.polling_distinct_voter) {
                this.glbObj.orientation_list.clear();
                this.glbObj.vote_stat_list.clear();
                this.glbObj.voter_orientation_lst.clear();
            } else {
                this.glbObj.first_name_list.clear();
                this.glbObj.mid_name_list.clear();
                this.glbObj.last_name_list.clear();
            }
            check = false;
            List ids = null;
            if (this.glbObj.survey_process) {
                if (this.glbObj.leader_pro_mode_cur.equals("1")) {
                    ids = this.glbObj.booth_to_voterid_map_processes.get(this.glbObj.boothid_cur + this.glbObj.process_id + this.glbObj.filter_str);
                }
                if (this.glbObj.leader_pro_mode_cur.equals("0")) {
                    ids = this.glbObj.booth_to_voterid_map_specific_survey.get(this.glbObj.boothid_cur + this.glbObj.process_id);
                }
            } else if (this.glbObj.polling_distinct_voter) {
                ids = this.glbObj.booth_to_voterid_map_processes.get(this.glbObj.boothid_cur + "vbpolling");
            } else if (this.glbObj.polling_process && !this.glbObj.set_voter_filter) {
                ids = this.glbObj.booth_to_voterid_map.get(this.glbObj.boothid_cur + "polling");
            } else if (this.glbObj.polling_process && this.glbObj.set_voter_filter) {
                System.out.println("polling map ids false=========" + this.glbObj.booth_to_voterid_map);
                ids = this.glbObj.booth_to_voterid_map.get(this.glbObj.boothid_cur + "polling" + this.glbObj.voter_orientation);
            } else {
                ids = this.glbObj.booth_to_voterid_map.get(this.glbObj.boothid_cur + this.glbObj.filter_str);
            }
            for (int i = 0; i < ids.size(); ++i) {
                this.glbObj.voter_id_curr = ids.get(i).toString();
                this.tlvObj.setTlv(21);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                if (this.glbObj.survey_process) {
                    this.glbObj.first_name_list.add(this.log.GetValuesFromTbl("tsurveystattbl.1_firstname").get(0).toString());
                    this.glbObj.mid_name_list.add(this.log.GetValuesFromTbl("tsurveystattbl.2_midname").get(0).toString());
                    this.glbObj.last_name_list.add(this.log.GetValuesFromTbl("tsurveystattbl.3_lastname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                } else if (this.glbObj.polling_distinct_voter) {
                    this.glbObj.orientation_list.add(this.log.GetValuesFromTbl("tvoterbatchwiseorientattbl.7_orientation").get(0).toString());
                    this.glbObj.vote_stat_list.add(this.log.GetValuesFromTbl("tvoterbatchwiseorientattbl.9f_votestat").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                } else {
                    this.glbObj.first_name_list.add(this.log.GetValuesFromTbl("tvotertbl.2_firstname").get(0).toString());
                    this.glbObj.mid_name_list.add(this.log.GetValuesFromTbl("tvotertbl.3_midname").get(0).toString());
                    this.glbObj.last_name_list.add(this.log.GetValuesFromTbl("tvotertbl.4_lastname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                }
                check = true;
            }
        }
        return check;
    }

    public boolean insert_voter() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(22);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            if (this.glbObj.update_voter) {
                this.dblib.PostDBExec("");
            }
            ch = true;
        }
        return ch;
    }

    public boolean get_religious_details() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            if (this.glbObj.religion && this.glbObj.relid_lst != null) {
                return true;
            }
            if (this.glbObj.cast) {
                this.glbObj.castid_lst = this.glbObj.religionid_to_castid_map.get(this.glbObj.relid);
                if (this.glbObj.castid_lst != null) {
                    return true;
                }
            }
            if (this.glbObj.subcast) {
                this.glbObj.subcastid_lst = this.glbObj.castid_to_subcastid_map.get(this.glbObj.cast_id);
                if (this.glbObj.subcastid_lst != null) {
                    return true;
                }
            }
            if (this.glbObj.profession && this.glbObj.profid_lst != null) {
                return true;
            }
            this.tlvObj.setTlv(23);
            this.do_all_network();
            System.out.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                if (this.glbObj.religion) {
                    this.glbObj.relid_lst = this.log.GetValuesFromTbl("pemreligiontbl.1_relid");
                }
                if (this.glbObj.cast) {
                    this.glbObj.castid_lst = new ArrayList();
                    this.glbObj.castid_lst = this.log.GetValuesFromTbl("pemcasttbl.1_castid");
                    this.glbObj.religionid_to_castid_map.put(this.glbObj.relid, this.glbObj.castid_lst);
                }
                if (this.glbObj.subcast) {
                    this.glbObj.subcastid_lst = new ArrayList();
                    this.glbObj.subcastid_lst = this.log.GetValuesFromTbl("pemsubcasttbl.1_subcastid");
                    this.glbObj.castid_to_subcastid_map.put(this.glbObj.cast_id, this.glbObj.subcastid_lst);
                }
                if (this.glbObj.profession) {
                    this.glbObj.profid_lst = this.log.GetValuesFromTbl("pemprofessiontbl.1_profid");
                }
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            boolean ca;
            int i;
            if (this.glbObj.religion) {
                this.glbObj.relname_lst.clear();
                check = false;
                for (i = 0; i < this.glbObj.relid_lst.size(); ++i) {
                    this.glbObj.relid_cur = this.glbObj.relid_lst.get(i).toString();
                    this.tlvObj.setTlv(23);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.relname_lst.add(this.log.GetValuesFromTbl("pemreligiontbl.2_relname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.cast) {
                this.glbObj.castname_lst.clear();
                this.glbObj.castid_lst = this.glbObj.religionid_to_castid_map.get(this.glbObj.relid);
                check = false;
                for (i = 0; i < this.glbObj.castid_lst.size(); ++i) {
                    this.glbObj.castid_cur = this.glbObj.castid_lst.get(i).toString();
                    this.tlvObj.setTlv(23);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.castname_lst.add(this.log.GetValuesFromTbl("pemcasttbl.2_castname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.subcast) {
                this.glbObj.subcastname_lst.clear();
                this.glbObj.subcastid_lst = this.glbObj.castid_to_subcastid_map.get(this.glbObj.cast_id);
                check = false;
                for (i = 0; i < this.glbObj.subcastid_lst.size(); ++i) {
                    this.glbObj.subcastid_cur = this.glbObj.subcastid_lst.get(i).toString();
                    this.tlvObj.setTlv(23);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.subcastname_lst.add(this.log.GetValuesFromTbl("pemsubcasttbl.2_subcastname").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            if (this.glbObj.profession) {
                this.glbObj.profname_lst.clear();
                check = false;
                for (i = 0; i < this.glbObj.profid_lst.size(); ++i) {
                    this.glbObj.profid_cur = this.glbObj.profid_lst.get(i).toString();
                    this.tlvObj.setTlv(23);
                    ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.profname_lst.add(this.log.GetValuesFromTbl("pemprofessiontbl.2_profession").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
            }
            check = true;
        }
        return check;
    }

    public boolean insert_religious_details() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(24);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            if (this.glbObj.religion) {
                this.dblib.PostDBExec("pemreligiontbl.1_relid");
            }
            if (this.glbObj.cast) {
                this.dblib.PostDBExec("pemcasttbl.1_castid");
            }
            if (this.glbObj.subcast) {
                this.dblib.PostDBExec("pemsubcasttbl.1_subcastid");
            }
            if (this.glbObj.profession) {
                this.dblib.PostDBExec("pemprofessiontbl.1_profid");
            }
            ch = true;
        }
        return ch;
    }

    public boolean load_sectors() throws IOException {
        this.tlvObj.setTlv(25);
        this.do_all_network();
        boolean check = false;
        System.out.println("In Library" + this.log.error_code);
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.sectorid_lst = this.log.GetValuesFromTbl("pregionsectortbl.1_sectorid");
            this.glbObj.sectorname_lst = this.log.GetValuesFromTbl("pregionsectortbl.2_sectorname");
            check = true;
        }
        return check;
    }

    public boolean get_voter_details() throws IOException {
        this.tlvObj.setTlv(26);
        this.do_all_network();
        boolean check = false;
        System.out.println("In Library" + this.log.error_code);
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.voter_id_cur = this.log.GetValuesFromTbl("tvotertbl.1_voterid").get(0).toString();
            this.glbObj.booth_id_cur = this.log.GetValuesFromTbl("tvotertbl.2_boothid").get(0).toString();
            this.glbObj.booth_name_cur = this.log.GetValuesFromTbl("tvotertbl.3_boothname").get(0).toString();
            this.glbObj.region_id_cur = this.log.GetValuesFromTbl("tvotertbl.4_regionid").get(0).toString();
            this.glbObj.firstname_cur = this.log.GetValuesFromTbl("tvotertbl.5_firstname").get(0).toString();
            this.glbObj.midname_cur = this.log.GetValuesFromTbl("tvotertbl.6_midname").get(0).toString();
            this.glbObj.lastname_cur = this.log.GetValuesFromTbl("tvotertbl.7_lastname").get(0).toString();
            this.glbObj.dob_cur = this.log.GetValuesFromTbl("tvotertbl.8_dob").get(0).toString();
            this.glbObj.castid_cur = this.log.GetValuesFromTbl("tvotertbl.9_castid").get(0).toString();
            this.glbObj.castname_cur = this.log.GetValuesFromTbl("tvotertbl.9a_castname").get(0).toString();
            this.glbObj.subcastid_cur = this.log.GetValuesFromTbl("tvotertbl.9b_subcastid").get(0).toString();
            this.glbObj.subcastname_cur = this.log.GetValuesFromTbl("tvotertbl.9c_subcast").get(0).toString();
            this.glbObj.age_cur = this.log.GetValuesFromTbl("tvotertbl.9d_age").get(0).toString();
            this.glbObj.religion_cur = this.log.GetValuesFromTbl("tvotertbl.9e_religion").get(0).toString();
            this.glbObj.status_cur = this.log.GetValuesFromTbl("tvotertbl.9f_status").get(0).toString();
            this.glbObj.homeno_cur = this.log.GetValuesFromTbl("tvotertbl.9g_homeno").get(0).toString();
            this.glbObj.sector_cur = this.log.GetValuesFromTbl("tvotertbl.9h_sector").get(0).toString();
            this.glbObj.landmark_cur = this.log.GetValuesFromTbl("tvotertbl.9i_landmark").get(0).toString();
            this.glbObj.profession_cur = this.log.GetValuesFromTbl("tvotertbl.9j_profession").get(0).toString();
            this.glbObj.remark_cur = this.log.GetValuesFromTbl("tvotertbl.9k_remark").get(0).toString();
            this.glbObj.contact_cur = this.log.GetValuesFromTbl("tvotertbl.9l_contact").get(0).toString();
            this.glbObj.voteridapplied_cur = this.log.GetValuesFromTbl("tvotertbl.9m_voteridapplied").get(0).toString();
            this.glbObj.hof_cur = this.log.GetValuesFromTbl("tvotertbl.9n_hof").get(0).toString();
            this.glbObj.gender_cur = this.log.GetValuesFromTbl("tvotertbl.9o_gender").get(0).toString();
            this.glbObj.reside_cur = this.log.GetValuesFromTbl("tvotertbl.9p_reside").get(0).toString();
            this.glbObj.vehicle_cur = this.log.GetValuesFromTbl("tvotertbl.9q_vehcl").get(0).toString();
            this.glbObj.trait_cur = this.log.GetValuesFromTbl("tvotertbl.9r_trait").get(0).toString();
            this.glbObj.picktime_cur = this.log.GetValuesFromTbl("tvotertbl.9s_picktime").get(0).toString();
            this.glbObj.pickplace_cur = this.log.GetValuesFromTbl("tvotertbl.9t_pickplace").get(0).toString();
            check = true;
        }
        return check;
    }

    public boolean insert_sectors() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(27);
        boolean ch = false;
        this.do_all_network();
        ch = this.log.error_code == 0;
        return ch;
    }

    public boolean get_process_booths() throws IOException {
        this.tlvObj.setTlv(28);
        this.do_all_network();
        boolean check = false;
        System.out.println("In Library" + this.log.error_code);
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.region_id_lst = this.log.GetValuesFromTbl("tprocessboothtbl.1_regionid");
            this.glbObj.region_name_lst = this.log.GetValuesFromTbl("tprocessboothtbl.2_regionname");
            this.glbObj.booth_id_lst = this.log.GetValuesFromTbl("tprocessboothtbl.3_boothid");
            this.glbObj.booth_name_lst = this.log.GetValuesFromTbl("tprocessboothtbl.4_boothname");
            this.glbObj.pro_time_critic = this.log.GetValuesFromTbl("tprocessboothtbl.5_protimecritic");
            this.glbObj.pro_start_date_lst = this.log.GetValuesFromTbl("tprocessboothtbl.6_prosdate");
            this.glbObj.pro_end_date_lst = this.log.GetValuesFromTbl("tprocessboothtbl.7_proedate");
            check = true;
        }
        return check;
    }

    public boolean get_candidate_constituency() throws IOException {
        this.tlvObj.setTlv(29);
        this.do_all_network();
        boolean check = false;
        System.out.println("In Library" + this.log.error_code);
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.consttype = this.log.GetValuesFromTbl("tcandidateconstituencytbl.1_consttype").get(0).toString();
            this.glbObj.mpconstid = this.log.GetValuesFromTbl("tcandidateconstituencytbl.2_mpconstid").get(0).toString();
            this.glbObj.mlaconstid = this.log.GetValuesFromTbl("tcandidateconstituencytbl.3_mlaconstid").get(0).toString();
            this.glbObj.conclconstid = this.log.GetValuesFromTbl("tcandidateconstituencytbl.4_conclconstid").get(0).toString();
            this.glbObj.zpconstid = this.log.GetValuesFromTbl("tcandidateconstituencytbl.5_zpconstid").get(0).toString();
            this.glbObj.tpconstid = this.log.GetValuesFromTbl("tcandidateconstituencytbl.6_tpconstid").get(0).toString();
            this.glbObj.gpconstid = this.log.GetValuesFromTbl("tcandidateconstituencytbl.7_gpconstid").get(0).toString();
            check = true;
        }
        return check;
    }

    public boolean insert_create_group() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(30);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("tregiongrouptbl.1_groupid");
            ch = true;
        }
        return ch;
    }

    public boolean insert_individual() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(31);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            if (this.glbObj.update_individual) {
                this.dblib.PostDBExec("");
            } else {
                this.dblib.PostDBExec("tinfindividualtbl.1_iiid");
            }
            ch = true;
        }
        return ch;
    }

    public boolean get_individuals() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.glbObj.iiid_lst = this.glbObj.booth_to_iiid_map.get(this.glbObj.boothid_cur + this.glbObj.infl_filter_str);
            if (this.glbObj.iiid_lst != null) {
                return true;
            }
            this.tlvObj.setTlv(32);
            this.do_all_network();
            System.out.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.iiid_lst = null;
                this.glbObj.iiid_lst = this.log.GetValuesFromTbl("tinfindividualtbl.1_iiid");
                this.glbObj.booth_to_iiid_map.put(this.glbObj.boothid_cur + this.glbObj.infl_filter_str, this.glbObj.iiid_lst);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.inf_firstname_lst.clear();
            this.glbObj.inf_midname_lst.clear();
            this.glbObj.inf_lastname_lst.clear();
            check = false;
            this.glbObj.iiid_lst = this.glbObj.booth_to_iiid_map.get(this.glbObj.boothid_cur + this.glbObj.infl_filter_str);
            for (int i = 0; i < this.glbObj.iiid_lst.size(); ++i) {
                this.glbObj.iiid_cur = this.glbObj.iiid_lst.get(i).toString();
                this.tlvObj.setTlv(32);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                System.out.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.inf_firstname_lst.add(this.log.GetValuesFromTbl("tinfindividualtbl.2_fname").get(0).toString());
                this.glbObj.inf_midname_lst.add(this.log.GetValuesFromTbl("tinfindividualtbl.3_midname").get(0).toString());
                this.glbObj.inf_lastname_lst.add(this.log.GetValuesFromTbl("tinfindividualtbl.4_lname").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean get_individual_details() throws IOException {
        this.tlvObj.setTlv(33);
        this.do_all_network();
        boolean check = false;
        System.out.println("In Library" + this.log.error_code);
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.indi_fname_cur = this.log.GetValuesFromTbl("tinfindividualtbl.1_fname").get(0).toString();
            this.glbObj.indi_middname_cur = this.log.GetValuesFromTbl("tinfindividualtbl.2_midname").get(0).toString();
            this.glbObj.indi_lname_cur = this.log.GetValuesFromTbl("tinfindividualtbl.3_lname").get(0).toString();
            this.glbObj.indi_contact_cur = this.log.GetValuesFromTbl("tinfindividualtbl.4_contact").get(0).toString();
            this.glbObj.indi_address_cur = this.log.GetValuesFromTbl("tinfindividualtbl.5_address").get(0).toString();
            this.glbObj.indi_remark_cur = this.log.GetValuesFromTbl("tinfindividualtbl.6_remark").get(0).toString();
            this.glbObj.indi_groupid_cur = this.log.GetValuesFromTbl("tinfindividualtbl.7_groupid").get(0).toString();
            this.glbObj.indi_gtype_cur = this.log.GetValuesFromTbl("tinfindividualtbl.8_gtype").get(0).toString();
            this.glbObj.indi_groupname_cur = this.log.GetValuesFromTbl("tinfindividualtbl.9_groupname").get(0).toString();
            this.glbObj.indi_groupinfl_cur = this.log.GetValuesFromTbl("tinfindividualtbl.9a_groupinfl").get(0).toString();
            this.glbObj.indi_finanstat_cur = this.log.GetValuesFromTbl("tinfindividualtbl.9b_finanstat").get(0).toString();
            this.glbObj.indi_infl_cur = this.log.GetValuesFromTbl("tinfindividualtbl.9c_infl").get(0).toString();
            this.glbObj.indi_orientation_cur = this.log.GetValuesFromTbl("tinfindividualtbl.9d_orientation").get(0).toString();
            this.glbObj.indi_factor_cur = this.log.GetValuesFromTbl("tinfindividualtbl.9e_factor").get(0).toString();
            this.glbObj.indi_grouplead_cur = this.log.GetValuesFromTbl("tinfindividualtbl.9f_grouplead").get(0).toString();
            check = true;
        }
        return check;
    }

    public boolean delete_group() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(34);
        boolean c = false;
        this.do_all_network();
        check = this.log.error_code == 0;
        return check;
    }

    public boolean get_survey_processes() throws IOException {
        int i;
        boolean check = false;
        if (this.glbObj.ids_only) {
            for (i = 0; i < this.glbObj.regionid_list.size(); ++i) {
                this.glbObj.rep_regionid_curr = this.glbObj.regionid_list.get(i).toString();
                this.glbObj.rep_boothid_curr = this.glbObj.boothid_list.get(i).toString();
                this.glbObj.leader_proboothid_lst = this.glbObj.process_to_processid_map.get(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr);
                if (this.glbObj.leader_proboothid_lst != null) {
                    return true;
                }
                this.tlvObj.setTlv(35);
                System.out.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) continue;
                this.glbObj.leader_proboothid_lst = null;
                this.glbObj.leader_proboothid_lst = this.log.GetValuesFromTbl("tprocessboothtbl.1_pboothid");
                this.glbObj.process_to_processid_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, this.glbObj.leader_proboothid_lst);
            }
        }
        if (!this.glbObj.ids_only) {
            for (i = 0; i < this.glbObj.regionid_list.size(); ++i) {
                this.glbObj.rep_regionid_curr = this.glbObj.regionid_list.get(i).toString();
                this.glbObj.rep_boothid_curr = this.glbObj.boothid_list.get(i).toString();
                this.glbObj.leader_proboothid_lst = this.glbObj.process_to_processid_map.get(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr);
                this.glbObj.leader_proid_lst = new ArrayList();
                this.glbObj.leader_pro_name_lst = new ArrayList();
                this.glbObj.leader_pro_phase_lst = new ArrayList();
                this.glbObj.leader_pro_criteria_lst = new ArrayList();
                this.glbObj.leader_pro_timecritic_lst = new ArrayList();
                this.glbObj.leader_pro_st_date_lst = new ArrayList();
                this.glbObj.leader_pro_end_date_lst = new ArrayList();
                this.glbObj.leader_pro_cr_date_lst = new ArrayList();
                this.glbObj.leader_pro_mode_lst = new ArrayList();
                this.glbObj.leader_stype_lst = new ArrayList();
                check = false;
                for (int j = 0; j < this.glbObj.leader_proboothid_lst.size(); ++j) {
                    this.glbObj.leader_proboothid_cur = this.glbObj.leader_proboothid_lst.get(j).toString();
                    this.tlvObj.setTlv(35);
                    this.do_all_network();
                    System.out.println("In Library" + this.log.error_code);
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    this.glbObj.leader_proid_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.2_proid").get(0).toString());
                    this.glbObj.leader_pro_name_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.3_proname").get(0).toString());
                    this.glbObj.leader_pro_phase_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.4_prophase").get(0).toString());
                    this.glbObj.leader_pro_criteria_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.5_procrit").get(0).toString());
                    this.glbObj.leader_pro_timecritic_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.6_protimecritic").get(0).toString());
                    this.glbObj.leader_pro_st_date_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.7_prosdate").get(0).toString());
                    this.glbObj.leader_pro_end_date_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.8_proedate").get(0).toString());
                    this.glbObj.leader_pro_cr_date_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.9_procrdate").get(0).toString());
                    this.glbObj.leader_pro_mode_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.9a_mode").get(0).toString());
                    this.glbObj.leader_stype_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.9b_stype").get(0).toString());
                    check = true;
                }
                this.glbObj.rep_booth_to_processid_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, this.glbObj.leader_proid_lst);
                this.glbObj.rep_booth_to_processname_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, this.glbObj.leader_pro_name_lst);
                this.glbObj.rep_booth_to_process_phase_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, this.glbObj.leader_pro_phase_lst);
                this.glbObj.rep_booth_to_process_time_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, this.glbObj.leader_pro_timecritic_lst);
                this.glbObj.rep_booth_to_process_startdate_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, this.glbObj.leader_pro_st_date_lst);
                this.glbObj.rep_booth_to_process_enddate_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, this.glbObj.leader_pro_end_date_lst);
                this.glbObj.rep_booth_to_processtype_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, this.glbObj.leader_stype_lst);
            }
        }
        return check;
    }

    public boolean get_all_process_conducts() throws IOException {
        this.tlvObj.setTlv(36);
        this.do_all_network();
        boolean check = false;
        System.out.println("In Library" + this.log.error_code);
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.pro_conid_lst = this.log.GetValuesFromTbl("tprocessconducttbl.1_proconid");
            this.glbObj.pro_date_lst = this.log.GetValuesFromTbl("tprocessconducttbl.2_prodate");
            this.glbObj.pro_stime_lst = this.log.GetValuesFromTbl("tprocessconducttbl.3_prostime");
            this.glbObj.pro_etime_lst = this.log.GetValuesFromTbl("tprocessconducttbl.4_proetime");
            this.glbObj.pro_status_lst = this.log.GetValuesFromTbl("tprocessconducttbl.5_status");
            this.glbObj.pro_boothname_lst = this.log.GetValuesFromTbl("tprocessconducttbl.6_boothname");
            this.glbObj.pro_regionname_lst = this.log.GetValuesFromTbl("tprocessconducttbl.7_regionname");
            check = true;
        }
        return check;
    }

    public boolean create_finish_new_process_conduct() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(37);
        boolean ch = false;
        this.do_all_network();
        ch = this.log.error_code == 0;
        return ch;
    }

    public boolean update_insert_orientation() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(38);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("");
            ch = true;
        }
        return ch;
    }

    public boolean unassign_region_of_subleader() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(39);
        boolean c = false;
        this.do_all_network();
        check = this.log.error_code == 0;
        return check;
    }

    public boolean get_count_from_tvoterbatchwiseorientattbl() throws IOException {
        System.out.println("In plugin");
        boolean check = false;
        this.tlvObj.setTlv(40);
        this.do_all_network();
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.count = this.log.GetValuesFromTbl("tvoterbatchwiseorientattbl.1_count(*)").get(0).toString();
            check = true;
        }
        return check;
    }

    public boolean insert_or_update_voter_batchwise_orientation() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(41);
        boolean ch = false;
        this.do_all_network();
        ch = this.log.error_code == 0;
        return ch;
    }

    public boolean update_insert_vote_stat() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(42);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("");
            ch = true;
        }
        return ch;
    }

    public boolean get_automated_questions() throws IOException {
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(43);
            this.do_all_network();
            System.out.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.auto_qid_lst = this.log.GetValuesFromTbl("tautoqstbl.1_aqid");
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            this.glbObj.auto_qs_lst.clear();
            this.glbObj.auto_lang_lst.clear();
            this.glbObj.auto_poans_lst.clear();
            this.glbObj.auto_noans_lst.clear();
            check = false;
            for (int i = 0; i < this.glbObj.auto_qid_lst.size(); ++i) {
                this.glbObj.auto_qid_cur = this.glbObj.auto_qid_lst.get(i).toString();
                this.tlvObj.setTlv(43);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.auto_qs_lst.add(this.log.GetValuesFromTbl("tautoqstbl.2_qs").get(0).toString());
                this.glbObj.auto_lang_lst.add(this.log.GetValuesFromTbl("tautoqstbl.3_language").get(0).toString());
                this.glbObj.auto_poans_lst.add(this.log.GetValuesFromTbl("tautoqstbl.4_poans").get(0).toString());
                this.glbObj.auto_noans_lst.add(this.log.GetValuesFromTbl("tautoqstbl.5_noans").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean get_questionary_questions() throws IOException {
        int i;
        boolean check = false;
        if (this.glbObj.ids_only) {
            this.tlvObj.setTlv(44);
            this.do_all_network();
            System.out.println("In Library" + this.log.error_code);
            if (this.log.error_code != 0) {
                check = false;
            } else {
                this.glbObj.qid_lst = this.log.GetValuesFromTbl("tquestionarytbl.1_qid");
                check = true;
            }
        }
        if (!this.glbObj.ids_only && !this.glbObj.options) {
            this.glbObj.question_lst.clear();
            check = false;
            for (i = 0; i < this.glbObj.qid_lst.size(); ++i) {
                this.glbObj.qid_cur = this.glbObj.qid_lst.get(i).toString();
                this.tlvObj.setTlv(44);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                this.glbObj.question_lst.add(this.log.GetValuesFromTbl("tquestionarytbl.2_question").get(0).toString());
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        if (!this.glbObj.ids_only && this.glbObj.options) {
            check = false;
            for (i = 0; i < this.glbObj.qid_lst.size(); ++i) {
                this.glbObj.qid_cur = this.glbObj.qid_lst.get(i).toString();
                List opt = this.glbObj.qid_to_option_map.get(this.glbObj.qid_cur);
                if (opt != null) continue;
                this.tlvObj.setTlv(44);
                boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                if (!ca) {
                    this.do_all_network();
                }
                if (this.log.error_code == 2) {
                    this.log.error_code = 0;
                    this.glbObj.qid_to_option_map.put(this.glbObj.qid_cur, null);
                    this.glbObj.qid_to_optionid_map.put(this.glbObj.qid_cur, null);
                    continue;
                }
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                List options = null;
                options = this.log.GetValuesFromTbl("temoptiontbl.2_options");
                this.glbObj.qid_to_option_map.put(this.glbObj.qid_cur, options);
                List optid = null;
                optid = this.log.GetValuesFromTbl("temoptiontbl.3_optid");
                this.glbObj.qid_to_optionid_map.put(this.glbObj.qid_cur, optid);
                this.dblib.PostDBExec(this.log.rcv_buff);
                check = true;
            }
        }
        return check;
    }

    public boolean insert_questionary_answers() throws IOException {
        boolean ch = false;
        for (int i = 0; i < this.glbObj.qid_lst.size(); ++i) {
            this.glbObj.qid_cur = this.glbObj.qid_lst.get(i).toString();
            this.glbObj.answer_cur = this.glbObj.answer_list.get(i).toString();
            this.tlvObj.setTlv(45);
            this.dblib.skip_db_exec = true;
            this.dblib.get_from_db(this.glbObj.tlvStr);
            this.do_all_network();
            if (this.log.error_code != 0) {
                ch = false;
                continue;
            }
            this.dblib.PostDBExec("tanswertbl.1_aid");
            ch = true;
        }
        return ch;
    }

    public boolean get_survey_processes_for_all_regions() throws IOException {
        int i;
        boolean check = false;
        if (this.glbObj.ids_only) {
            for (i = 0; i < this.glbObj.regionid_list.size(); ++i) {
                this.glbObj.rep_boothid_cur = this.glbObj.boothid_list.get(i).toString();
                this.glbObj.rep_regionid_cur = this.glbObj.regionid_list.get(i).toString();
                List rep_leader_proboothid_lst = this.glbObj.rep_booth_to_processid_map.get(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur);
                if (rep_leader_proboothid_lst != null) continue;
                this.tlvObj.setTlv(46);
                this.do_all_network();
                System.out.println("In Library" + this.log.error_code);
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                List leader_proboothid_lst = null;
                leader_proboothid_lst = this.log.GetValuesFromTbl("tprocessboothtbl.1_pboothid");
                this.glbObj.rep_booth_to_processid_map.put(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur, leader_proboothid_lst);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            check = false;
            for (i = 0; i < this.glbObj.regionid_list.size(); ++i) {
                this.glbObj.rep_boothid_cur = this.glbObj.boothid_list.get(i).toString();
                this.glbObj.rep_regionid_cur = this.glbObj.regionid_list.get(i).toString();
                List a = this.glbObj.rep_booth_to_processid_map.get(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur);
                ArrayList<String> leader_proid_lst = new ArrayList<String>();
                ArrayList<String> leader_pro_name_lst = new ArrayList<String>();
                ArrayList<String> leader_pro_phase_lst = new ArrayList<String>();
                ArrayList leader_pro_criteria_lst = new ArrayList();
                ArrayList<String> leader_pro_timecritic_lst = new ArrayList<String>();
                ArrayList<String> leader_pro_st_date_lst = new ArrayList<String>();
                ArrayList<String> leader_pro_end_date_lst = new ArrayList<String>();
                ArrayList leader_pro_cr_date_lst = new ArrayList();
                ArrayList leader_pro_mode_lst = new ArrayList();
                ArrayList<String> leader_stype_lst = new ArrayList<String>();
                for (int j = 0; j < a.size(); ++j) {
                    this.glbObj.rep_leader_proboothid_cur = a.get(j).toString();
                    this.tlvObj.setTlv(46);
                    this.do_all_network();
                    System.out.println("In Library" + this.log.error_code);
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    leader_proid_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.2_proid").get(0).toString());
                    leader_pro_name_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.3_proname").get(0).toString());
                    leader_pro_phase_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.4_prophase").get(0).toString());
                    leader_pro_timecritic_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.6_protimecritic").get(0).toString());
                    leader_pro_st_date_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.7_prosdate").get(0).toString());
                    leader_pro_end_date_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.8_proedate").get(0).toString());
                    leader_stype_lst.add(this.log.GetValuesFromTbl("tprocessboothtbl.9b_stype").get(0).toString());
                    check = true;
                }
                this.glbObj.rep_booth_to_processid_map.put(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur, leader_proid_lst);
                this.glbObj.rep_booth_to_processname_map.put(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur, leader_pro_name_lst);
                this.glbObj.rep_booth_to_processtype_map.put(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur, leader_stype_lst);
                this.glbObj.rep_booth_to_process_time_map.put(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur, leader_pro_timecritic_lst);
                this.glbObj.rep_booth_to_process_startdate_map.put(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur, leader_pro_st_date_lst);
                this.glbObj.rep_booth_to_process_enddate_map.put(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur, leader_pro_end_date_lst);
                this.glbObj.rep_booth_to_process_phase_map.put(this.glbObj.rep_regionid_cur + this.glbObj.rep_boothid_cur, leader_pro_phase_lst);
            }
        }
        System.out.println("===================================================================");
        System.out.println("this.glbObj.rep_booth_to_processid_map=======" + this.glbObj.rep_booth_to_processid_map);
        System.out.println("this.glbObj.rep_booth_to_processname_map==========" + this.glbObj.rep_booth_to_processname_map);
        System.out.println("this.glbObj.rep_booth_to_processtype_map========" + this.glbObj.rep_booth_to_processtype_map);
        return check;
    }

    public boolean get_number_of_voters_covered_in_every_survey() throws IOException {
        int i;
        List<String> tmp;
        String cnt;
        String key;
        List Booth_id;
        List Region_id;
        List Proc_id;
        boolean check = false;
        if (this.glbObj.covered_voters) {
            this.glbObj.tlvStr2 = "select count(*),proid,regionid,boothid from trueguide.tsurveystattbl where  proid in (select proid from trueguide.tprocessboothtbl where pboothid in (select pboothid from trueguide.tprocessboothtbl where boothid in (select boothid from trueguide.tleaderregiontbl where lregid in (select lregid from trueguide.tleaderregiontbl where leaderid='" + this.glbObj.Luid + "' and elebatchid='" + this.glbObj.elebatch_id + "')) and regionid in (select regionid from trueguide.tleaderregiontbl where lregid in (select lregid from trueguide.tleaderregiontbl where leaderid='" + this.glbObj.Luid + "' and elebatchid='" + this.glbObj.elebatch_id + "')) and elebatchid='" + this.glbObj.elebatch_id + "' and protype='" + this.glbObj.pro_type + "' and covered='1')) group by proid,regionid,boothid order by proid,regionid,boothid";
            this.get_generic_ex("");
            if (this.log.error_code == 101) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Internet Connection";
                return false;
            }
            if (this.log.error_code == 2) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Data Found..." + this.log.error_code;
                return false;
            }
            if (this.log.error_code != 0) {
                this.log.toastBox = true;
                this.log.toastMsg = "Something went wrong:" + this.log.error_code;
                return false;
            }
            List voter_covered_count_lst = this.get_list("1");
            Proc_id = this.get_list("2");
            Region_id = this.get_list("3");
            Booth_id = this.get_list("4");
            key = "";
            cnt = "";
            tmp = null;
            for (i = 0; i < voter_covered_count_lst.size(); ++i) {
                key = Region_id.get(i).toString() + Booth_id.get(i).toString() + Proc_id.get(i).toString();
                cnt = voter_covered_count_lst.get(i).toString();
                tmp = this.glbObj.rep_boothprocess_to_covered_votercount_map.get(key);
                if (tmp == null) {
                    tmp = new ArrayList<String>();
                }
                tmp.add(voter_covered_count_lst.get(i).toString());
                this.glbObj.rep_boothprocess_to_covered_votercount_map.put(key, tmp);
            }
            System.out.println("voter_covered_count_lst.size()===>" + voter_covered_count_lst.size());
            System.out.println("voter_covered_count_lst====>" + voter_covered_count_lst);
        }
        System.out.println("++++++++++++++++++++++++++++++++++");
        System.out.println("this.glbObj.rep_boothprocess_to_votercount_map==========" + this.glbObj.rep_boothprocess_to_votercount_map);
        if (!this.glbObj.covered_voters) {
            System.out.println("this.glbObj.tlvStr2====>" + this.glbObj.tlvStr2);
            this.glbObj.tlvStr2 = "select count(*),proid,regionid,boothid from trueguide.tsurveystattbl where  proid in (select proid from trueguide.tprocessboothtbl where pboothid in (select pboothid from trueguide.tprocessboothtbl where boothid in (select boothid from trueguide.tleaderregiontbl where lregid in (select lregid from trueguide.tleaderregiontbl where leaderid='" + this.glbObj.Luid + "' and elebatchid='" + this.glbObj.elebatch_id + "')) and regionid in (select regionid from trueguide.tleaderregiontbl where lregid in (select lregid from trueguide.tleaderregiontbl where leaderid='" + this.glbObj.Luid + "' and elebatchid='" + this.glbObj.elebatch_id + "')) and elebatchid='" + this.glbObj.elebatch_id + "' and protype='" + this.glbObj.pro_type + "')) group by proid,regionid,boothid order by proid,regionid,boothid";
            this.get_generic_ex("");
            if (this.log.error_code == 101) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Internet Connection";
                return false;
            }
            if (this.log.error_code == 2) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Data Found..." + this.log.error_code;
                return false;
            }
            if (this.log.error_code != 0) {
                this.log.toastBox = true;
                this.log.toastMsg = "Something went wrong:" + this.log.error_code;
                return false;
            }
            List voter_count_lst = this.get_list("1");
            Proc_id = this.get_list("2");
            Region_id = this.get_list("3");
            Booth_id = this.get_list("4");
            key = "";
            cnt = "";
            tmp = null;
            for (i = 0; i < voter_count_lst.size(); ++i) {
                key = Region_id.get(i).toString() + Booth_id.get(i).toString();
                cnt = voter_count_lst.get(i).toString();
                tmp = this.glbObj.rep_boothprocess_to_votercount_map.get(key);
                if (tmp == null) {
                    tmp = new ArrayList();
                }
                tmp.add(voter_count_lst.get(i).toString());
                this.glbObj.rep_boothprocess_to_votercount_map.put(key, tmp);
            }
        }
        return check;
    }

    public boolean insert_requests() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(48);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("tbreqtbl.1_reqid");
            ch = true;
        }
        return ch;
    }

    public boolean get_requests() throws IOException {
        if (this.glbObj.ids_only) {
            if (this.glbObj.requests.equals("APPROVED")) {
                this.glbObj.tlvStr2 = "select reqid,fname,mname,lname,role,roleid,rolename,reqrole,remark,contact,address,candid,elebatchid,status,reqdate,apprdate from trueguide.tbreqtbl where reqid in (select reqid from trueguide.tbreqtbl where role='Leader' and roleid='" + this.glbObj.Luid + "' and candid='" + this.glbObj.candidate_id + "' and status='1')";
                this.get_generic_ex("");
                if (this.log.error_code == 101) {
                    this.log.toastBox = true;
                    this.log.toastMsg = "No Internet Connection";
                    return false;
                }
                if (this.log.error_code == 2) {
                    this.log.toastBox = true;
                    this.log.toastMsg = "No Data Found..." + this.log.error_code;
                    return false;
                }
                if (this.log.error_code != 0) {
                    this.log.toastBox = true;
                    this.log.toastMsg = "Something went wrong:" + this.log.error_code;
                    return false;
                }
                this.glbObj.app_reqid_lst = this.get_list("1");
                this.glbObj.req_fname_lst = this.get_list("2");
                this.glbObj.req_mname_lst = this.get_list("3");
                this.glbObj.req_lname_lst = this.get_list("4");
                this.glbObj.req_remark_lst = this.get_list("5");
                this.glbObj.req_contact_lst = this.get_list("7");
                this.glbObj.req_addr_lst = this.get_list("8");
                this.glbObj.req_role_lst = this.get_list("9");
                return true;
            }
            if (this.glbObj.requests.equals("UNAPPROVED")) {
                this.glbObj.tlvStr2 = "select reqid,fname,mname,lname,role,roleid,rolename,reqrole,remark,contact,address,candid,elebatchid,status,reqdate,apprdate from trueguide.tbreqtbl where reqid in (select reqid from trueguide.tbreqtbl where role='Leader' and roleid='" + this.glbObj.Luid + "' and candid='" + this.glbObj.candidate_id + "' and status='0')";
                this.get_generic_ex("");
                if (this.log.error_code == 101) {
                    this.log.toastBox = true;
                    this.log.toastMsg = "No Internet Connection";
                    return false;
                }
                if (this.log.error_code == 2) {
                    this.log.toastBox = true;
                    this.log.toastMsg = "No Data Found..." + this.log.error_code;
                    return false;
                }
                if (this.log.error_code != 0) {
                    this.log.toastBox = true;
                    this.log.toastMsg = "Something went wrong:" + this.log.error_code;
                    return false;
                }
                this.glbObj.unapp_reqid_lst = this.get_list("1");
                this.glbObj.req_fname_lst = this.get_list("2");
                this.glbObj.req_mname_lst = this.get_list("3");
                this.glbObj.req_lname_lst = this.get_list("4");
                this.glbObj.req_remark_lst = this.get_list("5");
                this.glbObj.req_contact_lst = this.get_list("7");
                this.glbObj.req_addr_lst = this.get_list("8");
                this.glbObj.req_role_lst = this.get_list("9");
                return true;
            }
        }
        return true;
    }

    public boolean get_subleaders_for_reports() throws IOException {
        List subleader_regionid_lst;
        int i;
        boolean check = false;
        if (this.glbObj.ids_only) {
            for (i = 0; i < this.glbObj.regionid_list.size(); ++i) {
                this.glbObj.rep_regionid_curr = this.glbObj.regionid_list.get(i).toString();
                this.glbObj.rep_boothid_curr = this.glbObj.boothid_list.get(i).toString();
                subleader_regionid_lst = null;
                subleader_regionid_lst = this.glbObj.rep_leader_to_subleader_regionid_map.get(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr);
                if (subleader_regionid_lst != null) {
                    return true;
                }
                this.tlvObj.setTlv(50);
                System.out.println("set tlv====" + this.glbObj.tlvStr);
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                    continue;
                }
                subleader_regionid_lst = new ArrayList();
                subleader_regionid_lst = this.log.GetValuesFromTbl("tsubleaderregiontbl.1_slregid");
                this.glbObj.rep_leader_to_subleader_regionid_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, subleader_regionid_lst);
                check = true;
            }
        }
        if (!this.glbObj.ids_only) {
            for (i = 0; i < this.glbObj.regionid_list.size(); ++i) {
                this.glbObj.rep_regionid_curr = this.glbObj.regionid_list.get(i).toString();
                this.glbObj.rep_boothid_curr = this.glbObj.boothid_list.get(i).toString();
                subleader_regionid_lst = null;
                subleader_regionid_lst = this.glbObj.rep_leader_to_subleader_regionid_map.get(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr);
                if (subleader_regionid_lst == null) continue;
                ArrayList<String> subleaderid_lst = new ArrayList<String>();
                ArrayList<String> subleadername_lst = new ArrayList<String>();
                check = false;
                for (int j = 0; j < this.glbObj.subleader_regionid_lst.size(); ++j) {
                    this.glbObj.subleader_regionid_cur = this.glbObj.subleader_regionid_lst.get(j).toString();
                    this.tlvObj.setTlv(50);
                    System.out.println("set tlv====" + this.glbObj.tlvStr);
                    boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.do_all_network();
                    }
                    if (this.log.error_code != 0) {
                        check = false;
                        continue;
                    }
                    subleaderid_lst.add(this.log.GetValuesFromTbl("tsubleaderregiontbl.2_subleaderid").get(0).toString());
                    subleadername_lst.add(this.log.GetValuesFromTbl("tsubleaderregiontbl.3_subleadername").get(0).toString());
                    this.dblib.PostDBExec(this.log.rcv_buff);
                    check = true;
                }
                this.glbObj.rep_subleaderid_list_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, subleaderid_lst);
                this.glbObj.rep_subleadername_list_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr, subleadername_lst);
            }
        }
        return check;
    }

    public boolean get_covered_voters_from_subleader() throws IOException {
        boolean check = false;
        for (int i = 0; i < this.glbObj.regionid_list.size(); ++i) {
            this.glbObj.rep_boothid_curr = this.glbObj.boothid_list.get(i).toString();
            this.glbObj.rep_regionid_curr = this.glbObj.regionid_list.get(i).toString();
            System.out.println("this.glbObj.rep_regionid_curr in get covered ========" + this.glbObj.rep_regionid_curr);
            List subleaderid_lst = this.glbObj.rep_subleaderid_list_map.get(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr);
            List processid_lst = this.glbObj.rep_booth_to_processid_map.get(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr);
            if (subleaderid_lst == null) continue;
            for (int j = 0; j < subleaderid_lst.size(); ++j) {
                this.glbObj.rep_subleaderid_cur = subleaderid_lst.get(j).toString();
                ArrayList<String> voter_covered_count_lst = new ArrayList<String>();
                for (int k = 0; k < processid_lst.size(); ++k) {
                    this.glbObj.rep_processid_curr = processid_lst.get(k).toString();
                    this.tlvObj.setTlv(51);
                    this.do_all_network();
                    System.out.println("In Library" + this.log.error_code);
                    if (this.log.error_code != 0) {
                        check = false;
                    } else {
                        voter_covered_count_lst.add(this.log.GetValuesFromTbl("tsurveystattbl.1_count(*)").get(0).toString());
                    }
                    check = true;
                }
                this.glbObj.rep_voters_covered_subleader_map.put(this.glbObj.rep_regionid_curr + this.glbObj.rep_boothid_curr + this.glbObj.rep_subleaderid_cur, voter_covered_count_lst);
            }
        }
        System.out.println("++++++++++++++++++++++++++++++++++");
        System.out.println("this.glbObj.rep_boothprocess_to_votercount_map==========" + this.glbObj.rep_boothprocess_to_votercount_map);
        return check;
    }

    public boolean get_tasks() throws IOException {
        if (this.glbObj.ids_only) {
            this.glbObj.tlvStr2 = "select taskid,ttypeid,tasktype,verticle,timepri,priority,des,arole,aroleid,prole,proleid,fromdate,tilldate,status,aname,taskstatus from trueguide.ttasktbl where taskid in (select taskid from trueguide.ttasktbl where arole='LEADER' and aroleid='" + this.glbObj.Luid + "' and status='1')";
            this.get_generic_ex("");
            if (this.log.error_code == 101) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Internet Connection..." + this.log.error_code;
                return false;
            }
            if (this.log.error_code == 2) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Data Found:";
                return false;
            }
            if (this.log.error_code != 0) {
                this.log.toastBox = true;
                this.log.toastMsg = "Something went wrong:" + this.log.error_code;
                return false;
            }
            this.glbObj.taskid_lst = this.get_list("1");
            this.glbObj.task_ttypeid_lst = this.get_list("2");
            this.glbObj.task_type_lst = this.get_list("3");
            this.glbObj.task_time_proirity_lst = this.get_list("4");
            this.glbObj.task_proleid_lst = this.get_list("5");
            this.glbObj.task_fromdate_lst = this.get_list("6");
            this.glbObj.task_tilldate_lst = this.get_list("7");
        }
        return true;
    }

    public boolean get_distinct_dates_of_tasks() throws IOException {
        if (this.glbObj.ids_only) {
            this.glbObj.tlvStr2 = "select taskdescid,taskid,ttypeid,subject,description,taskdate,role,roleid,tasktime from trueguide.ttaskdesctbl where taskdescid in (select taskdescid from trueguide.ttaskdesctbl where taskid='" + this.glbObj.taskid_cur + "' and role='LEADER' and roleid='" + this.glbObj.Luid + "') order by taskdate";
            this.get_generic_ex("");
            if (this.log.error_code == 101) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Internet Connection..." + this.log.error_code;
                return false;
            }
            if (this.log.error_code == 2) {
                this.log.toastBox = true;
                this.log.toastMsg = "No Data Found:";
                return false;
            }
            if (this.log.error_code != 0) {
                this.log.toastBox = true;
                this.log.toastMsg = "Something went wrong:" + this.log.error_code;
                return false;
            }
            this.glbObj.taskdesc_id_lst = this.get_list("1");
            this.glbObj.taskid_lst = this.get_list("2");
            this.glbObj.task_ttypeid_lst = this.get_list("3");
            this.glbObj.task_sub_lst = this.get_list("4");
            this.glbObj.task_desc_lst = this.get_list("5");
            this.glbObj.task_date_lst = this.get_list("6");
            this.glbObj.task_time_lst = this.get_list("7");
        }
        return true;
    }

    public boolean insert_task_description() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(54);
        boolean ch = false;
        this.dblib.skip_db_exec = true;
        this.dblib.get_from_db(this.glbObj.tlvStr);
        this.do_all_network();
        if (this.log.error_code != 0) {
            ch = false;
        } else {
            this.dblib.PostDBExec("ttaskdesctbl.1_taskdescid");
            ch = true;
        }
        return ch;
    }

    public boolean download_image() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(558);
        this.glbObj.tlvStr = "/var/trueguide/TASKDOC/" + this.glbObj.taskdesc_id_cur + "/" + this.glbObj.ToteachFilename;
        this.log.skip_comp = true;
        this.do_all_network();
        this.log.skip_comp = false;
        if (this.log.error_code != 0) {
            if (this.log.error_code == 200 | this.log.error_code == 2) {
                check = false;
            }
            return check;
        }
        List filename_lst = this.log.GetImageFileNames(this.log.rcv_buff);
        String fname = "";
        for (int i = 0; i < filename_lst.size(); ++i) {
            this.tlvObj.setTlv(558);
            fname = filename_lst.get(i).toString().trim();
            this.glbObj.tlvStr = "/var/trueguide/TASKDOC/" + this.glbObj.taskdesc_id_cur + "/" + fname;
            File a = new File(this.glbObj.tlvStr);
            String file = a.getName().trim();
            boolean chk = this.log.checkIfFileExists(this.glbObj.localimagePath + "/" + file);
            if (chk) continue;
            this.log.skip_comp = true;
            this.do_all_network();
            this.log.skip_comp = false;
            File image = new File(this.glbObj.localimagePath, file);
            System.out.println("this.log.error_code" + file);
            this.log.save_image(559, this.glbObj.localimagePath + "/" + file);
        }
        return true;
    }

    public boolean set_path_addtaskdoc() throws IOException {
        this.tlvObj.setTlv(557);
        this.glbObj.tlvStr = "/var/trueguide/TASKDOC/" + this.glbObj.taskdesc_id_cur + "/" + this.glbObj.ToteachFilename;
        String file = this.glbObj.ToteachFilename;
        System.out.println("file name======" + file);
        File image = new File(this.glbObj.localimagePath, file);
        System.out.println("Copying image to++++++++" + this.glbObj.localimagePath.toString() + "/" + file);
        this.log.copyFile(this.glbObj.imagePath, this.glbObj.localimagePath.toString() + "/" + file);
        this.log.AppLock();
        this.log.skip_comp = true;
        this.do_all_network();
        this.log.skip_comp = false;
        this.log.sendImage(100, this.glbObj.localimagePath.toString() + "/" + file);
        this.log.AppUnLock();
        return true;
    }

    public boolean get_already_sent_docs_for_the_task() throws IOException {
        boolean check = false;
        if (this.glbObj.get_sent_files) {
            if (this.glbObj.ids_only) {
                this.tlvObj.setTlv(55);
                System.out.println("set tlv====" + this.glbObj.tlvStr);
                this.do_all_network();
                if (this.log.error_code != 0) {
                    check = false;
                } else {
                    this.glbObj.task_docid_lst = this.log.GetValuesFromTbl("ttaskdoctbl.1_taskdocid");
                    check = true;
                }
            }
            if (!this.glbObj.ids_only) {
                this.glbObj.file_name_lst = new ArrayList();
                for (int i = 0; i < this.glbObj.task_docid_lst.size(); ++i) {
                    this.glbObj.task_docid_cur = this.glbObj.task_docid_lst.get(i).toString();
                    this.dblib.pme.delim = "\\^";
                    this.log.delim = "\\^";
                    this.tlvObj.setTlv(55);
                    System.out.println("set tlv====" + this.glbObj.tlvStr);
                    boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
                    if (!c) {
                        return false;
                    }
                    boolean ca = this.dblib.get_from_db(this.glbObj.tlvStr);
                    if (!ca) {
                        this.tlvObj.setTlv(707);
                        this.glbObj.tlvStr = "TASKDOC#" + this.glbObj.task_docid_cur;
                        this.log.skip_comp = true;
                        this.do_all_network();
                        this.log.skip_comp = false;
                    }
                    if (this.log.error_code != 0) {
                        this.dblib.pme.delim = "\\.";
                        this.log.delim = "\\.";
                        check = false;
                        continue;
                    }
                    String fname = this.log.GetValuesFromTbl("ttaskdoctbl^2_fname").get(0).toString();
                    this.glbObj.file_name_lst.add(fname);
                    if (ca) {
                        System.out.println("recieved buff========" + this.log.rcv_buff);
                        this.dblib.PostDBExec(this.log.rcv_buff);
                        this.dblib.pme.delim = "\\.";
                        this.log.delim = "\\.";
                    } else {
                        String task_docid = this.log.GetValuesFromTbl("ttaskdoctbl^1_taskdocid").get(0).toString();
                        String task_descid = this.log.GetValuesFromTbl("ttaskdoctbl^3_taskdescid").get(0).toString();
                        String query = "insert into ttaskdoctbl(taskdocid,fname,taskdescid) values ('" + task_docid + "','" + fname + "','" + task_descid + "')";
                        this.dblib.dbhand.SendQuery(query);
                    }
                    this.dblib.pme.delim = "\\.";
                    this.log.delim = "\\.";
                    check = true;
                }
                this.dblib.pme.delim = "\\.";
                this.log.delim = "\\.";
            }
            check = true;
        }
        return check;
    }

    public boolean insert_into_ttaskdoctbl() throws IOException {
        boolean check = false;
        this.tlvObj.setTlv(707);
        boolean c = this.log.check_startup_credentials(this.glbObj.req_type);
        if (!c) {
            return false;
        }
        this.glbObj.tlvStr = "INSRTTASKDOC#" + this.glbObj.ToteachFilename + "#" + this.glbObj.taskdesc_id_cur;
        this.log.skip_comp = true;
        this.do_all_network();
        this.log.skip_comp = false;
        if (this.log.error_code != 0) {
            check = false;
        } else {
            this.glbObj.task_docid_cur = this.log.GetValuesFromTbl("ttaskdoctbl.1_taskdocid").get(0).toString();
            String query = "insert into ttaskdoctbl(taskdocid,fname,taskdescid) values ('" + this.glbObj.task_docid_cur + "','" + this.glbObj.ToteachFilename + "','" + this.glbObj.taskdesc_id_cur + "')";
            this.dblib.dbhand.SendQuery(query);
            check = true;
        }
        return check;
    }
}

